# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCloudProjectGatewayResult',
    'AwaitableGetCloudProjectGatewayResult',
    'get_cloud_project_gateway',
    'get_cloud_project_gateway_output',
]

@pulumi.output_type
class GetCloudProjectGatewayResult:
    """
    A collection of values returned by getCloudProjectGateway.
    """
    def __init__(__self__, external_information=None, id=None, interfaces=None, model=None, name=None, region=None, service_name=None, status=None):
        if external_information and not isinstance(external_information, dict):
            raise TypeError("Expected argument 'external_information' to be a dict")
        pulumi.set(__self__, "external_information", external_information)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if interfaces and not isinstance(interfaces, list):
            raise TypeError("Expected argument 'interfaces' to be a list")
        pulumi.set(__self__, "interfaces", interfaces)
        if model and not isinstance(model, str):
            raise TypeError("Expected argument 'model' to be a str")
        pulumi.set(__self__, "model", model)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="externalInformation")
    def external_information(self) -> 'outputs.GetCloudProjectGatewayExternalInformationResult':
        """
        External information
        """
        return pulumi.get(self, "external_information")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Id
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def interfaces(self) -> Sequence['outputs.GetCloudProjectGatewayInterfaceResult']:
        """
        Interfaces list of the gateway
        """
        return pulumi.get(self, "interfaces")

    @property
    @pulumi.getter
    def model(self) -> builtins.str:
        """
        Model of the gateway
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the gateway
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Gateway region
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Status of the gateway
        """
        return pulumi.get(self, "status")


class AwaitableGetCloudProjectGatewayResult(GetCloudProjectGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudProjectGatewayResult(
            external_information=self.external_information,
            id=self.id,
            interfaces=self.interfaces,
            model=self.model,
            name=self.name,
            region=self.region,
            service_name=self.service_name,
            status=self.status)


def get_cloud_project_gateway(id: Optional[builtins.str] = None,
                              region: Optional[builtins.str] = None,
                              service_name: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudProjectGatewayResult:
    """
    Get gateway

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    gateway = ovh.get_cloud_project_gateway(service_name="<public cloud project ID>",
        region="GRA11",
        id="<gateway ID>")
    ```


    :param builtins.str id: Id
    :param builtins.str region: Gateway region
    :param builtins.str service_name: Service name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['region'] = region
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:index/getCloudProjectGateway:getCloudProjectGateway', __args__, opts=opts, typ=GetCloudProjectGatewayResult).value

    return AwaitableGetCloudProjectGatewayResult(
        external_information=pulumi.get(__ret__, 'external_information'),
        id=pulumi.get(__ret__, 'id'),
        interfaces=pulumi.get(__ret__, 'interfaces'),
        model=pulumi.get(__ret__, 'model'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        service_name=pulumi.get(__ret__, 'service_name'),
        status=pulumi.get(__ret__, 'status'))
def get_cloud_project_gateway_output(id: Optional[pulumi.Input[builtins.str]] = None,
                                     region: Optional[pulumi.Input[builtins.str]] = None,
                                     service_name: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudProjectGatewayResult]:
    """
    Get gateway

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    gateway = ovh.get_cloud_project_gateway(service_name="<public cloud project ID>",
        region="GRA11",
        id="<gateway ID>")
    ```


    :param builtins.str id: Id
    :param builtins.str region: Gateway region
    :param builtins.str service_name: Service name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['region'] = region
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:index/getCloudProjectGateway:getCloudProjectGateway', __args__, opts=opts, typ=GetCloudProjectGatewayResult)
    return __ret__.apply(lambda __response__: GetCloudProjectGatewayResult(
        external_information=pulumi.get(__response__, 'external_information'),
        id=pulumi.get(__response__, 'id'),
        interfaces=pulumi.get(__response__, 'interfaces'),
        model=pulumi.get(__response__, 'model'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        service_name=pulumi.get(__response__, 'service_name'),
        status=pulumi.get(__response__, 'status')))
