# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetCloudProjectSshKeyResult',
    'AwaitableGetCloudProjectSshKeyResult',
    'get_cloud_project_ssh_key',
    'get_cloud_project_ssh_key_output',
]

@pulumi.output_type
class GetCloudProjectSshKeyResult:
    """
    A collection of values returned by getCloudProjectSshKey.
    """
    def __init__(__self__, finger_print=None, id=None, name=None, public_key=None, regions=None, service_name=None):
        if finger_print and not isinstance(finger_print, str):
            raise TypeError("Expected argument 'finger_print' to be a str")
        pulumi.set(__self__, "finger_print", finger_print)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public_key and not isinstance(public_key, str):
            raise TypeError("Expected argument 'public_key' to be a str")
        pulumi.set(__self__, "public_key", public_key)
        if regions and not isinstance(regions, list):
            raise TypeError("Expected argument 'regions' to be a list")
        pulumi.set(__self__, "regions", regions)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="fingerPrint")
    def finger_print(self) -> builtins.str:
        """
        SSH key fingerprint
        """
        return pulumi.get(self, "finger_print")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        SSH key ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        SSH key name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> builtins.str:
        """
        SSH public key
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def regions(self) -> Sequence[builtins.str]:
        """
        SSH key regions
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        Service name
        """
        return pulumi.get(self, "service_name")


class AwaitableGetCloudProjectSshKeyResult(GetCloudProjectSshKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudProjectSshKeyResult(
            finger_print=self.finger_print,
            id=self.id,
            name=self.name,
            public_key=self.public_key,
            regions=self.regions,
            service_name=self.service_name)


def get_cloud_project_ssh_key(id: Optional[builtins.str] = None,
                              service_name: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudProjectSshKeyResult:
    """
    Retrieve information about a SSH key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    key = ovh.get_cloud_project_ssh_key(service_name="XXX",
        id="YYY")
    ```


    :param builtins.str id: SSH key ID
    :param builtins.str service_name: Service name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:index/getCloudProjectSshKey:getCloudProjectSshKey', __args__, opts=opts, typ=GetCloudProjectSshKeyResult).value

    return AwaitableGetCloudProjectSshKeyResult(
        finger_print=pulumi.get(__ret__, 'finger_print'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        public_key=pulumi.get(__ret__, 'public_key'),
        regions=pulumi.get(__ret__, 'regions'),
        service_name=pulumi.get(__ret__, 'service_name'))
def get_cloud_project_ssh_key_output(id: Optional[pulumi.Input[builtins.str]] = None,
                                     service_name: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudProjectSshKeyResult]:
    """
    Retrieve information about a SSH key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    key = ovh.get_cloud_project_ssh_key(service_name="XXX",
        id="YYY")
    ```


    :param builtins.str id: SSH key ID
    :param builtins.str service_name: Service name
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:index/getCloudProjectSshKey:getCloudProjectSshKey', __args__, opts=opts, typ=GetCloudProjectSshKeyResult)
    return __ret__.apply(lambda __response__: GetCloudProjectSshKeyResult(
        finger_print=pulumi.get(__response__, 'finger_print'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        public_key=pulumi.get(__response__, 'public_key'),
        regions=pulumi.get(__response__, 'regions'),
        service_name=pulumi.get(__response__, 'service_name')))
