# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetInstallationTemplateResult',
    'AwaitableGetInstallationTemplateResult',
    'get_installation_template',
    'get_installation_template_output',
]

@pulumi.output_type
class GetInstallationTemplateResult:
    """
    A collection of values returned by getInstallationTemplate.
    """
    def __init__(__self__, bit_format=None, category=None, description=None, distribution=None, end_of_install=None, family=None, filesystems=None, hard_raid_configuration=None, id=None, inputs=None, licenses=None, lvm_ready=None, no_partitioning=None, projects=None, soft_raid_only_mirroring=None, subfamily=None, template_name=None):
        if bit_format and not isinstance(bit_format, int):
            raise TypeError("Expected argument 'bit_format' to be a int")
        pulumi.set(__self__, "bit_format", bit_format)
        if category and not isinstance(category, str):
            raise TypeError("Expected argument 'category' to be a str")
        pulumi.set(__self__, "category", category)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if distribution and not isinstance(distribution, str):
            raise TypeError("Expected argument 'distribution' to be a str")
        pulumi.set(__self__, "distribution", distribution)
        if end_of_install and not isinstance(end_of_install, str):
            raise TypeError("Expected argument 'end_of_install' to be a str")
        pulumi.set(__self__, "end_of_install", end_of_install)
        if family and not isinstance(family, str):
            raise TypeError("Expected argument 'family' to be a str")
        pulumi.set(__self__, "family", family)
        if filesystems and not isinstance(filesystems, list):
            raise TypeError("Expected argument 'filesystems' to be a list")
        pulumi.set(__self__, "filesystems", filesystems)
        if hard_raid_configuration and not isinstance(hard_raid_configuration, bool):
            raise TypeError("Expected argument 'hard_raid_configuration' to be a bool")
        pulumi.set(__self__, "hard_raid_configuration", hard_raid_configuration)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inputs and not isinstance(inputs, list):
            raise TypeError("Expected argument 'inputs' to be a list")
        pulumi.set(__self__, "inputs", inputs)
        if licenses and not isinstance(licenses, list):
            raise TypeError("Expected argument 'licenses' to be a list")
        pulumi.set(__self__, "licenses", licenses)
        if lvm_ready and not isinstance(lvm_ready, bool):
            raise TypeError("Expected argument 'lvm_ready' to be a bool")
        pulumi.set(__self__, "lvm_ready", lvm_ready)
        if no_partitioning and not isinstance(no_partitioning, bool):
            raise TypeError("Expected argument 'no_partitioning' to be a bool")
        pulumi.set(__self__, "no_partitioning", no_partitioning)
        if projects and not isinstance(projects, list):
            raise TypeError("Expected argument 'projects' to be a list")
        pulumi.set(__self__, "projects", projects)
        if soft_raid_only_mirroring and not isinstance(soft_raid_only_mirroring, bool):
            raise TypeError("Expected argument 'soft_raid_only_mirroring' to be a bool")
        pulumi.set(__self__, "soft_raid_only_mirroring", soft_raid_only_mirroring)
        if subfamily and not isinstance(subfamily, str):
            raise TypeError("Expected argument 'subfamily' to be a str")
        pulumi.set(__self__, "subfamily", subfamily)
        if template_name and not isinstance(template_name, str):
            raise TypeError("Expected argument 'template_name' to be a str")
        pulumi.set(__self__, "template_name", template_name)

    @property
    @pulumi.getter(name="bitFormat")
    def bit_format(self) -> builtins.int:
        """
        Template bit format (32 or 64).
        """
        return pulumi.get(self, "bit_format")

    @property
    @pulumi.getter
    def category(self) -> builtins.str:
        """
        Category of this template (informative only).
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Information about this template.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def distribution(self) -> builtins.str:
        """
        Distribution this template is based on.
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter(name="endOfInstall")
    def end_of_install(self) -> builtins.str:
        """
        End of install date of the template.
        """
        return pulumi.get(self, "end_of_install")

    @property
    @pulumi.getter
    def family(self) -> builtins.str:
        """
        Template family type.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def filesystems(self) -> Sequence[builtins.str]:
        """
        Filesystems available.
        """
        return pulumi.get(self, "filesystems")

    @property
    @pulumi.getter(name="hardRaidConfiguration")
    def hard_raid_configuration(self) -> builtins.bool:
        return pulumi.get(self, "hard_raid_configuration")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def inputs(self) -> Sequence['outputs.GetInstallationTemplateInputResult']:
        """
        Represents the questions of the expected answers in the userMetadata field.
        """
        return pulumi.get(self, "inputs")

    @property
    @pulumi.getter
    def licenses(self) -> Sequence['outputs.GetInstallationTemplateLicenseResult']:
        """
        License available for this template.
        """
        return pulumi.get(self, "licenses")

    @property
    @pulumi.getter(name="lvmReady")
    def lvm_ready(self) -> builtins.bool:
        """
        Whether this template supports LVM.
        """
        return pulumi.get(self, "lvm_ready")

    @property
    @pulumi.getter(name="noPartitioning")
    def no_partitioning(self) -> builtins.bool:
        """
        Partitioning customization is not available for this OS template.
        """
        return pulumi.get(self, "no_partitioning")

    @property
    @pulumi.getter
    def projects(self) -> Sequence['outputs.GetInstallationTemplateProjectResult']:
        """
        Distribution project details.
        """
        return pulumi.get(self, "projects")

    @property
    @pulumi.getter(name="softRaidOnlyMirroring")
    def soft_raid_only_mirroring(self) -> builtins.bool:
        """
        Template supports RAID0 and RAID1 on 2 disks.
        """
        return pulumi.get(self, "soft_raid_only_mirroring")

    @property
    @pulumi.getter
    def subfamily(self) -> builtins.str:
        """
        Subfamily of the template.
        """
        return pulumi.get(self, "subfamily")

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> builtins.str:
        return pulumi.get(self, "template_name")


class AwaitableGetInstallationTemplateResult(GetInstallationTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstallationTemplateResult(
            bit_format=self.bit_format,
            category=self.category,
            description=self.description,
            distribution=self.distribution,
            end_of_install=self.end_of_install,
            family=self.family,
            filesystems=self.filesystems,
            hard_raid_configuration=self.hard_raid_configuration,
            id=self.id,
            inputs=self.inputs,
            licenses=self.licenses,
            lvm_ready=self.lvm_ready,
            no_partitioning=self.no_partitioning,
            projects=self.projects,
            soft_raid_only_mirroring=self.soft_raid_only_mirroring,
            subfamily=self.subfamily,
            template_name=self.template_name)


def get_installation_template(template_name: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstallationTemplateResult:
    """
    Use this data source to retrieve information about a specific OVH dedicated server installation template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    ovh_template = ovh.get_installation_template(template_name="debian12_64")
    pulumi.export("template", ovh_template)
    ```


    :param builtins.str template_name: The name of the template.
    """
    __args__ = dict()
    __args__['templateName'] = template_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:index/getInstallationTemplate:getInstallationTemplate', __args__, opts=opts, typ=GetInstallationTemplateResult).value

    return AwaitableGetInstallationTemplateResult(
        bit_format=pulumi.get(__ret__, 'bit_format'),
        category=pulumi.get(__ret__, 'category'),
        description=pulumi.get(__ret__, 'description'),
        distribution=pulumi.get(__ret__, 'distribution'),
        end_of_install=pulumi.get(__ret__, 'end_of_install'),
        family=pulumi.get(__ret__, 'family'),
        filesystems=pulumi.get(__ret__, 'filesystems'),
        hard_raid_configuration=pulumi.get(__ret__, 'hard_raid_configuration'),
        id=pulumi.get(__ret__, 'id'),
        inputs=pulumi.get(__ret__, 'inputs'),
        licenses=pulumi.get(__ret__, 'licenses'),
        lvm_ready=pulumi.get(__ret__, 'lvm_ready'),
        no_partitioning=pulumi.get(__ret__, 'no_partitioning'),
        projects=pulumi.get(__ret__, 'projects'),
        soft_raid_only_mirroring=pulumi.get(__ret__, 'soft_raid_only_mirroring'),
        subfamily=pulumi.get(__ret__, 'subfamily'),
        template_name=pulumi.get(__ret__, 'template_name'))
def get_installation_template_output(template_name: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstallationTemplateResult]:
    """
    Use this data source to retrieve information about a specific OVH dedicated server installation template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    ovh_template = ovh.get_installation_template(template_name="debian12_64")
    pulumi.export("template", ovh_template)
    ```


    :param builtins.str template_name: The name of the template.
    """
    __args__ = dict()
    __args__['templateName'] = template_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:index/getInstallationTemplate:getInstallationTemplate', __args__, opts=opts, typ=GetInstallationTemplateResult)
    return __ret__.apply(lambda __response__: GetInstallationTemplateResult(
        bit_format=pulumi.get(__response__, 'bit_format'),
        category=pulumi.get(__response__, 'category'),
        description=pulumi.get(__response__, 'description'),
        distribution=pulumi.get(__response__, 'distribution'),
        end_of_install=pulumi.get(__response__, 'end_of_install'),
        family=pulumi.get(__response__, 'family'),
        filesystems=pulumi.get(__response__, 'filesystems'),
        hard_raid_configuration=pulumi.get(__response__, 'hard_raid_configuration'),
        id=pulumi.get(__response__, 'id'),
        inputs=pulumi.get(__response__, 'inputs'),
        licenses=pulumi.get(__response__, 'licenses'),
        lvm_ready=pulumi.get(__response__, 'lvm_ready'),
        no_partitioning=pulumi.get(__response__, 'no_partitioning'),
        projects=pulumi.get(__response__, 'projects'),
        soft_raid_only_mirroring=pulumi.get(__response__, 'soft_raid_only_mirroring'),
        subfamily=pulumi.get(__response__, 'subfamily'),
        template_name=pulumi.get(__response__, 'template_name')))
