# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetLocationResult',
    'AwaitableGetLocationResult',
    'get_location',
    'get_location_output',
]

@pulumi.output_type
class GetLocationResult:
    """
    A collection of values returned by getLocation.
    """
    def __init__(__self__, availability_zones=None, cardinal_point=None, city_code=None, city_latitude=None, city_longitude=None, city_name=None, code=None, country_code=None, country_name=None, geography_code=None, geography_name=None, id=None, location=None, name=None, opening_year=None, specific_type=None, type=None):
        if availability_zones and not isinstance(availability_zones, list):
            raise TypeError("Expected argument 'availability_zones' to be a list")
        pulumi.set(__self__, "availability_zones", availability_zones)
        if cardinal_point and not isinstance(cardinal_point, str):
            raise TypeError("Expected argument 'cardinal_point' to be a str")
        pulumi.set(__self__, "cardinal_point", cardinal_point)
        if city_code and not isinstance(city_code, str):
            raise TypeError("Expected argument 'city_code' to be a str")
        pulumi.set(__self__, "city_code", city_code)
        if city_latitude and not isinstance(city_latitude, float):
            raise TypeError("Expected argument 'city_latitude' to be a float")
        pulumi.set(__self__, "city_latitude", city_latitude)
        if city_longitude and not isinstance(city_longitude, float):
            raise TypeError("Expected argument 'city_longitude' to be a float")
        pulumi.set(__self__, "city_longitude", city_longitude)
        if city_name and not isinstance(city_name, str):
            raise TypeError("Expected argument 'city_name' to be a str")
        pulumi.set(__self__, "city_name", city_name)
        if code and not isinstance(code, str):
            raise TypeError("Expected argument 'code' to be a str")
        pulumi.set(__self__, "code", code)
        if country_code and not isinstance(country_code, str):
            raise TypeError("Expected argument 'country_code' to be a str")
        pulumi.set(__self__, "country_code", country_code)
        if country_name and not isinstance(country_name, str):
            raise TypeError("Expected argument 'country_name' to be a str")
        pulumi.set(__self__, "country_name", country_name)
        if geography_code and not isinstance(geography_code, str):
            raise TypeError("Expected argument 'geography_code' to be a str")
        pulumi.set(__self__, "geography_code", geography_code)
        if geography_name and not isinstance(geography_name, str):
            raise TypeError("Expected argument 'geography_name' to be a str")
        pulumi.set(__self__, "geography_name", geography_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if opening_year and not isinstance(opening_year, float):
            raise TypeError("Expected argument 'opening_year' to be a float")
        pulumi.set(__self__, "opening_year", opening_year)
        if specific_type and not isinstance(specific_type, str):
            raise TypeError("Expected argument 'specific_type' to be a str")
        pulumi.set(__self__, "specific_type", specific_type)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[builtins.str]:
        """
        List of availability zones for the region
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="cardinalPoint")
    def cardinal_point(self) -> builtins.str:
        """
        Cardinal direction where the region is located
        """
        return pulumi.get(self, "cardinal_point")

    @property
    @pulumi.getter(name="cityCode")
    def city_code(self) -> builtins.str:
        """
        ISO code of the city
        """
        return pulumi.get(self, "city_code")

    @property
    @pulumi.getter(name="cityLatitude")
    def city_latitude(self) -> builtins.float:
        """
        Geographical latitude of the city
        """
        return pulumi.get(self, "city_latitude")

    @property
    @pulumi.getter(name="cityLongitude")
    def city_longitude(self) -> builtins.float:
        """
        Geographical longitude of the city
        """
        return pulumi.get(self, "city_longitude")

    @property
    @pulumi.getter(name="cityName")
    def city_name(self) -> builtins.str:
        """
        Full name of the city
        """
        return pulumi.get(self, "city_name")

    @property
    @pulumi.getter
    def code(self) -> builtins.str:
        """
        Region's short code
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> builtins.str:
        """
        ISO code of the country
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter(name="countryName")
    def country_name(self) -> builtins.str:
        """
        Full name of the country
        """
        return pulumi.get(self, "country_name")

    @property
    @pulumi.getter(name="geographyCode")
    def geography_code(self) -> builtins.str:
        """
        Short code representing the geographical area
        """
        return pulumi.get(self, "geography_code")

    @property
    @pulumi.getter(name="geographyName")
    def geography_name(self) -> builtins.str:
        """
        Name of the geographical area
        """
        return pulumi.get(self, "geography_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        Location of the region
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="openingYear")
    def opening_year(self) -> builtins.float:
        """
        Year the region was opened
        """
        return pulumi.get(self, "opening_year")

    @property
    @pulumi.getter(name="specificType")
    def specific_type(self) -> builtins.str:
        """
        Specific typology of the region
        """
        return pulumi.get(self, "specific_type")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        General typology of the region
        """
        return pulumi.get(self, "type")


class AwaitableGetLocationResult(GetLocationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLocationResult(
            availability_zones=self.availability_zones,
            cardinal_point=self.cardinal_point,
            city_code=self.city_code,
            city_latitude=self.city_latitude,
            city_longitude=self.city_longitude,
            city_name=self.city_name,
            code=self.code,
            country_code=self.country_code,
            country_name=self.country_name,
            geography_code=self.geography_code,
            geography_name=self.geography_name,
            id=self.id,
            location=self.location,
            name=self.name,
            opening_year=self.opening_year,
            specific_type=self.specific_type,
            type=self.type)


def get_location(name: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLocationResult:
    """
    Get available regions and their availability zones

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    paris = ovh.get_location(name="eu-west-par")
    ```


    :param builtins.str name: Name
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:index/getLocation:getLocation', __args__, opts=opts, typ=GetLocationResult).value

    return AwaitableGetLocationResult(
        availability_zones=pulumi.get(__ret__, 'availability_zones'),
        cardinal_point=pulumi.get(__ret__, 'cardinal_point'),
        city_code=pulumi.get(__ret__, 'city_code'),
        city_latitude=pulumi.get(__ret__, 'city_latitude'),
        city_longitude=pulumi.get(__ret__, 'city_longitude'),
        city_name=pulumi.get(__ret__, 'city_name'),
        code=pulumi.get(__ret__, 'code'),
        country_code=pulumi.get(__ret__, 'country_code'),
        country_name=pulumi.get(__ret__, 'country_name'),
        geography_code=pulumi.get(__ret__, 'geography_code'),
        geography_name=pulumi.get(__ret__, 'geography_name'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        opening_year=pulumi.get(__ret__, 'opening_year'),
        specific_type=pulumi.get(__ret__, 'specific_type'),
        type=pulumi.get(__ret__, 'type'))
def get_location_output(name: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLocationResult]:
    """
    Get available regions and their availability zones

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    paris = ovh.get_location(name="eu-west-par")
    ```


    :param builtins.str name: Name
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:index/getLocation:getLocation', __args__, opts=opts, typ=GetLocationResult)
    return __ret__.apply(lambda __response__: GetLocationResult(
        availability_zones=pulumi.get(__response__, 'availability_zones'),
        cardinal_point=pulumi.get(__response__, 'cardinal_point'),
        city_code=pulumi.get(__response__, 'city_code'),
        city_latitude=pulumi.get(__response__, 'city_latitude'),
        city_longitude=pulumi.get(__response__, 'city_longitude'),
        city_name=pulumi.get(__response__, 'city_name'),
        code=pulumi.get(__response__, 'code'),
        country_code=pulumi.get(__response__, 'country_code'),
        country_name=pulumi.get(__response__, 'country_name'),
        geography_code=pulumi.get(__response__, 'geography_code'),
        geography_name=pulumi.get(__response__, 'geography_name'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        opening_year=pulumi.get(__response__, 'opening_year'),
        specific_type=pulumi.get(__response__, 'specific_type'),
        type=pulumi.get(__response__, 'type')))
