# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetServerResult',
    'AwaitableGetServerResult',
    'get_server',
    'get_server_output',
]

@pulumi.output_type
class GetServerResult:
    """
    A collection of values returned by getServer.
    """
    def __init__(__self__, server_urn=None, availability_zone=None, boot_id=None, boot_script=None, commercial_range=None, datacenter=None, display_name=None, efi_bootloader_path=None, enabled_public_vnis=None, enabled_vrack_aggregation_vnis=None, enabled_vrack_vnis=None, id=None, ip=None, ips=None, link_speed=None, monitoring=None, name=None, new_upgrade_system=None, no_intervention=None, os=None, power_state=None, professional_use=None, rack=None, region=None, rescue_mail=None, rescue_ssh_key=None, reverse=None, root_device=None, server_id=None, service_name=None, state=None, support_level=None, vnis=None):
        if server_urn and not isinstance(server_urn, str):
            raise TypeError("Expected argument 'server_urn' to be a str")
        pulumi.set(__self__, "server_urn", server_urn)
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if boot_id and not isinstance(boot_id, int):
            raise TypeError("Expected argument 'boot_id' to be a int")
        pulumi.set(__self__, "boot_id", boot_id)
        if boot_script and not isinstance(boot_script, str):
            raise TypeError("Expected argument 'boot_script' to be a str")
        pulumi.set(__self__, "boot_script", boot_script)
        if commercial_range and not isinstance(commercial_range, str):
            raise TypeError("Expected argument 'commercial_range' to be a str")
        pulumi.set(__self__, "commercial_range", commercial_range)
        if datacenter and not isinstance(datacenter, str):
            raise TypeError("Expected argument 'datacenter' to be a str")
        pulumi.set(__self__, "datacenter", datacenter)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if efi_bootloader_path and not isinstance(efi_bootloader_path, str):
            raise TypeError("Expected argument 'efi_bootloader_path' to be a str")
        pulumi.set(__self__, "efi_bootloader_path", efi_bootloader_path)
        if enabled_public_vnis and not isinstance(enabled_public_vnis, list):
            raise TypeError("Expected argument 'enabled_public_vnis' to be a list")
        pulumi.set(__self__, "enabled_public_vnis", enabled_public_vnis)
        if enabled_vrack_aggregation_vnis and not isinstance(enabled_vrack_aggregation_vnis, list):
            raise TypeError("Expected argument 'enabled_vrack_aggregation_vnis' to be a list")
        pulumi.set(__self__, "enabled_vrack_aggregation_vnis", enabled_vrack_aggregation_vnis)
        if enabled_vrack_vnis and not isinstance(enabled_vrack_vnis, list):
            raise TypeError("Expected argument 'enabled_vrack_vnis' to be a list")
        pulumi.set(__self__, "enabled_vrack_vnis", enabled_vrack_vnis)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip and not isinstance(ip, str):
            raise TypeError("Expected argument 'ip' to be a str")
        pulumi.set(__self__, "ip", ip)
        if ips and not isinstance(ips, list):
            raise TypeError("Expected argument 'ips' to be a list")
        pulumi.set(__self__, "ips", ips)
        if link_speed and not isinstance(link_speed, int):
            raise TypeError("Expected argument 'link_speed' to be a int")
        pulumi.set(__self__, "link_speed", link_speed)
        if monitoring and not isinstance(monitoring, bool):
            raise TypeError("Expected argument 'monitoring' to be a bool")
        pulumi.set(__self__, "monitoring", monitoring)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if new_upgrade_system and not isinstance(new_upgrade_system, bool):
            raise TypeError("Expected argument 'new_upgrade_system' to be a bool")
        pulumi.set(__self__, "new_upgrade_system", new_upgrade_system)
        if no_intervention and not isinstance(no_intervention, bool):
            raise TypeError("Expected argument 'no_intervention' to be a bool")
        pulumi.set(__self__, "no_intervention", no_intervention)
        if os and not isinstance(os, str):
            raise TypeError("Expected argument 'os' to be a str")
        pulumi.set(__self__, "os", os)
        if power_state and not isinstance(power_state, str):
            raise TypeError("Expected argument 'power_state' to be a str")
        pulumi.set(__self__, "power_state", power_state)
        if professional_use and not isinstance(professional_use, bool):
            raise TypeError("Expected argument 'professional_use' to be a bool")
        pulumi.set(__self__, "professional_use", professional_use)
        if rack and not isinstance(rack, str):
            raise TypeError("Expected argument 'rack' to be a str")
        pulumi.set(__self__, "rack", rack)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if rescue_mail and not isinstance(rescue_mail, str):
            raise TypeError("Expected argument 'rescue_mail' to be a str")
        pulumi.set(__self__, "rescue_mail", rescue_mail)
        if rescue_ssh_key and not isinstance(rescue_ssh_key, str):
            raise TypeError("Expected argument 'rescue_ssh_key' to be a str")
        pulumi.set(__self__, "rescue_ssh_key", rescue_ssh_key)
        if reverse and not isinstance(reverse, str):
            raise TypeError("Expected argument 'reverse' to be a str")
        pulumi.set(__self__, "reverse", reverse)
        if root_device and not isinstance(root_device, str):
            raise TypeError("Expected argument 'root_device' to be a str")
        pulumi.set(__self__, "root_device", root_device)
        if server_id and not isinstance(server_id, int):
            raise TypeError("Expected argument 'server_id' to be a int")
        pulumi.set(__self__, "server_id", server_id)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if support_level and not isinstance(support_level, str):
            raise TypeError("Expected argument 'support_level' to be a str")
        pulumi.set(__self__, "support_level", support_level)
        if vnis and not isinstance(vnis, list):
            raise TypeError("Expected argument 'vnis' to be a list")
        pulumi.set(__self__, "vnis", vnis)

    @property
    @pulumi.getter(name="ServerURN")
    def server_urn(self) -> builtins.str:
        """
        URN of the dedicated server instance
        """
        return pulumi.get(self, "server_urn")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> builtins.str:
        """
        Dedicated AZ localisation
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="bootId")
    def boot_id(self) -> builtins.int:
        """
        Boot id of the server
        """
        return pulumi.get(self, "boot_id")

    @property
    @pulumi.getter(name="bootScript")
    def boot_script(self) -> builtins.str:
        """
        Boot script of the server
        """
        return pulumi.get(self, "boot_script")

    @property
    @pulumi.getter(name="commercialRange")
    def commercial_range(self) -> builtins.str:
        """
        Dedicated server commercial range
        """
        return pulumi.get(self, "commercial_range")

    @property
    @pulumi.getter
    def datacenter(self) -> builtins.str:
        """
        Dedicated datacenter localisation (bhs1,bhs2,...)
        """
        return pulumi.get(self, "datacenter")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Dedicated server display name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="efiBootloaderPath")
    def efi_bootloader_path(self) -> builtins.str:
        """
        Path of the EFI bootloader of the dedicated server
        """
        return pulumi.get(self, "efi_bootloader_path")

    @property
    @pulumi.getter(name="enabledPublicVnis")
    def enabled_public_vnis(self) -> Sequence[builtins.str]:
        """
        List of enabled public VNI uuids
        """
        return pulumi.get(self, "enabled_public_vnis")

    @property
    @pulumi.getter(name="enabledVrackAggregationVnis")
    def enabled_vrack_aggregation_vnis(self) -> Sequence[builtins.str]:
        """
        List of enabled vrack_aggregation VNI uuids
        """
        return pulumi.get(self, "enabled_vrack_aggregation_vnis")

    @property
    @pulumi.getter(name="enabledVrackVnis")
    def enabled_vrack_vnis(self) -> Sequence[builtins.str]:
        """
        List of enabled vrack VNI uuids
        """
        return pulumi.get(self, "enabled_vrack_vnis")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ip(self) -> builtins.str:
        """
        Dedicated server ip (IPv4)
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def ips(self) -> Sequence[builtins.str]:
        """
        Dedicated server ip blocks
        """
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter(name="linkSpeed")
    def link_speed(self) -> builtins.int:
        """
        Link speed of the server
        """
        return pulumi.get(self, "link_speed")

    @property
    @pulumi.getter
    def monitoring(self) -> builtins.bool:
        """
        Icmp monitoring state
        """
        return pulumi.get(self, "monitoring")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        User defined VirtualNetworkInterface name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="newUpgradeSystem")
    def new_upgrade_system(self) -> builtins.bool:
        return pulumi.get(self, "new_upgrade_system")

    @property
    @pulumi.getter(name="noIntervention")
    def no_intervention(self) -> builtins.bool:
        """
        Prevent datacenter intervention
        """
        return pulumi.get(self, "no_intervention")

    @property
    @pulumi.getter
    def os(self) -> builtins.str:
        """
        Operating system
        """
        return pulumi.get(self, "os")

    @property
    @pulumi.getter(name="powerState")
    def power_state(self) -> builtins.str:
        """
        Power state of the server (poweroff, poweron)
        """
        return pulumi.get(self, "power_state")

    @property
    @pulumi.getter(name="professionalUse")
    def professional_use(self) -> builtins.bool:
        """
        Does this server have professional use option
        """
        return pulumi.get(self, "professional_use")

    @property
    @pulumi.getter
    def rack(self) -> builtins.str:
        """
        Rack id of the server
        """
        return pulumi.get(self, "rack")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Dedicated region localisation
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="rescueMail")
    def rescue_mail(self) -> builtins.str:
        """
        Rescue mail of the server
        """
        return pulumi.get(self, "rescue_mail")

    @property
    @pulumi.getter(name="rescueSshKey")
    def rescue_ssh_key(self) -> builtins.str:
        """
        Public SSH Key used in the rescue mode
        """
        return pulumi.get(self, "rescue_ssh_key")

    @property
    @pulumi.getter
    def reverse(self) -> builtins.str:
        """
        Dedicated server reverse
        """
        return pulumi.get(self, "reverse")

    @property
    @pulumi.getter(name="rootDevice")
    def root_device(self) -> builtins.str:
        """
        Root device of the server
        """
        return pulumi.get(self, "root_device")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> builtins.int:
        """
        Server id
        """
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Error, hacked, hackedBlocked, ok
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="supportLevel")
    def support_level(self) -> builtins.str:
        """
        Dedicated server support level (critical, fastpath, gs, pro)
        """
        return pulumi.get(self, "support_level")

    @property
    @pulumi.getter
    def vnis(self) -> Sequence['outputs.GetServerVniResult']:
        """
        The list of Virtualnetworkinterface associated with this server
        """
        return pulumi.get(self, "vnis")


class AwaitableGetServerResult(GetServerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerResult(
            server_urn=self.server_urn,
            availability_zone=self.availability_zone,
            boot_id=self.boot_id,
            boot_script=self.boot_script,
            commercial_range=self.commercial_range,
            datacenter=self.datacenter,
            display_name=self.display_name,
            efi_bootloader_path=self.efi_bootloader_path,
            enabled_public_vnis=self.enabled_public_vnis,
            enabled_vrack_aggregation_vnis=self.enabled_vrack_aggregation_vnis,
            enabled_vrack_vnis=self.enabled_vrack_vnis,
            id=self.id,
            ip=self.ip,
            ips=self.ips,
            link_speed=self.link_speed,
            monitoring=self.monitoring,
            name=self.name,
            new_upgrade_system=self.new_upgrade_system,
            no_intervention=self.no_intervention,
            os=self.os,
            power_state=self.power_state,
            professional_use=self.professional_use,
            rack=self.rack,
            region=self.region,
            rescue_mail=self.rescue_mail,
            rescue_ssh_key=self.rescue_ssh_key,
            reverse=self.reverse,
            root_device=self.root_device,
            server_id=self.server_id,
            service_name=self.service_name,
            state=self.state,
            support_level=self.support_level,
            vnis=self.vnis)


def get_server(service_name: Optional[builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerResult:
    """
    Use this data source to retrieve information about a dedicated server associated with your OVHcloud Account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    server = ovh.get_server(service_name="XXXXXX")
    ```


    :param builtins.str service_name: The service_name of your dedicated server.
    """
    __args__ = dict()
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:index/getServer:getServer', __args__, opts=opts, typ=GetServerResult).value

    return AwaitableGetServerResult(
        server_urn=pulumi.get(__ret__, 'server_urn'),
        availability_zone=pulumi.get(__ret__, 'availability_zone'),
        boot_id=pulumi.get(__ret__, 'boot_id'),
        boot_script=pulumi.get(__ret__, 'boot_script'),
        commercial_range=pulumi.get(__ret__, 'commercial_range'),
        datacenter=pulumi.get(__ret__, 'datacenter'),
        display_name=pulumi.get(__ret__, 'display_name'),
        efi_bootloader_path=pulumi.get(__ret__, 'efi_bootloader_path'),
        enabled_public_vnis=pulumi.get(__ret__, 'enabled_public_vnis'),
        enabled_vrack_aggregation_vnis=pulumi.get(__ret__, 'enabled_vrack_aggregation_vnis'),
        enabled_vrack_vnis=pulumi.get(__ret__, 'enabled_vrack_vnis'),
        id=pulumi.get(__ret__, 'id'),
        ip=pulumi.get(__ret__, 'ip'),
        ips=pulumi.get(__ret__, 'ips'),
        link_speed=pulumi.get(__ret__, 'link_speed'),
        monitoring=pulumi.get(__ret__, 'monitoring'),
        name=pulumi.get(__ret__, 'name'),
        new_upgrade_system=pulumi.get(__ret__, 'new_upgrade_system'),
        no_intervention=pulumi.get(__ret__, 'no_intervention'),
        os=pulumi.get(__ret__, 'os'),
        power_state=pulumi.get(__ret__, 'power_state'),
        professional_use=pulumi.get(__ret__, 'professional_use'),
        rack=pulumi.get(__ret__, 'rack'),
        region=pulumi.get(__ret__, 'region'),
        rescue_mail=pulumi.get(__ret__, 'rescue_mail'),
        rescue_ssh_key=pulumi.get(__ret__, 'rescue_ssh_key'),
        reverse=pulumi.get(__ret__, 'reverse'),
        root_device=pulumi.get(__ret__, 'root_device'),
        server_id=pulumi.get(__ret__, 'server_id'),
        service_name=pulumi.get(__ret__, 'service_name'),
        state=pulumi.get(__ret__, 'state'),
        support_level=pulumi.get(__ret__, 'support_level'),
        vnis=pulumi.get(__ret__, 'vnis'))
def get_server_output(service_name: Optional[pulumi.Input[builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServerResult]:
    """
    Use this data source to retrieve information about a dedicated server associated with your OVHcloud Account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    server = ovh.get_server(service_name="XXXXXX")
    ```


    :param builtins.str service_name: The service_name of your dedicated server.
    """
    __args__ = dict()
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:index/getServer:getServer', __args__, opts=opts, typ=GetServerResult)
    return __ret__.apply(lambda __response__: GetServerResult(
        server_urn=pulumi.get(__response__, 'server_urn'),
        availability_zone=pulumi.get(__response__, 'availability_zone'),
        boot_id=pulumi.get(__response__, 'boot_id'),
        boot_script=pulumi.get(__response__, 'boot_script'),
        commercial_range=pulumi.get(__response__, 'commercial_range'),
        datacenter=pulumi.get(__response__, 'datacenter'),
        display_name=pulumi.get(__response__, 'display_name'),
        efi_bootloader_path=pulumi.get(__response__, 'efi_bootloader_path'),
        enabled_public_vnis=pulumi.get(__response__, 'enabled_public_vnis'),
        enabled_vrack_aggregation_vnis=pulumi.get(__response__, 'enabled_vrack_aggregation_vnis'),
        enabled_vrack_vnis=pulumi.get(__response__, 'enabled_vrack_vnis'),
        id=pulumi.get(__response__, 'id'),
        ip=pulumi.get(__response__, 'ip'),
        ips=pulumi.get(__response__, 'ips'),
        link_speed=pulumi.get(__response__, 'link_speed'),
        monitoring=pulumi.get(__response__, 'monitoring'),
        name=pulumi.get(__response__, 'name'),
        new_upgrade_system=pulumi.get(__response__, 'new_upgrade_system'),
        no_intervention=pulumi.get(__response__, 'no_intervention'),
        os=pulumi.get(__response__, 'os'),
        power_state=pulumi.get(__response__, 'power_state'),
        professional_use=pulumi.get(__response__, 'professional_use'),
        rack=pulumi.get(__response__, 'rack'),
        region=pulumi.get(__response__, 'region'),
        rescue_mail=pulumi.get(__response__, 'rescue_mail'),
        rescue_ssh_key=pulumi.get(__response__, 'rescue_ssh_key'),
        reverse=pulumi.get(__response__, 'reverse'),
        root_device=pulumi.get(__response__, 'root_device'),
        server_id=pulumi.get(__response__, 'server_id'),
        service_name=pulumi.get(__response__, 'service_name'),
        state=pulumi.get(__response__, 'state'),
        support_level=pulumi.get(__response__, 'support_level'),
        vnis=pulumi.get(__response__, 'vnis')))
