# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetStorageEfsResult',
    'AwaitableGetStorageEfsResult',
    'get_storage_efs',
    'get_storage_efs_output',
]

@pulumi.output_type
class GetStorageEfsResult:
    """
    A collection of values returned by getStorageEfs.
    """
    def __init__(__self__, created_at=None, iam=None, id=None, name=None, performance_level=None, product=None, quota=None, region=None, service_name=None, status=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if iam and not isinstance(iam, dict):
            raise TypeError("Expected argument 'iam' to be a dict")
        pulumi.set(__self__, "iam", iam)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if performance_level and not isinstance(performance_level, str):
            raise TypeError("Expected argument 'performance_level' to be a str")
        pulumi.set(__self__, "performance_level", performance_level)
        if product and not isinstance(product, str):
            raise TypeError("Expected argument 'product' to be a str")
        pulumi.set(__self__, "product", product)
        if quota and not isinstance(quota, float):
            raise TypeError("Expected argument 'quota' to be a float")
        pulumi.set(__self__, "quota", quota)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> builtins.str:
        """
        Service creation date
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def iam(self) -> 'outputs.GetStorageEfsIamResult':
        """
        IAM resource metadata
        """
        return pulumi.get(self, "iam")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Service ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Service name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> builtins.str:
        """
        Service performance level
        """
        return pulumi.get(self, "performance_level")

    @property
    @pulumi.getter
    def product(self) -> builtins.str:
        """
        Product name
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter
    def quota(self) -> builtins.float:
        """
        Service quota
        """
        return pulumi.get(self, "quota")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        Service region
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Service status
        """
        return pulumi.get(self, "status")


class AwaitableGetStorageEfsResult(GetStorageEfsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStorageEfsResult(
            created_at=self.created_at,
            iam=self.iam,
            id=self.id,
            name=self.name,
            performance_level=self.performance_level,
            product=self.product,
            quota=self.quota,
            region=self.region,
            service_name=self.service_name,
            status=self.status)


def get_storage_efs(service_name: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStorageEfsResult:
    """
    Get information about an EFS service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    efs = ovh.get_storage_efs(service_name="XXX")
    ```


    :param builtins.str service_name: Service name
    """
    __args__ = dict()
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:index/getStorageEfs:getStorageEfs', __args__, opts=opts, typ=GetStorageEfsResult).value

    return AwaitableGetStorageEfsResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        iam=pulumi.get(__ret__, 'iam'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        performance_level=pulumi.get(__ret__, 'performance_level'),
        product=pulumi.get(__ret__, 'product'),
        quota=pulumi.get(__ret__, 'quota'),
        region=pulumi.get(__ret__, 'region'),
        service_name=pulumi.get(__ret__, 'service_name'),
        status=pulumi.get(__ret__, 'status'))
def get_storage_efs_output(service_name: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStorageEfsResult]:
    """
    Get information about an EFS service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    efs = ovh.get_storage_efs(service_name="XXX")
    ```


    :param builtins.str service_name: Service name
    """
    __args__ = dict()
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:index/getStorageEfs:getStorageEfs', __args__, opts=opts, typ=GetStorageEfsResult)
    return __ret__.apply(lambda __response__: GetStorageEfsResult(
        created_at=pulumi.get(__response__, 'created_at'),
        iam=pulumi.get(__response__, 'iam'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        performance_level=pulumi.get(__response__, 'performance_level'),
        product=pulumi.get(__response__, 'product'),
        quota=pulumi.get(__response__, 'quota'),
        region=pulumi.get(__response__, 'region'),
        service_name=pulumi.get(__response__, 'service_name'),
        status=pulumi.get(__response__, 'status')))
