# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PermissionsGroupArgs', 'PermissionsGroup']

@pulumi.input_type
class PermissionsGroupArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[builtins.str],
                 allows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 denies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 excepts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a PermissionsGroup resource.
        :param pulumi.Input[builtins.str] description: Group description.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allows: Set of actions allowed by the permissions group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] denies: Set of actions that will be denied no matter what permissions group exists.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] excepts: Set of actions that will be subtracted from the `allow` list.
        :param pulumi.Input[builtins.str] name: Name of the permissions group.
        :param pulumi.Input[builtins.str] updated_at: Date of the last update of this group.
        """
        pulumi.set(__self__, "description", description)
        if allows is not None:
            pulumi.set(__self__, "allows", allows)
        if denies is not None:
            pulumi.set(__self__, "denies", denies)
        if excepts is not None:
            pulumi.set(__self__, "excepts", excepts)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        Group description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def allows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Set of actions allowed by the permissions group.
        """
        return pulumi.get(self, "allows")

    @allows.setter
    def allows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allows", value)

    @property
    @pulumi.getter
    def denies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Set of actions that will be denied no matter what permissions group exists.
        """
        return pulumi.get(self, "denies")

    @denies.setter
    def denies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "denies", value)

    @property
    @pulumi.getter
    def excepts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Set of actions that will be subtracted from the `allow` list.
        """
        return pulumi.get(self, "excepts")

    @excepts.setter
    def excepts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "excepts", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the permissions group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date of the last update of this group.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.input_type
class _PermissionsGroupState:
    def __init__(__self__, *,
                 allows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 denies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 excepts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 urn: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering PermissionsGroup resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allows: Set of actions allowed by the permissions group.
        :param pulumi.Input[builtins.str] created_at: Creation date of this group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] denies: Set of actions that will be denied no matter what permissions group exists.
        :param pulumi.Input[builtins.str] description: Group description.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] excepts: Set of actions that will be subtracted from the `allow` list.
        :param pulumi.Input[builtins.str] name: Name of the permissions group.
        :param pulumi.Input[builtins.str] owner: Owner of the permissions group.
        :param pulumi.Input[builtins.str] updated_at: Date of the last update of this group.
        :param pulumi.Input[builtins.str] urn: URN of the permissions group.
        """
        if allows is not None:
            pulumi.set(__self__, "allows", allows)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if denies is not None:
            pulumi.set(__self__, "denies", denies)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if excepts is not None:
            pulumi.set(__self__, "excepts", excepts)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if urn is not None:
            pulumi.set(__self__, "urn", urn)

    @property
    @pulumi.getter
    def allows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Set of actions allowed by the permissions group.
        """
        return pulumi.get(self, "allows")

    @allows.setter
    def allows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allows", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation date of this group.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def denies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Set of actions that will be denied no matter what permissions group exists.
        """
        return pulumi.get(self, "denies")

    @denies.setter
    def denies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "denies", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Group description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def excepts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Set of actions that will be subtracted from the `allow` list.
        """
        return pulumi.get(self, "excepts")

    @excepts.setter
    def excepts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "excepts", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the permissions group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Owner of the permissions group.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date of the last update of this group.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter
    def urn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URN of the permissions group.
        """
        return pulumi.get(self, "urn")

    @urn.setter
    def urn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "urn", value)


@pulumi.type_token("ovh:Iam/permissionsGroup:PermissionsGroup")
class PermissionsGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 denies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 excepts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create am IAM permissions group.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allows: Set of actions allowed by the permissions group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] denies: Set of actions that will be denied no matter what permissions group exists.
        :param pulumi.Input[builtins.str] description: Group description.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] excepts: Set of actions that will be subtracted from the `allow` list.
        :param pulumi.Input[builtins.str] name: Name of the permissions group.
        :param pulumi.Input[builtins.str] updated_at: Date of the last update of this group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PermissionsGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create am IAM permissions group.

        :param str resource_name: The name of the resource.
        :param PermissionsGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PermissionsGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 denies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 excepts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PermissionsGroupArgs.__new__(PermissionsGroupArgs)

            __props__.__dict__["allows"] = allows
            __props__.__dict__["denies"] = denies
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["excepts"] = excepts
            __props__.__dict__["name"] = name
            __props__.__dict__["updated_at"] = updated_at
            __props__.__dict__["created_at"] = None
            __props__.__dict__["owner"] = None
            __props__.__dict__["urn"] = None
        super(PermissionsGroup, __self__).__init__(
            'ovh:Iam/permissionsGroup:PermissionsGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            denies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            excepts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            owner: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None,
            urn: Optional[pulumi.Input[builtins.str]] = None) -> 'PermissionsGroup':
        """
        Get an existing PermissionsGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allows: Set of actions allowed by the permissions group.
        :param pulumi.Input[builtins.str] created_at: Creation date of this group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] denies: Set of actions that will be denied no matter what permissions group exists.
        :param pulumi.Input[builtins.str] description: Group description.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] excepts: Set of actions that will be subtracted from the `allow` list.
        :param pulumi.Input[builtins.str] name: Name of the permissions group.
        :param pulumi.Input[builtins.str] owner: Owner of the permissions group.
        :param pulumi.Input[builtins.str] updated_at: Date of the last update of this group.
        :param pulumi.Input[builtins.str] urn: URN of the permissions group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PermissionsGroupState.__new__(_PermissionsGroupState)

        __props__.__dict__["allows"] = allows
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["denies"] = denies
        __props__.__dict__["description"] = description
        __props__.__dict__["excepts"] = excepts
        __props__.__dict__["name"] = name
        __props__.__dict__["owner"] = owner
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["urn"] = urn
        return PermissionsGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def allows(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Set of actions allowed by the permissions group.
        """
        return pulumi.get(self, "allows")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Creation date of this group.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def denies(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Set of actions that will be denied no matter what permissions group exists.
        """
        return pulumi.get(self, "denies")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Group description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def excepts(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Set of actions that will be subtracted from the `allow` list.
        """
        return pulumi.get(self, "excepts")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the permissions group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output[builtins.str]:
        """
        Owner of the permissions group.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        Date of the last update of this group.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def urn(self) -> pulumi.Output[builtins.str]:
        """
        URN of the permissions group.
        """
        return pulumi.get(self, "urn")

