# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PolicyArgs', 'Policy']

@pulumi.input_type
class PolicyArgs:
    def __init__(__self__, *,
                 identities: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 resources: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 allows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 denies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 excepts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 permissions_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Policy resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identities: List of identities affected by the policy
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] resources: List of resources affected by the policy
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allows: List of actions allowed on resources by identities
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] denies: List of actions that will always be denied even if also allowed by this policy or another one.
        :param pulumi.Input[builtins.str] description: Description of the policy
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] excepts: List of overrides of action that must not be allowed even if they are caught by allow. Only makes sens if allow contains wildcards.
        :param pulumi.Input[builtins.str] name: Name of the policy, must be unique
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] permissions_groups: Set of permissions groups included in the policy. At evaluation, these permissions groups are each evaluated independently (notably, excepts actions only affect actions in the same permission group).
        """
        pulumi.set(__self__, "identities", identities)
        pulumi.set(__self__, "resources", resources)
        if allows is not None:
            pulumi.set(__self__, "allows", allows)
        if denies is not None:
            pulumi.set(__self__, "denies", denies)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if excepts is not None:
            pulumi.set(__self__, "excepts", excepts)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permissions_groups is not None:
            pulumi.set(__self__, "permissions_groups", permissions_groups)

    @property
    @pulumi.getter
    def identities(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of identities affected by the policy
        """
        return pulumi.get(self, "identities")

    @identities.setter
    def identities(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "identities", value)

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of resources affected by the policy
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter
    def allows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of actions allowed on resources by identities
        """
        return pulumi.get(self, "allows")

    @allows.setter
    def allows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allows", value)

    @property
    @pulumi.getter
    def denies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of actions that will always be denied even if also allowed by this policy or another one.
        """
        return pulumi.get(self, "denies")

    @denies.setter
    def denies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "denies", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def excepts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of overrides of action that must not be allowed even if they are caught by allow. Only makes sens if allow contains wildcards.
        """
        return pulumi.get(self, "excepts")

    @excepts.setter
    def excepts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "excepts", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the policy, must be unique
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="permissionsGroups")
    def permissions_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Set of permissions groups included in the policy. At evaluation, these permissions groups are each evaluated independently (notably, excepts actions only affect actions in the same permission group).
        """
        return pulumi.get(self, "permissions_groups")

    @permissions_groups.setter
    def permissions_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "permissions_groups", value)


@pulumi.input_type
class _PolicyState:
    def __init__(__self__, *,
                 allows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 denies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 excepts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 identities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 permissions_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 read_only: Optional[pulumi.Input[builtins.bool]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Policy resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allows: List of actions allowed on resources by identities
        :param pulumi.Input[builtins.str] created_at: Creation date of this group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] denies: List of actions that will always be denied even if also allowed by this policy or another one.
        :param pulumi.Input[builtins.str] description: Description of the policy
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] excepts: List of overrides of action that must not be allowed even if they are caught by allow. Only makes sens if allow contains wildcards.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identities: List of identities affected by the policy
        :param pulumi.Input[builtins.str] name: Name of the policy, must be unique
        :param pulumi.Input[builtins.str] owner: Owner of the policy.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] permissions_groups: Set of permissions groups included in the policy. At evaluation, these permissions groups are each evaluated independently (notably, excepts actions only affect actions in the same permission group).
        :param pulumi.Input[builtins.bool] read_only: Indicates that the policy is a default one.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] resources: List of resources affected by the policy
        :param pulumi.Input[builtins.str] updated_at: Date of the last update of this group.
        """
        if allows is not None:
            pulumi.set(__self__, "allows", allows)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if denies is not None:
            pulumi.set(__self__, "denies", denies)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if excepts is not None:
            pulumi.set(__self__, "excepts", excepts)
        if identities is not None:
            pulumi.set(__self__, "identities", identities)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if permissions_groups is not None:
            pulumi.set(__self__, "permissions_groups", permissions_groups)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def allows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of actions allowed on resources by identities
        """
        return pulumi.get(self, "allows")

    @allows.setter
    def allows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allows", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation date of this group.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def denies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of actions that will always be denied even if also allowed by this policy or another one.
        """
        return pulumi.get(self, "denies")

    @denies.setter
    def denies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "denies", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def excepts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of overrides of action that must not be allowed even if they are caught by allow. Only makes sens if allow contains wildcards.
        """
        return pulumi.get(self, "excepts")

    @excepts.setter
    def excepts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "excepts", value)

    @property
    @pulumi.getter
    def identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of identities affected by the policy
        """
        return pulumi.get(self, "identities")

    @identities.setter
    def identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "identities", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the policy, must be unique
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Owner of the policy.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter(name="permissionsGroups")
    def permissions_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Set of permissions groups included in the policy. At evaluation, these permissions groups are each evaluated independently (notably, excepts actions only affect actions in the same permission group).
        """
        return pulumi.get(self, "permissions_groups")

    @permissions_groups.setter
    def permissions_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "permissions_groups", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates that the policy is a default one.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "read_only", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of resources affected by the policy
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date of the last update of this group.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("ovh:Iam/policy:Policy")
class Policy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 denies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 excepts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 identities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 permissions_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Creates an IAM policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        account = ovh.Me.get_me()
        my_group = ovh.me.IdentityGroup("my_group",
            name="my_group",
            description="my_group created in Terraform")
        manager = ovh.iam.Policy("manager",
            name="allow_ovh_manager",
            description="Users are allowed to use the OVH manager",
            identities=[my_group.group_urn],
            resources=[account.account_urn],
            allows=[
                "account:apiovh:me/get",
                "account:apiovh:me/supportLevel/get",
                "account:apiovh:me/certificates/get",
                "account:apiovh:me/tag/get",
                "account:apiovh:services/get",
                "account:apiovh:*",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allows: List of actions allowed on resources by identities
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] denies: List of actions that will always be denied even if also allowed by this policy or another one.
        :param pulumi.Input[builtins.str] description: Description of the policy
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] excepts: List of overrides of action that must not be allowed even if they are caught by allow. Only makes sens if allow contains wildcards.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identities: List of identities affected by the policy
        :param pulumi.Input[builtins.str] name: Name of the policy, must be unique
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] permissions_groups: Set of permissions groups included in the policy. At evaluation, these permissions groups are each evaluated independently (notably, excepts actions only affect actions in the same permission group).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] resources: List of resources affected by the policy
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an IAM policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        account = ovh.Me.get_me()
        my_group = ovh.me.IdentityGroup("my_group",
            name="my_group",
            description="my_group created in Terraform")
        manager = ovh.iam.Policy("manager",
            name="allow_ovh_manager",
            description="Users are allowed to use the OVH manager",
            identities=[my_group.group_urn],
            resources=[account.account_urn],
            allows=[
                "account:apiovh:me/get",
                "account:apiovh:me/supportLevel/get",
                "account:apiovh:me/certificates/get",
                "account:apiovh:me/tag/get",
                "account:apiovh:services/get",
                "account:apiovh:*",
            ])
        ```

        :param str resource_name: The name of the resource.
        :param PolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 denies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 excepts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 identities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 permissions_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyArgs.__new__(PolicyArgs)

            __props__.__dict__["allows"] = allows
            __props__.__dict__["denies"] = denies
            __props__.__dict__["description"] = description
            __props__.__dict__["excepts"] = excepts
            if identities is None and not opts.urn:
                raise TypeError("Missing required property 'identities'")
            __props__.__dict__["identities"] = identities
            __props__.__dict__["name"] = name
            __props__.__dict__["permissions_groups"] = permissions_groups
            if resources is None and not opts.urn:
                raise TypeError("Missing required property 'resources'")
            __props__.__dict__["resources"] = resources
            __props__.__dict__["created_at"] = None
            __props__.__dict__["owner"] = None
            __props__.__dict__["read_only"] = None
            __props__.__dict__["updated_at"] = None
        super(Policy, __self__).__init__(
            'ovh:Iam/policy:Policy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allows: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            denies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            excepts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            identities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            owner: Optional[pulumi.Input[builtins.str]] = None,
            permissions_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            read_only: Optional[pulumi.Input[builtins.bool]] = None,
            resources: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None) -> 'Policy':
        """
        Get an existing Policy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allows: List of actions allowed on resources by identities
        :param pulumi.Input[builtins.str] created_at: Creation date of this group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] denies: List of actions that will always be denied even if also allowed by this policy or another one.
        :param pulumi.Input[builtins.str] description: Description of the policy
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] excepts: List of overrides of action that must not be allowed even if they are caught by allow. Only makes sens if allow contains wildcards.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identities: List of identities affected by the policy
        :param pulumi.Input[builtins.str] name: Name of the policy, must be unique
        :param pulumi.Input[builtins.str] owner: Owner of the policy.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] permissions_groups: Set of permissions groups included in the policy. At evaluation, these permissions groups are each evaluated independently (notably, excepts actions only affect actions in the same permission group).
        :param pulumi.Input[builtins.bool] read_only: Indicates that the policy is a default one.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] resources: List of resources affected by the policy
        :param pulumi.Input[builtins.str] updated_at: Date of the last update of this group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyState.__new__(_PolicyState)

        __props__.__dict__["allows"] = allows
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["denies"] = denies
        __props__.__dict__["description"] = description
        __props__.__dict__["excepts"] = excepts
        __props__.__dict__["identities"] = identities
        __props__.__dict__["name"] = name
        __props__.__dict__["owner"] = owner
        __props__.__dict__["permissions_groups"] = permissions_groups
        __props__.__dict__["read_only"] = read_only
        __props__.__dict__["resources"] = resources
        __props__.__dict__["updated_at"] = updated_at
        return Policy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def allows(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of actions allowed on resources by identities
        """
        return pulumi.get(self, "allows")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Creation date of this group.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def denies(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of actions that will always be denied even if also allowed by this policy or another one.
        """
        return pulumi.get(self, "denies")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the policy
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def excepts(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of overrides of action that must not be allowed even if they are caught by allow. Only makes sens if allow contains wildcards.
        """
        return pulumi.get(self, "excepts")

    @property
    @pulumi.getter
    def identities(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of identities affected by the policy
        """
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the policy, must be unique
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output[builtins.str]:
        """
        Owner of the policy.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="permissionsGroups")
    def permissions_groups(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Set of permissions groups included in the policy. At evaluation, these permissions groups are each evaluated independently (notably, excepts actions only affect actions in the same permission group).
        """
        return pulumi.get(self, "permissions_groups")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates that the policy is a default one.
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of resources affected by the policy
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        Date of the last update of this group.
        """
        return pulumi.get(self, "updated_at")

