# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetFirewallResult',
    'AwaitableGetFirewallResult',
    'get_firewall',
    'get_firewall_output',
]

@pulumi.output_type
class GetFirewallResult:
    """
    A collection of values returned by getFirewall.
    """
    def __init__(__self__, enabled=None, id=None, ip=None, ip_on_firewall=None, state=None):
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip and not isinstance(ip, str):
            raise TypeError("Expected argument 'ip' to be a str")
        pulumi.set(__self__, "ip", ip)
        if ip_on_firewall and not isinstance(ip_on_firewall, str):
            raise TypeError("Expected argument 'ip_on_firewall' to be a str")
        pulumi.set(__self__, "ip_on_firewall", ip_on_firewall)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ip(self) -> builtins.str:
        """
        The IP or the CIDR
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipOnFirewall")
    def ip_on_firewall(self) -> builtins.str:
        """
        IPv4 address
        * `enabled ` - Whether firewall is enabled
        """
        return pulumi.get(self, "ip_on_firewall")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Current state of your ip on firewall
        """
        return pulumi.get(self, "state")


class AwaitableGetFirewallResult(GetFirewallResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFirewallResult(
            enabled=self.enabled,
            id=self.id,
            ip=self.ip,
            ip_on_firewall=self.ip_on_firewall,
            state=self.state)


def get_firewall(ip: Optional[builtins.str] = None,
                 ip_on_firewall: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFirewallResult:
    """
    Use this data source to retrieve information about an IP firewall.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    my_firewall = ovh.Ip.get_firewall(ip="XXXXXX",
        ip_on_firewall="XXXXXX")
    ```


    :param builtins.str ip: The IP or the CIDR
    :param builtins.str ip_on_firewall: IPv4 address
    """
    __args__ = dict()
    __args__['ip'] = ip
    __args__['ipOnFirewall'] = ip_on_firewall
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:Ip/getFirewall:getFirewall', __args__, opts=opts, typ=GetFirewallResult).value

    return AwaitableGetFirewallResult(
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        ip=pulumi.get(__ret__, 'ip'),
        ip_on_firewall=pulumi.get(__ret__, 'ip_on_firewall'),
        state=pulumi.get(__ret__, 'state'))
def get_firewall_output(ip: Optional[pulumi.Input[builtins.str]] = None,
                        ip_on_firewall: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFirewallResult]:
    """
    Use this data source to retrieve information about an IP firewall.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    my_firewall = ovh.Ip.get_firewall(ip="XXXXXX",
        ip_on_firewall="XXXXXX")
    ```


    :param builtins.str ip: The IP or the CIDR
    :param builtins.str ip_on_firewall: IPv4 address
    """
    __args__ = dict()
    __args__['ip'] = ip
    __args__['ipOnFirewall'] = ip_on_firewall
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:Ip/getFirewall:getFirewall', __args__, opts=opts, typ=GetFirewallResult)
    return __ret__.apply(lambda __response__: GetFirewallResult(
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        ip=pulumi.get(__response__, 'ip'),
        ip_on_firewall=pulumi.get(__response__, 'ip_on_firewall'),
        state=pulumi.get(__response__, 'state')))
