# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetFirewallRuleResult',
    'AwaitableGetFirewallRuleResult',
    'get_firewall_rule',
    'get_firewall_rule_output',
]

@pulumi.output_type
class GetFirewallRuleResult:
    """
    A collection of values returned by getFirewallRule.
    """
    def __init__(__self__, action=None, creation_date=None, destination=None, destination_port=None, fragments=None, id=None, ip=None, ip_on_firewall=None, protocol=None, rule=None, sequence=None, source=None, source_port=None, state=None, tcp_option=None):
        if action and not isinstance(action, str):
            raise TypeError("Expected argument 'action' to be a str")
        pulumi.set(__self__, "action", action)
        if creation_date and not isinstance(creation_date, str):
            raise TypeError("Expected argument 'creation_date' to be a str")
        pulumi.set(__self__, "creation_date", creation_date)
        if destination and not isinstance(destination, str):
            raise TypeError("Expected argument 'destination' to be a str")
        pulumi.set(__self__, "destination", destination)
        if destination_port and not isinstance(destination_port, str):
            raise TypeError("Expected argument 'destination_port' to be a str")
        pulumi.set(__self__, "destination_port", destination_port)
        if fragments and not isinstance(fragments, bool):
            raise TypeError("Expected argument 'fragments' to be a bool")
        pulumi.set(__self__, "fragments", fragments)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip and not isinstance(ip, str):
            raise TypeError("Expected argument 'ip' to be a str")
        pulumi.set(__self__, "ip", ip)
        if ip_on_firewall and not isinstance(ip_on_firewall, str):
            raise TypeError("Expected argument 'ip_on_firewall' to be a str")
        pulumi.set(__self__, "ip_on_firewall", ip_on_firewall)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if rule and not isinstance(rule, str):
            raise TypeError("Expected argument 'rule' to be a str")
        pulumi.set(__self__, "rule", rule)
        if sequence and not isinstance(sequence, float):
            raise TypeError("Expected argument 'sequence' to be a float")
        pulumi.set(__self__, "sequence", sequence)
        if source and not isinstance(source, str):
            raise TypeError("Expected argument 'source' to be a str")
        pulumi.set(__self__, "source", source)
        if source_port and not isinstance(source_port, str):
            raise TypeError("Expected argument 'source_port' to be a str")
        pulumi.set(__self__, "source_port", source_port)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tcp_option and not isinstance(tcp_option, str):
            raise TypeError("Expected argument 'tcp_option' to be a str")
        pulumi.set(__self__, "tcp_option", tcp_option)

    @property
    @pulumi.getter
    def action(self) -> builtins.str:
        """
        Possible values for action (deny|permit)
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> builtins.str:
        """
        Creation date of the rule
        """
        return pulumi.get(self, "creation_date")

    @property
    @pulumi.getter
    def destination(self) -> builtins.str:
        """
        Destination IP for your rule
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> builtins.str:
        """
        Destination port for your rule. Only with TCP/UDP protocol
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter
    def fragments(self) -> builtins.bool:
        """
        Fragments option
        """
        return pulumi.get(self, "fragments")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ip(self) -> builtins.str:
        """
        The IP or the CIDR
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ipOnFirewall")
    def ip_on_firewall(self) -> builtins.str:
        """
        IPv4 address
        """
        return pulumi.get(self, "ip_on_firewall")

    @property
    @pulumi.getter
    def protocol(self) -> builtins.str:
        """
        Possible values for protocol (ah|esp|gre|icmp|ipv4|tcp|udp)
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def rule(self) -> builtins.str:
        """
        Description of the rule
        """
        return pulumi.get(self, "rule")

    @property
    @pulumi.getter
    def sequence(self) -> builtins.float:
        """
        Rule position in the rules array
        """
        return pulumi.get(self, "sequence")

    @property
    @pulumi.getter
    def source(self) -> builtins.str:
        """
        IPv4 CIDR notation (e.g., 192.0.2.0/24)
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> builtins.str:
        """
        Source port for your rule. Only with TCP/UDP protocol
        """
        return pulumi.get(self, "source_port")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        Current state of your rule
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tcpOption")
    def tcp_option(self) -> builtins.str:
        """
        TCP option on your rule (syn|established)
        """
        return pulumi.get(self, "tcp_option")


class AwaitableGetFirewallRuleResult(GetFirewallRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFirewallRuleResult(
            action=self.action,
            creation_date=self.creation_date,
            destination=self.destination,
            destination_port=self.destination_port,
            fragments=self.fragments,
            id=self.id,
            ip=self.ip,
            ip_on_firewall=self.ip_on_firewall,
            protocol=self.protocol,
            rule=self.rule,
            sequence=self.sequence,
            source=self.source,
            source_port=self.source_port,
            state=self.state,
            tcp_option=self.tcp_option)


def get_firewall_rule(ip: Optional[builtins.str] = None,
                      ip_on_firewall: Optional[builtins.str] = None,
                      sequence: Optional[builtins.float] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFirewallRuleResult:
    """
    Use this data source to retrieve information about a rule on an IP firewall.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    my_firewall_rule = ovh.Ip.get_firewall_rule(ip="XXXXXX",
        ip_on_firewall="XXXXXX",
        sequence=0)
    ```


    :param builtins.str ip: The IP or the CIDR
    :param builtins.str ip_on_firewall: IPv4 address
    :param builtins.float sequence: Rule position in the rules array
    """
    __args__ = dict()
    __args__['ip'] = ip
    __args__['ipOnFirewall'] = ip_on_firewall
    __args__['sequence'] = sequence
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:Ip/getFirewallRule:getFirewallRule', __args__, opts=opts, typ=GetFirewallRuleResult).value

    return AwaitableGetFirewallRuleResult(
        action=pulumi.get(__ret__, 'action'),
        creation_date=pulumi.get(__ret__, 'creation_date'),
        destination=pulumi.get(__ret__, 'destination'),
        destination_port=pulumi.get(__ret__, 'destination_port'),
        fragments=pulumi.get(__ret__, 'fragments'),
        id=pulumi.get(__ret__, 'id'),
        ip=pulumi.get(__ret__, 'ip'),
        ip_on_firewall=pulumi.get(__ret__, 'ip_on_firewall'),
        protocol=pulumi.get(__ret__, 'protocol'),
        rule=pulumi.get(__ret__, 'rule'),
        sequence=pulumi.get(__ret__, 'sequence'),
        source=pulumi.get(__ret__, 'source'),
        source_port=pulumi.get(__ret__, 'source_port'),
        state=pulumi.get(__ret__, 'state'),
        tcp_option=pulumi.get(__ret__, 'tcp_option'))
def get_firewall_rule_output(ip: Optional[pulumi.Input[builtins.str]] = None,
                             ip_on_firewall: Optional[pulumi.Input[builtins.str]] = None,
                             sequence: Optional[pulumi.Input[builtins.float]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFirewallRuleResult]:
    """
    Use this data source to retrieve information about a rule on an IP firewall.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    my_firewall_rule = ovh.Ip.get_firewall_rule(ip="XXXXXX",
        ip_on_firewall="XXXXXX",
        sequence=0)
    ```


    :param builtins.str ip: The IP or the CIDR
    :param builtins.str ip_on_firewall: IPv4 address
    :param builtins.float sequence: Rule position in the rules array
    """
    __args__ = dict()
    __args__['ip'] = ip
    __args__['ipOnFirewall'] = ip_on_firewall
    __args__['sequence'] = sequence
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:Ip/getFirewallRule:getFirewallRule', __args__, opts=opts, typ=GetFirewallRuleResult)
    return __ret__.apply(lambda __response__: GetFirewallRuleResult(
        action=pulumi.get(__response__, 'action'),
        creation_date=pulumi.get(__response__, 'creation_date'),
        destination=pulumi.get(__response__, 'destination'),
        destination_port=pulumi.get(__response__, 'destination_port'),
        fragments=pulumi.get(__response__, 'fragments'),
        id=pulumi.get(__response__, 'id'),
        ip=pulumi.get(__response__, 'ip'),
        ip_on_firewall=pulumi.get(__response__, 'ip_on_firewall'),
        protocol=pulumi.get(__response__, 'protocol'),
        rule=pulumi.get(__response__, 'rule'),
        sequence=pulumi.get(__response__, 'sequence'),
        source=pulumi.get(__response__, 'source'),
        source_port=pulumi.get(__response__, 'source_port'),
        state=pulumi.get(__response__, 'state'),
        tcp_option=pulumi.get(__response__, 'tcp_option')))
