# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MoveArgs', 'Move']

@pulumi.input_type
class MoveArgs:
    def __init__(__self__, *,
                 ip: pulumi.Input[builtins.str],
                 routed_to: pulumi.Input['MoveRoutedToArgs'],
                 description: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Move resource.
        :param pulumi.Input[builtins.str] ip: IP block that we want to attach to a different service
        :param pulumi.Input['MoveRoutedToArgs'] routed_to: Service to route the IP to. If null, the IP will be [parked](https://api.ovh.com/console/#/ip/%7Bip%7D/park~POST) instead of [moved](https://api.ovh.com/console/#/ip/%7Bip%7D/move~POST)
        :param pulumi.Input[builtins.str] description: Description attached to the IP
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "routed_to", routed_to)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Input[builtins.str]:
        """
        IP block that we want to attach to a different service
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="routedTo")
    def routed_to(self) -> pulumi.Input['MoveRoutedToArgs']:
        """
        Service to route the IP to. If null, the IP will be [parked](https://api.ovh.com/console/#/ip/%7Bip%7D/park~POST) instead of [moved](https://api.ovh.com/console/#/ip/%7Bip%7D/move~POST)
        """
        return pulumi.get(self, "routed_to")

    @routed_to.setter
    def routed_to(self, value: pulumi.Input['MoveRoutedToArgs']):
        pulumi.set(self, "routed_to", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description attached to the IP
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _MoveState:
    def __init__(__self__, *,
                 can_be_terminated: Optional[pulumi.Input[builtins.bool]] = None,
                 country: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 ip: Optional[pulumi.Input[builtins.str]] = None,
                 organisation_id: Optional[pulumi.Input[builtins.str]] = None,
                 routed_to: Optional[pulumi.Input['MoveRoutedToArgs']] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 task_start_date: Optional[pulumi.Input[builtins.str]] = None,
                 task_status: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Move resources.
        :param pulumi.Input[builtins.bool] can_be_terminated: Whether IP service can be terminated
        :param pulumi.Input[builtins.str] country: Country
        :param pulumi.Input[builtins.str] description: Description attached to the IP
        :param pulumi.Input[builtins.str] ip: IP block that we want to attach to a different service
        :param pulumi.Input[builtins.str] organisation_id: IP block organisation Id
        :param pulumi.Input['MoveRoutedToArgs'] routed_to: Service to route the IP to. If null, the IP will be [parked](https://api.ovh.com/console/#/ip/%7Bip%7D/park~POST) instead of [moved](https://api.ovh.com/console/#/ip/%7Bip%7D/move~POST)
        :param pulumi.Input[builtins.str] service_name: Service name in the form of `ip-<part-1>.<part-2>.<part-3>.<part-4>`
        :param pulumi.Input[builtins.str] task_start_date: Starting date and time field of the current IP task that is in charge of changing the service the IP is attached to
        :param pulumi.Input[builtins.str] task_status: Status field of the current IP task that is in charge of changing the service the IP is attached to
        :param pulumi.Input[builtins.str] type: Possible values for ip type
        """
        if can_be_terminated is not None:
            pulumi.set(__self__, "can_be_terminated", can_be_terminated)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if organisation_id is not None:
            pulumi.set(__self__, "organisation_id", organisation_id)
        if routed_to is not None:
            pulumi.set(__self__, "routed_to", routed_to)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if task_start_date is not None:
            pulumi.set(__self__, "task_start_date", task_start_date)
        if task_status is not None:
            pulumi.set(__self__, "task_status", task_status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="canBeTerminated")
    def can_be_terminated(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether IP service can be terminated
        """
        return pulumi.get(self, "can_be_terminated")

    @can_be_terminated.setter
    def can_be_terminated(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "can_be_terminated", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Country
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description attached to the IP
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP block that we want to attach to a different service
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="organisationId")
    def organisation_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP block organisation Id
        """
        return pulumi.get(self, "organisation_id")

    @organisation_id.setter
    def organisation_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organisation_id", value)

    @property
    @pulumi.getter(name="routedTo")
    def routed_to(self) -> Optional[pulumi.Input['MoveRoutedToArgs']]:
        """
        Service to route the IP to. If null, the IP will be [parked](https://api.ovh.com/console/#/ip/%7Bip%7D/park~POST) instead of [moved](https://api.ovh.com/console/#/ip/%7Bip%7D/move~POST)
        """
        return pulumi.get(self, "routed_to")

    @routed_to.setter
    def routed_to(self, value: Optional[pulumi.Input['MoveRoutedToArgs']]):
        pulumi.set(self, "routed_to", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service name in the form of `ip-<part-1>.<part-2>.<part-3>.<part-4>`
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="taskStartDate")
    def task_start_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Starting date and time field of the current IP task that is in charge of changing the service the IP is attached to
        """
        return pulumi.get(self, "task_start_date")

    @task_start_date.setter
    def task_start_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "task_start_date", value)

    @property
    @pulumi.getter(name="taskStatus")
    def task_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Status field of the current IP task that is in charge of changing the service the IP is attached to
        """
        return pulumi.get(self, "task_status")

    @task_status.setter
    def task_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "task_status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible values for ip type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("ovh:Ip/move:Move")
class Move(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 ip: Optional[pulumi.Input[builtins.str]] = None,
                 routed_to: Optional[pulumi.Input[Union['MoveRoutedToArgs', 'MoveRoutedToArgsDict']]] = None,
                 __props__=None):
        """
        Moves a given IP to a different service, or inversely, parks it if empty service is given

        ## Move IP `1.2.3.4` to service loadbalancer-XXXXX

        ```python
        import pulumi
        import pulumi_ovh as ovh

        move_ip_to_load_balancer_xxxxx = ovh.ip.Move("move_ip_to_load_balancer_xxxxx",
            ip="1.2.3.4",
            routed_to={
                "service_name": "loadbalancer-XXXXX",
            })
        ```

        ## Park IP/Detach IP `1.2.3.4` from any service

        ```python
        import pulumi
        import pulumi_ovh as ovh

        park_ip = ovh.ip.Move("park_ip",
            ip="1.2.3.4",
            routed_to={
                "service_name": "",
            })
        ```

        ## Import

        The resource can be imported using the `ip` field, e.g.,

        bash

        ```sh
        $ pulumi import ovh:Ip/move:Move mv '1.2.3.4/32'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Description attached to the IP
        :param pulumi.Input[builtins.str] ip: IP block that we want to attach to a different service
        :param pulumi.Input[Union['MoveRoutedToArgs', 'MoveRoutedToArgsDict']] routed_to: Service to route the IP to. If null, the IP will be [parked](https://api.ovh.com/console/#/ip/%7Bip%7D/park~POST) instead of [moved](https://api.ovh.com/console/#/ip/%7Bip%7D/move~POST)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MoveArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Moves a given IP to a different service, or inversely, parks it if empty service is given

        ## Move IP `1.2.3.4` to service loadbalancer-XXXXX

        ```python
        import pulumi
        import pulumi_ovh as ovh

        move_ip_to_load_balancer_xxxxx = ovh.ip.Move("move_ip_to_load_balancer_xxxxx",
            ip="1.2.3.4",
            routed_to={
                "service_name": "loadbalancer-XXXXX",
            })
        ```

        ## Park IP/Detach IP `1.2.3.4` from any service

        ```python
        import pulumi
        import pulumi_ovh as ovh

        park_ip = ovh.ip.Move("park_ip",
            ip="1.2.3.4",
            routed_to={
                "service_name": "",
            })
        ```

        ## Import

        The resource can be imported using the `ip` field, e.g.,

        bash

        ```sh
        $ pulumi import ovh:Ip/move:Move mv '1.2.3.4/32'
        ```

        :param str resource_name: The name of the resource.
        :param MoveArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MoveArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 ip: Optional[pulumi.Input[builtins.str]] = None,
                 routed_to: Optional[pulumi.Input[Union['MoveRoutedToArgs', 'MoveRoutedToArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MoveArgs.__new__(MoveArgs)

            __props__.__dict__["description"] = description
            if ip is None and not opts.urn:
                raise TypeError("Missing required property 'ip'")
            __props__.__dict__["ip"] = ip
            if routed_to is None and not opts.urn:
                raise TypeError("Missing required property 'routed_to'")
            __props__.__dict__["routed_to"] = routed_to
            __props__.__dict__["can_be_terminated"] = None
            __props__.__dict__["country"] = None
            __props__.__dict__["organisation_id"] = None
            __props__.__dict__["service_name"] = None
            __props__.__dict__["task_start_date"] = None
            __props__.__dict__["task_status"] = None
            __props__.__dict__["type"] = None
        super(Move, __self__).__init__(
            'ovh:Ip/move:Move',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            can_be_terminated: Optional[pulumi.Input[builtins.bool]] = None,
            country: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            ip: Optional[pulumi.Input[builtins.str]] = None,
            organisation_id: Optional[pulumi.Input[builtins.str]] = None,
            routed_to: Optional[pulumi.Input[Union['MoveRoutedToArgs', 'MoveRoutedToArgsDict']]] = None,
            service_name: Optional[pulumi.Input[builtins.str]] = None,
            task_start_date: Optional[pulumi.Input[builtins.str]] = None,
            task_status: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'Move':
        """
        Get an existing Move resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] can_be_terminated: Whether IP service can be terminated
        :param pulumi.Input[builtins.str] country: Country
        :param pulumi.Input[builtins.str] description: Description attached to the IP
        :param pulumi.Input[builtins.str] ip: IP block that we want to attach to a different service
        :param pulumi.Input[builtins.str] organisation_id: IP block organisation Id
        :param pulumi.Input[Union['MoveRoutedToArgs', 'MoveRoutedToArgsDict']] routed_to: Service to route the IP to. If null, the IP will be [parked](https://api.ovh.com/console/#/ip/%7Bip%7D/park~POST) instead of [moved](https://api.ovh.com/console/#/ip/%7Bip%7D/move~POST)
        :param pulumi.Input[builtins.str] service_name: Service name in the form of `ip-<part-1>.<part-2>.<part-3>.<part-4>`
        :param pulumi.Input[builtins.str] task_start_date: Starting date and time field of the current IP task that is in charge of changing the service the IP is attached to
        :param pulumi.Input[builtins.str] task_status: Status field of the current IP task that is in charge of changing the service the IP is attached to
        :param pulumi.Input[builtins.str] type: Possible values for ip type
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MoveState.__new__(_MoveState)

        __props__.__dict__["can_be_terminated"] = can_be_terminated
        __props__.__dict__["country"] = country
        __props__.__dict__["description"] = description
        __props__.__dict__["ip"] = ip
        __props__.__dict__["organisation_id"] = organisation_id
        __props__.__dict__["routed_to"] = routed_to
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["task_start_date"] = task_start_date
        __props__.__dict__["task_status"] = task_status
        __props__.__dict__["type"] = type
        return Move(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="canBeTerminated")
    def can_be_terminated(self) -> pulumi.Output[builtins.bool]:
        """
        Whether IP service can be terminated
        """
        return pulumi.get(self, "can_be_terminated")

    @property
    @pulumi.getter
    def country(self) -> pulumi.Output[builtins.str]:
        """
        Country
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Description attached to the IP
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Output[builtins.str]:
        """
        IP block that we want to attach to a different service
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="organisationId")
    def organisation_id(self) -> pulumi.Output[builtins.str]:
        """
        IP block organisation Id
        """
        return pulumi.get(self, "organisation_id")

    @property
    @pulumi.getter(name="routedTo")
    def routed_to(self) -> pulumi.Output['outputs.MoveRoutedTo']:
        """
        Service to route the IP to. If null, the IP will be [parked](https://api.ovh.com/console/#/ip/%7Bip%7D/park~POST) instead of [moved](https://api.ovh.com/console/#/ip/%7Bip%7D/move~POST)
        """
        return pulumi.get(self, "routed_to")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[builtins.str]:
        """
        Service name in the form of `ip-<part-1>.<part-2>.<part-3>.<part-4>`
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="taskStartDate")
    def task_start_date(self) -> pulumi.Output[builtins.str]:
        """
        Starting date and time field of the current IP task that is in charge of changing the service the IP is attached to
        """
        return pulumi.get(self, "task_start_date")

    @property
    @pulumi.getter(name="taskStatus")
    def task_status(self) -> pulumi.Output[builtins.str]:
        """
        Status field of the current IP task that is in charge of changing the service the IP is attached to
        """
        return pulumi.get(self, "task_status")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Possible values for ip type
        """
        return pulumi.get(self, "type")

