# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ReverseArgs', 'Reverse']

@pulumi.input_type
class ReverseArgs:
    def __init__(__self__, *,
                 reverse_ip: pulumi.Input[builtins.str],
                 reverse_value: pulumi.Input[builtins.str],
                 ip: pulumi.Input[builtins.str],
                 readiness_timeout_duration: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Reverse resource.
        :param pulumi.Input[builtins.str] reverse_ip: The IP to set the reverse of
        :param pulumi.Input[builtins.str] reverse_value: The value of the reverse
        :param pulumi.Input[builtins.str] ip: The IP block to which the IP belongs
        :param pulumi.Input[builtins.str] readiness_timeout_duration: The maximum duration that the provider will wait for a successful response (while retrying every 5s). If the record cannot be verified within this timeout, the operation will fail (default value: 60s)
        """
        pulumi.set(__self__, "reverse_ip", reverse_ip)
        pulumi.set(__self__, "reverse_value", reverse_value)
        pulumi.set(__self__, "ip", ip)
        if readiness_timeout_duration is not None:
            pulumi.set(__self__, "readiness_timeout_duration", readiness_timeout_duration)

    @property
    @pulumi.getter(name="ReverseIp")
    def reverse_ip(self) -> pulumi.Input[builtins.str]:
        """
        The IP to set the reverse of
        """
        return pulumi.get(self, "reverse_ip")

    @reverse_ip.setter
    def reverse_ip(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "reverse_ip", value)

    @property
    @pulumi.getter(name="ReverseValue")
    def reverse_value(self) -> pulumi.Input[builtins.str]:
        """
        The value of the reverse
        """
        return pulumi.get(self, "reverse_value")

    @reverse_value.setter
    def reverse_value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "reverse_value", value)

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Input[builtins.str]:
        """
        The IP block to which the IP belongs
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="readinessTimeoutDuration")
    def readiness_timeout_duration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The maximum duration that the provider will wait for a successful response (while retrying every 5s). If the record cannot be verified within this timeout, the operation will fail (default value: 60s)
        """
        return pulumi.get(self, "readiness_timeout_duration")

    @readiness_timeout_duration.setter
    def readiness_timeout_duration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "readiness_timeout_duration", value)


@pulumi.input_type
class _ReverseState:
    def __init__(__self__, *,
                 reverse_ip: Optional[pulumi.Input[builtins.str]] = None,
                 reverse_value: Optional[pulumi.Input[builtins.str]] = None,
                 ip: Optional[pulumi.Input[builtins.str]] = None,
                 readiness_timeout_duration: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Reverse resources.
        :param pulumi.Input[builtins.str] reverse_ip: The IP to set the reverse of
        :param pulumi.Input[builtins.str] reverse_value: The value of the reverse
        :param pulumi.Input[builtins.str] ip: The IP block to which the IP belongs
        :param pulumi.Input[builtins.str] readiness_timeout_duration: The maximum duration that the provider will wait for a successful response (while retrying every 5s). If the record cannot be verified within this timeout, the operation will fail (default value: 60s)
        """
        if reverse_ip is not None:
            pulumi.set(__self__, "reverse_ip", reverse_ip)
        if reverse_value is not None:
            pulumi.set(__self__, "reverse_value", reverse_value)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if readiness_timeout_duration is not None:
            pulumi.set(__self__, "readiness_timeout_duration", readiness_timeout_duration)

    @property
    @pulumi.getter(name="ReverseIp")
    def reverse_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP to set the reverse of
        """
        return pulumi.get(self, "reverse_ip")

    @reverse_ip.setter
    def reverse_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reverse_ip", value)

    @property
    @pulumi.getter(name="ReverseValue")
    def reverse_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value of the reverse
        """
        return pulumi.get(self, "reverse_value")

    @reverse_value.setter
    def reverse_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reverse_value", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP block to which the IP belongs
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="readinessTimeoutDuration")
    def readiness_timeout_duration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The maximum duration that the provider will wait for a successful response (while retrying every 5s). If the record cannot be verified within this timeout, the operation will fail (default value: 60s)
        """
        return pulumi.get(self, "readiness_timeout_duration")

    @readiness_timeout_duration.setter
    def readiness_timeout_duration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "readiness_timeout_duration", value)


@pulumi.type_token("ovh:Ip/reverse:Reverse")
class Reverse(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 reverse_ip: Optional[pulumi.Input[builtins.str]] = None,
                 reverse_value: Optional[pulumi.Input[builtins.str]] = None,
                 ip: Optional[pulumi.Input[builtins.str]] = None,
                 readiness_timeout_duration: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a OVHcloud IP reverse.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        # Set the reverse of an IP
        test = ovh.ip.Reverse("test",
            readiness_timeout_duration="1m",
            ip="192.0.2.0/24",
            reverse_ip="192.0.2.1",
            reverse_value="example.com")
        ```

        ## Import

        The resource can be imported using the `ip`, `ip_reverse` of the address, separated by "|" E.g.,

        bash

        ```sh
        $ pulumi import ovh:Ip/reverse:Reverse my_reverse '2001:0db8:c0ff:ee::/64|2001:0db8:c0ff:ee::42'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] reverse_ip: The IP to set the reverse of
        :param pulumi.Input[builtins.str] reverse_value: The value of the reverse
        :param pulumi.Input[builtins.str] ip: The IP block to which the IP belongs
        :param pulumi.Input[builtins.str] readiness_timeout_duration: The maximum duration that the provider will wait for a successful response (while retrying every 5s). If the record cannot be verified within this timeout, the operation will fail (default value: 60s)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReverseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a OVHcloud IP reverse.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        # Set the reverse of an IP
        test = ovh.ip.Reverse("test",
            readiness_timeout_duration="1m",
            ip="192.0.2.0/24",
            reverse_ip="192.0.2.1",
            reverse_value="example.com")
        ```

        ## Import

        The resource can be imported using the `ip`, `ip_reverse` of the address, separated by "|" E.g.,

        bash

        ```sh
        $ pulumi import ovh:Ip/reverse:Reverse my_reverse '2001:0db8:c0ff:ee::/64|2001:0db8:c0ff:ee::42'
        ```

        :param str resource_name: The name of the resource.
        :param ReverseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReverseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 reverse_ip: Optional[pulumi.Input[builtins.str]] = None,
                 reverse_value: Optional[pulumi.Input[builtins.str]] = None,
                 ip: Optional[pulumi.Input[builtins.str]] = None,
                 readiness_timeout_duration: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReverseArgs.__new__(ReverseArgs)

            if reverse_ip is None and not opts.urn:
                raise TypeError("Missing required property 'reverse_ip'")
            __props__.__dict__["reverse_ip"] = reverse_ip
            if reverse_value is None and not opts.urn:
                raise TypeError("Missing required property 'reverse_value'")
            __props__.__dict__["reverse_value"] = reverse_value
            if ip is None and not opts.urn:
                raise TypeError("Missing required property 'ip'")
            __props__.__dict__["ip"] = ip
            __props__.__dict__["readiness_timeout_duration"] = readiness_timeout_duration
        super(Reverse, __self__).__init__(
            'ovh:Ip/reverse:Reverse',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            reverse_ip: Optional[pulumi.Input[builtins.str]] = None,
            reverse_value: Optional[pulumi.Input[builtins.str]] = None,
            ip: Optional[pulumi.Input[builtins.str]] = None,
            readiness_timeout_duration: Optional[pulumi.Input[builtins.str]] = None) -> 'Reverse':
        """
        Get an existing Reverse resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] reverse_ip: The IP to set the reverse of
        :param pulumi.Input[builtins.str] reverse_value: The value of the reverse
        :param pulumi.Input[builtins.str] ip: The IP block to which the IP belongs
        :param pulumi.Input[builtins.str] readiness_timeout_duration: The maximum duration that the provider will wait for a successful response (while retrying every 5s). If the record cannot be verified within this timeout, the operation will fail (default value: 60s)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReverseState.__new__(_ReverseState)

        __props__.__dict__["reverse_ip"] = reverse_ip
        __props__.__dict__["reverse_value"] = reverse_value
        __props__.__dict__["ip"] = ip
        __props__.__dict__["readiness_timeout_duration"] = readiness_timeout_duration
        return Reverse(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="ReverseIp")
    def reverse_ip(self) -> pulumi.Output[builtins.str]:
        """
        The IP to set the reverse of
        """
        return pulumi.get(self, "reverse_ip")

    @property
    @pulumi.getter(name="ReverseValue")
    def reverse_value(self) -> pulumi.Output[builtins.str]:
        """
        The value of the reverse
        """
        return pulumi.get(self, "reverse_value")

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Output[builtins.str]:
        """
        The IP block to which the IP belongs
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="readinessTimeoutDuration")
    def readiness_timeout_duration(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The maximum duration that the provider will wait for a successful response (while retrying every 5s). If the record cannot be verified within this timeout, the operation will fail (default value: 60s)
        """
        return pulumi.get(self, "readiness_timeout_duration")

