# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'HttpFarmProbeArgs',
    'HttpFarmProbeArgsDict',
    'HttpRouteActionArgs',
    'HttpRouteActionArgsDict',
    'HttpRouteRuleArgs',
    'HttpRouteRuleArgsDict',
    'LoadBalancerOrderArgs',
    'LoadBalancerOrderArgsDict',
    'LoadBalancerOrderDetailArgs',
    'LoadBalancerOrderDetailArgsDict',
    'LoadBalancerOrderableZoneArgs',
    'LoadBalancerOrderableZoneArgsDict',
    'LoadBalancerPlanArgs',
    'LoadBalancerPlanArgsDict',
    'LoadBalancerPlanConfigurationArgs',
    'LoadBalancerPlanConfigurationArgsDict',
    'LoadBalancerPlanOptionArgs',
    'LoadBalancerPlanOptionArgsDict',
    'LoadBalancerPlanOptionConfigurationArgs',
    'LoadBalancerPlanOptionConfigurationArgsDict',
    'TcpFarmProbeArgs',
    'TcpFarmProbeArgsDict',
    'TcpRouteActionArgs',
    'TcpRouteActionArgsDict',
    'TcpRouteRuleArgs',
    'TcpRouteRuleArgsDict',
]

MYPY = False

if not MYPY:
    class HttpFarmProbeArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        Valid values : `http`, `internal`, `mysql`, `oco`, `pgsql`, `smtp`, `tcp`
        """
        force_ssl: NotRequired[pulumi.Input[builtins.bool]]
        """
        Force use of SSL (TLS)
        """
        interval: NotRequired[pulumi.Input[builtins.int]]
        """
        probe interval, Value between 30 and 3600 seconds, default 30
        """
        match: NotRequired[pulumi.Input[builtins.str]]
        """
        What to match `pattern` against (`contains`, `default`, `internal`, `matches`, `status`)
        """
        method: NotRequired[pulumi.Input[builtins.str]]
        """
        HTTP probe method (`GET`, `HEAD`, `OPTIONS`, `internal`)
        """
        negate: NotRequired[pulumi.Input[builtins.bool]]
        """
        Negate probe result
        """
        pattern: NotRequired[pulumi.Input[builtins.str]]
        """
        Pattern to match against `match`
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        Port for backends to receive traffic on.
        """
        url: NotRequired[pulumi.Input[builtins.str]]
        """
        URL for HTTP probe type.
        """
elif False:
    HttpFarmProbeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HttpFarmProbeArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 force_ssl: Optional[pulumi.Input[builtins.bool]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 match: Optional[pulumi.Input[builtins.str]] = None,
                 method: Optional[pulumi.Input[builtins.str]] = None,
                 negate: Optional[pulumi.Input[builtins.bool]] = None,
                 pattern: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: Valid values : `http`, `internal`, `mysql`, `oco`, `pgsql`, `smtp`, `tcp`
        :param pulumi.Input[builtins.bool] force_ssl: Force use of SSL (TLS)
        :param pulumi.Input[builtins.int] interval: probe interval, Value between 30 and 3600 seconds, default 30
        :param pulumi.Input[builtins.str] match: What to match `pattern` against (`contains`, `default`, `internal`, `matches`, `status`)
        :param pulumi.Input[builtins.str] method: HTTP probe method (`GET`, `HEAD`, `OPTIONS`, `internal`)
        :param pulumi.Input[builtins.bool] negate: Negate probe result
        :param pulumi.Input[builtins.str] pattern: Pattern to match against `match`
        :param pulumi.Input[builtins.int] port: Port for backends to receive traffic on.
        :param pulumi.Input[builtins.str] url: URL for HTTP probe type.
        """
        pulumi.set(__self__, "type", type)
        if force_ssl is not None:
            pulumi.set(__self__, "force_ssl", force_ssl)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Valid values : `http`, `internal`, `mysql`, `oco`, `pgsql`, `smtp`, `tcp`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="forceSsl")
    def force_ssl(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Force use of SSL (TLS)
        """
        return pulumi.get(self, "force_ssl")

    @force_ssl.setter
    def force_ssl(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_ssl", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        probe interval, Value between 30 and 3600 seconds, default 30
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        What to match `pattern` against (`contains`, `default`, `internal`, `matches`, `status`)
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        HTTP probe method (`GET`, `HEAD`, `OPTIONS`, `internal`)
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def negate(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Negate probe result
        """
        return pulumi.get(self, "negate")

    @negate.setter
    def negate(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "negate", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Pattern to match against `match`
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Port for backends to receive traffic on.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL for HTTP probe type.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)


if not MYPY:
    class HttpRouteActionArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        Action to trigger if all the rules of this route matches
        """
        status: NotRequired[pulumi.Input[builtins.int]]
        """
        HTTP status code for "redirect" and "reject" actions
        """
        target: NotRequired[pulumi.Input[builtins.str]]
        """
        Farm ID for "farm" action type or URL template for "redirect" action. You may use ${uri}, ${protocol}, ${host}, ${port} and ${path} variables in redirect target
        """
elif False:
    HttpRouteActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HttpRouteActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 status: Optional[pulumi.Input[builtins.int]] = None,
                 target: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: Action to trigger if all the rules of this route matches
        :param pulumi.Input[builtins.int] status: HTTP status code for "redirect" and "reject" actions
        :param pulumi.Input[builtins.str] target: Farm ID for "farm" action type or URL template for "redirect" action. You may use ${uri}, ${protocol}, ${host}, ${port} and ${path} variables in redirect target
        """
        pulumi.set(__self__, "type", type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Action to trigger if all the rules of this route matches
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        HTTP status code for "redirect" and "reject" actions
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Farm ID for "farm" action type or URL template for "redirect" action. You may use ${uri}, ${protocol}, ${host}, ${port} and ${path} variables in redirect target
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target", value)


if not MYPY:
    class HttpRouteRuleArgsDict(TypedDict):
        field: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the field to match like "protocol" or "host" "/ipLoadbalancing/{serviceName}/route/availableRules" for a list of available rules
        """
        match: NotRequired[pulumi.Input[builtins.str]]
        """
        Matching operator. Not all operators are available for all fields. See "availableRules"
        """
        negate: NotRequired[pulumi.Input[builtins.bool]]
        """
        Invert the matching operator effect
        """
        pattern: NotRequired[pulumi.Input[builtins.str]]
        """
        Value to match against this match. Interpretation if this field depends on the match and field
        """
        rule_id: NotRequired[pulumi.Input[builtins.int]]
        """
        Id of your rule
        """
        sub_field: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
elif False:
    HttpRouteRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class HttpRouteRuleArgs:
    def __init__(__self__, *,
                 field: Optional[pulumi.Input[builtins.str]] = None,
                 match: Optional[pulumi.Input[builtins.str]] = None,
                 negate: Optional[pulumi.Input[builtins.bool]] = None,
                 pattern: Optional[pulumi.Input[builtins.str]] = None,
                 rule_id: Optional[pulumi.Input[builtins.int]] = None,
                 sub_field: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] field: Name of the field to match like "protocol" or "host" "/ipLoadbalancing/{serviceName}/route/availableRules" for a list of available rules
        :param pulumi.Input[builtins.str] match: Matching operator. Not all operators are available for all fields. See "availableRules"
        :param pulumi.Input[builtins.bool] negate: Invert the matching operator effect
        :param pulumi.Input[builtins.str] pattern: Value to match against this match. Interpretation if this field depends on the match and field
        :param pulumi.Input[builtins.int] rule_id: Id of your rule
        :param pulumi.Input[builtins.str] sub_field: Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        if field is not None:
            pulumi.set(__self__, "field", field)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if sub_field is not None:
            pulumi.set(__self__, "sub_field", sub_field)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the field to match like "protocol" or "host" "/ipLoadbalancing/{serviceName}/route/availableRules" for a list of available rules
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Matching operator. Not all operators are available for all fields. See "availableRules"
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def negate(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Invert the matching operator effect
        """
        return pulumi.get(self, "negate")

    @negate.setter
    def negate(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "negate", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Value to match against this match. Interpretation if this field depends on the match and field
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Id of your rule
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter(name="subField")
    def sub_field(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        return pulumi.get(self, "sub_field")

    @sub_field.setter
    def sub_field(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sub_field", value)


if not MYPY:
    class LoadBalancerOrderArgsDict(TypedDict):
        date: NotRequired[pulumi.Input[builtins.str]]
        """
        date
        """
        details: NotRequired[pulumi.Input[Sequence[pulumi.Input['LoadBalancerOrderDetailArgsDict']]]]
        """
        Information about a Bill entry
        """
        expiration_date: NotRequired[pulumi.Input[builtins.str]]
        """
        expiration date
        """
        order_id: NotRequired[pulumi.Input[builtins.int]]
        """
        order id
        """
elif False:
    LoadBalancerOrderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerOrderArgs:
    def __init__(__self__, *,
                 date: Optional[pulumi.Input[builtins.str]] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerOrderDetailArgs']]]] = None,
                 expiration_date: Optional[pulumi.Input[builtins.str]] = None,
                 order_id: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] date: date
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerOrderDetailArgs']]] details: Information about a Bill entry
        :param pulumi.Input[builtins.str] expiration_date: expiration date
        :param pulumi.Input[builtins.int] order_id: order id
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)

    @property
    @pulumi.getter
    def date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        date
        """
        return pulumi.get(self, "date")

    @date.setter
    def date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "date", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerOrderDetailArgs']]]]:
        """
        Information about a Bill entry
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerOrderDetailArgs']]]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        expiration date
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        order id
        """
        return pulumi.get(self, "order_id")

    @order_id.setter
    def order_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "order_id", value)


if not MYPY:
    class LoadBalancerOrderDetailArgsDict(TypedDict):
        description: NotRequired[pulumi.Input[builtins.str]]
        """
        description
        """
        domain: NotRequired[pulumi.Input[builtins.str]]
        """
        expiration date
        """
        order_detail_id: NotRequired[pulumi.Input[builtins.int]]
        """
        order detail id
        """
        quantity: NotRequired[pulumi.Input[builtins.str]]
        """
        quantity
        """
elif False:
    LoadBalancerOrderDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerOrderDetailArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 order_detail_id: Optional[pulumi.Input[builtins.int]] = None,
                 quantity: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] description: description
        :param pulumi.Input[builtins.str] domain: expiration date
        :param pulumi.Input[builtins.int] order_detail_id: order detail id
        :param pulumi.Input[builtins.str] quantity: quantity
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if order_detail_id is not None:
            pulumi.set(__self__, "order_detail_id", order_detail_id)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        expiration date
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="orderDetailId")
    def order_detail_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        order detail id
        """
        return pulumi.get(self, "order_detail_id")

    @order_detail_id.setter
    def order_detail_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "order_detail_id", value)

    @property
    @pulumi.getter
    def quantity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        quantity
        """
        return pulumi.get(self, "quantity")

    @quantity.setter
    def quantity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "quantity", value)


if not MYPY:
    class LoadBalancerOrderableZoneArgsDict(TypedDict):
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The zone three letter code
        """
        plan_code: NotRequired[pulumi.Input[builtins.str]]
        """
        The billing planCode for this zone
        """
elif False:
    LoadBalancerOrderableZoneArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerOrderableZoneArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 plan_code: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] name: The zone three letter code
        :param pulumi.Input[builtins.str] plan_code: The billing planCode for this zone
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if plan_code is not None:
            pulumi.set(__self__, "plan_code", plan_code)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The zone three letter code
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The billing planCode for this zone
        """
        return pulumi.get(self, "plan_code")

    @plan_code.setter
    def plan_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "plan_code", value)


if not MYPY:
    class LoadBalancerPlanArgsDict(TypedDict):
        duration: pulumi.Input[builtins.str]
        """
        duration
        """
        plan_code: pulumi.Input[builtins.str]
        """
        Plan code
        """
        pricing_mode: pulumi.Input[builtins.str]
        """
        Pricing model identifier
        """
        catalog_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Catalog name
        """
        configurations: NotRequired[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPlanConfigurationArgsDict']]]]
        """
        Representation of a configuration item for personalizing product
        """
elif False:
    LoadBalancerPlanArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerPlanArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[builtins.str],
                 plan_code: pulumi.Input[builtins.str],
                 pricing_mode: pulumi.Input[builtins.str],
                 catalog_name: Optional[pulumi.Input[builtins.str]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPlanConfigurationArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] duration: duration
        :param pulumi.Input[builtins.str] plan_code: Plan code
        :param pulumi.Input[builtins.str] pricing_mode: Pricing model identifier
        :param pulumi.Input[builtins.str] catalog_name: Catalog name
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerPlanConfigurationArgs']]] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[builtins.str]:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> pulumi.Input[builtins.str]:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @plan_code.setter
    def plan_code(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "plan_code", value)

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> pulumi.Input[builtins.str]:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @pricing_mode.setter
    def pricing_mode(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "pricing_mode", value)

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @catalog_name.setter
    def catalog_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "catalog_name", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPlanConfigurationArgs']]]]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPlanConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)


if not MYPY:
    class LoadBalancerPlanConfigurationArgsDict(TypedDict):
        label: pulumi.Input[builtins.str]
        """
        Identifier of the resource
        """
        value: pulumi.Input[builtins.str]
        """
        Path to the resource in API.OVH.COM
        """
elif False:
    LoadBalancerPlanConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerPlanConfigurationArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] label: Identifier of the resource
        :param pulumi.Input[builtins.str] value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[builtins.str]:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class LoadBalancerPlanOptionArgsDict(TypedDict):
        duration: pulumi.Input[builtins.str]
        """
        duration
        """
        plan_code: pulumi.Input[builtins.str]
        """
        Plan code
        """
        pricing_mode: pulumi.Input[builtins.str]
        """
        Pricing model identifier
        """
        catalog_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Catalog name
        """
        configurations: NotRequired[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPlanOptionConfigurationArgsDict']]]]
        """
        Representation of a configuration item for personalizing product
        """
elif False:
    LoadBalancerPlanOptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerPlanOptionArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[builtins.str],
                 plan_code: pulumi.Input[builtins.str],
                 pricing_mode: pulumi.Input[builtins.str],
                 catalog_name: Optional[pulumi.Input[builtins.str]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPlanOptionConfigurationArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] duration: duration
        :param pulumi.Input[builtins.str] plan_code: Plan code
        :param pulumi.Input[builtins.str] pricing_mode: Pricing model identifier
        :param pulumi.Input[builtins.str] catalog_name: Catalog name
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerPlanOptionConfigurationArgs']]] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Input[builtins.str]:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> pulumi.Input[builtins.str]:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @plan_code.setter
    def plan_code(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "plan_code", value)

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> pulumi.Input[builtins.str]:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @pricing_mode.setter
    def pricing_mode(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "pricing_mode", value)

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @catalog_name.setter
    def catalog_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "catalog_name", value)

    @property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPlanOptionConfigurationArgs']]]]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerPlanOptionConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)


if not MYPY:
    class LoadBalancerPlanOptionConfigurationArgsDict(TypedDict):
        label: pulumi.Input[builtins.str]
        """
        Identifier of the resource
        """
        value: pulumi.Input[builtins.str]
        """
        Path to the resource in API.OVH.COM
        """
elif False:
    LoadBalancerPlanOptionConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerPlanOptionConfigurationArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] label: Identifier of the resource
        :param pulumi.Input[builtins.str] value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[builtins.str]:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class TcpFarmProbeArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        Valid values : `http`, `internal`, `mysql`, `oco`, `pgsql`, `smtp`, `tcp`
        """
        force_ssl: NotRequired[pulumi.Input[builtins.bool]]
        """
        Force use of SSL (TLS)
        """
        interval: NotRequired[pulumi.Input[builtins.int]]
        """
        probe interval, Value between 30 and 3600 seconds, default 30
        """
        match: NotRequired[pulumi.Input[builtins.str]]
        """
        What to match `pattern` against (`contains`, `default`, `internal`, `matches`, `status`)
        """
        method: NotRequired[pulumi.Input[builtins.str]]
        """
        HTTP probe method (`GET`, `HEAD`, `OPTIONS`, `internal`)
        """
        negate: NotRequired[pulumi.Input[builtins.bool]]
        """
        Negate probe result
        """
        pattern: NotRequired[pulumi.Input[builtins.str]]
        """
        Pattern to match against `match`
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        Port for backends to receive traffic on.
        """
        url: NotRequired[pulumi.Input[builtins.str]]
        """
        URL for HTTP probe type.
        """
elif False:
    TcpFarmProbeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TcpFarmProbeArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 force_ssl: Optional[pulumi.Input[builtins.bool]] = None,
                 interval: Optional[pulumi.Input[builtins.int]] = None,
                 match: Optional[pulumi.Input[builtins.str]] = None,
                 method: Optional[pulumi.Input[builtins.str]] = None,
                 negate: Optional[pulumi.Input[builtins.bool]] = None,
                 pattern: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: Valid values : `http`, `internal`, `mysql`, `oco`, `pgsql`, `smtp`, `tcp`
        :param pulumi.Input[builtins.bool] force_ssl: Force use of SSL (TLS)
        :param pulumi.Input[builtins.int] interval: probe interval, Value between 30 and 3600 seconds, default 30
        :param pulumi.Input[builtins.str] match: What to match `pattern` against (`contains`, `default`, `internal`, `matches`, `status`)
        :param pulumi.Input[builtins.str] method: HTTP probe method (`GET`, `HEAD`, `OPTIONS`, `internal`)
        :param pulumi.Input[builtins.bool] negate: Negate probe result
        :param pulumi.Input[builtins.str] pattern: Pattern to match against `match`
        :param pulumi.Input[builtins.int] port: Port for backends to receive traffic on.
        :param pulumi.Input[builtins.str] url: URL for HTTP probe type.
        """
        pulumi.set(__self__, "type", type)
        if force_ssl is not None:
            pulumi.set(__self__, "force_ssl", force_ssl)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Valid values : `http`, `internal`, `mysql`, `oco`, `pgsql`, `smtp`, `tcp`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="forceSsl")
    def force_ssl(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Force use of SSL (TLS)
        """
        return pulumi.get(self, "force_ssl")

    @force_ssl.setter
    def force_ssl(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_ssl", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        probe interval, Value between 30 and 3600 seconds, default 30
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        What to match `pattern` against (`contains`, `default`, `internal`, `matches`, `status`)
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        HTTP probe method (`GET`, `HEAD`, `OPTIONS`, `internal`)
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def negate(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Negate probe result
        """
        return pulumi.get(self, "negate")

    @negate.setter
    def negate(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "negate", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Pattern to match against `match`
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Port for backends to receive traffic on.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL for HTTP probe type.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)


if not MYPY:
    class TcpRouteActionArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        Action to trigger if all the rules of this route matches
        """
        target: NotRequired[pulumi.Input[builtins.str]]
        """
        Farm ID for "farm" action type, empty for others.
        """
elif False:
    TcpRouteActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TcpRouteActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 target: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: Action to trigger if all the rules of this route matches
        :param pulumi.Input[builtins.str] target: Farm ID for "farm" action type, empty for others.
        """
        pulumi.set(__self__, "type", type)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Action to trigger if all the rules of this route matches
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Farm ID for "farm" action type, empty for others.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target", value)


if not MYPY:
    class TcpRouteRuleArgsDict(TypedDict):
        field: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the field to match like "protocol" or "host" "/ipLoadbalancing/{serviceName}/route/availableRules" for a list of available rules
        """
        match: NotRequired[pulumi.Input[builtins.str]]
        """
        Matching operator. Not all operators are available for all fields. See "availableRules"
        """
        negate: NotRequired[pulumi.Input[builtins.bool]]
        """
        Invert the matching operator effect
        """
        pattern: NotRequired[pulumi.Input[builtins.str]]
        """
        Value to match against this match. Interpretation if this field depends on the match and field
        """
        rule_id: NotRequired[pulumi.Input[builtins.int]]
        """
        Id of your rule
        """
        sub_field: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
elif False:
    TcpRouteRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TcpRouteRuleArgs:
    def __init__(__self__, *,
                 field: Optional[pulumi.Input[builtins.str]] = None,
                 match: Optional[pulumi.Input[builtins.str]] = None,
                 negate: Optional[pulumi.Input[builtins.bool]] = None,
                 pattern: Optional[pulumi.Input[builtins.str]] = None,
                 rule_id: Optional[pulumi.Input[builtins.int]] = None,
                 sub_field: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] field: Name of the field to match like "protocol" or "host" "/ipLoadbalancing/{serviceName}/route/availableRules" for a list of available rules
        :param pulumi.Input[builtins.str] match: Matching operator. Not all operators are available for all fields. See "availableRules"
        :param pulumi.Input[builtins.bool] negate: Invert the matching operator effect
        :param pulumi.Input[builtins.str] pattern: Value to match against this match. Interpretation if this field depends on the match and field
        :param pulumi.Input[builtins.int] rule_id: Id of your rule
        :param pulumi.Input[builtins.str] sub_field: Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        if field is not None:
            pulumi.set(__self__, "field", field)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if sub_field is not None:
            pulumi.set(__self__, "sub_field", sub_field)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the field to match like "protocol" or "host" "/ipLoadbalancing/{serviceName}/route/availableRules" for a list of available rules
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Matching operator. Not all operators are available for all fields. See "availableRules"
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def negate(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Invert the matching operator effect
        """
        return pulumi.get(self, "negate")

    @negate.setter
    def negate(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "negate", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Value to match against this match. Interpretation if this field depends on the match and field
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Id of your rule
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter(name="subField")
    def sub_field(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        return pulumi.get(self, "sub_field")

    @sub_field.setter
    def sub_field(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sub_field", value)


