# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HttpRouteArgs', 'HttpRoute']

@pulumi.input_type
class HttpRouteArgs:
    def __init__(__self__, *,
                 action: pulumi.Input['HttpRouteActionArgs'],
                 service_name: pulumi.Input[builtins.str],
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 frontend_id: Optional[pulumi.Input[builtins.int]] = None,
                 weight: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a HttpRoute resource.
        :param pulumi.Input['HttpRouteActionArgs'] action: Action triggered when all rules match
        :param pulumi.Input[builtins.str] service_name: The internal name of your IP load balancing
        :param pulumi.Input[builtins.str] display_name: Human readable name for your route, this field is for you
        :param pulumi.Input[builtins.int] frontend_id: Route traffic for this frontend
        :param pulumi.Input[builtins.int] weight: Route priority ([0..255]). 0 if null. Highest priority routes are evaluated first. Only the first matching route will trigger an action
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "service_name", service_name)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if frontend_id is not None:
            pulumi.set(__self__, "frontend_id", frontend_id)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input['HttpRouteActionArgs']:
        """
        Action triggered when all rules match
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input['HttpRouteActionArgs']):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[builtins.str]:
        """
        The internal name of your IP load balancing
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Human readable name for your route, this field is for you
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="frontendId")
    def frontend_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Route traffic for this frontend
        """
        return pulumi.get(self, "frontend_id")

    @frontend_id.setter
    def frontend_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "frontend_id", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Route priority ([0..255]). 0 if null. Highest priority routes are evaluated first. Only the first matching route will trigger an action
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class _HttpRouteState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['HttpRouteActionArgs']] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 frontend_id: Optional[pulumi.Input[builtins.int]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['HttpRouteRuleArgs']]]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 weight: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering HttpRoute resources.
        :param pulumi.Input['HttpRouteActionArgs'] action: Action triggered when all rules match
        :param pulumi.Input[builtins.str] display_name: Human readable name for your route, this field is for you
        :param pulumi.Input[builtins.int] frontend_id: Route traffic for this frontend
        :param pulumi.Input[Sequence[pulumi.Input['HttpRouteRuleArgs']]] rules: List of rules to match to trigger action
        :param pulumi.Input[builtins.str] service_name: The internal name of your IP load balancing
        :param pulumi.Input[builtins.str] status: Route status. Routes in "ok" state are ready to operate
        :param pulumi.Input[builtins.int] weight: Route priority ([0..255]). 0 if null. Highest priority routes are evaluated first. Only the first matching route will trigger an action
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if frontend_id is not None:
            pulumi.set(__self__, "frontend_id", frontend_id)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['HttpRouteActionArgs']]:
        """
        Action triggered when all rules match
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['HttpRouteActionArgs']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Human readable name for your route, this field is for you
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="frontendId")
    def frontend_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Route traffic for this frontend
        """
        return pulumi.get(self, "frontend_id")

    @frontend_id.setter
    def frontend_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "frontend_id", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HttpRouteRuleArgs']]]]:
        """
        List of rules to match to trigger action
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HttpRouteRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The internal name of your IP load balancing
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Route status. Routes in "ok" state are ready to operate
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Route priority ([0..255]). 0 if null. Highest priority routes are evaluated first. Only the first matching route will trigger an action
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "weight", value)


@pulumi.type_token("ovh:IpLoadBalancing/httpRoute:HttpRoute")
class HttpRoute(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union['HttpRouteActionArgs', 'HttpRouteActionArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 frontend_id: Optional[pulumi.Input[builtins.int]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 weight: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Manage HTTP route for a loadbalancer service

        ## Example Usage

        Route which redirect all url to https.

        ```python
        import pulumi
        import pulumi_ovh as ovh

        https_redirect = ovh.ip_load_balancing.HttpRoute("https_redirect",
            service_name="loadbalancer-xxxxxxxxxxxxxxxxxx",
            display_name="Redirect to HTTPS",
            weight=1,
            action={
                "status": 302,
                "target": "https://${host}${path}${arguments}",
                "type": "redirect",
            })
        ```

        ## Import

        HTTP route can be imported using the following format `service_name` and the `id` of the route separated by "/" e.g.

        bash

        ```sh
        $ pulumi import ovh:IpLoadBalancing/httpRoute:HttpRoute httpsredirect service_name/route_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['HttpRouteActionArgs', 'HttpRouteActionArgsDict']] action: Action triggered when all rules match
        :param pulumi.Input[builtins.str] display_name: Human readable name for your route, this field is for you
        :param pulumi.Input[builtins.int] frontend_id: Route traffic for this frontend
        :param pulumi.Input[builtins.str] service_name: The internal name of your IP load balancing
        :param pulumi.Input[builtins.int] weight: Route priority ([0..255]). 0 if null. Highest priority routes are evaluated first. Only the first matching route will trigger an action
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HttpRouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage HTTP route for a loadbalancer service

        ## Example Usage

        Route which redirect all url to https.

        ```python
        import pulumi
        import pulumi_ovh as ovh

        https_redirect = ovh.ip_load_balancing.HttpRoute("https_redirect",
            service_name="loadbalancer-xxxxxxxxxxxxxxxxxx",
            display_name="Redirect to HTTPS",
            weight=1,
            action={
                "status": 302,
                "target": "https://${host}${path}${arguments}",
                "type": "redirect",
            })
        ```

        ## Import

        HTTP route can be imported using the following format `service_name` and the `id` of the route separated by "/" e.g.

        bash

        ```sh
        $ pulumi import ovh:IpLoadBalancing/httpRoute:HttpRoute httpsredirect service_name/route_id
        ```

        :param str resource_name: The name of the resource.
        :param HttpRouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HttpRouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Union['HttpRouteActionArgs', 'HttpRouteActionArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 frontend_id: Optional[pulumi.Input[builtins.int]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 weight: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HttpRouteArgs.__new__(HttpRouteArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["frontend_id"] = frontend_id
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["weight"] = weight
            __props__.__dict__["rules"] = None
            __props__.__dict__["status"] = None
        super(HttpRoute, __self__).__init__(
            'ovh:IpLoadBalancing/httpRoute:HttpRoute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[Union['HttpRouteActionArgs', 'HttpRouteActionArgsDict']]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            frontend_id: Optional[pulumi.Input[builtins.int]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HttpRouteRuleArgs', 'HttpRouteRuleArgsDict']]]]] = None,
            service_name: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            weight: Optional[pulumi.Input[builtins.int]] = None) -> 'HttpRoute':
        """
        Get an existing HttpRoute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['HttpRouteActionArgs', 'HttpRouteActionArgsDict']] action: Action triggered when all rules match
        :param pulumi.Input[builtins.str] display_name: Human readable name for your route, this field is for you
        :param pulumi.Input[builtins.int] frontend_id: Route traffic for this frontend
        :param pulumi.Input[Sequence[pulumi.Input[Union['HttpRouteRuleArgs', 'HttpRouteRuleArgsDict']]]] rules: List of rules to match to trigger action
        :param pulumi.Input[builtins.str] service_name: The internal name of your IP load balancing
        :param pulumi.Input[builtins.str] status: Route status. Routes in "ok" state are ready to operate
        :param pulumi.Input[builtins.int] weight: Route priority ([0..255]). 0 if null. Highest priority routes are evaluated first. Only the first matching route will trigger an action
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HttpRouteState.__new__(_HttpRouteState)

        __props__.__dict__["action"] = action
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["frontend_id"] = frontend_id
        __props__.__dict__["rules"] = rules
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["status"] = status
        __props__.__dict__["weight"] = weight
        return HttpRoute(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output['outputs.HttpRouteAction']:
        """
        Action triggered when all rules match
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Human readable name for your route, this field is for you
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="frontendId")
    def frontend_id(self) -> pulumi.Output[builtins.int]:
        """
        Route traffic for this frontend
        """
        return pulumi.get(self, "frontend_id")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.HttpRouteRule']]:
        """
        List of rules to match to trigger action
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[builtins.str]:
        """
        The internal name of your IP load balancing
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        Route status. Routes in "ok" state are ready to operate
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def weight(self) -> pulumi.Output[builtins.int]:
        """
        Route priority ([0..255]). 0 if null. Highest priority routes are evaluated first. Only the first matching route will trigger an action
        """
        return pulumi.get(self, "weight")

