# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TcpRouteRuleInitArgs', 'TcpRouteRule']

@pulumi.input_type
class TcpRouteRuleInitArgs:
    def __init__(__self__, *,
                 field: pulumi.Input[builtins.str],
                 match: pulumi.Input[builtins.str],
                 route_id: pulumi.Input[builtins.str],
                 service_name: pulumi.Input[builtins.str],
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 negate: Optional[pulumi.Input[builtins.bool]] = None,
                 pattern: Optional[pulumi.Input[builtins.str]] = None,
                 sub_field: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a TcpRouteRule resource.
        :param pulumi.Input[builtins.str] field: Name of the field to match like "protocol" or "host". See "/ipLoadbalancing/{serviceName}/availableRouteRules" for a list of available rules
        :param pulumi.Input[builtins.str] match: Matching operator. Not all operators are available for all fields. See "/ipLoadbalancing/{serviceName}/availableRouteRules"
        :param pulumi.Input[builtins.str] route_id: The route to apply this rule
        :param pulumi.Input[builtins.str] service_name: The internal name of your IP load balancing
        :param pulumi.Input[builtins.str] display_name: Human readable name for your rule, this field is for you
        :param pulumi.Input[builtins.bool] negate: Invert the matching operator effect
        :param pulumi.Input[builtins.str] pattern: Value to match against this match. Interpretation if this field depends on the match and field
        :param pulumi.Input[builtins.str] sub_field: Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "route_id", route_id)
        pulumi.set(__self__, "service_name", service_name)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if sub_field is not None:
            pulumi.set(__self__, "sub_field", sub_field)

    @property
    @pulumi.getter
    def field(self) -> pulumi.Input[builtins.str]:
        """
        Name of the field to match like "protocol" or "host". See "/ipLoadbalancing/{serviceName}/availableRouteRules" for a list of available rules
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter
    def match(self) -> pulumi.Input[builtins.str]:
        """
        Matching operator. Not all operators are available for all fields. See "/ipLoadbalancing/{serviceName}/availableRouteRules"
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter(name="routeId")
    def route_id(self) -> pulumi.Input[builtins.str]:
        """
        The route to apply this rule
        """
        return pulumi.get(self, "route_id")

    @route_id.setter
    def route_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "route_id", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[builtins.str]:
        """
        The internal name of your IP load balancing
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Human readable name for your rule, this field is for you
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def negate(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Invert the matching operator effect
        """
        return pulumi.get(self, "negate")

    @negate.setter
    def negate(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "negate", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Value to match against this match. Interpretation if this field depends on the match and field
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter(name="subField")
    def sub_field(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        return pulumi.get(self, "sub_field")

    @sub_field.setter
    def sub_field(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sub_field", value)


@pulumi.input_type
class _TcpRouteRuleState:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 field: Optional[pulumi.Input[builtins.str]] = None,
                 match: Optional[pulumi.Input[builtins.str]] = None,
                 negate: Optional[pulumi.Input[builtins.bool]] = None,
                 pattern: Optional[pulumi.Input[builtins.str]] = None,
                 route_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 sub_field: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering TcpRouteRule resources.
        :param pulumi.Input[builtins.str] display_name: Human readable name for your rule, this field is for you
        :param pulumi.Input[builtins.str] field: Name of the field to match like "protocol" or "host". See "/ipLoadbalancing/{serviceName}/availableRouteRules" for a list of available rules
        :param pulumi.Input[builtins.str] match: Matching operator. Not all operators are available for all fields. See "/ipLoadbalancing/{serviceName}/availableRouteRules"
        :param pulumi.Input[builtins.bool] negate: Invert the matching operator effect
        :param pulumi.Input[builtins.str] pattern: Value to match against this match. Interpretation if this field depends on the match and field
        :param pulumi.Input[builtins.str] route_id: The route to apply this rule
        :param pulumi.Input[builtins.str] service_name: The internal name of your IP load balancing
        :param pulumi.Input[builtins.str] sub_field: Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if field is not None:
            pulumi.set(__self__, "field", field)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if negate is not None:
            pulumi.set(__self__, "negate", negate)
        if pattern is not None:
            pulumi.set(__self__, "pattern", pattern)
        if route_id is not None:
            pulumi.set(__self__, "route_id", route_id)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if sub_field is not None:
            pulumi.set(__self__, "sub_field", sub_field)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Human readable name for your rule, this field is for you
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the field to match like "protocol" or "host". See "/ipLoadbalancing/{serviceName}/availableRouteRules" for a list of available rules
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Matching operator. Not all operators are available for all fields. See "/ipLoadbalancing/{serviceName}/availableRouteRules"
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def negate(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Invert the matching operator effect
        """
        return pulumi.get(self, "negate")

    @negate.setter
    def negate(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "negate", value)

    @property
    @pulumi.getter
    def pattern(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Value to match against this match. Interpretation if this field depends on the match and field
        """
        return pulumi.get(self, "pattern")

    @pattern.setter
    def pattern(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pattern", value)

    @property
    @pulumi.getter(name="routeId")
    def route_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The route to apply this rule
        """
        return pulumi.get(self, "route_id")

    @route_id.setter
    def route_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_id", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The internal name of your IP load balancing
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="subField")
    def sub_field(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        return pulumi.get(self, "sub_field")

    @sub_field.setter
    def sub_field(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sub_field", value)


@pulumi.type_token("ovh:IpLoadBalancing/tcpRouteRule:TcpRouteRule")
class TcpRouteRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 field: Optional[pulumi.Input[builtins.str]] = None,
                 match: Optional[pulumi.Input[builtins.str]] = None,
                 negate: Optional[pulumi.Input[builtins.bool]] = None,
                 pattern: Optional[pulumi.Input[builtins.str]] = None,
                 route_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 sub_field: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manage rules for TCP route.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        reject = ovh.ip_load_balancing.TcpRoute("reject",
            service_name="loadbalancer-xxxxxxxxxxxxxxxxxx",
            weight=1,
            frontend_id=11111,
            action={
                "type": "reject",
            })
        example_rule = ovh.ip_load_balancing.TcpRouteRule("example_rule",
            service_name="loadbalancer-xxxxxxxxxxxxxxxxxx",
            route_id=reject.id,
            display_name="Match example.com host",
            field="sni",
            match="is",
            negate=False,
            pattern="example.com")
        ```

        ## Import

        TCP route rule can be imported using the following format `service_name`, the `id` of the route and the `id` of the rule separated by "/" e.g.

        bash

        ```sh
        $ pulumi import ovh:IpLoadBalancing/tcpRouteRule:TcpRouteRule examplerule service_name/route_id/rule_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] display_name: Human readable name for your rule, this field is for you
        :param pulumi.Input[builtins.str] field: Name of the field to match like "protocol" or "host". See "/ipLoadbalancing/{serviceName}/availableRouteRules" for a list of available rules
        :param pulumi.Input[builtins.str] match: Matching operator. Not all operators are available for all fields. See "/ipLoadbalancing/{serviceName}/availableRouteRules"
        :param pulumi.Input[builtins.bool] negate: Invert the matching operator effect
        :param pulumi.Input[builtins.str] pattern: Value to match against this match. Interpretation if this field depends on the match and field
        :param pulumi.Input[builtins.str] route_id: The route to apply this rule
        :param pulumi.Input[builtins.str] service_name: The internal name of your IP load balancing
        :param pulumi.Input[builtins.str] sub_field: Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TcpRouteRuleInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage rules for TCP route.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        reject = ovh.ip_load_balancing.TcpRoute("reject",
            service_name="loadbalancer-xxxxxxxxxxxxxxxxxx",
            weight=1,
            frontend_id=11111,
            action={
                "type": "reject",
            })
        example_rule = ovh.ip_load_balancing.TcpRouteRule("example_rule",
            service_name="loadbalancer-xxxxxxxxxxxxxxxxxx",
            route_id=reject.id,
            display_name="Match example.com host",
            field="sni",
            match="is",
            negate=False,
            pattern="example.com")
        ```

        ## Import

        TCP route rule can be imported using the following format `service_name`, the `id` of the route and the `id` of the rule separated by "/" e.g.

        bash

        ```sh
        $ pulumi import ovh:IpLoadBalancing/tcpRouteRule:TcpRouteRule examplerule service_name/route_id/rule_id
        ```

        :param str resource_name: The name of the resource.
        :param TcpRouteRuleInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TcpRouteRuleInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 field: Optional[pulumi.Input[builtins.str]] = None,
                 match: Optional[pulumi.Input[builtins.str]] = None,
                 negate: Optional[pulumi.Input[builtins.bool]] = None,
                 pattern: Optional[pulumi.Input[builtins.str]] = None,
                 route_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 sub_field: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TcpRouteRuleInitArgs.__new__(TcpRouteRuleInitArgs)

            __props__.__dict__["display_name"] = display_name
            if field is None and not opts.urn:
                raise TypeError("Missing required property 'field'")
            __props__.__dict__["field"] = field
            if match is None and not opts.urn:
                raise TypeError("Missing required property 'match'")
            __props__.__dict__["match"] = match
            __props__.__dict__["negate"] = negate
            __props__.__dict__["pattern"] = pattern
            if route_id is None and not opts.urn:
                raise TypeError("Missing required property 'route_id'")
            __props__.__dict__["route_id"] = route_id
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["sub_field"] = sub_field
        super(TcpRouteRule, __self__).__init__(
            'ovh:IpLoadBalancing/tcpRouteRule:TcpRouteRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            field: Optional[pulumi.Input[builtins.str]] = None,
            match: Optional[pulumi.Input[builtins.str]] = None,
            negate: Optional[pulumi.Input[builtins.bool]] = None,
            pattern: Optional[pulumi.Input[builtins.str]] = None,
            route_id: Optional[pulumi.Input[builtins.str]] = None,
            service_name: Optional[pulumi.Input[builtins.str]] = None,
            sub_field: Optional[pulumi.Input[builtins.str]] = None) -> 'TcpRouteRule':
        """
        Get an existing TcpRouteRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] display_name: Human readable name for your rule, this field is for you
        :param pulumi.Input[builtins.str] field: Name of the field to match like "protocol" or "host". See "/ipLoadbalancing/{serviceName}/availableRouteRules" for a list of available rules
        :param pulumi.Input[builtins.str] match: Matching operator. Not all operators are available for all fields. See "/ipLoadbalancing/{serviceName}/availableRouteRules"
        :param pulumi.Input[builtins.bool] negate: Invert the matching operator effect
        :param pulumi.Input[builtins.str] pattern: Value to match against this match. Interpretation if this field depends on the match and field
        :param pulumi.Input[builtins.str] route_id: The route to apply this rule
        :param pulumi.Input[builtins.str] service_name: The internal name of your IP load balancing
        :param pulumi.Input[builtins.str] sub_field: Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TcpRouteRuleState.__new__(_TcpRouteRuleState)

        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["field"] = field
        __props__.__dict__["match"] = match
        __props__.__dict__["negate"] = negate
        __props__.__dict__["pattern"] = pattern
        __props__.__dict__["route_id"] = route_id
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["sub_field"] = sub_field
        return TcpRouteRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Human readable name for your rule, this field is for you
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def field(self) -> pulumi.Output[builtins.str]:
        """
        Name of the field to match like "protocol" or "host". See "/ipLoadbalancing/{serviceName}/availableRouteRules" for a list of available rules
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def match(self) -> pulumi.Output[builtins.str]:
        """
        Matching operator. Not all operators are available for all fields. See "/ipLoadbalancing/{serviceName}/availableRouteRules"
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def negate(self) -> pulumi.Output[builtins.bool]:
        """
        Invert the matching operator effect
        """
        return pulumi.get(self, "negate")

    @property
    @pulumi.getter
    def pattern(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Value to match against this match. Interpretation if this field depends on the match and field
        """
        return pulumi.get(self, "pattern")

    @property
    @pulumi.getter(name="routeId")
    def route_id(self) -> pulumi.Output[builtins.str]:
        """
        The route to apply this rule
        """
        return pulumi.get(self, "route_id")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[builtins.str]:
        """
        The internal name of your IP load balancing
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="subField")
    def sub_field(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of sub-field, if applicable. This may be a Cookie or Header name for instance
        """
        return pulumi.get(self, "sub_field")

