# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAPIOAuth2ClientsResult',
    'AwaitableGetAPIOAuth2ClientsResult',
    'get_apio_auth2_clients',
    'get_apio_auth2_clients_output',
]

@pulumi.output_type
class GetAPIOAuth2ClientsResult:
    """
    A collection of values returned by getAPIOAuth2Clients.
    """
    def __init__(__self__, client_ids=None, id=None):
        if client_ids and not isinstance(client_ids, list):
            raise TypeError("Expected argument 'client_ids' to be a list")
        pulumi.set(__self__, "client_ids", client_ids)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="clientIds")
    def client_ids(self) -> Sequence[builtins.str]:
        """
        The list of all the existing client IDs.
        """
        return pulumi.get(self, "client_ids")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetAPIOAuth2ClientsResult(GetAPIOAuth2ClientsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAPIOAuth2ClientsResult(
            client_ids=self.client_ids,
            id=self.id)


def get_apio_auth2_clients(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAPIOAuth2ClientsResult:
    """
    Use this data source to retrieve information the list of existing OAuth2 service account IDs.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    my_oauth2_clients = ovh.Me.get_apio_auth2_client()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:Me/getAPIOAuth2Clients:getAPIOAuth2Clients', __args__, opts=opts, typ=GetAPIOAuth2ClientsResult).value

    return AwaitableGetAPIOAuth2ClientsResult(
        client_ids=pulumi.get(__ret__, 'client_ids'),
        id=pulumi.get(__ret__, 'id'))
def get_apio_auth2_clients_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAPIOAuth2ClientsResult]:
    """
    Use this data source to retrieve information the list of existing OAuth2 service account IDs.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    my_oauth2_clients = ovh.Me.get_apio_auth2_client()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:Me/getAPIOAuth2Clients:getAPIOAuth2Clients', __args__, opts=opts, typ=GetAPIOAuth2ClientsResult)
    return __ret__.apply(lambda __response__: GetAPIOAuth2ClientsResult(
        client_ids=pulumi.get(__response__, 'client_ids'),
        id=pulumi.get(__response__, 'id')))
