# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IdentityGroupArgs', 'IdentityGroup']

@pulumi.input_type
class IdentityGroupArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a IdentityGroup resource.
        :param pulumi.Input[builtins.str] description: Group description.
        :param pulumi.Input[builtins.str] name: Group name.
        :param pulumi.Input[builtins.str] role: Role associated with the group. Valid roles are ADMIN, REGULAR, UNPRIVILEGED, and NONE.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Group description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Group name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Role associated with the group. Valid roles are ADMIN, REGULAR, UNPRIVILEGED, and NONE.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class _IdentityGroupState:
    def __init__(__self__, *,
                 group_urn: Optional[pulumi.Input[builtins.str]] = None,
                 creation: Optional[pulumi.Input[builtins.str]] = None,
                 default_group: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 last_update: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering IdentityGroup resources.
        :param pulumi.Input[builtins.str] group_urn: URN of the user group, used when writing IAM policies
        :param pulumi.Input[builtins.str] creation: Creation date of this group.
        :param pulumi.Input[builtins.bool] default_group: Is the group a default and immutable one.
        :param pulumi.Input[builtins.str] description: Group description.
        :param pulumi.Input[builtins.str] last_update: Date of the last update of this group.
        :param pulumi.Input[builtins.str] name: Group name.
        :param pulumi.Input[builtins.str] role: Role associated with the group. Valid roles are ADMIN, REGULAR, UNPRIVILEGED, and NONE.
        """
        if group_urn is not None:
            pulumi.set(__self__, "group_urn", group_urn)
        if creation is not None:
            pulumi.set(__self__, "creation", creation)
        if default_group is not None:
            pulumi.set(__self__, "default_group", default_group)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if last_update is not None:
            pulumi.set(__self__, "last_update", last_update)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="GroupURN")
    def group_urn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URN of the user group, used when writing IAM policies
        """
        return pulumi.get(self, "group_urn")

    @group_urn.setter
    def group_urn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group_urn", value)

    @property
    @pulumi.getter
    def creation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation date of this group.
        """
        return pulumi.get(self, "creation")

    @creation.setter
    def creation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation", value)

    @property
    @pulumi.getter(name="defaultGroup")
    def default_group(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the group a default and immutable one.
        """
        return pulumi.get(self, "default_group")

    @default_group.setter
    def default_group(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "default_group", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Group description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="lastUpdate")
    def last_update(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date of the last update of this group.
        """
        return pulumi.get(self, "last_update")

    @last_update.setter
    def last_update(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_update", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Group name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Role associated with the group. Valid roles are ADMIN, REGULAR, UNPRIVILEGED, and NONE.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role", value)


@pulumi.type_token("ovh:Me/identityGroup:IdentityGroup")
class IdentityGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Creates an identity group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        my_group = ovh.me.IdentityGroup("my_group",
            description="Some custom description",
            name="my_group_name",
            role="NONE")
        ```

        ## Import

        Identity groups can be imported using their `name`:

        bash

        ```sh
        $ pulumi import ovh:Me/identityGroup:IdentityGroup my_identity_group name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Group description.
        :param pulumi.Input[builtins.str] name: Group name.
        :param pulumi.Input[builtins.str] role: Role associated with the group. Valid roles are ADMIN, REGULAR, UNPRIVILEGED, and NONE.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[IdentityGroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an identity group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        my_group = ovh.me.IdentityGroup("my_group",
            description="Some custom description",
            name="my_group_name",
            role="NONE")
        ```

        ## Import

        Identity groups can be imported using their `name`:

        bash

        ```sh
        $ pulumi import ovh:Me/identityGroup:IdentityGroup my_identity_group name
        ```

        :param str resource_name: The name of the resource.
        :param IdentityGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IdentityGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IdentityGroupArgs.__new__(IdentityGroupArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["role"] = role
            __props__.__dict__["group_urn"] = None
            __props__.__dict__["creation"] = None
            __props__.__dict__["default_group"] = None
            __props__.__dict__["last_update"] = None
        super(IdentityGroup, __self__).__init__(
            'ovh:Me/identityGroup:IdentityGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group_urn: Optional[pulumi.Input[builtins.str]] = None,
            creation: Optional[pulumi.Input[builtins.str]] = None,
            default_group: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            last_update: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            role: Optional[pulumi.Input[builtins.str]] = None) -> 'IdentityGroup':
        """
        Get an existing IdentityGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] group_urn: URN of the user group, used when writing IAM policies
        :param pulumi.Input[builtins.str] creation: Creation date of this group.
        :param pulumi.Input[builtins.bool] default_group: Is the group a default and immutable one.
        :param pulumi.Input[builtins.str] description: Group description.
        :param pulumi.Input[builtins.str] last_update: Date of the last update of this group.
        :param pulumi.Input[builtins.str] name: Group name.
        :param pulumi.Input[builtins.str] role: Role associated with the group. Valid roles are ADMIN, REGULAR, UNPRIVILEGED, and NONE.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IdentityGroupState.__new__(_IdentityGroupState)

        __props__.__dict__["group_urn"] = group_urn
        __props__.__dict__["creation"] = creation
        __props__.__dict__["default_group"] = default_group
        __props__.__dict__["description"] = description
        __props__.__dict__["last_update"] = last_update
        __props__.__dict__["name"] = name
        __props__.__dict__["role"] = role
        return IdentityGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="GroupURN")
    def group_urn(self) -> pulumi.Output[builtins.str]:
        """
        URN of the user group, used when writing IAM policies
        """
        return pulumi.get(self, "group_urn")

    @property
    @pulumi.getter
    def creation(self) -> pulumi.Output[builtins.str]:
        """
        Creation date of this group.
        """
        return pulumi.get(self, "creation")

    @property
    @pulumi.getter(name="defaultGroup")
    def default_group(self) -> pulumi.Output[builtins.bool]:
        """
        Is the group a default and immutable one.
        """
        return pulumi.get(self, "default_group")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Group description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="lastUpdate")
    def last_update(self) -> pulumi.Output[builtins.str]:
        """
        Date of the last update of this group.
        """
        return pulumi.get(self, "last_update")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Group name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Role associated with the group. Valid roles are ADMIN, REGULAR, UNPRIVILEGED, and NONE.
        """
        return pulumi.get(self, "role")

