# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CredentialArgs', 'Credential']

@pulumi.input_type
class CredentialArgs:
    def __init__(__self__, *,
                 identity_urns: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 okms_id: pulumi.Input[builtins.str],
                 csr: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 validity: Optional[pulumi.Input[builtins.float]] = None):
        """
        The set of arguments for constructing a Credential resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identity_urns: List of identity URNs associated with the credential (max 25)
        :param pulumi.Input[builtins.str] okms_id: Okms ID
        :param pulumi.Input[builtins.str] csr: Valid Certificate Signing Request
        :param pulumi.Input[builtins.str] description: Description of the credential (max 200)
        :param pulumi.Input[builtins.str] name: Name of the credential (max 50)
        :param pulumi.Input[builtins.float] validity: Validity in days (default 365, max 365)
        """
        pulumi.set(__self__, "identity_urns", identity_urns)
        pulumi.set(__self__, "okms_id", okms_id)
        if csr is not None:
            pulumi.set(__self__, "csr", csr)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if validity is not None:
            pulumi.set(__self__, "validity", validity)

    @property
    @pulumi.getter(name="identityUrns")
    def identity_urns(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of identity URNs associated with the credential (max 25)
        """
        return pulumi.get(self, "identity_urns")

    @identity_urns.setter
    def identity_urns(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "identity_urns", value)

    @property
    @pulumi.getter(name="okmsId")
    def okms_id(self) -> pulumi.Input[builtins.str]:
        """
        Okms ID
        """
        return pulumi.get(self, "okms_id")

    @okms_id.setter
    def okms_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "okms_id", value)

    @property
    @pulumi.getter
    def csr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Valid Certificate Signing Request
        """
        return pulumi.get(self, "csr")

    @csr.setter
    def csr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "csr", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the credential (max 200)
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the credential (max 50)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def validity(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Validity in days (default 365, max 365)
        """
        return pulumi.get(self, "validity")

    @validity.setter
    def validity(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "validity", value)


@pulumi.input_type
class _CredentialState:
    def __init__(__self__, *,
                 certificate_pem: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 csr: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 expired_at: Optional[pulumi.Input[builtins.str]] = None,
                 from_csr: Optional[pulumi.Input[builtins.bool]] = None,
                 identity_urns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 okms_id: Optional[pulumi.Input[builtins.str]] = None,
                 private_key_pem: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 validity: Optional[pulumi.Input[builtins.float]] = None):
        """
        Input properties used for looking up and filtering Credential resources.
        :param pulumi.Input[builtins.str] certificate_pem: (String) Certificate PEM of the credential.
        :param pulumi.Input[builtins.str] created_at: (String) Creation time of the credential
        :param pulumi.Input[builtins.str] csr: Valid Certificate Signing Request
        :param pulumi.Input[builtins.str] description: Description of the credential (max 200)
        :param pulumi.Input[builtins.str] expired_at: (String) Expiration time of the credential
        :param pulumi.Input[builtins.bool] from_csr: (Boolean) Whether the credential was generated from a CSR
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identity_urns: List of identity URNs associated with the credential (max 25)
        :param pulumi.Input[builtins.str] name: Name of the credential (max 50)
        :param pulumi.Input[builtins.str] okms_id: Okms ID
        :param pulumi.Input[builtins.str] private_key_pem: (String, Sensitive) Private Key PEM of the credential if no CSR is provided
        :param pulumi.Input[builtins.str] status: (String) Status of the credential
        :param pulumi.Input[builtins.float] validity: Validity in days (default 365, max 365)
        """
        if certificate_pem is not None:
            pulumi.set(__self__, "certificate_pem", certificate_pem)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if csr is not None:
            pulumi.set(__self__, "csr", csr)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expired_at is not None:
            pulumi.set(__self__, "expired_at", expired_at)
        if from_csr is not None:
            pulumi.set(__self__, "from_csr", from_csr)
        if identity_urns is not None:
            pulumi.set(__self__, "identity_urns", identity_urns)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if okms_id is not None:
            pulumi.set(__self__, "okms_id", okms_id)
        if private_key_pem is not None:
            pulumi.set(__self__, "private_key_pem", private_key_pem)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if validity is not None:
            pulumi.set(__self__, "validity", validity)

    @property
    @pulumi.getter(name="certificatePem")
    def certificate_pem(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (String) Certificate PEM of the credential.
        """
        return pulumi.get(self, "certificate_pem")

    @certificate_pem.setter
    def certificate_pem(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_pem", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (String) Creation time of the credential
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def csr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Valid Certificate Signing Request
        """
        return pulumi.get(self, "csr")

    @csr.setter
    def csr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "csr", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the credential (max 200)
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="expiredAt")
    def expired_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (String) Expiration time of the credential
        """
        return pulumi.get(self, "expired_at")

    @expired_at.setter
    def expired_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expired_at", value)

    @property
    @pulumi.getter(name="fromCsr")
    def from_csr(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Boolean) Whether the credential was generated from a CSR
        """
        return pulumi.get(self, "from_csr")

    @from_csr.setter
    def from_csr(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "from_csr", value)

    @property
    @pulumi.getter(name="identityUrns")
    def identity_urns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of identity URNs associated with the credential (max 25)
        """
        return pulumi.get(self, "identity_urns")

    @identity_urns.setter
    def identity_urns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "identity_urns", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the credential (max 50)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="okmsId")
    def okms_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Okms ID
        """
        return pulumi.get(self, "okms_id")

    @okms_id.setter
    def okms_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "okms_id", value)

    @property
    @pulumi.getter(name="privateKeyPem")
    def private_key_pem(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (String, Sensitive) Private Key PEM of the credential if no CSR is provided
        """
        return pulumi.get(self, "private_key_pem")

    @private_key_pem.setter
    def private_key_pem(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_key_pem", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (String) Status of the credential
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def validity(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Validity in days (default 365, max 365)
        """
        return pulumi.get(self, "validity")

    @validity.setter
    def validity(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "validity", value)


@pulumi.type_token("ovh:Okms/credential:Credential")
class Credential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 csr: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 identity_urns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 okms_id: Optional[pulumi.Input[builtins.str]] = None,
                 validity: Optional[pulumi.Input[builtins.float]] = None,
                 __props__=None):
        """
        Creates a credential for an OVHcloud KMS.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] csr: Valid Certificate Signing Request
        :param pulumi.Input[builtins.str] description: Description of the credential (max 200)
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identity_urns: List of identity URNs associated with the credential (max 25)
        :param pulumi.Input[builtins.str] name: Name of the credential (max 50)
        :param pulumi.Input[builtins.str] okms_id: Okms ID
        :param pulumi.Input[builtins.float] validity: Validity in days (default 365, max 365)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a credential for an OVHcloud KMS.

        :param str resource_name: The name of the resource.
        :param CredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 csr: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 identity_urns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 okms_id: Optional[pulumi.Input[builtins.str]] = None,
                 validity: Optional[pulumi.Input[builtins.float]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CredentialArgs.__new__(CredentialArgs)

            __props__.__dict__["csr"] = csr
            __props__.__dict__["description"] = description
            if identity_urns is None and not opts.urn:
                raise TypeError("Missing required property 'identity_urns'")
            __props__.__dict__["identity_urns"] = identity_urns
            __props__.__dict__["name"] = name
            if okms_id is None and not opts.urn:
                raise TypeError("Missing required property 'okms_id'")
            __props__.__dict__["okms_id"] = okms_id
            __props__.__dict__["validity"] = validity
            __props__.__dict__["certificate_pem"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["expired_at"] = None
            __props__.__dict__["from_csr"] = None
            __props__.__dict__["private_key_pem"] = None
            __props__.__dict__["status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["privateKeyPem"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Credential, __self__).__init__(
            'ovh:Okms/credential:Credential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_pem: Optional[pulumi.Input[builtins.str]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            csr: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            expired_at: Optional[pulumi.Input[builtins.str]] = None,
            from_csr: Optional[pulumi.Input[builtins.bool]] = None,
            identity_urns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            okms_id: Optional[pulumi.Input[builtins.str]] = None,
            private_key_pem: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            validity: Optional[pulumi.Input[builtins.float]] = None) -> 'Credential':
        """
        Get an existing Credential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] certificate_pem: (String) Certificate PEM of the credential.
        :param pulumi.Input[builtins.str] created_at: (String) Creation time of the credential
        :param pulumi.Input[builtins.str] csr: Valid Certificate Signing Request
        :param pulumi.Input[builtins.str] description: Description of the credential (max 200)
        :param pulumi.Input[builtins.str] expired_at: (String) Expiration time of the credential
        :param pulumi.Input[builtins.bool] from_csr: (Boolean) Whether the credential was generated from a CSR
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identity_urns: List of identity URNs associated with the credential (max 25)
        :param pulumi.Input[builtins.str] name: Name of the credential (max 50)
        :param pulumi.Input[builtins.str] okms_id: Okms ID
        :param pulumi.Input[builtins.str] private_key_pem: (String, Sensitive) Private Key PEM of the credential if no CSR is provided
        :param pulumi.Input[builtins.str] status: (String) Status of the credential
        :param pulumi.Input[builtins.float] validity: Validity in days (default 365, max 365)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CredentialState.__new__(_CredentialState)

        __props__.__dict__["certificate_pem"] = certificate_pem
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["csr"] = csr
        __props__.__dict__["description"] = description
        __props__.__dict__["expired_at"] = expired_at
        __props__.__dict__["from_csr"] = from_csr
        __props__.__dict__["identity_urns"] = identity_urns
        __props__.__dict__["name"] = name
        __props__.__dict__["okms_id"] = okms_id
        __props__.__dict__["private_key_pem"] = private_key_pem
        __props__.__dict__["status"] = status
        __props__.__dict__["validity"] = validity
        return Credential(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificatePem")
    def certificate_pem(self) -> pulumi.Output[builtins.str]:
        """
        (String) Certificate PEM of the credential.
        """
        return pulumi.get(self, "certificate_pem")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        (String) Creation time of the credential
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def csr(self) -> pulumi.Output[builtins.str]:
        """
        Valid Certificate Signing Request
        """
        return pulumi.get(self, "csr")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Description of the credential (max 200)
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="expiredAt")
    def expired_at(self) -> pulumi.Output[builtins.str]:
        """
        (String) Expiration time of the credential
        """
        return pulumi.get(self, "expired_at")

    @property
    @pulumi.getter(name="fromCsr")
    def from_csr(self) -> pulumi.Output[builtins.bool]:
        """
        (Boolean) Whether the credential was generated from a CSR
        """
        return pulumi.get(self, "from_csr")

    @property
    @pulumi.getter(name="identityUrns")
    def identity_urns(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of identity URNs associated with the credential (max 25)
        """
        return pulumi.get(self, "identity_urns")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the credential (max 50)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="okmsId")
    def okms_id(self) -> pulumi.Output[builtins.str]:
        """
        Okms ID
        """
        return pulumi.get(self, "okms_id")

    @property
    @pulumi.getter(name="privateKeyPem")
    def private_key_pem(self) -> pulumi.Output[builtins.str]:
        """
        (String, Sensitive) Private Key PEM of the credential if no CSR is provided
        """
        return pulumi.get(self, "private_key_pem")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        (String) Status of the credential
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def validity(self) -> pulumi.Output[builtins.float]:
        """
        Validity in days (default 365, max 365)
        """
        return pulumi.get(self, "validity")

