# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'OkmsIam',
    'ServiceKeyJWKIam',
    'ServiceKeyJWKKey',
    'GetOkmsResourceIamResult',
    'GetOkmsServiceKeyIamResult',
    'GetOkmsServiceKeyJwkIamResult',
    'GetOkmsServiceKeyJwkKeyResult',
    'GetOkmsServiceKeyPemIamResult',
    'GetOkmsServiceKeyPemKeysPemResult',
]

@pulumi.output_type
class OkmsIam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OkmsIam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OkmsIam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OkmsIam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 tags: Optional[Mapping[str, builtins.str]] = None,
                 urn: Optional[builtins.str] = None):
        """
        :param builtins.str display_name: (String) Resource display name
        :param builtins.str id: (String) Unique identifier of the resource
        :param Mapping[str, builtins.str] tags: (Map of String) Resource tags. Tags that were internally computed are prefixed with ovh:
        :param builtins.str urn: (String) Unique resource name used in policies
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if urn is not None:
            pulumi.set(__self__, "urn", urn)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        (String) Resource display name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        (String) Unique identifier of the resource
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        (Map of String) Resource tags. Tags that were internally computed are prefixed with ovh:
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def urn(self) -> Optional[builtins.str]:
        """
        (String) Unique resource name used in policies
        """
        return pulumi.get(self, "urn")


@pulumi.output_type
class ServiceKeyJWKIam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceKeyJWKIam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceKeyJWKIam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceKeyJWKIam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 tags: Optional[Mapping[str, builtins.str]] = None,
                 urn: Optional[builtins.str] = None):
        """
        :param builtins.str display_name: Resource display name
        :param builtins.str id: Unique identifier of the resource
        :param Mapping[str, builtins.str] tags: Resource tags. Tags that were internally computed are prefixed with ovh:
        :param builtins.str urn: Unique resource name used in policies
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if urn is not None:
            pulumi.set(__self__, "urn", urn)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        Resource display name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Unique identifier of the resource
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Resource tags. Tags that were internally computed are prefixed with ovh:
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def urn(self) -> Optional[builtins.str]:
        """
        Unique resource name used in policies
        """
        return pulumi.get(self, "urn")


@pulumi.output_type
class ServiceKeyJWKKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyOps":
            suggest = "key_ops"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceKeyJWKKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceKeyJWKKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceKeyJWKKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_ops: Sequence[builtins.str],
                 kty: builtins.str,
                 alg: Optional[builtins.str] = None,
                 crv: Optional[builtins.str] = None,
                 d: Optional[builtins.str] = None,
                 dp: Optional[builtins.str] = None,
                 dq: Optional[builtins.str] = None,
                 e: Optional[builtins.str] = None,
                 k: Optional[builtins.str] = None,
                 kid: Optional[builtins.str] = None,
                 n: Optional[builtins.str] = None,
                 p: Optional[builtins.str] = None,
                 q: Optional[builtins.str] = None,
                 qi: Optional[builtins.str] = None,
                 use: Optional[builtins.str] = None,
                 x: Optional[builtins.str] = None,
                 y: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] key_ops: The operation for which the key is intended to be used
        :param builtins.str kty: Key type parameter identifies the cryptographic algorithm family used with the key, such as RSA or EC
        :param builtins.str alg: The algorithm intended to be used with the key
        :param builtins.str crv: The cryptographic curve used with the key
        :param builtins.str d: The RSA or EC private exponent
        :param builtins.str dp: The RSA private key's first factor CRT exponent
        :param builtins.str dq: The RSA private key's second factor CRT exponent
        :param builtins.str e: The exponent value for the RSA public key
        :param builtins.str k: The value of the symmetric (or other single-valued) key
        :param builtins.str kid: key ID parameter used to match a specific key
        :param builtins.str n: The modulus value for the RSA public key
        :param builtins.str p: The first prime factor of the RSA private key
        :param builtins.str q: The second prime factor of the RSA private key
        :param builtins.str qi: The CRT coefficient of the second factor of the RSA private key
        :param builtins.str use: The intended use of the public key
        :param builtins.str x: The x coordinate for the Elliptic Curve point
        :param builtins.str y: The y coordinate for the Elliptic Curve point
        """
        pulumi.set(__self__, "key_ops", key_ops)
        pulumi.set(__self__, "kty", kty)
        if alg is not None:
            pulumi.set(__self__, "alg", alg)
        if crv is not None:
            pulumi.set(__self__, "crv", crv)
        if d is not None:
            pulumi.set(__self__, "d", d)
        if dp is not None:
            pulumi.set(__self__, "dp", dp)
        if dq is not None:
            pulumi.set(__self__, "dq", dq)
        if e is not None:
            pulumi.set(__self__, "e", e)
        if k is not None:
            pulumi.set(__self__, "k", k)
        if kid is not None:
            pulumi.set(__self__, "kid", kid)
        if n is not None:
            pulumi.set(__self__, "n", n)
        if p is not None:
            pulumi.set(__self__, "p", p)
        if q is not None:
            pulumi.set(__self__, "q", q)
        if qi is not None:
            pulumi.set(__self__, "qi", qi)
        if use is not None:
            pulumi.set(__self__, "use", use)
        if x is not None:
            pulumi.set(__self__, "x", x)
        if y is not None:
            pulumi.set(__self__, "y", y)

    @property
    @pulumi.getter(name="keyOps")
    def key_ops(self) -> Sequence[builtins.str]:
        """
        The operation for which the key is intended to be used
        """
        return pulumi.get(self, "key_ops")

    @property
    @pulumi.getter
    def kty(self) -> builtins.str:
        """
        Key type parameter identifies the cryptographic algorithm family used with the key, such as RSA or EC
        """
        return pulumi.get(self, "kty")

    @property
    @pulumi.getter
    def alg(self) -> Optional[builtins.str]:
        """
        The algorithm intended to be used with the key
        """
        return pulumi.get(self, "alg")

    @property
    @pulumi.getter
    def crv(self) -> Optional[builtins.str]:
        """
        The cryptographic curve used with the key
        """
        return pulumi.get(self, "crv")

    @property
    @pulumi.getter
    def d(self) -> Optional[builtins.str]:
        """
        The RSA or EC private exponent
        """
        return pulumi.get(self, "d")

    @property
    @pulumi.getter
    def dp(self) -> Optional[builtins.str]:
        """
        The RSA private key's first factor CRT exponent
        """
        return pulumi.get(self, "dp")

    @property
    @pulumi.getter
    def dq(self) -> Optional[builtins.str]:
        """
        The RSA private key's second factor CRT exponent
        """
        return pulumi.get(self, "dq")

    @property
    @pulumi.getter
    def e(self) -> Optional[builtins.str]:
        """
        The exponent value for the RSA public key
        """
        return pulumi.get(self, "e")

    @property
    @pulumi.getter
    def k(self) -> Optional[builtins.str]:
        """
        The value of the symmetric (or other single-valued) key
        """
        return pulumi.get(self, "k")

    @property
    @pulumi.getter
    def kid(self) -> Optional[builtins.str]:
        """
        key ID parameter used to match a specific key
        """
        return pulumi.get(self, "kid")

    @property
    @pulumi.getter
    def n(self) -> Optional[builtins.str]:
        """
        The modulus value for the RSA public key
        """
        return pulumi.get(self, "n")

    @property
    @pulumi.getter
    def p(self) -> Optional[builtins.str]:
        """
        The first prime factor of the RSA private key
        """
        return pulumi.get(self, "p")

    @property
    @pulumi.getter
    def q(self) -> Optional[builtins.str]:
        """
        The second prime factor of the RSA private key
        """
        return pulumi.get(self, "q")

    @property
    @pulumi.getter
    def qi(self) -> Optional[builtins.str]:
        """
        The CRT coefficient of the second factor of the RSA private key
        """
        return pulumi.get(self, "qi")

    @property
    @pulumi.getter
    def use(self) -> Optional[builtins.str]:
        """
        The intended use of the public key
        """
        return pulumi.get(self, "use")

    @property
    @pulumi.getter
    def x(self) -> Optional[builtins.str]:
        """
        The x coordinate for the Elliptic Curve point
        """
        return pulumi.get(self, "x")

    @property
    @pulumi.getter
    def y(self) -> Optional[builtins.str]:
        """
        The y coordinate for the Elliptic Curve point
        """
        return pulumi.get(self, "y")


@pulumi.output_type
class GetOkmsResourceIamResult(dict):
    def __init__(__self__, *,
                 display_name: builtins.str,
                 id: builtins.str,
                 tags: Mapping[str, builtins.str],
                 urn: builtins.str):
        """
        :param builtins.str display_name: (String) Resource display name
        :param builtins.str id: Should be set to the ID of your KMS
        :param Mapping[str, builtins.str] tags: (Map of String) Resource tags. Tags that were internally computed are prefixed with ovh:
        :param builtins.str urn: (String) Unique resource name used in policies
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "urn", urn)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        (String) Resource display name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Should be set to the ID of your KMS
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        (Map of String) Resource tags. Tags that were internally computed are prefixed with ovh:
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def urn(self) -> builtins.str:
        """
        (String) Unique resource name used in policies
        """
        return pulumi.get(self, "urn")


@pulumi.output_type
class GetOkmsServiceKeyIamResult(dict):
    def __init__(__self__, *,
                 display_name: builtins.str,
                 id: builtins.str,
                 tags: Mapping[str, builtins.str],
                 urn: builtins.str):
        """
        :param builtins.str display_name: Resource display name
        :param builtins.str id: ID of the service key
        :param Mapping[str, builtins.str] tags: Resource tags. Tags that were internally computed are prefixed with ovh:
        :param builtins.str urn: Unique resource name used in policies
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "urn", urn)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Resource display name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        ID of the service key
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Resource tags. Tags that were internally computed are prefixed with ovh:
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def urn(self) -> builtins.str:
        """
        Unique resource name used in policies
        """
        return pulumi.get(self, "urn")


@pulumi.output_type
class GetOkmsServiceKeyJwkIamResult(dict):
    def __init__(__self__, *,
                 display_name: builtins.str,
                 id: builtins.str,
                 tags: Mapping[str, builtins.str],
                 urn: builtins.str):
        """
        :param builtins.str display_name: Resource display name
        :param builtins.str id: ID of the service key
        :param Mapping[str, builtins.str] tags: Resource tags. Tags that were internally computed are prefixed with ovh:
        :param builtins.str urn: Unique resource name used in policies
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "urn", urn)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Resource display name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        ID of the service key
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Resource tags. Tags that were internally computed are prefixed with ovh:
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def urn(self) -> builtins.str:
        """
        Unique resource name used in policies
        """
        return pulumi.get(self, "urn")


@pulumi.output_type
class GetOkmsServiceKeyJwkKeyResult(dict):
    def __init__(__self__, *,
                 alg: builtins.str,
                 crv: builtins.str,
                 e: builtins.str,
                 key_ops: Sequence[builtins.str],
                 kid: builtins.str,
                 kty: builtins.str,
                 n: builtins.str,
                 use: builtins.str,
                 x: builtins.str,
                 y: builtins.str):
        """
        :param builtins.str alg: The algorithm intended to be used with the key
        :param builtins.str crv: The cryptographic curve used with the key
        :param builtins.str e: The exponent value for the RSA public key
        :param Sequence[builtins.str] key_ops: The operation for which the key is intended to be used
        :param builtins.str kid: key ID parameter used to match a specific key
        :param builtins.str kty: Key type parameter identifies the cryptographic algorithm family used with the key, such as RSA or EC
        :param builtins.str n: The modulus value for the RSA public key
        :param builtins.str use: The intended use of the public key
        :param builtins.str x: The x coordinate for the Elliptic Curve point
        :param builtins.str y: The y coordinate for the Elliptic Curve point
        """
        pulumi.set(__self__, "alg", alg)
        pulumi.set(__self__, "crv", crv)
        pulumi.set(__self__, "e", e)
        pulumi.set(__self__, "key_ops", key_ops)
        pulumi.set(__self__, "kid", kid)
        pulumi.set(__self__, "kty", kty)
        pulumi.set(__self__, "n", n)
        pulumi.set(__self__, "use", use)
        pulumi.set(__self__, "x", x)
        pulumi.set(__self__, "y", y)

    @property
    @pulumi.getter
    def alg(self) -> builtins.str:
        """
        The algorithm intended to be used with the key
        """
        return pulumi.get(self, "alg")

    @property
    @pulumi.getter
    def crv(self) -> builtins.str:
        """
        The cryptographic curve used with the key
        """
        return pulumi.get(self, "crv")

    @property
    @pulumi.getter
    def e(self) -> builtins.str:
        """
        The exponent value for the RSA public key
        """
        return pulumi.get(self, "e")

    @property
    @pulumi.getter(name="keyOps")
    def key_ops(self) -> Sequence[builtins.str]:
        """
        The operation for which the key is intended to be used
        """
        return pulumi.get(self, "key_ops")

    @property
    @pulumi.getter
    def kid(self) -> builtins.str:
        """
        key ID parameter used to match a specific key
        """
        return pulumi.get(self, "kid")

    @property
    @pulumi.getter
    def kty(self) -> builtins.str:
        """
        Key type parameter identifies the cryptographic algorithm family used with the key, such as RSA or EC
        """
        return pulumi.get(self, "kty")

    @property
    @pulumi.getter
    def n(self) -> builtins.str:
        """
        The modulus value for the RSA public key
        """
        return pulumi.get(self, "n")

    @property
    @pulumi.getter
    def use(self) -> builtins.str:
        """
        The intended use of the public key
        """
        return pulumi.get(self, "use")

    @property
    @pulumi.getter
    def x(self) -> builtins.str:
        """
        The x coordinate for the Elliptic Curve point
        """
        return pulumi.get(self, "x")

    @property
    @pulumi.getter
    def y(self) -> builtins.str:
        """
        The y coordinate for the Elliptic Curve point
        """
        return pulumi.get(self, "y")


@pulumi.output_type
class GetOkmsServiceKeyPemIamResult(dict):
    def __init__(__self__, *,
                 display_name: builtins.str,
                 id: builtins.str,
                 tags: Mapping[str, builtins.str],
                 urn: builtins.str):
        """
        :param builtins.str display_name: Resource display name
        :param builtins.str id: Unique identifier of the resource
        :param Mapping[str, builtins.str] tags: Resource tags. Tags that were internally computed are prefixed with ovh:
        :param builtins.str urn: Unique resource name used in policies
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "urn", urn)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Resource display name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Unique identifier of the resource
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Resource tags. Tags that were internally computed are prefixed with ovh:
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def urn(self) -> builtins.str:
        """
        Unique resource name used in policies
        """
        return pulumi.get(self, "urn")


@pulumi.output_type
class GetOkmsServiceKeyPemKeysPemResult(dict):
    def __init__(__self__, *,
                 pem: builtins.str):
        """
        :param builtins.str pem: The key in base64 encoded PEM format
        """
        pulumi.set(__self__, "pem", pem)

    @property
    @pulumi.getter
    def pem(self) -> builtins.str:
        """
        The key in base64 encoded PEM format
        """
        return pulumi.get(self, "pem")


