# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ConnectResult',
    'AwaitableConnectResult',
    'connect',
    'connect_output',
]

@pulumi.output_type
class ConnectResult:
    """
    A collection of values returned by Connect.
    """
    def __init__(__self__, bandwidth=None, description=None, iam=None, id=None, interface_lists=None, pop=None, port_quantity=None, product=None, provider_name=None, service_name=None, status=None, uuid=None, vrack=None):
        if bandwidth and not isinstance(bandwidth, str):
            raise TypeError("Expected argument 'bandwidth' to be a str")
        pulumi.set(__self__, "bandwidth", bandwidth)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if iam and not isinstance(iam, dict):
            raise TypeError("Expected argument 'iam' to be a dict")
        pulumi.set(__self__, "iam", iam)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if interface_lists and not isinstance(interface_lists, list):
            raise TypeError("Expected argument 'interface_lists' to be a list")
        pulumi.set(__self__, "interface_lists", interface_lists)
        if pop and not isinstance(pop, str):
            raise TypeError("Expected argument 'pop' to be a str")
        pulumi.set(__self__, "pop", pop)
        if port_quantity and not isinstance(port_quantity, str):
            raise TypeError("Expected argument 'port_quantity' to be a str")
        pulumi.set(__self__, "port_quantity", port_quantity)
        if product and not isinstance(product, str):
            raise TypeError("Expected argument 'product' to be a str")
        pulumi.set(__self__, "product", product)
        if provider_name and not isinstance(provider_name, str):
            raise TypeError("Expected argument 'provider_name' to be a str")
        pulumi.set(__self__, "provider_name", provider_name)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if uuid and not isinstance(uuid, str):
            raise TypeError("Expected argument 'uuid' to be a str")
        pulumi.set(__self__, "uuid", uuid)
        if vrack and not isinstance(vrack, str):
            raise TypeError("Expected argument 'vrack' to be a str")
        pulumi.set(__self__, "vrack", vrack)

    @property
    @pulumi.getter
    def bandwidth(self) -> builtins.str:
        """
        Service bandwidth
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Service description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def iam(self) -> 'outputs.ConnectIamResult':
        """
        IAM resource information
        """
        return pulumi.get(self, "iam")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="interfaceLists")
    def interface_lists(self) -> Sequence[builtins.float]:
        """
        List of interfaces linked to a service
        """
        return pulumi.get(self, "interface_lists")

    @property
    @pulumi.getter
    def pop(self) -> builtins.str:
        """
        Pop reference where the service is delivered
        """
        return pulumi.get(self, "pop")

    @property
    @pulumi.getter(name="portQuantity")
    def port_quantity(self) -> builtins.str:
        """
        Port quantity
        """
        return pulumi.get(self, "port_quantity")

    @property
    @pulumi.getter
    def product(self) -> builtins.str:
        """
        Product name of the service
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> builtins.str:
        """
        Service provider
        """
        return pulumi.get(self, "provider_name")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Service status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def uuid(self) -> builtins.str:
        """
        uuid of the Ovhcloud Connect service
        """
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter
    def vrack(self) -> builtins.str:
        """
        vrack linked to the service
        """
        return pulumi.get(self, "vrack")


class AwaitableConnectResult(ConnectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ConnectResult(
            bandwidth=self.bandwidth,
            description=self.description,
            iam=self.iam,
            id=self.id,
            interface_lists=self.interface_lists,
            pop=self.pop,
            port_quantity=self.port_quantity,
            product=self.product,
            provider_name=self.provider_name,
            service_name=self.service_name,
            status=self.status,
            uuid=self.uuid,
            vrack=self.vrack)


def connect(service_name: Optional[builtins.str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableConnectResult:
    """
    Use this data source to retrieve information about an Ovhcloud Connect product

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    occ = ovh.OVHcloud.connect(service_name="XXX")
    ```


    :param builtins.str service_name: The uuid of the Ovhcloud connect.
    """
    __args__ = dict()
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:OVHcloud/connect:Connect', __args__, opts=opts, typ=ConnectResult).value

    return AwaitableConnectResult(
        bandwidth=pulumi.get(__ret__, 'bandwidth'),
        description=pulumi.get(__ret__, 'description'),
        iam=pulumi.get(__ret__, 'iam'),
        id=pulumi.get(__ret__, 'id'),
        interface_lists=pulumi.get(__ret__, 'interface_lists'),
        pop=pulumi.get(__ret__, 'pop'),
        port_quantity=pulumi.get(__ret__, 'port_quantity'),
        product=pulumi.get(__ret__, 'product'),
        provider_name=pulumi.get(__ret__, 'provider_name'),
        service_name=pulumi.get(__ret__, 'service_name'),
        status=pulumi.get(__ret__, 'status'),
        uuid=pulumi.get(__ret__, 'uuid'),
        vrack=pulumi.get(__ret__, 'vrack'))
def connect_output(service_name: Optional[pulumi.Input[builtins.str]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[ConnectResult]:
    """
    Use this data source to retrieve information about an Ovhcloud Connect product

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    occ = ovh.OVHcloud.connect(service_name="XXX")
    ```


    :param builtins.str service_name: The uuid of the Ovhcloud connect.
    """
    __args__ = dict()
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ovh:OVHcloud/connect:Connect', __args__, opts=opts, typ=ConnectResult)
    return __ret__.apply(lambda __response__: ConnectResult(
        bandwidth=pulumi.get(__response__, 'bandwidth'),
        description=pulumi.get(__response__, 'description'),
        iam=pulumi.get(__response__, 'iam'),
        id=pulumi.get(__response__, 'id'),
        interface_lists=pulumi.get(__response__, 'interface_lists'),
        pop=pulumi.get(__response__, 'pop'),
        port_quantity=pulumi.get(__response__, 'port_quantity'),
        product=pulumi.get(__response__, 'product'),
        provider_name=pulumi.get(__response__, 'provider_name'),
        service_name=pulumi.get(__response__, 'service_name'),
        status=pulumi.get(__response__, 'status'),
        uuid=pulumi.get(__response__, 'uuid'),
        vrack=pulumi.get(__response__, 'vrack')))
