# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ConnectIamResult',
    'ConnectsOccResult',
    'ConnectsOccIamResult',
]

@pulumi.output_type
class ConnectIamResult(dict):
    def __init__(__self__, *,
                 display_name: builtins.str,
                 id: builtins.str,
                 tags: Mapping[str, builtins.str],
                 urn: builtins.str):
        """
        :param builtins.str display_name: Resource display name
        :param builtins.str id: Unique identifier of the resource in the IAM
        :param Mapping[str, builtins.str] tags: Resource tags. Tags that were internally computed are prefixed with `ovh:`
        :param builtins.str urn: URN of the private database, used when writing IAM policies
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "urn", urn)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Resource display name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Unique identifier of the resource in the IAM
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Resource tags. Tags that were internally computed are prefixed with `ovh:`
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def urn(self) -> builtins.str:
        """
        URN of the private database, used when writing IAM policies
        """
        return pulumi.get(self, "urn")


@pulumi.output_type
class ConnectsOccResult(dict):
    def __init__(__self__, *,
                 bandwidth: builtins.str,
                 description: builtins.str,
                 iam: 'outputs.ConnectsOccIamResult',
                 interface_lists: Sequence[builtins.float],
                 pop: builtins.str,
                 port_quantity: builtins.str,
                 product: builtins.str,
                 provider_name: builtins.str,
                 service_name: builtins.str,
                 status: builtins.str,
                 uuid: builtins.str,
                 vrack: builtins.str):
        """
        :param builtins.str bandwidth: Service bandwidth
        :param builtins.str description: Service description
        :param 'ConnectsOccIamArgs' iam: IAM resource information
        :param Sequence[builtins.float] interface_lists: List of interfaces linked to a service
        :param builtins.str pop: Pop reference where the service is delivered
        :param builtins.str port_quantity: Port quantity
        :param builtins.str product: Product name of the service
        :param builtins.str provider_name: Service provider
        :param builtins.str service_name: Service name
        :param builtins.str status: Service status
        :param builtins.str uuid: uuid of the Ovhcloud Connect service
        :param builtins.str vrack: vrack linked to the service
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "iam", iam)
        pulumi.set(__self__, "interface_lists", interface_lists)
        pulumi.set(__self__, "pop", pop)
        pulumi.set(__self__, "port_quantity", port_quantity)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "provider_name", provider_name)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "uuid", uuid)
        pulumi.set(__self__, "vrack", vrack)

    @property
    @pulumi.getter
    def bandwidth(self) -> builtins.str:
        """
        Service bandwidth
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Service description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def iam(self) -> 'outputs.ConnectsOccIamResult':
        """
        IAM resource information
        """
        return pulumi.get(self, "iam")

    @property
    @pulumi.getter(name="interfaceLists")
    def interface_lists(self) -> Sequence[builtins.float]:
        """
        List of interfaces linked to a service
        """
        return pulumi.get(self, "interface_lists")

    @property
    @pulumi.getter
    def pop(self) -> builtins.str:
        """
        Pop reference where the service is delivered
        """
        return pulumi.get(self, "pop")

    @property
    @pulumi.getter(name="portQuantity")
    def port_quantity(self) -> builtins.str:
        """
        Port quantity
        """
        return pulumi.get(self, "port_quantity")

    @property
    @pulumi.getter
    def product(self) -> builtins.str:
        """
        Product name of the service
        """
        return pulumi.get(self, "product")

    @property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> builtins.str:
        """
        Service provider
        """
        return pulumi.get(self, "provider_name")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> builtins.str:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Service status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def uuid(self) -> builtins.str:
        """
        uuid of the Ovhcloud Connect service
        """
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter
    def vrack(self) -> builtins.str:
        """
        vrack linked to the service
        """
        return pulumi.get(self, "vrack")


@pulumi.output_type
class ConnectsOccIamResult(dict):
    def __init__(__self__, *,
                 display_name: builtins.str,
                 id: builtins.str,
                 tags: Mapping[str, builtins.str],
                 urn: builtins.str):
        """
        :param builtins.str display_name: Resource display name
        :param builtins.str id: Unique identifier of the resource in the IAM
        :param Mapping[str, builtins.str] tags: Resource tags. Tags that were internally computed are prefixed with `ovh:`
        :param builtins.str urn: URN of the private database, used when writing IAM policies
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "urn", urn)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Resource display name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Unique identifier of the resource in the IAM
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Resource tags. Tags that were internally computed are prefixed with `ovh:`
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def urn(self) -> builtins.str:
        """
        URN of the private database, used when writing IAM policies
        """
        return pulumi.get(self, "urn")


