# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['OvhcloudConnectPopConfigArgs', 'OvhcloudConnectPopConfig']

@pulumi.input_type
class OvhcloudConnectPopConfigArgs:
    def __init__(__self__, *,
                 interface_id: pulumi.Input[builtins.float],
                 service_name: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 customer_bgp_area: Optional[pulumi.Input[builtins.float]] = None,
                 ovh_bgp_area: Optional[pulumi.Input[builtins.float]] = None,
                 subnet: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a OvhcloudConnectPopConfig resource.
        :param pulumi.Input[builtins.float] interface_id: ID of the interface
        :param pulumi.Input[builtins.str] service_name: Service name
        :param pulumi.Input[builtins.str] type: Type of the pop configuration
        :param pulumi.Input[builtins.float] customer_bgp_area: Customer Private AS
        :param pulumi.Input[builtins.float] ovh_bgp_area: OVH Private AS
        :param pulumi.Input[builtins.str] subnet: Subnet should be a /30, first IP for OVH, second IP for customer
        """
        pulumi.set(__self__, "interface_id", interface_id)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "type", type)
        if customer_bgp_area is not None:
            pulumi.set(__self__, "customer_bgp_area", customer_bgp_area)
        if ovh_bgp_area is not None:
            pulumi.set(__self__, "ovh_bgp_area", ovh_bgp_area)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter(name="interfaceId")
    def interface_id(self) -> pulumi.Input[builtins.float]:
        """
        ID of the interface
        """
        return pulumi.get(self, "interface_id")

    @interface_id.setter
    def interface_id(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "interface_id", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[builtins.str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Type of the pop configuration
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="customerBgpArea")
    def customer_bgp_area(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Customer Private AS
        """
        return pulumi.get(self, "customer_bgp_area")

    @customer_bgp_area.setter
    def customer_bgp_area(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "customer_bgp_area", value)

    @property
    @pulumi.getter(name="ovhBgpArea")
    def ovh_bgp_area(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        OVH Private AS
        """
        return pulumi.get(self, "ovh_bgp_area")

    @ovh_bgp_area.setter
    def ovh_bgp_area(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "ovh_bgp_area", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Subnet should be a /30, first IP for OVH, second IP for customer
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class _OvhcloudConnectPopConfigState:
    def __init__(__self__, *,
                 customer_bgp_area: Optional[pulumi.Input[builtins.float]] = None,
                 interface_id: Optional[pulumi.Input[builtins.float]] = None,
                 ovh_bgp_area: Optional[pulumi.Input[builtins.float]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 subnet: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering OvhcloudConnectPopConfig resources.
        :param pulumi.Input[builtins.float] customer_bgp_area: Customer Private AS
        :param pulumi.Input[builtins.float] interface_id: ID of the interface
        :param pulumi.Input[builtins.float] ovh_bgp_area: OVH Private AS
        :param pulumi.Input[builtins.str] service_name: Service name
        :param pulumi.Input[builtins.str] status: Status of the pop configuration
        :param pulumi.Input[builtins.str] subnet: Subnet should be a /30, first IP for OVH, second IP for customer
        :param pulumi.Input[builtins.str] type: Type of the pop configuration
        """
        if customer_bgp_area is not None:
            pulumi.set(__self__, "customer_bgp_area", customer_bgp_area)
        if interface_id is not None:
            pulumi.set(__self__, "interface_id", interface_id)
        if ovh_bgp_area is not None:
            pulumi.set(__self__, "ovh_bgp_area", ovh_bgp_area)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="customerBgpArea")
    def customer_bgp_area(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Customer Private AS
        """
        return pulumi.get(self, "customer_bgp_area")

    @customer_bgp_area.setter
    def customer_bgp_area(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "customer_bgp_area", value)

    @property
    @pulumi.getter(name="interfaceId")
    def interface_id(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        ID of the interface
        """
        return pulumi.get(self, "interface_id")

    @interface_id.setter
    def interface_id(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "interface_id", value)

    @property
    @pulumi.getter(name="ovhBgpArea")
    def ovh_bgp_area(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        OVH Private AS
        """
        return pulumi.get(self, "ovh_bgp_area")

    @ovh_bgp_area.setter
    def ovh_bgp_area(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "ovh_bgp_area", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Status of the pop configuration
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Subnet should be a /30, first IP for OVH, second IP for customer
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of the pop configuration
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("ovh:index/ovhcloudConnectPopConfig:OvhcloudConnectPopConfig")
class OvhcloudConnectPopConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer_bgp_area: Optional[pulumi.Input[builtins.float]] = None,
                 interface_id: Optional[pulumi.Input[builtins.float]] = None,
                 ovh_bgp_area: Optional[pulumi.Input[builtins.float]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 subnet: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Creates a pop configuration for an Ovhcloud Connect product.

        Please take a look at the list of available `types` in the `Required` section in order to know the list of available type configurations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        occ = ovh.OVHcloud.connect(service_name="XXX")
        pop = ovh.OvhcloudConnectPopConfig("pop",
            service_name=occ.service_name,
            interface_id=occ.interface_lists[0],
            type="l3",
            customer_bgp_area=65400,
            ovh_bgp_area=65401,
            subnet="I.I.I.I/30")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.float] customer_bgp_area: Customer Private AS
        :param pulumi.Input[builtins.float] interface_id: ID of the interface
        :param pulumi.Input[builtins.float] ovh_bgp_area: OVH Private AS
        :param pulumi.Input[builtins.str] service_name: Service name
        :param pulumi.Input[builtins.str] subnet: Subnet should be a /30, first IP for OVH, second IP for customer
        :param pulumi.Input[builtins.str] type: Type of the pop configuration
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OvhcloudConnectPopConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a pop configuration for an Ovhcloud Connect product.

        Please take a look at the list of available `types` in the `Required` section in order to know the list of available type configurations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        occ = ovh.OVHcloud.connect(service_name="XXX")
        pop = ovh.OvhcloudConnectPopConfig("pop",
            service_name=occ.service_name,
            interface_id=occ.interface_lists[0],
            type="l3",
            customer_bgp_area=65400,
            ovh_bgp_area=65401,
            subnet="I.I.I.I/30")
        ```

        :param str resource_name: The name of the resource.
        :param OvhcloudConnectPopConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OvhcloudConnectPopConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer_bgp_area: Optional[pulumi.Input[builtins.float]] = None,
                 interface_id: Optional[pulumi.Input[builtins.float]] = None,
                 ovh_bgp_area: Optional[pulumi.Input[builtins.float]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 subnet: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OvhcloudConnectPopConfigArgs.__new__(OvhcloudConnectPopConfigArgs)

            __props__.__dict__["customer_bgp_area"] = customer_bgp_area
            if interface_id is None and not opts.urn:
                raise TypeError("Missing required property 'interface_id'")
            __props__.__dict__["interface_id"] = interface_id
            __props__.__dict__["ovh_bgp_area"] = ovh_bgp_area
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["subnet"] = subnet
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["status"] = None
        super(OvhcloudConnectPopConfig, __self__).__init__(
            'ovh:index/ovhcloudConnectPopConfig:OvhcloudConnectPopConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            customer_bgp_area: Optional[pulumi.Input[builtins.float]] = None,
            interface_id: Optional[pulumi.Input[builtins.float]] = None,
            ovh_bgp_area: Optional[pulumi.Input[builtins.float]] = None,
            service_name: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            subnet: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'OvhcloudConnectPopConfig':
        """
        Get an existing OvhcloudConnectPopConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.float] customer_bgp_area: Customer Private AS
        :param pulumi.Input[builtins.float] interface_id: ID of the interface
        :param pulumi.Input[builtins.float] ovh_bgp_area: OVH Private AS
        :param pulumi.Input[builtins.str] service_name: Service name
        :param pulumi.Input[builtins.str] status: Status of the pop configuration
        :param pulumi.Input[builtins.str] subnet: Subnet should be a /30, first IP for OVH, second IP for customer
        :param pulumi.Input[builtins.str] type: Type of the pop configuration
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OvhcloudConnectPopConfigState.__new__(_OvhcloudConnectPopConfigState)

        __props__.__dict__["customer_bgp_area"] = customer_bgp_area
        __props__.__dict__["interface_id"] = interface_id
        __props__.__dict__["ovh_bgp_area"] = ovh_bgp_area
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet"] = subnet
        __props__.__dict__["type"] = type
        return OvhcloudConnectPopConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customerBgpArea")
    def customer_bgp_area(self) -> pulumi.Output[builtins.float]:
        """
        Customer Private AS
        """
        return pulumi.get(self, "customer_bgp_area")

    @property
    @pulumi.getter(name="interfaceId")
    def interface_id(self) -> pulumi.Output[builtins.float]:
        """
        ID of the interface
        """
        return pulumi.get(self, "interface_id")

    @property
    @pulumi.getter(name="ovhBgpArea")
    def ovh_bgp_area(self) -> pulumi.Output[builtins.float]:
        """
        OVH Private AS
        """
        return pulumi.get(self, "ovh_bgp_area")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[builtins.str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        Status of the pop configuration
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Output[builtins.str]:
        """
        Subnet should be a /30, first IP for OVH, second IP for customer
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Type of the pop configuration
        """
        return pulumi.get(self, "type")

