# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['StorageEfsShareSnapshotArgs', 'StorageEfsShareSnapshot']

@pulumi.input_type
class StorageEfsShareSnapshotArgs:
    def __init__(__self__, *,
                 service_name: pulumi.Input[builtins.str],
                 share_id: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a StorageEfsShareSnapshot resource.
        :param pulumi.Input[builtins.str] service_name: Service name
        :param pulumi.Input[builtins.str] share_id: Share ID
        :param pulumi.Input[builtins.str] description: Snapshot description
        :param pulumi.Input[builtins.str] name: Snapshot name
        """
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "share_id", share_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[builtins.str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="shareId")
    def share_id(self) -> pulumi.Input[builtins.str]:
        """
        Share ID
        """
        return pulumi.get(self, "share_id")

    @share_id.setter
    def share_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "share_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Snapshot description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Snapshot name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _StorageEfsShareSnapshotState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 share_id: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering StorageEfsShareSnapshot resources.
        :param pulumi.Input[builtins.str] created_at: Snapshot creation date
        :param pulumi.Input[builtins.str] description: Snapshot description
        :param pulumi.Input[builtins.str] name: Snapshot name
        :param pulumi.Input[builtins.str] path: Snapshot path
        :param pulumi.Input[builtins.str] service_name: Service name
        :param pulumi.Input[builtins.str] share_id: Share ID
        :param pulumi.Input[builtins.str] status: Snapshot status
        :param pulumi.Input[builtins.str] type: Snapshot type
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if share_id is not None:
            pulumi.set(__self__, "share_id", share_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Snapshot creation date
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Snapshot description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Snapshot name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Snapshot path
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="shareId")
    def share_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Share ID
        """
        return pulumi.get(self, "share_id")

    @share_id.setter
    def share_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "share_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Snapshot status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Snapshot type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("ovh:index/storageEfsShareSnapshot:StorageEfsShareSnapshot")
class StorageEfsShareSnapshot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 share_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh
        import pulumi_time as time

        efs = ovh.get_storage_efs(service_name="XXX")
        # This resource will destroy (at least) 10 seconds after ovh_storage_efs_share_snapshot resource
        share = ovh.StorageEfsShare("share",
            service_name=efs.service_name,
            name="share",
            description="My share",
            protocol="NFS",
            size=100)
        # This resource adds a delay between ovh_storage_efs_share_snapshot and ovh_storage_efs_share resources destruction
        wait10_seconds = time.index.Sleep("wait_10_seconds", destroy_duration=10s,
        opts = pulumi.ResourceOptions(depends_on=[share]))
        snapshot = ovh.StorageEfsShareSnapshot("snapshot",
            service_name=efs.service_name,
            share_id=share.id,
            name="snapshot",
            description="My snapshot",
            opts = pulumi.ResourceOptions(depends_on=[wait10_seconds]))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Snapshot description
        :param pulumi.Input[builtins.str] name: Snapshot name
        :param pulumi.Input[builtins.str] service_name: Service name
        :param pulumi.Input[builtins.str] share_id: Share ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StorageEfsShareSnapshotArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh
        import pulumi_time as time

        efs = ovh.get_storage_efs(service_name="XXX")
        # This resource will destroy (at least) 10 seconds after ovh_storage_efs_share_snapshot resource
        share = ovh.StorageEfsShare("share",
            service_name=efs.service_name,
            name="share",
            description="My share",
            protocol="NFS",
            size=100)
        # This resource adds a delay between ovh_storage_efs_share_snapshot and ovh_storage_efs_share resources destruction
        wait10_seconds = time.index.Sleep("wait_10_seconds", destroy_duration=10s,
        opts = pulumi.ResourceOptions(depends_on=[share]))
        snapshot = ovh.StorageEfsShareSnapshot("snapshot",
            service_name=efs.service_name,
            share_id=share.id,
            name="snapshot",
            description="My snapshot",
            opts = pulumi.ResourceOptions(depends_on=[wait10_seconds]))
        ```

        :param str resource_name: The name of the resource.
        :param StorageEfsShareSnapshotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StorageEfsShareSnapshotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 share_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StorageEfsShareSnapshotArgs.__new__(StorageEfsShareSnapshotArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            if share_id is None and not opts.urn:
                raise TypeError("Missing required property 'share_id'")
            __props__.__dict__["share_id"] = share_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["path"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["type"] = None
        super(StorageEfsShareSnapshot, __self__).__init__(
            'ovh:index/storageEfsShareSnapshot:StorageEfsShareSnapshot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            path: Optional[pulumi.Input[builtins.str]] = None,
            service_name: Optional[pulumi.Input[builtins.str]] = None,
            share_id: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'StorageEfsShareSnapshot':
        """
        Get an existing StorageEfsShareSnapshot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] created_at: Snapshot creation date
        :param pulumi.Input[builtins.str] description: Snapshot description
        :param pulumi.Input[builtins.str] name: Snapshot name
        :param pulumi.Input[builtins.str] path: Snapshot path
        :param pulumi.Input[builtins.str] service_name: Service name
        :param pulumi.Input[builtins.str] share_id: Share ID
        :param pulumi.Input[builtins.str] status: Snapshot status
        :param pulumi.Input[builtins.str] type: Snapshot type
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StorageEfsShareSnapshotState.__new__(_StorageEfsShareSnapshotState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["path"] = path
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["share_id"] = share_id
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        return StorageEfsShareSnapshot(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Snapshot creation date
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Snapshot description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Snapshot name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[builtins.str]:
        """
        Snapshot path
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[builtins.str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="shareId")
    def share_id(self) -> pulumi.Output[builtins.str]:
        """
        Share ID
        """
        return pulumi.get(self, "share_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        Snapshot status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Snapshot type
        """
        return pulumi.get(self, "type")

