# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DedicatedCloudDatacenterArgs', 'DedicatedCloudDatacenter']

@pulumi.input_type
class DedicatedCloudDatacenterArgs:
    def __init__(__self__, *,
                 datacenter: pulumi.Input[builtins.str],
                 service_name: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a DedicatedCloudDatacenter resource.
        :param pulumi.Input[builtins.str] datacenter: Your Dedicated Cloud Datacenter.
        :param pulumi.Input[builtins.str] service_name: The internal name of your vrack
        """
        pulumi.set(__self__, "datacenter", datacenter)
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter
    def datacenter(self) -> pulumi.Input[builtins.str]:
        """
        Your Dedicated Cloud Datacenter.
        """
        return pulumi.get(self, "datacenter")

    @datacenter.setter
    def datacenter(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "datacenter", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[builtins.str]:
        """
        The internal name of your vrack
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class _DedicatedCloudDatacenterState:
    def __init__(__self__, *,
                 datacenter: Optional[pulumi.Input[builtins.str]] = None,
                 dedicated_cloud: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 target_service_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DedicatedCloudDatacenter resources.
        :param pulumi.Input[builtins.str] datacenter: Your Dedicated Cloud Datacenter.
        :param pulumi.Input[builtins.str] dedicated_cloud: Your dedicatedCloud name
        :param pulumi.Input[builtins.str] service_name: The internal name of your vrack
        :param pulumi.Input[builtins.str] target_service_name: The internal name of your target vrack
        """
        if datacenter is not None:
            pulumi.set(__self__, "datacenter", datacenter)
        if dedicated_cloud is not None:
            pulumi.set(__self__, "dedicated_cloud", dedicated_cloud)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if target_service_name is not None:
            pulumi.set(__self__, "target_service_name", target_service_name)

    @property
    @pulumi.getter
    def datacenter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Your Dedicated Cloud Datacenter.
        """
        return pulumi.get(self, "datacenter")

    @datacenter.setter
    def datacenter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "datacenter", value)

    @property
    @pulumi.getter(name="dedicatedCloud")
    def dedicated_cloud(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Your dedicatedCloud name
        """
        return pulumi.get(self, "dedicated_cloud")

    @dedicated_cloud.setter
    def dedicated_cloud(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dedicated_cloud", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The internal name of your vrack
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="targetServiceName")
    def target_service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The internal name of your target vrack
        """
        return pulumi.get(self, "target_service_name")

    @target_service_name.setter
    def target_service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_service_name", value)


@pulumi.type_token("ovh:Vrack/dedicatedCloudDatacenter:DedicatedCloudDatacenter")
class DedicatedCloudDatacenter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 datacenter: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Move a Dedicated Cloud Datacenter to a vrack.

        ## Example Usage

        > **WARNING** You have to import the resource first as it cannot be created, see Import section below.

        ```python
        import pulumi
        import pulumi_ovh as ovh

        vrack_dedicated_cloud_datacenter = ovh.vrack.DedicatedCloudDatacenter("vrack_dedicated_cloud_datacenter",
            service_name="<vRack service name>",
            datacenter="<Dedicated Cloud Datacenter service name>")
        ```

        ## Import

        A Datacenter will always be in a vRack, first import the resource, this will move the Dedicated Cloud Datacenter to the vRack target.

        bash

        ```sh
        $ pulumi import ovh:Vrack/dedicatedCloudDatacenter:DedicatedCloudDatacenter vrack-dedicatedCloudDatacenter "<vRack service name>/<Dedicated Cloud Datacener service name>/<vRack target service name>"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] datacenter: Your Dedicated Cloud Datacenter.
        :param pulumi.Input[builtins.str] service_name: The internal name of your vrack
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DedicatedCloudDatacenterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Move a Dedicated Cloud Datacenter to a vrack.

        ## Example Usage

        > **WARNING** You have to import the resource first as it cannot be created, see Import section below.

        ```python
        import pulumi
        import pulumi_ovh as ovh

        vrack_dedicated_cloud_datacenter = ovh.vrack.DedicatedCloudDatacenter("vrack_dedicated_cloud_datacenter",
            service_name="<vRack service name>",
            datacenter="<Dedicated Cloud Datacenter service name>")
        ```

        ## Import

        A Datacenter will always be in a vRack, first import the resource, this will move the Dedicated Cloud Datacenter to the vRack target.

        bash

        ```sh
        $ pulumi import ovh:Vrack/dedicatedCloudDatacenter:DedicatedCloudDatacenter vrack-dedicatedCloudDatacenter "<vRack service name>/<Dedicated Cloud Datacener service name>/<vRack target service name>"
        ```

        :param str resource_name: The name of the resource.
        :param DedicatedCloudDatacenterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DedicatedCloudDatacenterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 datacenter: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DedicatedCloudDatacenterArgs.__new__(DedicatedCloudDatacenterArgs)

            if datacenter is None and not opts.urn:
                raise TypeError("Missing required property 'datacenter'")
            __props__.__dict__["datacenter"] = datacenter
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["dedicated_cloud"] = None
            __props__.__dict__["target_service_name"] = None
        super(DedicatedCloudDatacenter, __self__).__init__(
            'ovh:Vrack/dedicatedCloudDatacenter:DedicatedCloudDatacenter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            datacenter: Optional[pulumi.Input[builtins.str]] = None,
            dedicated_cloud: Optional[pulumi.Input[builtins.str]] = None,
            service_name: Optional[pulumi.Input[builtins.str]] = None,
            target_service_name: Optional[pulumi.Input[builtins.str]] = None) -> 'DedicatedCloudDatacenter':
        """
        Get an existing DedicatedCloudDatacenter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] datacenter: Your Dedicated Cloud Datacenter.
        :param pulumi.Input[builtins.str] dedicated_cloud: Your dedicatedCloud name
        :param pulumi.Input[builtins.str] service_name: The internal name of your vrack
        :param pulumi.Input[builtins.str] target_service_name: The internal name of your target vrack
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DedicatedCloudDatacenterState.__new__(_DedicatedCloudDatacenterState)

        __props__.__dict__["datacenter"] = datacenter
        __props__.__dict__["dedicated_cloud"] = dedicated_cloud
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["target_service_name"] = target_service_name
        return DedicatedCloudDatacenter(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def datacenter(self) -> pulumi.Output[builtins.str]:
        """
        Your Dedicated Cloud Datacenter.
        """
        return pulumi.get(self, "datacenter")

    @property
    @pulumi.getter(name="dedicatedCloud")
    def dedicated_cloud(self) -> pulumi.Output[builtins.str]:
        """
        Your dedicatedCloud name
        """
        return pulumi.get(self, "dedicated_cloud")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[builtins.str]:
        """
        The internal name of your vrack
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="targetServiceName")
    def target_service_name(self) -> pulumi.Output[builtins.str]:
        """
        The internal name of your target vrack
        """
        return pulumi.get(self, "target_service_name")

