# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IpAddressArgs', 'IpAddress']

@pulumi.input_type
class IpAddressArgs:
    def __init__(__self__, *,
                 block: pulumi.Input[builtins.str],
                 service_name: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a IpAddress resource.
        :param pulumi.Input[builtins.str] block: Your IP block.
        :param pulumi.Input[builtins.str] service_name: The internal name of your vrack
        :param pulumi.Input[builtins.str] region: The region (e.g: eu-west-gra) where want to route your block to.
        """
        pulumi.set(__self__, "block", block)
        pulumi.set(__self__, "service_name", service_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def block(self) -> pulumi.Input[builtins.str]:
        """
        Your IP block.
        """
        return pulumi.get(self, "block")

    @block.setter
    def block(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "block", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[builtins.str]:
        """
        The internal name of your vrack
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region (e.g: eu-west-gra) where want to route your block to.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _IpAddressState:
    def __init__(__self__, *,
                 block: Optional[pulumi.Input[builtins.str]] = None,
                 gateway: Optional[pulumi.Input[builtins.str]] = None,
                 ip: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering IpAddress resources.
        :param pulumi.Input[builtins.str] block: Your IP block.
        :param pulumi.Input[builtins.str] gateway: Your gateway
        :param pulumi.Input[builtins.str] ip: Your IP block
        :param pulumi.Input[builtins.str] region: The region (e.g: eu-west-gra) where want to route your block to.
        :param pulumi.Input[builtins.str] service_name: The internal name of your vrack
        :param pulumi.Input[builtins.str] zone: Where you want your block announced on the network
        """
        if block is not None:
            pulumi.set(__self__, "block", block)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def block(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Your IP block.
        """
        return pulumi.get(self, "block")

    @block.setter
    def block(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "block", value)

    @property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Your gateway
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gateway", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Your IP block
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region (e.g: eu-west-gra) where want to route your block to.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The internal name of your vrack
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Where you want your block announced on the network
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("ovh:Vrack/ipAddress:IpAddress")
class IpAddress(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 block: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Attach an IP block to a VRack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        my_account = ovh.Me.get_me()
        my_cart = ovh.Order.get_cart(ovh_subsidiary=my_account.ovh_subsidiary)
        vrack = ovh.Order.get_cart_product_plan(cart_id=my_cart.id,
            price_capacity="renew",
            product="vrack",
            plan_code="vrack")
        vrack_vrack = ovh.vrack.Vrack("vrack",
            description=my_cart.description,
            name=my_cart.description,
            ovh_subsidiary=my_cart.ovh_subsidiary,
            plan={
                "duration": vrack.selected_prices[0].duration,
                "plan_code": vrack.plan_code,
                "pricing_mode": vrack.selected_prices[0].pricing_mode,
            })
        ipblock = ovh.Order.get_cart_product_plan(cart_id=my_cart.id,
            price_capacity="renew",
            product="ip",
            plan_code="ip-v4-s30-ripe")
        ipblock_ip_service = ovh.ip.IpService("ipblock",
            ovh_subsidiary=my_cart.ovh_subsidiary,
            description=my_cart.description,
            plan={
                "duration": ipblock.selected_prices[0].duration,
                "plan_code": ipblock.plan_code,
                "pricing_mode": ipblock.selected_prices[0].pricing_mode,
                "configurations": [{
                    "label": "country",
                    "value": "FR",
                }],
            })
        vrack_block = ovh.vrack.IpAddress("vrack_block",
            service_name=vrack_vrack.service_name,
            block=ipblock_ip_service.ip)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] block: Your IP block.
        :param pulumi.Input[builtins.str] region: The region (e.g: eu-west-gra) where want to route your block to.
        :param pulumi.Input[builtins.str] service_name: The internal name of your vrack
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IpAddressArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Attach an IP block to a VRack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        my_account = ovh.Me.get_me()
        my_cart = ovh.Order.get_cart(ovh_subsidiary=my_account.ovh_subsidiary)
        vrack = ovh.Order.get_cart_product_plan(cart_id=my_cart.id,
            price_capacity="renew",
            product="vrack",
            plan_code="vrack")
        vrack_vrack = ovh.vrack.Vrack("vrack",
            description=my_cart.description,
            name=my_cart.description,
            ovh_subsidiary=my_cart.ovh_subsidiary,
            plan={
                "duration": vrack.selected_prices[0].duration,
                "plan_code": vrack.plan_code,
                "pricing_mode": vrack.selected_prices[0].pricing_mode,
            })
        ipblock = ovh.Order.get_cart_product_plan(cart_id=my_cart.id,
            price_capacity="renew",
            product="ip",
            plan_code="ip-v4-s30-ripe")
        ipblock_ip_service = ovh.ip.IpService("ipblock",
            ovh_subsidiary=my_cart.ovh_subsidiary,
            description=my_cart.description,
            plan={
                "duration": ipblock.selected_prices[0].duration,
                "plan_code": ipblock.plan_code,
                "pricing_mode": ipblock.selected_prices[0].pricing_mode,
                "configurations": [{
                    "label": "country",
                    "value": "FR",
                }],
            })
        vrack_block = ovh.vrack.IpAddress("vrack_block",
            service_name=vrack_vrack.service_name,
            block=ipblock_ip_service.ip)
        ```

        :param str resource_name: The name of the resource.
        :param IpAddressArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpAddressArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 block: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpAddressArgs.__new__(IpAddressArgs)

            if block is None and not opts.urn:
                raise TypeError("Missing required property 'block'")
            __props__.__dict__["block"] = block
            __props__.__dict__["region"] = region
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["gateway"] = None
            __props__.__dict__["ip"] = None
            __props__.__dict__["zone"] = None
        super(IpAddress, __self__).__init__(
            'ovh:Vrack/ipAddress:IpAddress',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            block: Optional[pulumi.Input[builtins.str]] = None,
            gateway: Optional[pulumi.Input[builtins.str]] = None,
            ip: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            service_name: Optional[pulumi.Input[builtins.str]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'IpAddress':
        """
        Get an existing IpAddress resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] block: Your IP block.
        :param pulumi.Input[builtins.str] gateway: Your gateway
        :param pulumi.Input[builtins.str] ip: Your IP block
        :param pulumi.Input[builtins.str] region: The region (e.g: eu-west-gra) where want to route your block to.
        :param pulumi.Input[builtins.str] service_name: The internal name of your vrack
        :param pulumi.Input[builtins.str] zone: Where you want your block announced on the network
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IpAddressState.__new__(_IpAddressState)

        __props__.__dict__["block"] = block
        __props__.__dict__["gateway"] = gateway
        __props__.__dict__["ip"] = ip
        __props__.__dict__["region"] = region
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["zone"] = zone
        return IpAddress(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def block(self) -> pulumi.Output[builtins.str]:
        """
        Your IP block.
        """
        return pulumi.get(self, "block")

    @property
    @pulumi.getter
    def gateway(self) -> pulumi.Output[builtins.str]:
        """
        Your gateway
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Output[builtins.str]:
        """
        Your IP block
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The region (e.g: eu-west-gra) where want to route your block to.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[builtins.str]:
        """
        The internal name of your vrack
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        Where you want your block announced on the network
        """
        return pulumi.get(self, "zone")

