# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'IpV6BridgedSubrange',
    'VrackOrder',
    'VrackOrderDetail',
    'VrackPlan',
    'VrackPlanConfiguration',
    'VrackPlanOption',
    'VrackPlanOptionConfiguration',
]

@pulumi.output_type
class IpV6BridgedSubrange(dict):
    def __init__(__self__, *,
                 slaac: builtins.str,
                 gateway: Optional[builtins.str] = None,
                 subrange: Optional[builtins.str] = None):
        """
        :param builtins.str slaac: Slaac status <enabled|disabled>
        :param builtins.str gateway: Your gateway
        :param builtins.str subrange: IPv6 CIDR notation (e.g., 2001:41d0::/128)
        """
        pulumi.set(__self__, "slaac", slaac)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if subrange is not None:
            pulumi.set(__self__, "subrange", subrange)

    @property
    @pulumi.getter
    def slaac(self) -> builtins.str:
        """
        Slaac status <enabled|disabled>
        """
        return pulumi.get(self, "slaac")

    @property
    @pulumi.getter
    def gateway(self) -> Optional[builtins.str]:
        """
        Your gateway
        """
        return pulumi.get(self, "gateway")

    @property
    @pulumi.getter
    def subrange(self) -> Optional[builtins.str]:
        """
        IPv6 CIDR notation (e.g., 2001:41d0::/128)
        """
        return pulumi.get(self, "subrange")


@pulumi.output_type
class VrackOrder(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationDate":
            suggest = "expiration_date"
        elif key == "orderId":
            suggest = "order_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VrackOrder. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VrackOrder.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VrackOrder.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date: Optional[builtins.str] = None,
                 details: Optional[Sequence['outputs.VrackOrderDetail']] = None,
                 expiration_date: Optional[builtins.str] = None,
                 order_id: Optional[builtins.int] = None):
        """
        :param builtins.str date: date
        :param Sequence['VrackOrderDetailArgs'] details: Information about a Bill entry
        :param builtins.str expiration_date: expiration date
        :param builtins.int order_id: order id
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if order_id is not None:
            pulumi.set(__self__, "order_id", order_id)

    @property
    @pulumi.getter
    def date(self) -> Optional[builtins.str]:
        """
        date
        """
        return pulumi.get(self, "date")

    @property
    @pulumi.getter
    def details(self) -> Optional[Sequence['outputs.VrackOrderDetail']]:
        """
        Information about a Bill entry
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[builtins.str]:
        """
        expiration date
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="orderId")
    def order_id(self) -> Optional[builtins.int]:
        """
        order id
        """
        return pulumi.get(self, "order_id")


@pulumi.output_type
class VrackOrderDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "orderDetailId":
            suggest = "order_detail_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VrackOrderDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VrackOrderDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VrackOrderDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[builtins.str] = None,
                 domain: Optional[builtins.str] = None,
                 order_detail_id: Optional[builtins.int] = None,
                 quantity: Optional[builtins.str] = None):
        """
        :param builtins.str description: yourvrackdescription
        :param builtins.str domain: expiration date
        :param builtins.int order_detail_id: order detail id
        :param builtins.str quantity: quantity
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if order_detail_id is not None:
            pulumi.set(__self__, "order_detail_id", order_detail_id)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        yourvrackdescription
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def domain(self) -> Optional[builtins.str]:
        """
        expiration date
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="orderDetailId")
    def order_detail_id(self) -> Optional[builtins.int]:
        """
        order detail id
        """
        return pulumi.get(self, "order_detail_id")

    @property
    @pulumi.getter
    def quantity(self) -> Optional[builtins.str]:
        """
        quantity
        """
        return pulumi.get(self, "quantity")


@pulumi.output_type
class VrackPlan(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"
        elif key == "catalogName":
            suggest = "catalog_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VrackPlan. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VrackPlan.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VrackPlan.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: builtins.str,
                 plan_code: builtins.str,
                 pricing_mode: builtins.str,
                 catalog_name: Optional[builtins.str] = None,
                 configurations: Optional[Sequence['outputs.VrackPlanConfiguration']] = None):
        """
        :param builtins.str duration: duration
        :param builtins.str plan_code: Plan code
        :param builtins.str pricing_mode: Pricing model identifier
        :param builtins.str catalog_name: Catalog name
        :param Sequence['VrackPlanConfigurationArgs'] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> builtins.str:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> builtins.str:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> builtins.str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[builtins.str]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.VrackPlanConfiguration']]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")


@pulumi.output_type
class VrackPlanConfiguration(dict):
    def __init__(__self__, *,
                 label: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str label: Identifier of the resource
        :param builtins.str value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> builtins.str:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class VrackPlanOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "planCode":
            suggest = "plan_code"
        elif key == "pricingMode":
            suggest = "pricing_mode"
        elif key == "catalogName":
            suggest = "catalog_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VrackPlanOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VrackPlanOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VrackPlanOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: builtins.str,
                 plan_code: builtins.str,
                 pricing_mode: builtins.str,
                 catalog_name: Optional[builtins.str] = None,
                 configurations: Optional[Sequence['outputs.VrackPlanOptionConfiguration']] = None):
        """
        :param builtins.str duration: duration
        :param builtins.str plan_code: Plan code
        :param builtins.str pricing_mode: Pricing model identifier
        :param builtins.str catalog_name: Catalog name
        :param Sequence['VrackPlanOptionConfigurationArgs'] configurations: Representation of a configuration item for personalizing product
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "plan_code", plan_code)
        pulumi.set(__self__, "pricing_mode", pricing_mode)
        if catalog_name is not None:
            pulumi.set(__self__, "catalog_name", catalog_name)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)

    @property
    @pulumi.getter
    def duration(self) -> builtins.str:
        """
        duration
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="planCode")
    def plan_code(self) -> builtins.str:
        """
        Plan code
        """
        return pulumi.get(self, "plan_code")

    @property
    @pulumi.getter(name="pricingMode")
    def pricing_mode(self) -> builtins.str:
        """
        Pricing model identifier
        """
        return pulumi.get(self, "pricing_mode")

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> Optional[builtins.str]:
        """
        Catalog name
        """
        return pulumi.get(self, "catalog_name")

    @property
    @pulumi.getter
    def configurations(self) -> Optional[Sequence['outputs.VrackPlanOptionConfiguration']]:
        """
        Representation of a configuration item for personalizing product
        """
        return pulumi.get(self, "configurations")


@pulumi.output_type
class VrackPlanOptionConfiguration(dict):
    def __init__(__self__, *,
                 label: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str label: Identifier of the resource
        :param builtins.str value: Path to the resource in API.OVH.COM
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def label(self) -> builtins.str:
        """
        Identifier of the resource
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Path to the resource in API.OVH.COM
        """
        return pulumi.get(self, "value")


