# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OVHcloudConnectArgs', 'OVHcloudConnect']

@pulumi.input_type
class OVHcloudConnectArgs:
    def __init__(__self__, *,
                 ovh_cloud_connect: pulumi.Input[builtins.str],
                 service_name: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a OVHcloudConnect resource.
        :param pulumi.Input[builtins.str] ovh_cloud_connect: Your OVH Cloud Connect service name.
        :param pulumi.Input[builtins.str] service_name: The internal name of your vrack
        """
        pulumi.set(__self__, "ovh_cloud_connect", ovh_cloud_connect)
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="ovhCloudConnect")
    def ovh_cloud_connect(self) -> pulumi.Input[builtins.str]:
        """
        Your OVH Cloud Connect service name.
        """
        return pulumi.get(self, "ovh_cloud_connect")

    @ovh_cloud_connect.setter
    def ovh_cloud_connect(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ovh_cloud_connect", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[builtins.str]:
        """
        The internal name of your vrack
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class _OVHcloudConnectState:
    def __init__(__self__, *,
                 ovh_cloud_connect: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering OVHcloudConnect resources.
        :param pulumi.Input[builtins.str] ovh_cloud_connect: Your OVH Cloud Connect service name.
        :param pulumi.Input[builtins.str] service_name: The internal name of your vrack
        """
        if ovh_cloud_connect is not None:
            pulumi.set(__self__, "ovh_cloud_connect", ovh_cloud_connect)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="ovhCloudConnect")
    def ovh_cloud_connect(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Your OVH Cloud Connect service name.
        """
        return pulumi.get(self, "ovh_cloud_connect")

    @ovh_cloud_connect.setter
    def ovh_cloud_connect(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ovh_cloud_connect", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The internal name of your vrack
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)


@pulumi.type_token("ovh:Vrack/oVHcloudConnect:OVHcloudConnect")
class OVHcloudConnect(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ovh_cloud_connect: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Attach an OVH Cloud Connect to the vrack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        vrack_ovhcloudconnect = ovh.vrack.OVHcloudConnect("vrack_ovhcloudconnect",
            service_name="<vRack service name>",
            ovh_cloud_connect="<OVH Cloud Connect service name>")
        ```

        ## Import

        Attachment of an OVH Cloud Connect and a vRack can be imported using the `service_name` (vRack identifier) and the `ovh_cloud_connect` (OVH Cloud Connect service name), separated by "/" E.g.,

        bash

        ```sh
        $ pulumi import ovh:Vrack/oVHcloudConnect:OVHcloudConnect myattach "<service_name>/<OVH Cloud Connect service name>"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] ovh_cloud_connect: Your OVH Cloud Connect service name.
        :param pulumi.Input[builtins.str] service_name: The internal name of your vrack
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OVHcloudConnectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Attach an OVH Cloud Connect to the vrack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ovh as ovh

        vrack_ovhcloudconnect = ovh.vrack.OVHcloudConnect("vrack_ovhcloudconnect",
            service_name="<vRack service name>",
            ovh_cloud_connect="<OVH Cloud Connect service name>")
        ```

        ## Import

        Attachment of an OVH Cloud Connect and a vRack can be imported using the `service_name` (vRack identifier) and the `ovh_cloud_connect` (OVH Cloud Connect service name), separated by "/" E.g.,

        bash

        ```sh
        $ pulumi import ovh:Vrack/oVHcloudConnect:OVHcloudConnect myattach "<service_name>/<OVH Cloud Connect service name>"
        ```

        :param str resource_name: The name of the resource.
        :param OVHcloudConnectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OVHcloudConnectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ovh_cloud_connect: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OVHcloudConnectArgs.__new__(OVHcloudConnectArgs)

            if ovh_cloud_connect is None and not opts.urn:
                raise TypeError("Missing required property 'ovh_cloud_connect'")
            __props__.__dict__["ovh_cloud_connect"] = ovh_cloud_connect
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
        super(OVHcloudConnect, __self__).__init__(
            'ovh:Vrack/oVHcloudConnect:OVHcloudConnect',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ovh_cloud_connect: Optional[pulumi.Input[builtins.str]] = None,
            service_name: Optional[pulumi.Input[builtins.str]] = None) -> 'OVHcloudConnect':
        """
        Get an existing OVHcloudConnect resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] ovh_cloud_connect: Your OVH Cloud Connect service name.
        :param pulumi.Input[builtins.str] service_name: The internal name of your vrack
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OVHcloudConnectState.__new__(_OVHcloudConnectState)

        __props__.__dict__["ovh_cloud_connect"] = ovh_cloud_connect
        __props__.__dict__["service_name"] = service_name
        return OVHcloudConnect(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="ovhCloudConnect")
    def ovh_cloud_connect(self) -> pulumi.Output[builtins.str]:
        """
        Your OVH Cloud Connect service name.
        """
        return pulumi.get(self, "ovh_cloud_connect")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[builtins.str]:
        """
        The internal name of your vrack
        """
        return pulumi.get(self, "service_name")

