# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetFwRuleV2Result',
    'AwaitableGetFwRuleV2Result',
    'get_fw_rule_v2',
    'get_fw_rule_v2_output',
]

@pulumi.output_type
class GetFwRuleV2Result:
    """
    A collection of values returned by getFwRuleV2.
    """
    def __init__(__self__, action=None, description=None, destination_ip_address=None, destination_port=None, enabled=None, firewall_policy_ids=None, id=None, ip_version=None, name=None, project_id=None, protocol=None, region=None, rule_id=None, shared=None, source_ip_address=None, source_port=None, tenant_id=None):
        if action and not isinstance(action, str):
            raise TypeError("Expected argument 'action' to be a str")
        pulumi.set(__self__, "action", action)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if destination_ip_address and not isinstance(destination_ip_address, str):
            raise TypeError("Expected argument 'destination_ip_address' to be a str")
        pulumi.set(__self__, "destination_ip_address", destination_ip_address)
        if destination_port and not isinstance(destination_port, str):
            raise TypeError("Expected argument 'destination_port' to be a str")
        pulumi.set(__self__, "destination_port", destination_port)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if firewall_policy_ids and not isinstance(firewall_policy_ids, list):
            raise TypeError("Expected argument 'firewall_policy_ids' to be a list")
        pulumi.set(__self__, "firewall_policy_ids", firewall_policy_ids)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_version and not isinstance(ip_version, int):
            raise TypeError("Expected argument 'ip_version' to be a int")
        pulumi.set(__self__, "ip_version", ip_version)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if rule_id and not isinstance(rule_id, str):
            raise TypeError("Expected argument 'rule_id' to be a str")
        pulumi.set(__self__, "rule_id", rule_id)
        if shared and not isinstance(shared, bool):
            raise TypeError("Expected argument 'shared' to be a bool")
        pulumi.set(__self__, "shared", shared)
        if source_ip_address and not isinstance(source_ip_address, str):
            raise TypeError("Expected argument 'source_ip_address' to be a str")
        pulumi.set(__self__, "source_ip_address", source_ip_address)
        if source_port and not isinstance(source_port, str):
            raise TypeError("Expected argument 'source_port' to be a str")
        pulumi.set(__self__, "source_port", source_port)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationIpAddress")
    def destination_ip_address(self) -> Optional[str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "destination_ip_address")

    @property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "destination_port")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="firewallPolicyIds")
    def firewall_policy_ids(self) -> Sequence[str]:
        """
        The ID of the firewall policy the rule belongs to.
        """
        return pulumi.get(self, "firewall_policy_ids")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[int]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter
    def shared(self) -> bool:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "shared")

    @property
    @pulumi.getter(name="sourceIpAddress")
    def source_ip_address(self) -> Optional[str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "source_ip_address")

    @property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "source_port")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetFwRuleV2Result(GetFwRuleV2Result):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFwRuleV2Result(
            action=self.action,
            description=self.description,
            destination_ip_address=self.destination_ip_address,
            destination_port=self.destination_port,
            enabled=self.enabled,
            firewall_policy_ids=self.firewall_policy_ids,
            id=self.id,
            ip_version=self.ip_version,
            name=self.name,
            project_id=self.project_id,
            protocol=self.protocol,
            region=self.region,
            rule_id=self.rule_id,
            shared=self.shared,
            source_ip_address=self.source_ip_address,
            source_port=self.source_port,
            tenant_id=self.tenant_id)


def get_fw_rule_v2(action: Optional[str] = None,
                   description: Optional[str] = None,
                   destination_ip_address: Optional[str] = None,
                   destination_port: Optional[str] = None,
                   enabled: Optional[bool] = None,
                   firewall_policy_ids: Optional[Sequence[str]] = None,
                   ip_version: Optional[int] = None,
                   name: Optional[str] = None,
                   project_id: Optional[str] = None,
                   protocol: Optional[str] = None,
                   region: Optional[str] = None,
                   rule_id: Optional[str] = None,
                   shared: Optional[bool] = None,
                   source_ip_address: Optional[str] = None,
                   source_port: Optional[str] = None,
                   tenant_id: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFwRuleV2Result:
    """
    Use this data source to get information of an available OpenStack firewall rule v2.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    rule = openstack.get_fw_rule_v2(name="tf_test_rule")
    ```


    :param str action: Action to be taken when the firewall rule matches.
    :param str description: The description of the firewall rule.
    :param str destination_ip_address: The destination IP address on which the
           firewall rule operates.
    :param str destination_port: The destination port on which the firewall
           rule operates.
    :param bool enabled: Enabled status for the firewall rule.
    :param Sequence[str] firewall_policy_ids: The ID of the firewall policy the rule belongs to.
    :param int ip_version: IP version, either 4 (default) or 6.
    :param str name: The name of the firewall rule.
    :param str project_id: This argument conflicts and is interchangeable
           with `tenant_id`. The owner of the firewall rule.
    :param str protocol: The protocol type on which the firewall rule operates.
    :param str region: The region in which to obtain the V2 Neutron client.
           A Neutron client is needed to retrieve firewall policy ids. If omitted, the
           `region` argument of the provider is used.
    :param str rule_id: The ID of the firewall rule.
    :param bool shared: The sharing status of the firewall policy.
    :param str source_ip_address: The source IP address on which the firewall
           rule operates.
    :param str source_port: The source port on which the firewall
           rule operates.
    :param str tenant_id: This argument conflicts and is interchangeable
           with `project_id`. The owner of the firewall rule.
    """
    __args__ = dict()
    __args__['action'] = action
    __args__['description'] = description
    __args__['destinationIpAddress'] = destination_ip_address
    __args__['destinationPort'] = destination_port
    __args__['enabled'] = enabled
    __args__['firewallPolicyIds'] = firewall_policy_ids
    __args__['ipVersion'] = ip_version
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['protocol'] = protocol
    __args__['region'] = region
    __args__['ruleId'] = rule_id
    __args__['shared'] = shared
    __args__['sourceIpAddress'] = source_ip_address
    __args__['sourcePort'] = source_port
    __args__['tenantId'] = tenant_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('openstack:index/getFwRuleV2:getFwRuleV2', __args__, opts=opts, typ=GetFwRuleV2Result).value

    return AwaitableGetFwRuleV2Result(
        action=pulumi.get(__ret__, 'action'),
        description=pulumi.get(__ret__, 'description'),
        destination_ip_address=pulumi.get(__ret__, 'destination_ip_address'),
        destination_port=pulumi.get(__ret__, 'destination_port'),
        enabled=pulumi.get(__ret__, 'enabled'),
        firewall_policy_ids=pulumi.get(__ret__, 'firewall_policy_ids'),
        id=pulumi.get(__ret__, 'id'),
        ip_version=pulumi.get(__ret__, 'ip_version'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        protocol=pulumi.get(__ret__, 'protocol'),
        region=pulumi.get(__ret__, 'region'),
        rule_id=pulumi.get(__ret__, 'rule_id'),
        shared=pulumi.get(__ret__, 'shared'),
        source_ip_address=pulumi.get(__ret__, 'source_ip_address'),
        source_port=pulumi.get(__ret__, 'source_port'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))


@_utilities.lift_output_func(get_fw_rule_v2)
def get_fw_rule_v2_output(action: Optional[pulumi.Input[Optional[str]]] = None,
                          description: Optional[pulumi.Input[Optional[str]]] = None,
                          destination_ip_address: Optional[pulumi.Input[Optional[str]]] = None,
                          destination_port: Optional[pulumi.Input[Optional[str]]] = None,
                          enabled: Optional[pulumi.Input[Optional[bool]]] = None,
                          firewall_policy_ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                          ip_version: Optional[pulumi.Input[Optional[int]]] = None,
                          name: Optional[pulumi.Input[Optional[str]]] = None,
                          project_id: Optional[pulumi.Input[Optional[str]]] = None,
                          protocol: Optional[pulumi.Input[Optional[str]]] = None,
                          region: Optional[pulumi.Input[Optional[str]]] = None,
                          rule_id: Optional[pulumi.Input[Optional[str]]] = None,
                          shared: Optional[pulumi.Input[Optional[bool]]] = None,
                          source_ip_address: Optional[pulumi.Input[Optional[str]]] = None,
                          source_port: Optional[pulumi.Input[Optional[str]]] = None,
                          tenant_id: Optional[pulumi.Input[Optional[str]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFwRuleV2Result]:
    """
    Use this data source to get information of an available OpenStack firewall rule v2.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    rule = openstack.get_fw_rule_v2(name="tf_test_rule")
    ```


    :param str action: Action to be taken when the firewall rule matches.
    :param str description: The description of the firewall rule.
    :param str destination_ip_address: The destination IP address on which the
           firewall rule operates.
    :param str destination_port: The destination port on which the firewall
           rule operates.
    :param bool enabled: Enabled status for the firewall rule.
    :param Sequence[str] firewall_policy_ids: The ID of the firewall policy the rule belongs to.
    :param int ip_version: IP version, either 4 (default) or 6.
    :param str name: The name of the firewall rule.
    :param str project_id: This argument conflicts and is interchangeable
           with `tenant_id`. The owner of the firewall rule.
    :param str protocol: The protocol type on which the firewall rule operates.
    :param str region: The region in which to obtain the V2 Neutron client.
           A Neutron client is needed to retrieve firewall policy ids. If omitted, the
           `region` argument of the provider is used.
    :param str rule_id: The ID of the firewall rule.
    :param bool shared: The sharing status of the firewall policy.
    :param str source_ip_address: The source IP address on which the firewall
           rule operates.
    :param str source_port: The source port on which the firewall
           rule operates.
    :param str tenant_id: This argument conflicts and is interchangeable
           with `project_id`. The owner of the firewall rule.
    """
    ...
