# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 allow_reauth: Optional[pulumi.Input[bool]] = None,
                 application_credential_id: Optional[pulumi.Input[str]] = None,
                 application_credential_name: Optional[pulumi.Input[str]] = None,
                 application_credential_secret: Optional[pulumi.Input[str]] = None,
                 auth_url: Optional[pulumi.Input[str]] = None,
                 cacert_file: Optional[pulumi.Input[str]] = None,
                 cert: Optional[pulumi.Input[str]] = None,
                 cloud: Optional[pulumi.Input[str]] = None,
                 default_domain: Optional[pulumi.Input[str]] = None,
                 delayed_auth: Optional[pulumi.Input[bool]] = None,
                 disable_no_cache_header: Optional[pulumi.Input[bool]] = None,
                 domain_id: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 enable_logging: Optional[pulumi.Input[bool]] = None,
                 endpoint_overrides: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 insecure: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 project_domain_id: Optional[pulumi.Input[str]] = None,
                 project_domain_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 swauth: Optional[pulumi.Input[bool]] = None,
                 system_scope: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 tenant_name: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 user_domain_id: Optional[pulumi.Input[str]] = None,
                 user_domain_name: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[bool] allow_reauth: If set to `false`, OpenStack authorization won't be perfomed automatically, if the initial auth token get expired.
               Defaults to `true`
        :param pulumi.Input[str] application_credential_id: Application Credential ID to login with.
        :param pulumi.Input[str] application_credential_name: Application Credential name to login with.
        :param pulumi.Input[str] application_credential_secret: Application Credential secret to login with.
        :param pulumi.Input[str] auth_url: The Identity authentication URL.
        :param pulumi.Input[str] cacert_file: A Custom CA certificate.
        :param pulumi.Input[str] cert: A client certificate to authenticate with.
        :param pulumi.Input[str] cloud: An entry in a `clouds.yaml` file to use.
        :param pulumi.Input[str] default_domain: The name of the Domain ID to scope to if no other domain is specified. Defaults to `default` (Identity v3).
        :param pulumi.Input[bool] delayed_auth: If set to `false`, OpenStack authorization will be perfomed, every time the service provider client is called. Defaults
               to `true`.
        :param pulumi.Input[bool] disable_no_cache_header: If set to `true`, the HTTP `Cache-Control: no-cache` header will not be added by default to all API requests.
        :param pulumi.Input[str] domain_id: The ID of the Domain to scope to (Identity v3).
        :param pulumi.Input[str] domain_name: The name of the Domain to scope to (Identity v3).
        :param pulumi.Input[bool] enable_logging: Outputs very verbose logs with all calls made to and responses from OpenStack
        :param pulumi.Input[Mapping[str, Any]] endpoint_overrides: A map of services with an endpoint to override what was from the Keystone catalog
        :param pulumi.Input[bool] insecure: Trust self-signed certificates.
        :param pulumi.Input[str] key: A client private key to authenticate with.
        :param pulumi.Input[int] max_retries: How many times HTTP connection should be retried until giving up.
        :param pulumi.Input[str] password: Password to login with.
        :param pulumi.Input[str] project_domain_id: The ID of the domain where the proejct resides (Identity v3).
        :param pulumi.Input[str] project_domain_name: The name of the domain where the project resides (Identity v3).
        :param pulumi.Input[str] region: The OpenStack region to connect to.
        :param pulumi.Input[bool] swauth: Use Swift's authentication system instead of Keystone. Only used for interaction with Swift.
        :param pulumi.Input[bool] system_scope: If set to `true`, system scoped authorization will be enabled. Defaults to `false` (Identity v3).
        :param pulumi.Input[str] tenant_id: The ID of the Tenant (Identity v2) or Project (Identity v3) to login with.
        :param pulumi.Input[str] tenant_name: The name of the Tenant (Identity v2) or Project (Identity v3) to login with.
        :param pulumi.Input[str] token: Authentication token to use as an alternative to username/password.
        :param pulumi.Input[str] user_domain_id: The ID of the domain where the user resides (Identity v3).
        :param pulumi.Input[str] user_domain_name: The name of the domain where the user resides (Identity v3).
        :param pulumi.Input[str] user_id: User ID to login with.
        :param pulumi.Input[str] user_name: Username to login with.
        """
        if allow_reauth is None:
            allow_reauth = _utilities.get_env_bool('OS_ALLOW_REAUTH')
        if allow_reauth is not None:
            pulumi.set(__self__, "allow_reauth", allow_reauth)
        if application_credential_id is not None:
            pulumi.set(__self__, "application_credential_id", application_credential_id)
        if application_credential_name is not None:
            pulumi.set(__self__, "application_credential_name", application_credential_name)
        if application_credential_secret is not None:
            pulumi.set(__self__, "application_credential_secret", application_credential_secret)
        if auth_url is not None:
            pulumi.set(__self__, "auth_url", auth_url)
        if cacert_file is not None:
            pulumi.set(__self__, "cacert_file", cacert_file)
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if cloud is None:
            cloud = _utilities.get_env('OS_CLOUD')
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if default_domain is not None:
            pulumi.set(__self__, "default_domain", default_domain)
        if delayed_auth is None:
            delayed_auth = _utilities.get_env_bool('OS_DELAYED_AUTH')
        if delayed_auth is not None:
            pulumi.set(__self__, "delayed_auth", delayed_auth)
        if disable_no_cache_header is not None:
            pulumi.set(__self__, "disable_no_cache_header", disable_no_cache_header)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if enable_logging is not None:
            pulumi.set(__self__, "enable_logging", enable_logging)
        if endpoint_overrides is not None:
            pulumi.set(__self__, "endpoint_overrides", endpoint_overrides)
        if endpoint_type is None:
            endpoint_type = _utilities.get_env('OS_ENDPOINT_TYPE')
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if insecure is None:
            insecure = _utilities.get_env_bool('OS_INSECURE')
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if project_domain_id is not None:
            pulumi.set(__self__, "project_domain_id", project_domain_id)
        if project_domain_name is not None:
            pulumi.set(__self__, "project_domain_name", project_domain_name)
        if region is None:
            region = _utilities.get_env('OS_REGION_NAME')
        if region is not None:
            pulumi.set(__self__, "region", region)
        if swauth is None:
            swauth = _utilities.get_env_bool('OS_SWAUTH')
        if swauth is not None:
            pulumi.set(__self__, "swauth", swauth)
        if system_scope is not None:
            pulumi.set(__self__, "system_scope", system_scope)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if tenant_name is not None:
            pulumi.set(__self__, "tenant_name", tenant_name)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if user_domain_id is not None:
            pulumi.set(__self__, "user_domain_id", user_domain_id)
        if user_domain_name is not None:
            pulumi.set(__self__, "user_domain_name", user_domain_name)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="allowReauth")
    def allow_reauth(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `false`, OpenStack authorization won't be perfomed automatically, if the initial auth token get expired.
        Defaults to `true`
        """
        return pulumi.get(self, "allow_reauth")

    @allow_reauth.setter
    def allow_reauth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_reauth", value)

    @property
    @pulumi.getter(name="applicationCredentialId")
    def application_credential_id(self) -> Optional[pulumi.Input[str]]:
        """
        Application Credential ID to login with.
        """
        return pulumi.get(self, "application_credential_id")

    @application_credential_id.setter
    def application_credential_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_credential_id", value)

    @property
    @pulumi.getter(name="applicationCredentialName")
    def application_credential_name(self) -> Optional[pulumi.Input[str]]:
        """
        Application Credential name to login with.
        """
        return pulumi.get(self, "application_credential_name")

    @application_credential_name.setter
    def application_credential_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_credential_name", value)

    @property
    @pulumi.getter(name="applicationCredentialSecret")
    def application_credential_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Application Credential secret to login with.
        """
        return pulumi.get(self, "application_credential_secret")

    @application_credential_secret.setter
    def application_credential_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_credential_secret", value)

    @property
    @pulumi.getter(name="authUrl")
    def auth_url(self) -> Optional[pulumi.Input[str]]:
        """
        The Identity authentication URL.
        """
        return pulumi.get(self, "auth_url")

    @auth_url.setter
    def auth_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_url", value)

    @property
    @pulumi.getter(name="cacertFile")
    def cacert_file(self) -> Optional[pulumi.Input[str]]:
        """
        A Custom CA certificate.
        """
        return pulumi.get(self, "cacert_file")

    @cacert_file.setter
    def cacert_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cacert_file", value)

    @property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input[str]]:
        """
        A client certificate to authenticate with.
        """
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert", value)

    @property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[str]]:
        """
        An entry in a `clouds.yaml` file to use.
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud", value)

    @property
    @pulumi.getter(name="defaultDomain")
    def default_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Domain ID to scope to if no other domain is specified. Defaults to `default` (Identity v3).
        """
        return pulumi.get(self, "default_domain")

    @default_domain.setter
    def default_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_domain", value)

    @property
    @pulumi.getter(name="delayedAuth")
    def delayed_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `false`, OpenStack authorization will be perfomed, every time the service provider client is called. Defaults
        to `true`.
        """
        return pulumi.get(self, "delayed_auth")

    @delayed_auth.setter
    def delayed_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delayed_auth", value)

    @property
    @pulumi.getter(name="disableNoCacheHeader")
    def disable_no_cache_header(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `true`, the HTTP `Cache-Control: no-cache` header will not be added by default to all API requests.
        """
        return pulumi.get(self, "disable_no_cache_header")

    @disable_no_cache_header.setter
    def disable_no_cache_header(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_no_cache_header", value)

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Domain to scope to (Identity v3).
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_id", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Domain to scope to (Identity v3).
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> Optional[pulumi.Input[bool]]:
        """
        Outputs very verbose logs with all calls made to and responses from OpenStack
        """
        return pulumi.get(self, "enable_logging")

    @enable_logging.setter
    def enable_logging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_logging", value)

    @property
    @pulumi.getter(name="endpointOverrides")
    def endpoint_overrides(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A map of services with an endpoint to override what was from the Keystone catalog
        """
        return pulumi.get(self, "endpoint_overrides")

    @endpoint_overrides.setter
    def endpoint_overrides(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "endpoint_overrides", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter
    def insecure(self) -> Optional[pulumi.Input[bool]]:
        """
        Trust self-signed certificates.
        """
        return pulumi.get(self, "insecure")

    @insecure.setter
    def insecure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "insecure", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        A client private key to authenticate with.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[int]]:
        """
        How many times HTTP connection should be retried until giving up.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password to login with.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="projectDomainId")
    def project_domain_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the domain where the proejct resides (Identity v3).
        """
        return pulumi.get(self, "project_domain_id")

    @project_domain_id.setter
    def project_domain_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_domain_id", value)

    @property
    @pulumi.getter(name="projectDomainName")
    def project_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the domain where the project resides (Identity v3).
        """
        return pulumi.get(self, "project_domain_name")

    @project_domain_name.setter
    def project_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_domain_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The OpenStack region to connect to.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def swauth(self) -> Optional[pulumi.Input[bool]]:
        """
        Use Swift's authentication system instead of Keystone. Only used for interaction with Swift.
        """
        return pulumi.get(self, "swauth")

    @swauth.setter
    def swauth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "swauth", value)

    @property
    @pulumi.getter(name="systemScope")
    def system_scope(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `true`, system scoped authorization will be enabled. Defaults to `false` (Identity v3).
        """
        return pulumi.get(self, "system_scope")

    @system_scope.setter
    def system_scope(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "system_scope", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Tenant (Identity v2) or Project (Identity v3) to login with.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="tenantName")
    def tenant_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Tenant (Identity v2) or Project (Identity v3) to login with.
        """
        return pulumi.get(self, "tenant_name")

    @tenant_name.setter
    def tenant_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_name", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        Authentication token to use as an alternative to username/password.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter(name="userDomainId")
    def user_domain_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the domain where the user resides (Identity v3).
        """
        return pulumi.get(self, "user_domain_id")

    @user_domain_id.setter
    def user_domain_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_domain_id", value)

    @property
    @pulumi.getter(name="userDomainName")
    def user_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the domain where the user resides (Identity v3).
        """
        return pulumi.get(self, "user_domain_name")

    @user_domain_name.setter
    def user_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_domain_name", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        User ID to login with.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Username to login with.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_reauth: Optional[pulumi.Input[bool]] = None,
                 application_credential_id: Optional[pulumi.Input[str]] = None,
                 application_credential_name: Optional[pulumi.Input[str]] = None,
                 application_credential_secret: Optional[pulumi.Input[str]] = None,
                 auth_url: Optional[pulumi.Input[str]] = None,
                 cacert_file: Optional[pulumi.Input[str]] = None,
                 cert: Optional[pulumi.Input[str]] = None,
                 cloud: Optional[pulumi.Input[str]] = None,
                 default_domain: Optional[pulumi.Input[str]] = None,
                 delayed_auth: Optional[pulumi.Input[bool]] = None,
                 disable_no_cache_header: Optional[pulumi.Input[bool]] = None,
                 domain_id: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 enable_logging: Optional[pulumi.Input[bool]] = None,
                 endpoint_overrides: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 insecure: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 project_domain_id: Optional[pulumi.Input[str]] = None,
                 project_domain_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 swauth: Optional[pulumi.Input[bool]] = None,
                 system_scope: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 tenant_name: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 user_domain_id: Optional[pulumi.Input[str]] = None,
                 user_domain_name: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The provider type for the openstack package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_reauth: If set to `false`, OpenStack authorization won't be perfomed automatically, if the initial auth token get expired.
               Defaults to `true`
        :param pulumi.Input[str] application_credential_id: Application Credential ID to login with.
        :param pulumi.Input[str] application_credential_name: Application Credential name to login with.
        :param pulumi.Input[str] application_credential_secret: Application Credential secret to login with.
        :param pulumi.Input[str] auth_url: The Identity authentication URL.
        :param pulumi.Input[str] cacert_file: A Custom CA certificate.
        :param pulumi.Input[str] cert: A client certificate to authenticate with.
        :param pulumi.Input[str] cloud: An entry in a `clouds.yaml` file to use.
        :param pulumi.Input[str] default_domain: The name of the Domain ID to scope to if no other domain is specified. Defaults to `default` (Identity v3).
        :param pulumi.Input[bool] delayed_auth: If set to `false`, OpenStack authorization will be perfomed, every time the service provider client is called. Defaults
               to `true`.
        :param pulumi.Input[bool] disable_no_cache_header: If set to `true`, the HTTP `Cache-Control: no-cache` header will not be added by default to all API requests.
        :param pulumi.Input[str] domain_id: The ID of the Domain to scope to (Identity v3).
        :param pulumi.Input[str] domain_name: The name of the Domain to scope to (Identity v3).
        :param pulumi.Input[bool] enable_logging: Outputs very verbose logs with all calls made to and responses from OpenStack
        :param pulumi.Input[Mapping[str, Any]] endpoint_overrides: A map of services with an endpoint to override what was from the Keystone catalog
        :param pulumi.Input[bool] insecure: Trust self-signed certificates.
        :param pulumi.Input[str] key: A client private key to authenticate with.
        :param pulumi.Input[int] max_retries: How many times HTTP connection should be retried until giving up.
        :param pulumi.Input[str] password: Password to login with.
        :param pulumi.Input[str] project_domain_id: The ID of the domain where the proejct resides (Identity v3).
        :param pulumi.Input[str] project_domain_name: The name of the domain where the project resides (Identity v3).
        :param pulumi.Input[str] region: The OpenStack region to connect to.
        :param pulumi.Input[bool] swauth: Use Swift's authentication system instead of Keystone. Only used for interaction with Swift.
        :param pulumi.Input[bool] system_scope: If set to `true`, system scoped authorization will be enabled. Defaults to `false` (Identity v3).
        :param pulumi.Input[str] tenant_id: The ID of the Tenant (Identity v2) or Project (Identity v3) to login with.
        :param pulumi.Input[str] tenant_name: The name of the Tenant (Identity v2) or Project (Identity v3) to login with.
        :param pulumi.Input[str] token: Authentication token to use as an alternative to username/password.
        :param pulumi.Input[str] user_domain_id: The ID of the domain where the user resides (Identity v3).
        :param pulumi.Input[str] user_domain_name: The name of the domain where the user resides (Identity v3).
        :param pulumi.Input[str] user_id: User ID to login with.
        :param pulumi.Input[str] user_name: Username to login with.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the openstack package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_reauth: Optional[pulumi.Input[bool]] = None,
                 application_credential_id: Optional[pulumi.Input[str]] = None,
                 application_credential_name: Optional[pulumi.Input[str]] = None,
                 application_credential_secret: Optional[pulumi.Input[str]] = None,
                 auth_url: Optional[pulumi.Input[str]] = None,
                 cacert_file: Optional[pulumi.Input[str]] = None,
                 cert: Optional[pulumi.Input[str]] = None,
                 cloud: Optional[pulumi.Input[str]] = None,
                 default_domain: Optional[pulumi.Input[str]] = None,
                 delayed_auth: Optional[pulumi.Input[bool]] = None,
                 disable_no_cache_header: Optional[pulumi.Input[bool]] = None,
                 domain_id: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 enable_logging: Optional[pulumi.Input[bool]] = None,
                 endpoint_overrides: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 endpoint_type: Optional[pulumi.Input[str]] = None,
                 insecure: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 project_domain_id: Optional[pulumi.Input[str]] = None,
                 project_domain_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 swauth: Optional[pulumi.Input[bool]] = None,
                 system_scope: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 tenant_name: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 user_domain_id: Optional[pulumi.Input[str]] = None,
                 user_domain_name: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            if allow_reauth is None:
                allow_reauth = _utilities.get_env_bool('OS_ALLOW_REAUTH')
            __props__.__dict__["allow_reauth"] = pulumi.Output.from_input(allow_reauth).apply(pulumi.runtime.to_json) if allow_reauth is not None else None
            __props__.__dict__["application_credential_id"] = application_credential_id
            __props__.__dict__["application_credential_name"] = application_credential_name
            __props__.__dict__["application_credential_secret"] = application_credential_secret
            __props__.__dict__["auth_url"] = auth_url
            __props__.__dict__["cacert_file"] = cacert_file
            __props__.__dict__["cert"] = cert
            if cloud is None:
                cloud = _utilities.get_env('OS_CLOUD')
            __props__.__dict__["cloud"] = cloud
            __props__.__dict__["default_domain"] = default_domain
            if delayed_auth is None:
                delayed_auth = _utilities.get_env_bool('OS_DELAYED_AUTH')
            __props__.__dict__["delayed_auth"] = pulumi.Output.from_input(delayed_auth).apply(pulumi.runtime.to_json) if delayed_auth is not None else None
            __props__.__dict__["disable_no_cache_header"] = pulumi.Output.from_input(disable_no_cache_header).apply(pulumi.runtime.to_json) if disable_no_cache_header is not None else None
            __props__.__dict__["domain_id"] = domain_id
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["enable_logging"] = pulumi.Output.from_input(enable_logging).apply(pulumi.runtime.to_json) if enable_logging is not None else None
            __props__.__dict__["endpoint_overrides"] = pulumi.Output.from_input(endpoint_overrides).apply(pulumi.runtime.to_json) if endpoint_overrides is not None else None
            if endpoint_type is None:
                endpoint_type = _utilities.get_env('OS_ENDPOINT_TYPE')
            __props__.__dict__["endpoint_type"] = endpoint_type
            if insecure is None:
                insecure = _utilities.get_env_bool('OS_INSECURE')
            __props__.__dict__["insecure"] = pulumi.Output.from_input(insecure).apply(pulumi.runtime.to_json) if insecure is not None else None
            __props__.__dict__["key"] = key
            __props__.__dict__["max_retries"] = pulumi.Output.from_input(max_retries).apply(pulumi.runtime.to_json) if max_retries is not None else None
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["project_domain_id"] = project_domain_id
            __props__.__dict__["project_domain_name"] = project_domain_name
            if region is None:
                region = _utilities.get_env('OS_REGION_NAME')
            __props__.__dict__["region"] = region
            if swauth is None:
                swauth = _utilities.get_env_bool('OS_SWAUTH')
            __props__.__dict__["swauth"] = pulumi.Output.from_input(swauth).apply(pulumi.runtime.to_json) if swauth is not None else None
            __props__.__dict__["system_scope"] = pulumi.Output.from_input(system_scope).apply(pulumi.runtime.to_json) if system_scope is not None else None
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["tenant_name"] = tenant_name
            __props__.__dict__["token"] = token
            __props__.__dict__["user_domain_id"] = user_domain_id
            __props__.__dict__["user_domain_name"] = user_domain_name
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["user_name"] = user_name
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'openstack',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter(name="applicationCredentialId")
    def application_credential_id(self) -> pulumi.Output[Optional[str]]:
        """
        Application Credential ID to login with.
        """
        return pulumi.get(self, "application_credential_id")

    @property
    @pulumi.getter(name="applicationCredentialName")
    def application_credential_name(self) -> pulumi.Output[Optional[str]]:
        """
        Application Credential name to login with.
        """
        return pulumi.get(self, "application_credential_name")

    @property
    @pulumi.getter(name="applicationCredentialSecret")
    def application_credential_secret(self) -> pulumi.Output[Optional[str]]:
        """
        Application Credential secret to login with.
        """
        return pulumi.get(self, "application_credential_secret")

    @property
    @pulumi.getter(name="authUrl")
    def auth_url(self) -> pulumi.Output[Optional[str]]:
        """
        The Identity authentication URL.
        """
        return pulumi.get(self, "auth_url")

    @property
    @pulumi.getter(name="cacertFile")
    def cacert_file(self) -> pulumi.Output[Optional[str]]:
        """
        A Custom CA certificate.
        """
        return pulumi.get(self, "cacert_file")

    @property
    @pulumi.getter
    def cert(self) -> pulumi.Output[Optional[str]]:
        """
        A client certificate to authenticate with.
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter
    def cloud(self) -> pulumi.Output[Optional[str]]:
        """
        An entry in a `clouds.yaml` file to use.
        """
        return pulumi.get(self, "cloud")

    @property
    @pulumi.getter(name="defaultDomain")
    def default_domain(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the Domain ID to scope to if no other domain is specified. Defaults to `default` (Identity v3).
        """
        return pulumi.get(self, "default_domain")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the Domain to scope to (Identity v3).
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the Domain to scope to (Identity v3).
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[Optional[str]]:
        """
        A client private key to authenticate with.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        Password to login with.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="projectDomainId")
    def project_domain_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the domain where the proejct resides (Identity v3).
        """
        return pulumi.get(self, "project_domain_id")

    @property
    @pulumi.getter(name="projectDomainName")
    def project_domain_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the domain where the project resides (Identity v3).
        """
        return pulumi.get(self, "project_domain_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        The OpenStack region to connect to.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the Tenant (Identity v2) or Project (Identity v3) to login with.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="tenantName")
    def tenant_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the Tenant (Identity v2) or Project (Identity v3) to login with.
        """
        return pulumi.get(self, "tenant_name")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional[str]]:
        """
        Authentication token to use as an alternative to username/password.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="userDomainId")
    def user_domain_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the domain where the user resides (Identity v3).
        """
        return pulumi.get(self, "user_domain_id")

    @property
    @pulumi.getter(name="userDomainName")
    def user_domain_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the domain where the user resides (Identity v3).
        """
        return pulumi.get(self, "user_domain_name")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[Optional[str]]:
        """
        User ID to login with.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[Optional[str]]:
        """
        Username to login with.
        """
        return pulumi.get(self, "user_name")

