# Copyright 2024 Atlan Pte. Ltd.
# isort: skip_file
import lazy_loader as lazy

__PYATLAN_ASSETS__ = {
    "core": [
        "Referenceable",
        "Asset",
        "Process",
        "AtlasGlossaryCategory",
        "AccessControl",
        "AuthPolicy",
        "StakeholderTitle",
        "Catalog",
        "Namespace",
        "Flow",
        "AtlasGlossary",
        "AtlasGlossaryTerm",
        "FlowDatasetOperation",
        "BIProcess",
        "ColumnProcess",
        "Persona",
        "App",
        "Airflow",
        "ADF",
        "BI",
        "FlowDataset",
        "NoSQL",
        "Dbt",
        "Fivetran",
        "DataContract",
        "DataQuality",
        "AI",
        "Resource",
        "FlowField",
        "DataMesh",
        "SQL",
        "Matillion",
        "Model",
        "Spark",
        "Tag",
        "SchemaRegistry",
        "Folder",
        "FlowReusableUnit",
        "FlowFieldOperation",
        "FlowControlOperation",
        "Stakeholder",
        "ApplicationField",
        "Application",
        "AirflowDag",
        "AirflowTask",
        "AdfDataflow",
        "AdfDataset",
        "AdfPipeline",
        "AdfLinkedservice",
        "AdfActivity",
        "PowerBI",
        "CosmosMongoDB",
        "DocumentDB",
        "DbtModelColumn",
        "DbtTest",
        "DbtModel",
        "DbtMetric",
        "DbtSource",
        "DbtSeed",
        "FivetranConnector",
        "Anomalo",
        "MonteCarlo",
        "Metric",
        "Soda",
        "AIApplication",
        "AIModelVersion",
        "AIModel",
        "Readme",
        "File",
        "Link",
        "DataDomain",
        "DataProduct",
        "Table",
        "Query",
        "Schema",
        "SnowflakePipe",
        "View",
        "MaterialisedView",
        "Function",
        "TablePartition",
        "Column",
        "SnowflakeStage",
        "DatabricksUnityCatalogTag",
        "SnowflakeStream",
        "Database",
        "CalculationView",
        "Procedure",
        "SnowflakeTag",
        "MatillionGroup",
        "MatillionJob",
        "MatillionProject",
        "MatillionComponent",
        "ModelAttribute",
        "ModelEntity",
        "ModelVersion",
        "ModelEntityAssociation",
        "ModelAttributeAssociation",
        "ModelDataModel",
        "SparkJob",
        "SchemaRegistrySubject",
        "PowerBIReport",
        "PowerBIDatasource",
        "PowerBIWorkspace",
        "PowerBIDashboard",
        "PowerBIDataflow",
        "PowerBIDataflowEntityColumn",
        "PowerBIMeasure",
        "PowerBIColumn",
        "PowerBITable",
        "PowerBITile",
        "PowerBIDataset",
        "PowerBIApp",
        "PowerBIPage",
        "CosmosMongoDBCollection",
        "CosmosMongoDBAccount",
        "CosmosMongoDBDatabase",
        "DocumentDBCollection",
        "DocumentDBDatabase",
        "DynamoDBSecondaryIndex",
        "MongoDBCollection",
        "MongoDBDatabase",
        "AnomaloCheck",
        "MCIncident",
        "MCMonitor",
        "SodaCheck",
        "DatabricksAIModelVersion",
        "SnowflakeAIModelVersion",
        "SnowflakeAIModelContext",
        "DatabricksAIModelContext",
        "SnowflakeDynamicTable",
        "IndistinctAsset",
    ],
    "task": ["Task"],
    "form": ["Form"],
    "data_set": ["DataSet"],
    "badge": ["Badge"],
    "process_execution": ["ProcessExecution"],
    "auth_service": ["AuthService"],
    "infrastructure": ["Infrastructure"],
    "business_policy_exception": ["BusinessPolicyException"],
    "tag_attachment": ["TagAttachment"],
    "connection": ["Connection"],
    "workflow": ["Workflow"],
    "business_policy_log": ["BusinessPolicyLog"],
    "business_policy": ["BusinessPolicy"],
    "workflow_run": ["WorkflowRun"],
    "response": ["Response"],
    "connection_process": ["ConnectionProcess"],
    "cloud": ["Cloud"],
    "incident": ["Incident"],
    "dbt_process": ["DbtProcess"],
    "purpose": ["Purpose"],
    "s_a_p": ["SAP"],
    "event_store": ["EventStore"],
    "insight": ["Insight"],
    "object_store": ["ObjectStore"],
    "saa_s": ["SaaS"],
    "multi_dimensional_dataset": ["MultiDimensionalDataset"],
    "custom": ["Custom"],
    "a_p_i": ["API"],
    "collection": ["Collection"],
    "flow_folder": ["FlowFolder"],
    "flow_project": ["FlowProject"],
    "google": ["Google"],
    "azure": ["Azure"],
    "a_w_s": ["AWS"],
    "business_policy_incident": ["BusinessPolicyIncident"],
    "dbt_column_process": ["DbtColumnProcess"],
    "sap_erp_table": ["SapErpTable"],
    "sap_erp_column": ["SapErpColumn"],
    "sap_erp_cds_view": ["SapErpCdsView"],
    "sap_erp_abap_program": ["SapErpAbapProgram"],
    "sap_erp_transaction_code": ["SapErpTransactionCode"],
    "sap_erp_component": ["SapErpComponent"],
    "sap_erp_function_module": ["SapErpFunctionModule"],
    "sap_erp_view": ["SapErpView"],
    "preset": ["Preset"],
    "mode": ["Mode"],
    "sigma": ["Sigma"],
    "anaplan": ["Anaplan"],
    "tableau": ["Tableau"],
    "looker": ["Looker"],
    "domo": ["Domo"],
    "redash": ["Redash"],
    "sisense": ["Sisense"],
    "data_studio": ["DataStudio"],
    "metabase": ["Metabase"],
    "quick_sight": ["QuickSight"],
    "thoughtspot": ["Thoughtspot"],
    "micro_strategy": ["MicroStrategy"],
    "cognos": ["Cognos"],
    "superset": ["Superset"],
    "qlik": ["Qlik"],
    "kafka": ["Kafka"],
    "azure_service_bus": ["AzureServiceBus"],
    "cassandra": ["Cassandra"],
    "dynamo_d_b": ["DynamoDB"],
    "mongo_d_b": ["MongoDB"],
    "dbt_tag": ["DbtTag"],
    "s3": ["S3"],
    "a_d_l_s": ["ADLS"],
    "g_c_s": ["GCS"],
    "dataverse": ["Dataverse"],
    "cognite": ["Cognite"],
    "salesforce": ["Salesforce"],
    "readme_template": ["ReadmeTemplate"],
    "cube": ["Cube"],
    "cube_hierarchy": ["CubeHierarchy"],
    "cube_dimension": ["CubeDimension"],
    "cube_field": ["CubeField"],
    "custom_entity": ["CustomEntity"],
    "bigquery_tag": ["BigqueryTag"],
    "snowflake": ["Snowflake"],
    "databricks": ["Databricks"],
    "a_p_i_spec": ["APISpec"],
    "a_p_i_query": ["APIQuery"],
    "a_p_i_object": ["APIObject"],
    "a_p_i_path": ["APIPath"],
    "a_p_i_field": ["APIField"],
    "source_tag": ["SourceTag"],
    "data_studio_asset": ["DataStudioAsset"],
    "preset_chart": ["PresetChart"],
    "preset_dataset": ["PresetDataset"],
    "preset_dashboard": ["PresetDashboard"],
    "preset_workspace": ["PresetWorkspace"],
    "mode_report": ["ModeReport"],
    "mode_query": ["ModeQuery"],
    "mode_chart": ["ModeChart"],
    "mode_workspace": ["ModeWorkspace"],
    "mode_collection": ["ModeCollection"],
    "sigma_dataset_column": ["SigmaDatasetColumn"],
    "sigma_dataset": ["SigmaDataset"],
    "sigma_workbook": ["SigmaWorkbook"],
    "sigma_page": ["SigmaPage"],
    "sigma_data_element_field": ["SigmaDataElementField"],
    "sigma_data_element": ["SigmaDataElement"],
    "anaplan_page": ["AnaplanPage"],
    "anaplan_list": ["AnaplanList"],
    "anaplan_line_item": ["AnaplanLineItem"],
    "anaplan_workspace": ["AnaplanWorkspace"],
    "anaplan_module": ["AnaplanModule"],
    "anaplan_model": ["AnaplanModel"],
    "anaplan_app": ["AnaplanApp"],
    "anaplan_system_dimension": ["AnaplanSystemDimension"],
    "anaplan_dimension": ["AnaplanDimension"],
    "anaplan_view": ["AnaplanView"],
    "tableau_workbook": ["TableauWorkbook"],
    "tableau_worksheet_field": ["TableauWorksheetField"],
    "tableau_datasource_field": ["TableauDatasourceField"],
    "tableau_calculated_field": ["TableauCalculatedField"],
    "tableau_project": ["TableauProject"],
    "tableau_dashboard_field": ["TableauDashboardField"],
    "tableau_metric": ["TableauMetric"],
    "tableau_site": ["TableauSite"],
    "tableau_datasource": ["TableauDatasource"],
    "tableau_dashboard": ["TableauDashboard"],
    "tableau_flow": ["TableauFlow"],
    "tableau_worksheet": ["TableauWorksheet"],
    "looker_look": ["LookerLook"],
    "looker_dashboard": ["LookerDashboard"],
    "looker_folder": ["LookerFolder"],
    "looker_tile": ["LookerTile"],
    "looker_model": ["LookerModel"],
    "looker_explore": ["LookerExplore"],
    "looker_project": ["LookerProject"],
    "looker_query": ["LookerQuery"],
    "looker_field": ["LookerField"],
    "looker_view": ["LookerView"],
    "domo_dataset": ["DomoDataset"],
    "domo_card": ["DomoCard"],
    "domo_dataset_column": ["DomoDatasetColumn"],
    "domo_dashboard": ["DomoDashboard"],
    "redash_dashboard": ["RedashDashboard"],
    "redash_query": ["RedashQuery"],
    "redash_visualization": ["RedashVisualization"],
    "sisense_folder": ["SisenseFolder"],
    "sisense_widget": ["SisenseWidget"],
    "sisense_datamodel": ["SisenseDatamodel"],
    "sisense_datamodel_table": ["SisenseDatamodelTable"],
    "sisense_dashboard": ["SisenseDashboard"],
    "metabase_question": ["MetabaseQuestion"],
    "metabase_collection": ["MetabaseCollection"],
    "metabase_dashboard": ["MetabaseDashboard"],
    "quick_sight_folder": ["QuickSightFolder"],
    "quick_sight_dashboard_visual": ["QuickSightDashboardVisual"],
    "quick_sight_dataset_field": ["QuickSightDatasetField"],
    "quick_sight_analysis_visual": ["QuickSightAnalysisVisual"],
    "quick_sight_analysis": ["QuickSightAnalysis"],
    "quick_sight_dashboard": ["QuickSightDashboard"],
    "quick_sight_dataset": ["QuickSightDataset"],
    "thoughtspot_worksheet": ["ThoughtspotWorksheet"],
    "thoughtspot_liveboard": ["ThoughtspotLiveboard"],
    "thoughtspot_table": ["ThoughtspotTable"],
    "thoughtspot_view": ["ThoughtspotView"],
    "thoughtspot_column": ["ThoughtspotColumn"],
    "thoughtspot_dashlet": ["ThoughtspotDashlet"],
    "thoughtspot_answer": ["ThoughtspotAnswer"],
    "micro_strategy_report": ["MicroStrategyReport"],
    "micro_strategy_project": ["MicroStrategyProject"],
    "micro_strategy_metric": ["MicroStrategyMetric"],
    "micro_strategy_dossier": ["MicroStrategyDossier"],
    "micro_strategy_fact": ["MicroStrategyFact"],
    "micro_strategy_cube": ["MicroStrategyCube"],
    "micro_strategy_document": ["MicroStrategyDocument"],
    "micro_strategy_attribute": ["MicroStrategyAttribute"],
    "micro_strategy_visualization": ["MicroStrategyVisualization"],
    "cognos_column": ["CognosColumn"],
    "cognos_exploration": ["CognosExploration"],
    "cognos_dataset": ["CognosDataset"],
    "cognos_dashboard": ["CognosDashboard"],
    "cognos_report": ["CognosReport"],
    "cognos_module": ["CognosModule"],
    "cognos_file": ["CognosFile"],
    "cognos_folder": ["CognosFolder"],
    "cognos_package": ["CognosPackage"],
    "cognos_datasource": ["CognosDatasource"],
    "superset_dataset": ["SupersetDataset"],
    "superset_chart": ["SupersetChart"],
    "superset_dashboard": ["SupersetDashboard"],
    "qlik_space": ["QlikSpace"],
    "qlik_app": ["QlikApp"],
    "qlik_chart": ["QlikChart"],
    "qlik_dataset": ["QlikDataset"],
    "qlik_sheet": ["QlikSheet"],
    "kafka_topic": ["KafkaTopic"],
    "kafka_consumer_group": ["KafkaConsumerGroup"],
    "azure_service_bus_namespace": ["AzureServiceBusNamespace"],
    "azure_service_bus_schema": ["AzureServiceBusSchema"],
    "azure_service_bus_topic": ["AzureServiceBusTopic"],
    "cassandra_table": ["CassandraTable"],
    "cassandra_view": ["CassandraView"],
    "cassandra_column": ["CassandraColumn"],
    "cassandra_index": ["CassandraIndex"],
    "cassandra_keyspace": ["CassandraKeyspace"],
    "dynamo_dbtable": ["DynamoDBTable"],
    "s3_bucket": ["S3Bucket"],
    "s3_object": ["S3Object"],
    "a_d_l_s_account": ["ADLSAccount"],
    "a_d_l_s_container": ["ADLSContainer"],
    "a_d_l_s_object": ["ADLSObject"],
    "g_c_s_object": ["GCSObject"],
    "g_c_s_bucket": ["GCSBucket"],
    "dataverse_attribute": ["DataverseAttribute"],
    "dataverse_entity": ["DataverseEntity"],
    "cognite_event": ["CogniteEvent"],
    "cognite_asset": ["CogniteAsset"],
    "cognite3_d_model": ["Cognite3DModel"],
    "cognite_sequence": ["CogniteSequence"],
    "cognite_time_series": ["CogniteTimeSeries"],
    "cognite_file": ["CogniteFile"],
    "salesforce_object": ["SalesforceObject"],
    "salesforce_field": ["SalesforceField"],
    "salesforce_organization": ["SalesforceOrganization"],
    "salesforce_dashboard": ["SalesforceDashboard"],
    "salesforce_report": ["SalesforceReport"],
    "qlik_stream": ["QlikStream"],
    "azure_event_hub": ["AzureEventHub"],
    "azure_event_hub_consumer_group": ["AzureEventHubConsumerGroup"],
    "dynamo_d_b_local_secondary_index": ["DynamoDBLocalSecondaryIndex"],
    "dynamo_d_b_global_secondary_index": ["DynamoDBGlobalSecondaryIndex"],
}

lazy_loader = lazy.attach(__name__, submod_attrs=__PYATLAN_ASSETS__)
__getattr__, __dir__, __all__ = lazy_loader
