# This file was auto-generated by Fern from our API Definition.

# isort: skip_file

import typing
from importlib import import_module

if typing.TYPE_CHECKING:
    from . import auth, common, v1
    from .auth import TokenResponse
    from .common import EnvironmentId
    from .method_client import AsyncMethodClient, MethodClient
    from .version import __version__
_dynamic_imports: typing.Dict[str, str] = {
    "AsyncMethodClient": ".method_client",
    "EnvironmentId": ".common",
    "MethodClient": ".method_client",
    "TokenResponse": ".auth",
    "__version__": ".version",
    "auth": ".auth",
    "common": ".common",
    "v1": ".v1",
}


def __getattr__(attr_name: str) -> typing.Any:
    module_name = _dynamic_imports.get(attr_name)
    if module_name is None:
        raise AttributeError(f"No {attr_name} found in _dynamic_imports for module name -> {__name__}")
    try:
        module = import_module(module_name, __package__)
        if module_name == f".{attr_name}":
            return module
        else:
            return getattr(module, attr_name)
    except ImportError as e:
        raise ImportError(f"Failed to import {attr_name} from {module_name}: {e}") from e
    except AttributeError as e:
        raise AttributeError(f"Failed to get {attr_name} from {module_name}: {e}") from e


def __dir__():
    lazy_attrs = list(_dynamic_imports.keys())
    return sorted(lazy_attrs)


__all__ = ["AsyncMethodClient", "EnvironmentId", "MethodClient", "TokenResponse", "__version__", "auth", "common", "v1"]
