# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawAuthClient, RawAuthClient
from .types.token_response import TokenResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AuthClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAuthClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAuthClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAuthClient
        """
        return self._raw_client

    def get_token_with_client_credentials(
        self,
        *,
        client_id: str,
        client_secret: str,
        scope: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TokenResponse:
        """
        Parameters
        ----------
        client_id : str

        client_secret : str

        scope : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TokenResponse

        Examples
        --------
        from method_security import MethodClient

        client = MethodClient(
            base_url="https://yourhost.com/path/to/api",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.auth.get_token_with_client_credentials(
            client_id="client_id",
            client_secret="client_secret",
        )
        """
        _response = self._raw_client.get_token_with_client_credentials(
            client_id=client_id, client_secret=client_secret, scope=scope, request_options=request_options
        )
        return _response.data


class AsyncAuthClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAuthClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAuthClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAuthClient
        """
        return self._raw_client

    async def get_token_with_client_credentials(
        self,
        *,
        client_id: str,
        client_secret: str,
        scope: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TokenResponse:
        """
        Parameters
        ----------
        client_id : str

        client_secret : str

        scope : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TokenResponse

        Examples
        --------
        import asyncio

        from method_security import AsyncMethodClient

        client = AsyncMethodClient(
            base_url="https://yourhost.com/path/to/api",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.auth.get_token_with_client_credentials(
                client_id="client_id",
                client_secret="client_secret",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_token_with_client_credentials(
            client_id=client_id, client_secret=client_secret, scope=scope, request_options=request_options
        )
        return _response.data
