# This file was auto-generated by Fern from our API Definition.

# isort: skip_file

import typing
from importlib import import_module

if typing.TYPE_CHECKING:
    from . import audit, issues, objects
    from .audit import (
        Action,
        Action_AuditLogAccess,
        Action_UserAccountCreation,
        Action_UserAccountDeletion,
        Action_UserAccountModification,
        Action_UserLogin,
        Action_UserLogout,
        Actor,
        Actor_ServiceAccount,
        Actor_User,
        AuditEvent,
        AuditEventId,
        AuditEventsResponse,
        AuditLogAccess,
        Context,
        ExternalUserId,
        GetAuditEventsRequest,
        Group,
        GroupId,
        IpAddress,
        Resource,
        Resource_Group,
        Resource_UserAccount,
        ServiceAccount,
        ServiceAccountId,
        TenantId,
        User,
        UserAccount,
        UserAccountCreation,
        UserAccountDeletion,
        UserAccountModification,
        UserAgent,
        UserId,
        UserLogin,
        UserLogout,
    )
    from .issues import Issue, IssueClosedReason, IssueDoesNotExistError, IssueId, IssueSeverity, IssueStatus
    from .objects import ObjectId
_dynamic_imports: typing.Dict[str, str] = {
    "Action": ".audit",
    "Action_AuditLogAccess": ".audit",
    "Action_UserAccountCreation": ".audit",
    "Action_UserAccountDeletion": ".audit",
    "Action_UserAccountModification": ".audit",
    "Action_UserLogin": ".audit",
    "Action_UserLogout": ".audit",
    "Actor": ".audit",
    "Actor_ServiceAccount": ".audit",
    "Actor_User": ".audit",
    "AuditEvent": ".audit",
    "AuditEventId": ".audit",
    "AuditEventsResponse": ".audit",
    "AuditLogAccess": ".audit",
    "Context": ".audit",
    "ExternalUserId": ".audit",
    "GetAuditEventsRequest": ".audit",
    "Group": ".audit",
    "GroupId": ".audit",
    "IpAddress": ".audit",
    "Issue": ".issues",
    "IssueClosedReason": ".issues",
    "IssueDoesNotExistError": ".issues",
    "IssueId": ".issues",
    "IssueSeverity": ".issues",
    "IssueStatus": ".issues",
    "ObjectId": ".objects",
    "Resource": ".audit",
    "Resource_Group": ".audit",
    "Resource_UserAccount": ".audit",
    "ServiceAccount": ".audit",
    "ServiceAccountId": ".audit",
    "TenantId": ".audit",
    "User": ".audit",
    "UserAccount": ".audit",
    "UserAccountCreation": ".audit",
    "UserAccountDeletion": ".audit",
    "UserAccountModification": ".audit",
    "UserAgent": ".audit",
    "UserId": ".audit",
    "UserLogin": ".audit",
    "UserLogout": ".audit",
    "audit": ".audit",
    "issues": ".issues",
    "objects": ".objects",
}


def __getattr__(attr_name: str) -> typing.Any:
    module_name = _dynamic_imports.get(attr_name)
    if module_name is None:
        raise AttributeError(f"No {attr_name} found in _dynamic_imports for module name -> {__name__}")
    try:
        module = import_module(module_name, __package__)
        if module_name == f".{attr_name}":
            return module
        else:
            return getattr(module, attr_name)
    except ImportError as e:
        raise ImportError(f"Failed to import {attr_name} from {module_name}: {e}") from e
    except AttributeError as e:
        raise AttributeError(f"Failed to get {attr_name} from {module_name}: {e}") from e


def __dir__():
    lazy_attrs = list(_dynamic_imports.keys())
    return sorted(lazy_attrs)


__all__ = [
    "Action",
    "Action_AuditLogAccess",
    "Action_UserAccountCreation",
    "Action_UserAccountDeletion",
    "Action_UserAccountModification",
    "Action_UserLogin",
    "Action_UserLogout",
    "Actor",
    "Actor_ServiceAccount",
    "Actor_User",
    "AuditEvent",
    "AuditEventId",
    "AuditEventsResponse",
    "AuditLogAccess",
    "Context",
    "ExternalUserId",
    "GetAuditEventsRequest",
    "Group",
    "GroupId",
    "IpAddress",
    "Issue",
    "IssueClosedReason",
    "IssueDoesNotExistError",
    "IssueId",
    "IssueSeverity",
    "IssueStatus",
    "ObjectId",
    "Resource",
    "Resource_Group",
    "Resource_UserAccount",
    "ServiceAccount",
    "ServiceAccountId",
    "TenantId",
    "User",
    "UserAccount",
    "UserAccountCreation",
    "UserAccountDeletion",
    "UserAccountModification",
    "UserAgent",
    "UserId",
    "UserLogin",
    "UserLogout",
    "audit",
    "issues",
    "objects",
]
