# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from .raw_client import AsyncRawAuditClient, RawAuditClient
from .types.audit_events_response import AuditEventsResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AuditClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAuditClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAuditClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAuditClient
        """
        return self._raw_client

    def get_audit_events(
        self,
        *,
        start_time: dt.datetime,
        end_time: dt.datetime,
        page_size: typing.Optional[int] = None,
        token: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AuditEventsResponse:
        """
        Retrieves all audit events in the specified time range

        Parameters
        ----------
        start_time : dt.datetime

        end_time : dt.datetime

        page_size : typing.Optional[int]

        token : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AuditEventsResponse

        Examples
        --------
        import datetime

        from method_security import MethodClient

        client = MethodClient(
            base_url="https://yourhost.com/path/to/api",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.v1.audit.get_audit_events(
            start_time=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            end_time=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
        )
        """
        _response = self._raw_client.get_audit_events(
            start_time=start_time, end_time=end_time, page_size=page_size, token=token, request_options=request_options
        )
        return _response.data


class AsyncAuditClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAuditClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAuditClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAuditClient
        """
        return self._raw_client

    async def get_audit_events(
        self,
        *,
        start_time: dt.datetime,
        end_time: dt.datetime,
        page_size: typing.Optional[int] = None,
        token: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AuditEventsResponse:
        """
        Retrieves all audit events in the specified time range

        Parameters
        ----------
        start_time : dt.datetime

        end_time : dt.datetime

        page_size : typing.Optional[int]

        token : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AuditEventsResponse

        Examples
        --------
        import asyncio
        import datetime

        from method_security import AsyncMethodClient

        client = AsyncMethodClient(
            base_url="https://yourhost.com/path/to/api",
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.v1.audit.get_audit_events(
                start_time=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                end_time=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_audit_events(
            start_time=start_time, end_time=end_time, page_size=page_size, token=token, request_options=request_options
        )
        return _response.data
