# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from .types.audit_events_response import AuditEventsResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawAuditClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_audit_events(
        self,
        *,
        start_time: dt.datetime,
        end_time: dt.datetime,
        page_size: typing.Optional[int] = None,
        token: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[AuditEventsResponse]:
        """
        Retrieves all audit events in the specified time range

        Parameters
        ----------
        start_time : dt.datetime

        end_time : dt.datetime

        page_size : typing.Optional[int]

        token : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[AuditEventsResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            "method-api-gateway/api/v1/audit/getAuditEvents",
            method="POST",
            params={
                "pageSize": page_size,
                "token": token,
            },
            json={
                "startTime": start_time,
                "endTime": end_time,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AuditEventsResponse,
                    parse_obj_as(
                        type_=AuditEventsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawAuditClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_audit_events(
        self,
        *,
        start_time: dt.datetime,
        end_time: dt.datetime,
        page_size: typing.Optional[int] = None,
        token: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[AuditEventsResponse]:
        """
        Retrieves all audit events in the specified time range

        Parameters
        ----------
        start_time : dt.datetime

        end_time : dt.datetime

        page_size : typing.Optional[int]

        token : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[AuditEventsResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "method-api-gateway/api/v1/audit/getAuditEvents",
            method="POST",
            params={
                "pageSize": page_size,
                "token": token,
            },
            json={
                "startTime": start_time,
                "endTime": end_time,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AuditEventsResponse,
                    parse_obj_as(
                        type_=AuditEventsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
