# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawV1Client, RawV1Client

if typing.TYPE_CHECKING:
    from .audit.client import AsyncAuditClient, AuditClient
    from .issues.client import AsyncIssuesClient, IssuesClient


class V1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV1Client(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._audit: typing.Optional[AuditClient] = None
        self._issues: typing.Optional[IssuesClient] = None

    @property
    def with_raw_response(self) -> RawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV1Client
        """
        return self._raw_client

    @property
    def audit(self):
        if self._audit is None:
            from .audit.client import AuditClient  # noqa: E402

            self._audit = AuditClient(client_wrapper=self._client_wrapper)
        return self._audit

    @property
    def issues(self):
        if self._issues is None:
            from .issues.client import IssuesClient  # noqa: E402

            self._issues = IssuesClient(client_wrapper=self._client_wrapper)
        return self._issues


class AsyncV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV1Client(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._audit: typing.Optional[AsyncAuditClient] = None
        self._issues: typing.Optional[AsyncIssuesClient] = None

    @property
    def with_raw_response(self) -> AsyncRawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV1Client
        """
        return self._raw_client

    @property
    def audit(self):
        if self._audit is None:
            from .audit.client import AsyncAuditClient  # noqa: E402

            self._audit = AsyncAuditClient(client_wrapper=self._client_wrapper)
        return self._audit

    @property
    def issues(self):
        if self._issues is None:
            from .issues.client import AsyncIssuesClient  # noqa: E402

            self._issues = AsyncIssuesClient(client_wrapper=self._client_wrapper)
        return self._issues
