# SPDX-FileCopyrightText: All Contributors to the PyTango project
# SPDX-License-Identifier: LGPL-3.0-or-later

"""
This is the main PyTango package file.
Documentation for this package can be found online:

http://pytango.readthedocs.io
"""


__all__ = (
    "AccessControlType",
    "ApiUtil",
    "ArchiveEventInfo",
    "ArchiveEventProp",
    "ArgType",
    "AsynCall",
    "AsynReplyNotArrived",
    "AttReqType",
    "Attr",
    "AttrConfEventData",
    "AttrData",
    "AttrDataFormat",
    "AttrMemorizedType",
    "AttrProperty",
    "AttrQuality",
    "AttrReadEvent",
    "AttrSerialModel",
    "AttrWriteType",
    "AttrWrittenEvent",
    "Attribute",
    "AttributeAlarm",
    "AttributeAlarmInfo",
    "AttributeConfig",
    "AttributeConfig_2",
    "AttributeConfig_3",
    "AttributeConfig_5",
    "AttributeDimension",
    "AttributeEventInfo",
    "AttributeInfo",
    "AttributeInfoEx",
    "AttributeInfoList",
    "AttributeInfoListEx",
    "AttributeProxy",
    "ChangeEventInfo",
    "ChangeEventProp",
    "DevIntrChangeEventData",
    "ClientAddr",
    "CmdArgType",
    "CmdDoneEvent",
    "CommandInfo",
    "CommandInfoList",
    "CommunicationFailed",
    "Connection",
    "ConnectionFailed",
    "ConstDevString",
    "DServer",
    "DataReadyEventData",
    "Database",
    "DbData",
    "DbDatum",
    "DbDevExportInfo",
    "DbDevExportInfos",
    "DbDevImportInfo",
    "DbDevImportInfos",
    "DbDevFullInfo",
    "DbDevInfo",
    "DbDevInfos",
    "DbHistory",
    "DbHistoryList",
    "DbServerInfo",
    "DbServerData",
    "DebugIt",
    "DevBoolean",
    "DevCommandInfo",
    "DevDouble",
    "DevEncoded",
    "DevError",
    "DevFailed",
    "DevFloat",
    "DevLong",
    "DevLong64",
    "DevShort",
    "DevSource",
    "DevString",
    "DevUChar",
    "DevULong",
    "DevULong64",
    "DevUShort",
    "DevEnum",
    "DevState",
    "DevVarBooleanArray",
    "DevVarCharArray",
    "DevVarDoubleArray",
    "DevVarDoubleStringArray",
    "DevVarFloatArray",
    "DevVarLong64Array",
    "DevVarLongArray",
    "DevVarLongStringArray",
    "DevVarShortArray",
    "DevVarStringArray",
    "DevVarULong64Array",
    "DevVarULongArray",
    "DevVarUShortArray",
    "DevVoid",
    "DeviceAttribute",
    "DeviceAttributeConfig",
    "DeviceAttributeHistory",
    "DeviceClass",
    "DeviceData",
    "DeviceDataList",
    "DeviceDataHistory",
    "DeviceDataHistoryList",
    "DeviceImpl",
    "DeviceInfo",
    "DeviceProxy",
    "DeviceUnlocked",
    "Device_2Impl",
    "Device_3Impl",
    "Device_4Impl",
    "Device_5Impl",
    "Device_6Impl",
    "DispLevel",
    "EncodedAttribute",
    "EnsureOmniThread",
    "ErrSeverity",
    "ErrorIt",
    "EventData",
    "EventProperties",
    "EventReason",
    "EventSubMode",
    "EventSystemFailed",
    "EventType",
    "Except",
    "ExtractAs",
    "FMT_UNKNOWN",
    "FatalIt",
    "GreenMode",
    "Group",
    "GroupAttrReply",
    "GroupAttrReplyList",
    "GroupCmdReply",
    "GroupCmdReplyList",
    "GroupReply",
    "GroupReplyList",
    "IMAGE",
    "ImageAttr",
    "InfoIt",
    "KeepAliveCmdCode",
    "Level",
    "LockCmdCode",
    "LockerInfo",
    "LockerLanguage",
    "LogIt",
    "LogLevel",
    "LogTarget",
    "Logger",
    "Logging",
    "MessBoxType",
    "MultiAttribute",
    "MultiAttrProp",
    "MultiClassAttribute",
    "NamedDevFailed",
    "NamedDevFailedList",
    "NonDbDevice",
    "NonSupportedFeature",
    "NotAllowed",
    "PeriodicEventInfo",
    "PeriodicEventProp",
    "PollCmdCode",
    "PollDevice",
    "PollObjType",
    "PyTangoUserWarning",
    "READ",
    "READ_WITH_WRITE",
    "READ_WRITE",
    "Release",
    "SCALAR",
    "SPECTRUM",
    "SerialModel",
    "SpectrumAttr",
    "StdDoubleVector",
    "StdLongVector",
    "StdNamedDevFailedVector",
    "StdStringVector",
    "SubDevDiag",
    "TangoStream",
    "TimeVal",
    "TimedAttrData",
    "TimedCmdData",
    "UserDefaultAttrProp",
    "Util",
    "WAttribute",
    "WRITE",
    "WarnIt",
    "WrongData",
    "WrongNameSyntax",
    "__version__",
    "__version_description__",
    "__version_info__",
    "__version_long__",
    "__version_number__",
    "alarm_flags",
    "asyn_req_type",
    "cb_sub_model",
    "class_factory",
    "class_list",
    "constants",
    "constructed_class",
    "cpp_class_list",
    "delete_class_list",
    "get_class",
    "get_classes",
    "get_constructed_class",
    "get_constructed_classes",
    "get_cpp_class",
    "get_cpp_classes",
    "raise_asynch_exception",
    "AutoTangoMonitor",
    "AutoTangoAllowThreads",
    "LatestDeviceImpl",
    "Interceptors",
    "get_attribute_proxy",
    "requires_tango",
    "requires_pytango",
    "set_green_mode",
    "get_green_mode",
    "get_device_proxy",
    "is_scalar_type",
    "is_array_type",
    "is_omni_thread",
    "is_numerical_type",
    "is_int_type",
    "is_float_type",
    "is_bool_type",
    "is_str_type",
    "obj_2_str",
    "str_2_obj",
    "seqStr_2_obj",
)

__docformat__ = "restructuredtext"

from ._tango import (
    AccessControlType,
    ApiUtil,
    ArchiveEventInfo,
    AsynCall,
    AsynReplyNotArrived,
    AttReqType,
    Attr,
    AttrConfEventData,
    AttrDataFormat,
    AttrMemorizedType,
    AttrProperty,
    AttrQuality,
    AttrReadEvent,
    AttrSerialModel,
    AttrWriteType,
    AttrWrittenEvent,
    Attribute,
    AttributeAlarm,
    AttributeAlarmInfo,
    AttributeConfig,
    AttributeConfig_2,
    AttributeConfig_3,
    AttributeConfig_5,
    AttributeDimension,
    AttributeEventInfo,
    AttributeInfo,
    AttributeInfoEx,
    AttributeInfoList,
    AttributeInfoListEx,
    ArchiveEventProp,
    ChangeEventInfo,
    ChangeEventProp,
    ClientAddr,
    CmdArgType,
    DevIntrChangeEventData,
    CmdDoneEvent,
    CommandInfo,
    CommandInfoList,
    CommunicationFailed,
    Connection,
    ConnectionFailed,
    ConstDevString,
    DServer,
    DataReadyEventData,
    Database,
    DbData,
    DbDatum,
    DbDevExportInfo,
    DbDevExportInfos,
    DbDevImportInfo,
    DbDevImportInfos,
    DbDevFullInfo,
    DbDevInfo,
    DbDevInfos,
    DbHistory,
    DbHistoryList,
    DbServerInfo,
    DbServerData,
    DevBoolean,
    DevCommandInfo,
    DevDouble,
    DevEncoded,
    DevError,
    DevFailed,
    DevFloat,
    DevLong,
    DevLong64,
    DevShort,
    DevSource,
    DevString,
    DevUChar,
    DevULong,
    DevULong64,
    DevUShort,
    DevEnum,
    DevState,
    DevVarBooleanArray,
    DevVarCharArray,
    DevVarDoubleArray,
    DevVarDoubleStringArray,
    DevVarFloatArray,
    DevVarLong64Array,
    DevVarLongArray,
    DevVarLongStringArray,
    DevVarShortArray,
    DevVarStringArray,
    DevVarULong64Array,
    DevVarULongArray,
    DevVarUShortArray,
    DevVoid,
    DeviceAttribute,
    DeviceAttributeConfig,
    DeviceAttributeHistory,
    DeviceData,
    DeviceDataList,
    DeviceDataHistory,
    DeviceDataHistoryList,
    DeviceImpl,
    DeviceInfo,
    DeviceProxy,
    DeviceUnlocked,
    Device_2Impl,
    Device_3Impl,
    Device_4Impl,
    Device_5Impl,
    Device_6Impl,
    DispLevel,
    EncodedAttribute,
    EnsureOmniThread,
    ErrSeverity,
    EventData,
    EventSystemFailed,
    EventProperties,
    EventReason,
    EventSubMode,
    EventType,
    Except,
    ExtractAs,
    GreenMode,
    FMT_UNKNOWN,
    GroupAttrReply,
    GroupAttrReplyList,
    GroupCmdReply,
    GroupCmdReplyList,
    GroupReply,
    GroupReplyList,
    IMAGE,
    ImageAttr,
    KeepAliveCmdCode,
    Level,
    LockCmdCode,
    LockerInfo,
    LockerLanguage,
    LogLevel,
    LogTarget,
    Logger,
    Logging,
    MessBoxType,
    MultiAttribute,
    MultiClassAttribute,
    NamedDevFailed,
    NamedDevFailedList,
    NonDbDevice,
    NonSupportedFeature,
    NotAllowed,
    PeriodicEventInfo,
    PeriodicEventProp,
    PollCmdCode,
    PollDevice,
    PollObjType,
    READ,
    READ_WITH_WRITE,
    READ_WRITE,
    SCALAR,
    SPECTRUM,
    SerialModel,
    SpectrumAttr,
    StdDoubleVector,
    StdLongVector,
    StdNamedDevFailedVector,
    StdStringVector,
    SubDevDiag,
    TimeVal,
    UserDefaultAttrProp,
    WAttribute,
    WRITE,
    WrongData,
    WrongNameSyntax,
    alarm_flags,
    asyn_req_type,
    cb_sub_model,
    constants,
    raise_asynch_exception,
    Interceptors,
    AutoTangoMonitor,
    AutoTangoAllowThreads,
    is_omni_thread,
)

__auto_die_callbacks_holder = {}


# Aliases

ArgType = CmdArgType

# Release

from .release import Release

__author__ = Release.author_lines
__version_info__ = Release.version_info
__version_short__ = Release.version
__version__ = Release.version_long
__version_long__ = Release.version_long
__version_number__ = Release.version_number
__version_description__ = Release.version_description
__doc__ = Release.long_description

# Pytango imports

from .attr_data import AttrData

from .log4tango import TangoStream, LogIt, DebugIt, InfoIt, WarnIt, ErrorIt, FatalIt

from .device_server import (
    MultiAttrProp,
    LatestDeviceImpl,
)

from .attribute_proxy import AttributeProxy, get_attribute_proxy

from .group import Group

from .pyutil import Util

from .device_class import DeviceClass

from .globals import (
    get_class,
    get_classes,
    get_cpp_class,
    get_cpp_classes,
    get_constructed_class,
    get_constructed_classes,
    class_factory,
    delete_class_list,
    class_list,
    cpp_class_list,
    constructed_class,
)

from .utils import (
    requires_pytango,
    requires_tango,
    is_scalar_type,
    is_array_type,
    is_numerical_type,
    is_int_type,
    is_float_type,
    is_bool_type,
    is_str_type,
    obj_2_str,
    str_2_obj,
    seqStr_2_obj,
    PyTangoUserWarning,
    _RemovedClass,
)

from .green import set_green_mode, get_green_mode

from .device_proxy import get_device_proxy

from .pyutil import TimedAttrData, TimedCmdData

# PyTango initialization

from .pytango_init import init as __init

PipeWriteType = _RemovedClass(
    "PipeWriteType Enum was removed from PyTango starting from version 10.1.0. Pipes are not supported anymore. "
    "Please update your code!"
)

__init()
requires_tango("10.1.0", software_name="PyTango")
