"""This module implements the Python Tango Device API mapping."""

from __future__ import annotations

from tango._tango import (
    AccessControlType,
    ApiUtil,
    ArchiveEventInfo,
    ArchiveEventProp,
    AsynCall,
    AsynReplyNotArrived,
    Attr,
    AttrConfEventData,
    AttrDataFormat,
    AttReqType,
    Attribute,
    AttributeAlarm,
    AttributeAlarmInfo,
    AttributeConfig,
    AttributeConfig_2,
    AttributeConfig_3,
    AttributeConfig_5,
    AttributeDimension,
    AttributeEventInfo,
    AttributeInfo,
    AttributeInfoEx,
    AttributeInfoList,
    AttributeInfoListEx,
    AttrMemorizedType,
    AttrProperty,
    AttrQuality,
    AttrReadEvent,
    AttrSerialModel,
    AttrWriteType,
    AttrWrittenEvent,
    AutoTangoAllowThreads,
    AutoTangoMonitor,
    ChangeEventInfo,
    ChangeEventProp,
    ClientAddr,
    CmdArgType,
    CmdDoneEvent,
    CommandInfo,
    CommandInfoList,
    CommunicationFailed,
    Connection,
    ConnectionFailed,
    Database,
    DataReadyEventData,
    DbData,
    DbDatum,
    DbDevExportInfo,
    DbDevExportInfos,
    DbDevFullInfo,
    DbDevImportInfo,
    DbDevImportInfos,
    DbDevInfo,
    DbDevInfos,
    DbHistory,
    DbHistoryList,
    DbServerData,
    DbServerInfo,
    DevCommandInfo,
    DevError,
    DevFailed,
    Device_2Impl,
    Device_3Impl,
    Device_4Impl,
    Device_5Impl,
    Device_6Impl,
    DeviceAttribute,
    DeviceAttributeConfig,
    DeviceAttributeHistory,
    DeviceClass,
    DeviceData,
    DeviceDataHistory,
    DeviceDataHistoryList,
    DeviceDataList,
    DeviceImpl,
    DeviceInfo,
    DeviceProxy,
    DeviceUnlocked,
    DevIntrChangeEventData,
    DevSource,
    DevState,
    DispLevel,
    DServer,
    EncodedAttribute,
    EnsureOmniThread,
    ErrSeverity,
    EventData,
    EventProperties,
    EventReason,
    EventSubMode,
    EventSystemFailed,
    EventType,
    Except,
    ExtractAs,
    GreenMode,
    GroupAttrReply,
    GroupAttrReplyList,
    GroupCmdReply,
    GroupCmdReplyList,
    GroupReply,
    GroupReplyList,
    ImageAttr,
    Interceptors,
    KeepAliveCmdCode,
    Level,
    LockCmdCode,
    LockerInfo,
    LockerLanguage,
    Logger,
    Logging,
    LogLevel,
    LogTarget,
    MessBoxType,
    MultiAttribute,
    MultiClassAttribute,
    NamedDevFailed,
    NamedDevFailedList,
    NonDbDevice,
    NonSupportedFeature,
    NotAllowed,
    PeriodicEventInfo,
    PeriodicEventProp,
    PollCmdCode,
    PollDevice,
    PollObjType,
    SerialModel,
    SpectrumAttr,
    StdDoubleVector,
    StdLongVector,
    StdNamedDevFailedVector,
    StdStringVector,
    SubDevDiag,
    TimeVal,
    UserDefaultAttrProp,
    Util,
    WAttribute,
    WrongData,
    WrongNameSyntax,
    alarm_flags,
    asyn_req_type,
    cb_sub_model,
    is_omni_thread,
    raise_asynch_exception,
)
from tango._tango import CmdArgType as ArgType
from tango.attr_data import AttrData
from tango.attribute_proxy import AttributeProxy, get_attribute_proxy
from tango.device_proxy import get_device_proxy
from tango.device_server import LatestDeviceImpl, MultiAttrProp
from tango.globals import (
    class_factory,
    delete_class_list,
    get_class,
    get_classes,
    get_constructed_class,
    get_constructed_classes,
    get_cpp_class,
    get_cpp_classes,
)
from tango.green import get_green_mode, set_green_mode
from tango.group import Group
from tango.log4tango import (
    DebugIt,
    ErrorIt,
    FatalIt,
    InfoIt,
    LogIt,
    TangoStream,
    WarnIt,
)
from tango.pytango_init import init as __init
from tango.pyutil import TimedAttrData, TimedCmdData
from tango.release import Release
from tango.utils import (
    PyTangoUserWarning,
    _RemovedClass,
    obj_2_str,
    requires_pytango,
    requires_tango,
    seqStr_2_obj,
    str_2_obj,
)
from tango.utils import is_array as is_array_type
from tango.utils import is_bool as is_bool_type
from tango.utils import is_float as is_float_type
from tango.utils import is_int as is_int_type
from tango.utils import is_numerical as is_numerical_type
from tango.utils import is_scalar as is_scalar_type
from tango.utils import is_str as is_str_type

from . import (
    _tango,
    attr_data,
    attribute_proxy,
    auto_monitor,
    base_types,
    connection,
    constants,
    db,
    device_attribute,
    device_class,
    device_proxy,
    device_server,
    encoded_attribute,
    globals,
    green,
    group,
    group_reply,
    log4tango,
    pytango_init,
    pytango_pprint,
    pyutil,
    release,
    time_val,
    utils,
)

__all__: tuple = (
    "AccessControlType",
    "ApiUtil",
    "ArchiveEventInfo",
    "ArchiveEventProp",
    "ArgType",
    "AsynCall",
    "AsynReplyNotArrived",
    "AttReqType",
    "Attr",
    "AttrConfEventData",
    "AttrData",
    "AttrDataFormat",
    "AttrMemorizedType",
    "AttrProperty",
    "AttrQuality",
    "AttrReadEvent",
    "AttrSerialModel",
    "AttrWriteType",
    "AttrWrittenEvent",
    "Attribute",
    "AttributeAlarm",
    "AttributeAlarmInfo",
    "AttributeConfig",
    "AttributeConfig_2",
    "AttributeConfig_3",
    "AttributeConfig_5",
    "AttributeDimension",
    "AttributeEventInfo",
    "AttributeInfo",
    "AttributeInfoEx",
    "AttributeInfoList",
    "AttributeInfoListEx",
    "AttributeProxy",
    "ChangeEventInfo",
    "ChangeEventProp",
    "DevIntrChangeEventData",
    "ClientAddr",
    "CmdArgType",
    "CmdDoneEvent",
    "CommandInfo",
    "CommandInfoList",
    "CommunicationFailed",
    "Connection",
    "ConnectionFailed",
    "ConstDevString",
    "DServer",
    "DataReadyEventData",
    "Database",
    "DbData",
    "DbDatum",
    "DbDevExportInfo",
    "DbDevExportInfos",
    "DbDevImportInfo",
    "DbDevImportInfos",
    "DbDevFullInfo",
    "DbDevInfo",
    "DbDevInfos",
    "DbHistory",
    "DbHistoryList",
    "DbServerInfo",
    "DbServerData",
    "DebugIt",
    "DevBoolean",
    "DevCommandInfo",
    "DevDouble",
    "DevEncoded",
    "DevError",
    "DevFailed",
    "DevFloat",
    "DevLong",
    "DevLong64",
    "DevShort",
    "DevSource",
    "DevString",
    "DevUChar",
    "DevULong",
    "DevULong64",
    "DevUShort",
    "DevEnum",
    "DevState",
    "DevVarBooleanArray",
    "DevVarCharArray",
    "DevVarDoubleArray",
    "DevVarDoubleStringArray",
    "DevVarFloatArray",
    "DevVarLong64Array",
    "DevVarLongArray",
    "DevVarLongStringArray",
    "DevVarShortArray",
    "DevVarStringArray",
    "DevVarULong64Array",
    "DevVarULongArray",
    "DevVarUShortArray",
    "DevVoid",
    "DeviceAttribute",
    "DeviceAttributeConfig",
    "DeviceAttributeHistory",
    "DeviceClass",
    "DeviceData",
    "DeviceDataList",
    "DeviceDataHistory",
    "DeviceDataHistoryList",
    "DeviceImpl",
    "DeviceInfo",
    "DeviceProxy",
    "DeviceUnlocked",
    "Device_2Impl",
    "Device_3Impl",
    "Device_4Impl",
    "Device_5Impl",
    "Device_6Impl",
    "DispLevel",
    "EncodedAttribute",
    "EnsureOmniThread",
    "ErrSeverity",
    "ErrorIt",
    "EventData",
    "EventProperties",
    "EventReason",
    "EventSubMode",
    "EventSystemFailed",
    "EventType",
    "Except",
    "ExtractAs",
    "FMT_UNKNOWN",
    "FatalIt",
    "GreenMode",
    "Group",
    "GroupAttrReply",
    "GroupAttrReplyList",
    "GroupCmdReply",
    "GroupCmdReplyList",
    "GroupReply",
    "GroupReplyList",
    "IMAGE",
    "ImageAttr",
    "InfoIt",
    "KeepAliveCmdCode",
    "Level",
    "LockCmdCode",
    "LockerInfo",
    "LockerLanguage",
    "LogIt",
    "LogLevel",
    "LogTarget",
    "Logger",
    "Logging",
    "MessBoxType",
    "MultiAttribute",
    "MultiAttrProp",
    "MultiClassAttribute",
    "NamedDevFailed",
    "NamedDevFailedList",
    "NonDbDevice",
    "NonSupportedFeature",
    "NotAllowed",
    "PeriodicEventInfo",
    "PeriodicEventProp",
    "PollCmdCode",
    "PollDevice",
    "PollObjType",
    "PyTangoUserWarning",
    "READ",
    "READ_WITH_WRITE",
    "READ_WRITE",
    "Release",
    "SCALAR",
    "SPECTRUM",
    "SerialModel",
    "SpectrumAttr",
    "StdDoubleVector",
    "StdLongVector",
    "StdNamedDevFailedVector",
    "StdStringVector",
    "SubDevDiag",
    "TangoStream",
    "TimeVal",
    "TimedAttrData",
    "TimedCmdData",
    "UserDefaultAttrProp",
    "Util",
    "WAttribute",
    "WRITE",
    "WarnIt",
    "WrongData",
    "WrongNameSyntax",
    "__version__",
    "__version_description__",
    "__version_info__",
    "__version_long__",
    "__version_number__",
    "alarm_flags",
    "asyn_req_type",
    "cb_sub_model",
    "class_factory",
    "class_list",
    "constants",
    "constructed_class",
    "cpp_class_list",
    "delete_class_list",
    "get_class",
    "get_classes",
    "get_constructed_class",
    "get_constructed_classes",
    "get_cpp_class",
    "get_cpp_classes",
    "raise_asynch_exception",
    "AutoTangoMonitor",
    "AutoTangoAllowThreads",
    "LatestDeviceImpl",
    "Interceptors",
    "get_attribute_proxy",
    "requires_tango",
    "requires_pytango",
    "set_green_mode",
    "get_green_mode",
    "get_device_proxy",
    "is_scalar_type",
    "is_array_type",
    "is_omni_thread",
    "is_numerical_type",
    "is_int_type",
    "is_float_type",
    "is_bool_type",
    "is_str_type",
    "obj_2_str",
    "str_2_obj",
    "seqStr_2_obj",
)
ConstDevString: _tango.CmdArgType  # value = <CmdArgType.ConstDevString: 20>
DevBoolean: _tango.CmdArgType  # value = <CmdArgType.DevBoolean: 1>
DevDouble: _tango.CmdArgType  # value = <CmdArgType.DevDouble: 5>
DevEncoded: _tango.CmdArgType  # value = <CmdArgType.DevEncoded: 28>
DevEnum: _tango.CmdArgType  # value = <CmdArgType.DevEnum: 29>
DevFloat: _tango.CmdArgType  # value = <CmdArgType.DevFloat: 4>
DevLong: _tango.CmdArgType  # value = <CmdArgType.DevLong: 3>
DevLong64: _tango.CmdArgType  # value = <CmdArgType.DevLong64: 23>
DevShort: _tango.CmdArgType  # value = <CmdArgType.DevShort: 2>
DevString: _tango.CmdArgType  # value = <CmdArgType.DevString: 8>
DevUChar: _tango.CmdArgType  # value = <CmdArgType.DevUChar: 22>
DevULong: _tango.CmdArgType  # value = <CmdArgType.DevULong: 7>
DevULong64: _tango.CmdArgType  # value = <CmdArgType.DevULong64: 24>
DevUShort: _tango.CmdArgType  # value = <CmdArgType.DevUShort: 6>
DevVarBooleanArray: _tango.CmdArgType  # value = <CmdArgType.DevVarBooleanArray: 21>
DevVarCharArray: _tango.CmdArgType  # value = <CmdArgType.DevVarCharArray: 9>
DevVarDoubleArray: _tango.CmdArgType  # value = <CmdArgType.DevVarDoubleArray: 13>
DevVarDoubleStringArray: (
    _tango.CmdArgType
)  # value = <CmdArgType.DevVarDoubleStringArray: 18>
DevVarFloatArray: _tango.CmdArgType  # value = <CmdArgType.DevVarFloatArray: 12>
DevVarLong64Array: _tango.CmdArgType  # value = <CmdArgType.DevVarLong64Array: 25>
DevVarLongArray: _tango.CmdArgType  # value = <CmdArgType.DevVarLongArray: 11>
DevVarLongStringArray: (
    _tango.CmdArgType
)  # value = <CmdArgType.DevVarLongStringArray: 17>
DevVarShortArray: _tango.CmdArgType  # value = <CmdArgType.DevVarShortArray: 10>
DevVarStringArray: _tango.CmdArgType  # value = <CmdArgType.DevVarStringArray: 16>
DevVarULong64Array: _tango.CmdArgType  # value = <CmdArgType.DevVarULong64Array: 26>
DevVarULongArray: _tango.CmdArgType  # value = <CmdArgType.DevVarULongArray: 15>
DevVarUShortArray: _tango.CmdArgType  # value = <CmdArgType.DevVarUShortArray: 14>
DevVoid: _tango.CmdArgType  # value = <CmdArgType.DevVoid: 0>
FMT_UNKNOWN: _tango.AttrDataFormat  # value = <AttrDataFormat.FMT_UNKNOWN: 3>
IMAGE: _tango.AttrDataFormat  # value = <AttrDataFormat.IMAGE: 2>
PipeWriteType: utils._RemovedClass  # value = <tango.utils._RemovedClass object>
READ: _tango.AttrWriteType  # value = <AttrWriteType.READ: 0>
READ_WITH_WRITE: _tango.AttrWriteType  # value = <AttrWriteType.READ_WITH_WRITE: 1>
READ_WRITE: _tango.AttrWriteType  # value = <AttrWriteType.READ_WRITE: 3>
SCALAR: _tango.AttrDataFormat  # value = <AttrDataFormat.SCALAR: 0>
SPECTRUM: _tango.AttrDataFormat  # value = <AttrDataFormat.SPECTRUM: 1>
WRITE: _tango.AttrWriteType  # value = <AttrWriteType.WRITE: 2>
__author__: str = "Tiago Coutinho <coutinho@esrf.fr>"
__auto_die_callbacks_holder: dict = {}
__docformat__: str = "restructuredtext"
__version__: str = "10.1.0"
__version_description__: str = "This version implements the C++ Tango 10.1 API."
__version_info__: tuple = (10, 1, 0)
__version_long__: str = "10.1.0"
__version_number__: int = 1010
__version_short__: str = "10.1.0"
class_list: list = list()
constructed_class: list = list()
cpp_class_list: list = list()
