from typing import Literal

Industry = Literal[
    "Publishing",
    "Internet Retail",
    "Scientific & Technical Instruments",
    "Engineering & Construction",
    "Diagnostics & Research",
    "Software - Infrastructure",
    "Thermal Coal",
    "Software - Application",
    "Auto Manufacturers",
    "Farm Products",
    "Medical Devices",
    "Education & Training Services",
    "Auto Parts",
    "Specialty Chemicals",
    "Marine Shipping",
    "Biotechnology",
    "Real Estate Services",
    "Gold",
    "Entertainment",
    "Specialty Retail",
    "Utilities - Independent Power Producers",
    "Steel",
    "Mortgage Finance",
    "Communication Equipment",
    "Drug Manufacturers - Specialty & Generic",
    "Electronic Gaming & Multimedia",
    "Banks - Regional",
    "Oil & Gas E&P",
    "Travel Services",
    "Real Estate - Diversified",
    "Telecom Services",
    "Uranium",
    "Consulting Services",
    "Waste Management",
    "Agricultural Inputs",
    "Utilities - Diversified",
    "Auto & Truck Dealerships",
    "Confectioners",
    "Other Industrial Metals & Mining",
    "Beverages - Wineries & Distilleries",
    "Oil & Gas Midstream",
    "Recreational Vehicles",
    "Electrical Equipment & Parts",
    "Household & Personal Products",
    "Packaging & Containers",
    "REIT - Specialty",
    "Home Improvement Retail",
    "Electronic Components",
    "Asset Management",
    "Consumer Electronics",
    "Conglomerates",
    "Health Information Services",
    "Medical Instruments & Supplies",
    "Building Products & Equipment",
    "Information Technology Services",
    "Specialty Industrial Machinery",
    "Food Distribution",
    "Packaged Foods",
    "Rental & Leasing Services",
    "Medical Distribution",
    "Grocery Stores",
    "Advertising Agencies",
    "Beverages - Non - Alcoholic",
    "Apparel Manufacturing",
    "Oil & Gas Equipment & Services",
    "Coking Coal",
    "Industrial Distribution",
    "Restaurants",
    "Beverages - Brewers",
    "Chemicals",
    "Real Estate - Development",
    "Credit Services",
    "Tobacco",
    "Metal Fabrication",
    "Building Materials",
    "Residential Construction",
    "Specialty Business Services",
    "REIT - Hotel & Motel",
    "Internet Content & Information",
    "Lodging",
    "Furnishings, Fixtures & Appliances",
    "Airlines",
    "Computer Hardware",
    "Integrated Freight & Logistics",
    "Solar",
    "Capital Markets",
    "Leisure",
    "Airports & Air Services",
    "Aluminum",
    "Insurance Brokers",
    "Semiconductors",
    "REIT - Retail",
    "Luxury Goods",
    "Lumber & Wood Production",
    "REIT - Mortgage",
    "Semiconductor Equipment & Materials",
    "Aerospace & Defense",
    "Security & Protection Services",
    "Utilities - Renewable",
    "Utilities - Regulated Gas",
    "Apparel Retail",
    "Pollution & Treatment Controls",
    "Broadcasting",
    "Resorts & Casinos",
    "Other Precious Metals & Mining",
    "Financial Data & Stock Exchanges",
    "Footwear & Accessories",
    "Medical Care Facilities",
    "Electronics & Computer Distribution",
    "Gambling",
    "Tools & Accessories",
    "Insurance - Property & Casualty",
    "Utilities - Regulated Water",
    "Insurance - Specialty",
    "Personal Services",
    "Pharmaceutical Retailers",
    "Farm & Heavy Construction Machinery",
    "Utilities - Regulated Electric",
    "Department Stores",
    "Staffing & Employment Services",
    "Textile Manufacturing",
    "Silver",
    "REIT - Industrial",
    "REIT - Diversified",
    "Copper",
    "Business Equipment & Supplies",
    "Infrastructure Operations",
    "Trucking",
    "Insurance - Reinsurance",
    "Insurance - Diversified",
    "Drug Manufacturers - General",
    "Oil & Gas Drilling",
    "Banks - Diversified",
    "REIT - Residential",
    "Oil & Gas Refining & Marketing",
    "Shell Companies",
    "Financial Conglomerates",
    "Paper & Paper Products",
    "Insurance - Life",
    "REIT - Office",
    "Railroads",
    "Oil & Gas Integrated",
    "Healthcare Plans",
    "REIT - Healthcare Facilities",
    "Discount Stores",
]
IndustryGroup = Literal[
    "publishing",
    "internet-retail",
    "scientific-technical-instruments",
    "engineering-construction",
    "diagnostics-research",
    "software-infrastructure",
    "thermal-coal",
    "software-application",
    "auto-manufacturers",
    "farm-products",
    "medical-devices",
    "education-training-services",
    "auto-parts",
    "specialty-chemicals",
    "marine-shipping",
    "biotechnology",
    "real-estate-services",
    "gold",
    "entertainment",
    "specialty-retail",
    "utilities-independent-power-producers",
    "steel",
    "mortgage-finance",
    "communication-equipment",
    "drug-manufacturers-specialty-generic",
    "electronic-gaming-multimedia",
    "banks-regional",
    "oil-gas-e-p",
    "travel-services",
    "real-estate-diversified",
    "telecom-services",
    "uranium",
    "consulting-services",
    "waste-management",
    "agricultural-inputs",
    "utilities-diversified",
    "auto-truck-dealerships",
    "confectioners",
    "other-industrial-metals-mining",
    "beverages-wineries-distilleries",
    "oil-gas-midstream",
    "recreational-vehicles",
    "electrical-equipment-parts",
    "household-personal-products",
    "packaging-containers",
    "reit-specialty",
    "home-improvement-retail",
    "electronic-components",
    "asset-management",
    "consumer-electronics",
    "conglomerates",
    "health-information-services",
    "medical-instruments-supplies",
    "building-products-equipment",
    "information-technology-services",
    "specialty-industrial-machinery",
    "food-distribution",
    "packaged-foods",
    "rental-leasing-services",
    "medical-distribution",
    "grocery-stores",
    "advertising-agencies",
    "beverages-non-alcoholic",
    "apparel-manufacturing",
    "oil-gas-equipment-services",
    "coking-coal",
    "industrial-distribution",
    "restaurants",
    "beverages-brewers",
    "chemicals",
    "real-estate-development",
    "credit-services",
    "tobacco",
    "metal-fabrication",
    "building-materials",
    "residential-construction",
    "specialty-business-services",
    "reit-hotel-motel",
    "internet-content-information",
    "lodging",
    "furnishings-fixtures-appliances",
    "airlines",
    "computer-hardware",
    "integrated-freight-logistics",
    "solar",
    "capital-markets",
    "leisure",
    "airports-air-services",
    "aluminum",
    "insurance-brokers",
    "semiconductors",
    "reit-retail",
    "luxury-goods",
    "lumber-wood-production",
    "reit-mortgage",
    "semiconductor-equipment-materials",
    "aerospace-defense",
    "security-protection-services",
    "utilities-renewable",
    "utilities-regulated-gas",
    "apparel-retail",
    "pollution-treatment-controls",
    "broadcasting",
    "resorts-casinos",
    "other-precious-metals-mining",
    "financial-data-stock-exchanges",
    "footwear-accessories",
    "medical-care-facilities",
    "electronics-computer-distribution",
    "gambling",
    "tools-accessories",
    "insurance-property-casualty",
    "utilities-regulated-water",
    "insurance-specialty",
    "personal-services",
    "pharmaceutical-retailers",
    "farm-heavy-construction-machinery",
    "utilities-regulated-electric",
    "department-stores",
    "staffing-employment-services",
    "textile-manufacturing",
    "silver",
    "reit-industrial",
    "reit-diversified",
    "copper",
    "business-equipment-supplies",
    "infrastructure-operations",
    "trucking",
    "insurance-reinsurance",
    "insurance-diversified",
    "drug-manufacturers-general",
    "oil-gas-drilling",
    "banks-diversified",
    "reit-residential",
    "oil-gas-refining-marketing",
    "shell-companies",
    "financial-conglomerates",
    "paper-paper-products",
    "insurance-life",
    "reit-office",
    "railroads",
    "oil-gas-integrated",
    "healthcare-plans",
    "reit-healthcare-facilities",
    "discount-stores",
]
Sector = Literal[
    "Communication Services",
    "Consumer Cyclical",
    "Technology",
    "Industrials",
    "Healthcare",
    "Energy",
    "Consumer Defensive",
    "Basic Materials",
    "Real Estate",
    "Utilities",
    "Financial Services",
    "Conglomerates",
]
Europe = Literal["Germany", "Belgium", "France"]
Us = Literal["United states"]
WesternCountries = Literal["United kingdom", Europe, Us]
Country = Literal[
    WesternCountries,
    "Australia",
    "China",
    "Japan",
    "Poland",
    "Switzerland",
    "Canada",
    "Greece",
    "Spain",
    "Indonesia",
    "Netherlands",
    "British virgin islands",
    "Italy",
    "Hungary",
    "Austria",
    "Finland",
    "Sweden",
    "Bermuda",
    "Taiwan",
    "Israel",
    "Ukraine",
    "Singapore",
    "Jersey",
    "Ireland",
    "Luxembourg",
    "Cyprus",
    "Cayman islands",
    "Norway",
    "Denmark",
    "Hong kong",
    "New zealand",
    "Kazakhstan",
    "Nigeria",
    "Argentina",
    "Brazil",
    "Czech republic",
    "Mauritius",
    "South africa",
    "India",
    "Mexico",
    "Mongolia",
    "Slovenia",
    "Thailand",
    "Malaysia",
    "Costa rica",
    "Isle of man",
    "Egypt",
    "Turkey",
    "United arab emirates",
    "Colombia",
    "Gibraltar",
    "Malta",
    "Liechtenstein",
    "Guernsey",
    "Peru",
    "Estonia",
    "French guiana",
    "Portugal",
    "Uruguay",
    "Chile",
    "Martinique",
    "Monaco",
    "Panama",
    "Papua new guinea",
    "South korea",
    "Macau",
    "Gabon",
    "Romania",
    "Senegal",
    "Morocco",
    "Jordan",
    "Lithuania",
    "Dominican republic",
    "Reunion",
    "Zambia",
    "Cambodia",
    "Myanmar",
    "Bahamas",
    "Philippines",
    "Bangladesh",
    "Latvia",
    "Vietnam",
    "Iceland",
    "Azerbaijan",
    "Georgia",
    "Liberia",
    "Kenya",
]


HighGrowthIndustry = Literal[
    "Software - Infrastructure",
    "Software - Application",
    "Internet Retail",
    "Internet Content & Information",
    "Electronic Gaming & Multimedia",
    "Semiconductors",
    "Semiconductor Equipment & Materials",
    "Information Technology Services",
    "Communication Equipment",
    "Consumer Electronics",
    "Health Information Services",
    "Biotechnology",
    "Medical Devices",
    "Diagnostics & Research",
    "Medical Instruments & Supplies",
    "Drug Manufacturers - Specialty & Generic",
]

DefensiveIndustries = Literal[
    "Utilities - Independent Power Producers",
    "Utilities - Diversified",
    "Utilities - Renewable",
    "Utilities - Regulated Gas",
    "Utilities - Regulated Water",
    "Utilities - Regulated Electric",
    "Household & Personal Products",
    "Food Distribution",
    "Packaged Foods",
    "Grocery Stores",
    "Beverages - Non - Alcoholic",
    "Beverages - Brewers",
    "Confectioners",
    "Tobacco",
    "Paper & Paper Products",
    "Medical Devices",
    "Drug Manufacturers - Specialty & Generic",
    "Medical Instruments & Supplies",
    "Medical Distribution",
    "Medical Care Facilities",
    "Drug Manufacturers - General",
    "Healthcare Plans",
    "Pharmaceutical Retailers",
    "Waste Management",
    "Pollution & Treatment Controls",
    "Insurance Brokers",
    "Insurance - Property & Casualty",
    "Insurance - Specialty",
    "Insurance - Reinsurance",
    "Insurance - Diversified",
    "Insurance - Life",
]
