"""

Revision ID: 260fcff7212e
Revises: 4ee82b171449
Create Date: 2025-08-11 10:08:17.582390

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite

# revision identifiers, used by Alembic.
revision: str = "260fcff7212e"
down_revision: Union[str, None] = "4ee82b171449"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.add_column(sa.Column("sma_50_below_sma_200", sa.Date(), nullable=True))
        batch_op.add_column(sa.Column("price_below_sma_50", sa.Date(), nullable=True))
        batch_op.create_index(
            "ix_analysis_price_below_sma_50", ["price_below_sma_50"], unique=False
        )
        batch_op.create_index(
            "ix_analysis_sma_50_below_sma_200", ["sma_50_below_sma_200"], unique=False
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("analysis", schema=None) as batch_op:
        batch_op.drop_index("ix_analysis_sma_50_below_sma_200")
        batch_op.drop_index("ix_analysis_price_below_sma_50")
        batch_op.drop_column("price_below_sma_50")
        batch_op.drop_column("sma_50_below_sma_200")

    # ### end Alembic commands ###
