from mteb.abstasks.classification import AbsTaskClassification
from mteb.abstasks.task_metadata import TaskMetadata


class SanskritShlokasClassification(AbsTaskClassification):
    metadata = TaskMetadata(
        name="SanskritShlokasClassification",
        description="This data set contains ~500 Shlokas  ",
        reference="https://github.com/goru001/nlp-for-sanskrit",
        dataset={
            "path": "bpHigh/iNLTK_Sanskrit_Shlokas_Dataset",
            "revision": "5a79d6472db143690c7ce6e974995d3610eee7f0",
        },
        type="Classification",
        category="t2c",
        modalities=["text"],
        date=("2019-01-01", "2020-01-01"),
        eval_splits=["validation"],
        eval_langs=["san-Deva"],
        main_score="accuracy",
        domains=["Religious", "Written"],
        task_subtypes=["Topic classification"],
        license="cc-by-sa-4.0",
        annotations_creators="derived",
        dialect=[],
        sample_creation="found",
        bibtex_citation=r"""
@inproceedings{arora-2020-inltk,
  address = {Online},
  author = {Arora, Gaurav},
  booktitle = {Proceedings of Second Workshop for NLP Open Source Software (NLP-OSS)},
  doi = {10.18653/v1/2020.nlposs-1.10},
  editor = {Park, Eunjeong L.  and
Hagiwara, Masato  and
Milajevs, Dmitrijs  and
Liu, Nelson F.  and
Chauhan, Geeticka  and
Tan, Liling},
  month = nov,
  pages = {66--71},
  publisher = {Association for Computational Linguistics},
  title = {i{NLTK}: Natural Language Toolkit for Indic Languages},
  url = {https://aclanthology.org/2020.nlposs-1.10},
  year = {2020},
}
""",
    )

    def dataset_transform(self):
        self.dataset = self.dataset.rename_columns({"Sloka": "text", "Class": "label"})
