# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppleSiliconServerArgs', 'AppleSiliconServer']

@pulumi.input_type
class AppleSiliconServerArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 commitment: Optional[pulumi.Input[builtins.str]] = None,
                 enable_vpc: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input['AppleSiliconServerPrivateIpArgs']]]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input['AppleSiliconServerPrivateNetworkArgs']]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 public_bandwidth: Optional[pulumi.Input[builtins.int]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AppleSiliconServer resource.
        :param pulumi.Input[builtins.str] type: The commercial type of the server. You find all the available types on
               the [pricing page](https://www.scaleway.com/en/pricing/apple-silicon/). Updates to this field will recreate a new
               resource.
        :param pulumi.Input[builtins.str] commitment: The commitment period of the server
        :param pulumi.Input[builtins.bool] enable_vpc: : Enables the VPC option when set to true.
        :param pulumi.Input[builtins.str] name: The name of the server.
        :param pulumi.Input[Sequence[pulumi.Input['AppleSiliconServerPrivateIpArgs']]] private_ips: The list of private IPv4 and IPv6 addresses associated with the server.
        :param pulumi.Input[Sequence[pulumi.Input['AppleSiliconServerPrivateNetworkArgs']]] private_networks: The private networks to attach to the server
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the server is
               associated with.
        :param pulumi.Input[builtins.int] public_bandwidth: Configure the available public bandwidth for your server in bits per second. This option may not be available for all offers.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which
               the server should be created.
        """
        pulumi.set(__self__, "type", type)
        if commitment is not None:
            pulumi.set(__self__, "commitment", commitment)
        if enable_vpc is not None:
            pulumi.set(__self__, "enable_vpc", enable_vpc)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if private_networks is not None:
            pulumi.set(__self__, "private_networks", private_networks)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if public_bandwidth is not None:
            pulumi.set(__self__, "public_bandwidth", public_bandwidth)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The commercial type of the server. You find all the available types on
        the [pricing page](https://www.scaleway.com/en/pricing/apple-silicon/). Updates to this field will recreate a new
        resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def commitment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The commitment period of the server
        """
        return pulumi.get(self, "commitment")

    @commitment.setter
    def commitment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "commitment", value)

    @property
    @pulumi.getter(name="enableVpc")
    def enable_vpc(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        : Enables the VPC option when set to true.
        """
        return pulumi.get(self, "enable_vpc")

    @enable_vpc.setter
    def enable_vpc(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_vpc", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppleSiliconServerPrivateIpArgs']]]]:
        """
        The list of private IPv4 and IPv6 addresses associated with the server.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppleSiliconServerPrivateIpArgs']]]]):
        pulumi.set(self, "private_ips", value)

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppleSiliconServerPrivateNetworkArgs']]]]:
        """
        The private networks to attach to the server
        """
        return pulumi.get(self, "private_networks")

    @private_networks.setter
    def private_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppleSiliconServerPrivateNetworkArgs']]]]):
        pulumi.set(self, "private_networks", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project the server is
        associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="publicBandwidth")
    def public_bandwidth(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Configure the available public bandwidth for your server in bits per second. This option may not be available for all offers.
        """
        return pulumi.get(self, "public_bandwidth")

    @public_bandwidth.setter
    def public_bandwidth(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "public_bandwidth", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `zone`) The zone in which
        the server should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _AppleSiliconServerState:
    def __init__(__self__, *,
                 commitment: Optional[pulumi.Input[builtins.str]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 deletable_at: Optional[pulumi.Input[builtins.str]] = None,
                 enable_vpc: Optional[pulumi.Input[builtins.bool]] = None,
                 ip: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input['AppleSiliconServerPrivateIpArgs']]]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input['AppleSiliconServerPrivateNetworkArgs']]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 public_bandwidth: Optional[pulumi.Input[builtins.int]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 vnc_url: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_status: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppleSiliconServer resources.
        :param pulumi.Input[builtins.str] commitment: The commitment period of the server
        :param pulumi.Input[builtins.str] created_at: The date and time the private network was created.
        :param pulumi.Input[builtins.str] deletable_at: The minimal date and time on which you can delete this server due to Apple licence
        :param pulumi.Input[builtins.bool] enable_vpc: : Enables the VPC option when set to true.
        :param pulumi.Input[builtins.str] ip: IPv4 address of the server (IPv4 address).
        :param pulumi.Input[builtins.str] name: The name of the server.
        :param pulumi.Input[builtins.str] organization_id: The organization ID the server is associated with.
        :param pulumi.Input[builtins.str] password: The password of the server
        :param pulumi.Input[Sequence[pulumi.Input['AppleSiliconServerPrivateIpArgs']]] private_ips: The list of private IPv4 and IPv6 addresses associated with the server.
        :param pulumi.Input[Sequence[pulumi.Input['AppleSiliconServerPrivateNetworkArgs']]] private_networks: The private networks to attach to the server
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the server is
               associated with.
        :param pulumi.Input[builtins.int] public_bandwidth: Configure the available public bandwidth for your server in bits per second. This option may not be available for all offers.
        :param pulumi.Input[builtins.str] state: The state of the server.
        :param pulumi.Input[builtins.str] type: The commercial type of the server. You find all the available types on
               the [pricing page](https://www.scaleway.com/en/pricing/apple-silicon/). Updates to this field will recreate a new
               resource.
        :param pulumi.Input[builtins.str] updated_at: The date and time the private network was last updated.
        :param pulumi.Input[builtins.str] username: The username of the server
        :param pulumi.Input[builtins.str] vnc_url: URL of the VNC.
        :param pulumi.Input[builtins.str] vpc_status: The current status of the VPC option.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which
               the server should be created.
        """
        if commitment is not None:
            pulumi.set(__self__, "commitment", commitment)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if deletable_at is not None:
            pulumi.set(__self__, "deletable_at", deletable_at)
        if enable_vpc is not None:
            pulumi.set(__self__, "enable_vpc", enable_vpc)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if private_networks is not None:
            pulumi.set(__self__, "private_networks", private_networks)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if public_bandwidth is not None:
            pulumi.set(__self__, "public_bandwidth", public_bandwidth)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if vnc_url is not None:
            pulumi.set(__self__, "vnc_url", vnc_url)
        if vpc_status is not None:
            pulumi.set(__self__, "vpc_status", vpc_status)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def commitment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The commitment period of the server
        """
        return pulumi.get(self, "commitment")

    @commitment.setter
    def commitment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "commitment", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the private network was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="deletableAt")
    def deletable_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The minimal date and time on which you can delete this server due to Apple licence
        """
        return pulumi.get(self, "deletable_at")

    @deletable_at.setter
    def deletable_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deletable_at", value)

    @property
    @pulumi.getter(name="enableVpc")
    def enable_vpc(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        : Enables the VPC option when set to true.
        """
        return pulumi.get(self, "enable_vpc")

    @enable_vpc.setter
    def enable_vpc(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_vpc", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv4 address of the server (IPv4 address).
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The organization ID the server is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password of the server
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppleSiliconServerPrivateIpArgs']]]]:
        """
        The list of private IPv4 and IPv6 addresses associated with the server.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppleSiliconServerPrivateIpArgs']]]]):
        pulumi.set(self, "private_ips", value)

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppleSiliconServerPrivateNetworkArgs']]]]:
        """
        The private networks to attach to the server
        """
        return pulumi.get(self, "private_networks")

    @private_networks.setter
    def private_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppleSiliconServerPrivateNetworkArgs']]]]):
        pulumi.set(self, "private_networks", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project the server is
        associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="publicBandwidth")
    def public_bandwidth(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Configure the available public bandwidth for your server in bits per second. This option may not be available for all offers.
        """
        return pulumi.get(self, "public_bandwidth")

    @public_bandwidth.setter
    def public_bandwidth(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "public_bandwidth", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The state of the server.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The commercial type of the server. You find all the available types on
        the [pricing page](https://www.scaleway.com/en/pricing/apple-silicon/). Updates to this field will recreate a new
        resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the private network was last updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The username of the server
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="vncUrl")
    def vnc_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the VNC.
        """
        return pulumi.get(self, "vnc_url")

    @vnc_url.setter
    def vnc_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vnc_url", value)

    @property
    @pulumi.getter(name="vpcStatus")
    def vpc_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current status of the VPC option.
        """
        return pulumi.get(self, "vpc_status")

    @vpc_status.setter
    def vpc_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_status", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `zone`) The zone in which
        the server should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


warnings.warn("""scaleway.index/applesiliconserver.AppleSiliconServer has been deprecated in favor of scaleway.applesilicon/server.Server""", DeprecationWarning)


@pulumi.type_token("scaleway:index/appleSiliconServer:AppleSiliconServer")
class AppleSiliconServer(pulumi.CustomResource):
    warnings.warn("""scaleway.index/applesiliconserver.AppleSiliconServer has been deprecated in favor of scaleway.applesilicon/server.Server""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 commitment: Optional[pulumi.Input[builtins.str]] = None,
                 enable_vpc: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppleSiliconServerPrivateIpArgs', 'AppleSiliconServerPrivateIpArgsDict']]]]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppleSiliconServerPrivateNetworkArgs', 'AppleSiliconServerPrivateNetworkArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 public_bandwidth: Optional[pulumi.Input[builtins.int]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Apple silicon. For more information,
        see the [API documentation](https://www.scaleway.com/en/developers/api/apple-silicon/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        server = scaleway.applesilicon.Server("server",
            name="test-m1",
            type="M1-M")
        ```

        ### Enable VPC and attach private network

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc_apple_silicon = scaleway.network.Vpc("vpc-apple-silicon", name="vpc-apple-silicon")
        pn_apple_silicon = scaleway.network.PrivateNetwork("pn-apple-silicon",
            name="pn-apple-silicon",
            vpc_id=vpc_apple_silicon.id)
        my_server = scaleway.applesilicon.Server("my-server",
            name="TestAccServerEnableVPC",
            type="M2-M",
            enable_vpc=True,
            private_networks=[{
                "id": pn_apple_silicon.id,
            }])
        ```

        ## Import

        Instance servers can be imported using the `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/appleSiliconServer:AppleSiliconServer main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] commitment: The commitment period of the server
        :param pulumi.Input[builtins.bool] enable_vpc: : Enables the VPC option when set to true.
        :param pulumi.Input[builtins.str] name: The name of the server.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppleSiliconServerPrivateIpArgs', 'AppleSiliconServerPrivateIpArgsDict']]]] private_ips: The list of private IPv4 and IPv6 addresses associated with the server.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppleSiliconServerPrivateNetworkArgs', 'AppleSiliconServerPrivateNetworkArgsDict']]]] private_networks: The private networks to attach to the server
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the server is
               associated with.
        :param pulumi.Input[builtins.int] public_bandwidth: Configure the available public bandwidth for your server in bits per second. This option may not be available for all offers.
        :param pulumi.Input[builtins.str] type: The commercial type of the server. You find all the available types on
               the [pricing page](https://www.scaleway.com/en/pricing/apple-silicon/). Updates to this field will recreate a new
               resource.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which
               the server should be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppleSiliconServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Apple silicon. For more information,
        see the [API documentation](https://www.scaleway.com/en/developers/api/apple-silicon/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        server = scaleway.applesilicon.Server("server",
            name="test-m1",
            type="M1-M")
        ```

        ### Enable VPC and attach private network

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        vpc_apple_silicon = scaleway.network.Vpc("vpc-apple-silicon", name="vpc-apple-silicon")
        pn_apple_silicon = scaleway.network.PrivateNetwork("pn-apple-silicon",
            name="pn-apple-silicon",
            vpc_id=vpc_apple_silicon.id)
        my_server = scaleway.applesilicon.Server("my-server",
            name="TestAccServerEnableVPC",
            type="M2-M",
            enable_vpc=True,
            private_networks=[{
                "id": pn_apple_silicon.id,
            }])
        ```

        ## Import

        Instance servers can be imported using the `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/appleSiliconServer:AppleSiliconServer main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param AppleSiliconServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppleSiliconServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 commitment: Optional[pulumi.Input[builtins.str]] = None,
                 enable_vpc: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppleSiliconServerPrivateIpArgs', 'AppleSiliconServerPrivateIpArgsDict']]]]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppleSiliconServerPrivateNetworkArgs', 'AppleSiliconServerPrivateNetworkArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 public_bandwidth: Optional[pulumi.Input[builtins.int]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""AppleSiliconServer is deprecated: scaleway.index/applesiliconserver.AppleSiliconServer has been deprecated in favor of scaleway.applesilicon/server.Server""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppleSiliconServerArgs.__new__(AppleSiliconServerArgs)

            __props__.__dict__["commitment"] = commitment
            __props__.__dict__["enable_vpc"] = enable_vpc
            __props__.__dict__["name"] = name
            __props__.__dict__["private_ips"] = private_ips
            __props__.__dict__["private_networks"] = private_networks
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["public_bandwidth"] = public_bandwidth
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["zone"] = zone
            __props__.__dict__["created_at"] = None
            __props__.__dict__["deletable_at"] = None
            __props__.__dict__["ip"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["password"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["username"] = None
            __props__.__dict__["vnc_url"] = None
            __props__.__dict__["vpc_status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AppleSiliconServer, __self__).__init__(
            'scaleway:index/appleSiliconServer:AppleSiliconServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            commitment: Optional[pulumi.Input[builtins.str]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            deletable_at: Optional[pulumi.Input[builtins.str]] = None,
            enable_vpc: Optional[pulumi.Input[builtins.bool]] = None,
            ip: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            organization_id: Optional[pulumi.Input[builtins.str]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppleSiliconServerPrivateIpArgs', 'AppleSiliconServerPrivateIpArgsDict']]]]] = None,
            private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppleSiliconServerPrivateNetworkArgs', 'AppleSiliconServerPrivateNetworkArgsDict']]]]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            public_bandwidth: Optional[pulumi.Input[builtins.int]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None,
            username: Optional[pulumi.Input[builtins.str]] = None,
            vnc_url: Optional[pulumi.Input[builtins.str]] = None,
            vpc_status: Optional[pulumi.Input[builtins.str]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'AppleSiliconServer':
        """
        Get an existing AppleSiliconServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] commitment: The commitment period of the server
        :param pulumi.Input[builtins.str] created_at: The date and time the private network was created.
        :param pulumi.Input[builtins.str] deletable_at: The minimal date and time on which you can delete this server due to Apple licence
        :param pulumi.Input[builtins.bool] enable_vpc: : Enables the VPC option when set to true.
        :param pulumi.Input[builtins.str] ip: IPv4 address of the server (IPv4 address).
        :param pulumi.Input[builtins.str] name: The name of the server.
        :param pulumi.Input[builtins.str] organization_id: The organization ID the server is associated with.
        :param pulumi.Input[builtins.str] password: The password of the server
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppleSiliconServerPrivateIpArgs', 'AppleSiliconServerPrivateIpArgsDict']]]] private_ips: The list of private IPv4 and IPv6 addresses associated with the server.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppleSiliconServerPrivateNetworkArgs', 'AppleSiliconServerPrivateNetworkArgsDict']]]] private_networks: The private networks to attach to the server
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the server is
               associated with.
        :param pulumi.Input[builtins.int] public_bandwidth: Configure the available public bandwidth for your server in bits per second. This option may not be available for all offers.
        :param pulumi.Input[builtins.str] state: The state of the server.
        :param pulumi.Input[builtins.str] type: The commercial type of the server. You find all the available types on
               the [pricing page](https://www.scaleway.com/en/pricing/apple-silicon/). Updates to this field will recreate a new
               resource.
        :param pulumi.Input[builtins.str] updated_at: The date and time the private network was last updated.
        :param pulumi.Input[builtins.str] username: The username of the server
        :param pulumi.Input[builtins.str] vnc_url: URL of the VNC.
        :param pulumi.Input[builtins.str] vpc_status: The current status of the VPC option.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which
               the server should be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppleSiliconServerState.__new__(_AppleSiliconServerState)

        __props__.__dict__["commitment"] = commitment
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["deletable_at"] = deletable_at
        __props__.__dict__["enable_vpc"] = enable_vpc
        __props__.__dict__["ip"] = ip
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["password"] = password
        __props__.__dict__["private_ips"] = private_ips
        __props__.__dict__["private_networks"] = private_networks
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["public_bandwidth"] = public_bandwidth
        __props__.__dict__["state"] = state
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["username"] = username
        __props__.__dict__["vnc_url"] = vnc_url
        __props__.__dict__["vpc_status"] = vpc_status
        __props__.__dict__["zone"] = zone
        return AppleSiliconServer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def commitment(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The commitment period of the server
        """
        return pulumi.get(self, "commitment")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the private network was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="deletableAt")
    def deletable_at(self) -> pulumi.Output[builtins.str]:
        """
        The minimal date and time on which you can delete this server due to Apple licence
        """
        return pulumi.get(self, "deletable_at")

    @property
    @pulumi.getter(name="enableVpc")
    def enable_vpc(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        : Enables the VPC option when set to true.
        """
        return pulumi.get(self, "enable_vpc")

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Output[builtins.str]:
        """
        IPv4 address of the server (IPv4 address).
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[builtins.str]:
        """
        The organization ID the server is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[builtins.str]:
        """
        The password of the server
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> pulumi.Output[Sequence['outputs.AppleSiliconServerPrivateIp']]:
        """
        The list of private IPv4 and IPv6 addresses associated with the server.
        """
        return pulumi.get(self, "private_ips")

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> pulumi.Output[Optional[Sequence['outputs.AppleSiliconServerPrivateNetwork']]]:
        """
        The private networks to attach to the server
        """
        return pulumi.get(self, "private_networks")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        `project_id`) The ID of the project the server is
        associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="publicBandwidth")
    def public_bandwidth(self) -> pulumi.Output[builtins.int]:
        """
        Configure the available public bandwidth for your server in bits per second. This option may not be available for all offers.
        """
        return pulumi.get(self, "public_bandwidth")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The state of the server.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The commercial type of the server. You find all the available types on
        the [pricing page](https://www.scaleway.com/en/pricing/apple-silicon/). Updates to this field will recreate a new
        resource.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the private network was last updated.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[builtins.str]:
        """
        The username of the server
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="vncUrl")
    def vnc_url(self) -> pulumi.Output[builtins.str]:
        """
        URL of the VNC.
        """
        return pulumi.get(self, "vnc_url")

    @property
    @pulumi.getter(name="vpcStatus")
    def vpc_status(self) -> pulumi.Output[builtins.str]:
        """
        The current status of the VPC option.
        """
        return pulumi.get(self, "vpc_status")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        `zone`) The zone in which
        the server should be created.
        """
        return pulumi.get(self, "zone")

