# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceGroupArgs', 'InstanceGroup']

@pulumi.input_type
class InstanceGroupArgs:
    def __init__(__self__, *,
                 template_id: pulumi.Input[builtins.str],
                 capacities: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupCapacityArgs']]]] = None,
                 delete_servers_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupLoadBalancerArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a InstanceGroup resource.
        :param pulumi.Input[builtins.str] template_id: The ID of the Instance template to attach to the Instance group.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceGroupCapacityArgs']]] capacities: The specification of the minimum and maximum replicas for the Instance group, and the cooldown interval between two scaling events.
        :param pulumi.Input[builtins.bool] delete_servers_on_destroy: Whether to delete all instances in this group when the group is destroyed. Set to `true` to tear them down, `false` (the default) leaves them running.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceGroupLoadBalancerArgs']]] load_balancers: The specification of the Load Balancer to link to the Instance group.
        :param pulumi.Input[builtins.str] name: The Instance group name.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project the Instance group is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the Instance group.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which the Instance group exists.
        """
        pulumi.set(__self__, "template_id", template_id)
        if capacities is not None:
            pulumi.set(__self__, "capacities", capacities)
        if delete_servers_on_destroy is not None:
            pulumi.set(__self__, "delete_servers_on_destroy", delete_servers_on_destroy)
        if load_balancers is not None:
            pulumi.set(__self__, "load_balancers", load_balancers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Instance template to attach to the Instance group.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "template_id", value)

    @property
    @pulumi.getter
    def capacities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupCapacityArgs']]]]:
        """
        The specification of the minimum and maximum replicas for the Instance group, and the cooldown interval between two scaling events.
        """
        return pulumi.get(self, "capacities")

    @capacities.setter
    def capacities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupCapacityArgs']]]]):
        pulumi.set(self, "capacities", value)

    @property
    @pulumi.getter(name="deleteServersOnDestroy")
    def delete_servers_on_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to delete all instances in this group when the group is destroyed. Set to `true` to tear them down, `false` (the default) leaves them running.
        """
        return pulumi.get(self, "delete_servers_on_destroy")

    @delete_servers_on_destroy.setter
    def delete_servers_on_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_servers_on_destroy", value)

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupLoadBalancerArgs']]]]:
        """
        The specification of the Load Balancer to link to the Instance group.
        """
        return pulumi.get(self, "load_balancers")

    @load_balancers.setter
    def load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupLoadBalancerArgs']]]]):
        pulumi.set(self, "load_balancers", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Instance group name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the Project the Instance group is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags associated with the Instance group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `zone`) The zone in which the Instance group exists.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _InstanceGroupState:
    def __init__(__self__, *,
                 capacities: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupCapacityArgs']]]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 delete_servers_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupLoadBalancerArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 template_id: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering InstanceGroup resources.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceGroupCapacityArgs']]] capacities: The specification of the minimum and maximum replicas for the Instance group, and the cooldown interval between two scaling events.
        :param pulumi.Input[builtins.str] created_at: Date and time of Instance group's creation (RFC 3339 format).
        :param pulumi.Input[builtins.bool] delete_servers_on_destroy: Whether to delete all instances in this group when the group is destroyed. Set to `true` to tear them down, `false` (the default) leaves them running.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceGroupLoadBalancerArgs']]] load_balancers: The specification of the Load Balancer to link to the Instance group.
        :param pulumi.Input[builtins.str] name: The Instance group name.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project the Instance group is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the Instance group.
        :param pulumi.Input[builtins.str] template_id: The ID of the Instance template to attach to the Instance group.
        :param pulumi.Input[builtins.str] updated_at: Date and time of Instance group's last update (RFC 3339 format).
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which the Instance group exists.
        """
        if capacities is not None:
            pulumi.set(__self__, "capacities", capacities)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if delete_servers_on_destroy is not None:
            pulumi.set(__self__, "delete_servers_on_destroy", delete_servers_on_destroy)
        if load_balancers is not None:
            pulumi.set(__self__, "load_balancers", load_balancers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def capacities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupCapacityArgs']]]]:
        """
        The specification of the minimum and maximum replicas for the Instance group, and the cooldown interval between two scaling events.
        """
        return pulumi.get(self, "capacities")

    @capacities.setter
    def capacities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupCapacityArgs']]]]):
        pulumi.set(self, "capacities", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date and time of Instance group's creation (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="deleteServersOnDestroy")
    def delete_servers_on_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to delete all instances in this group when the group is destroyed. Set to `true` to tear them down, `false` (the default) leaves them running.
        """
        return pulumi.get(self, "delete_servers_on_destroy")

    @delete_servers_on_destroy.setter
    def delete_servers_on_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_servers_on_destroy", value)

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupLoadBalancerArgs']]]]:
        """
        The specification of the Load Balancer to link to the Instance group.
        """
        return pulumi.get(self, "load_balancers")

    @load_balancers.setter
    def load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupLoadBalancerArgs']]]]):
        pulumi.set(self, "load_balancers", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Instance group name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the Project the Instance group is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The tags associated with the Instance group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Instance template to attach to the Instance group.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_id", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Date and time of Instance group's last update (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `zone`) The zone in which the Instance group exists.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("scaleway:autoscaling/instanceGroup:InstanceGroup")
class InstanceGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupCapacityArgs', 'InstanceGroupCapacityArgsDict']]]]] = None,
                 delete_servers_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupLoadBalancerArgs', 'InstanceGroupLoadBalancerArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 template_id: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Books and manages Autoscaling Instance groups.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.autoscaling.InstanceGroup("main",
            name="asg-group",
            template_id=main_scaleway_autoscaling_instance_template["id"],
            tags=[
                "terraform-test",
                "instance-group",
            ],
            capacities=[{
                "max_replicas": 5,
                "min_replicas": 1,
                "cooldown_delay": 300,
            }],
            load_balancers=[{
                "id": main_scaleway_lb["id"],
                "backend_ids": [main_scaleway_lb_backend["id"]],
                "private_network_id": main_scaleway_vpc_private_network["id"],
            }])
        ```

        ### With template and policies

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.network.Vpc("main", name="TestAccAutoscalingVPC")
        main_private_network = scaleway.network.PrivateNetwork("main",
            name="TestAccAutoscalingVPC",
            vpc_id=main.id)
        main_volume = scaleway.block.Volume("main",
            iops=5000,
            size_in_gb=10)
        main_snapshot = scaleway.block.Snapshot("main",
            name="test-ds-block-snapshot-basic",
            volume_id=main_volume.id)
        main_ip = scaleway.loadbalancers.Ip("main")
        main_load_balancer = scaleway.loadbalancers.LoadBalancer("main",
            ip_id=main_ip.id,
            name="test-lb",
            type="lb-s",
            private_networks=[{
                "private_network_id": main_private_network.id,
            }])
        main_backend = scaleway.loadbalancers.Backend("main",
            lb_id=main_load_balancer.id,
            forward_protocol="tcp",
            forward_port=80,
            proxy_protocol="none")
        main_instance_template = scaleway.autoscaling.InstanceTemplate("main",
            name="autoscaling-instance-template-basic",
            commercial_type="PLAY2-MICRO",
            tags=[
                "terraform-test",
                "basic",
            ],
            volumes=[{
                "name": "as-volume",
                "volume_type": "sbs",
                "boot": True,
                "from_snapshot": {
                    "snapshot_id": main_snapshot.id,
                },
                "perf_iops": 5000,
            }],
            public_ips_v4_count=1,
            private_network_ids=[main_private_network.id])
        main_instance_group = scaleway.autoscaling.InstanceGroup("main",
            name="autoscaling-instance-group-basic",
            template_id=main_instance_template.id,
            tags=[
                "terraform-test",
                "instance-group",
            ],
            capacities=[{
                "max_replicas": 5,
                "min_replicas": 1,
                "cooldown_delay": 300,
            }],
            load_balancers=[{
                "id": main_load_balancer.id,
                "backend_ids": [main_backend.id],
                "private_network_id": main_private_network.id,
            }],
            delete_servers_on_destroy=True)
        up = scaleway.autoscaling.InstancePolicy("up",
            instance_group_id=main_instance_group.id,
            name="scale-up-if-cpu-high",
            action="scale_up",
            type="flat_count",
            value=1,
            priority=1,
            metrics=[{
                "name": "cpu scale up",
                "managed_metric": "managed_metric_instance_cpu",
                "operator": "operator_greater_than",
                "aggregate": "aggregate_average",
                "sampling_range_min": 5,
                "threshold": 70,
            }])
        down = scaleway.autoscaling.InstancePolicy("down",
            instance_group_id=main_instance_group.id,
            name="scale-down-if-cpu-low",
            action="scale_down",
            type="flat_count",
            value=1,
            priority=2,
            metrics=[{
                "name": "cpu scale down",
                "managed_metric": "managed_metric_instance_cpu",
                "operator": "operator_less_than",
                "aggregate": "aggregate_average",
                "sampling_range_min": 5,
                "threshold": 40,
            }])
        ```

        ## Import

        Autoscaling Instance groups can be imported using `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:autoscaling/instanceGroup:InstanceGroup main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupCapacityArgs', 'InstanceGroupCapacityArgsDict']]]] capacities: The specification of the minimum and maximum replicas for the Instance group, and the cooldown interval between two scaling events.
        :param pulumi.Input[builtins.bool] delete_servers_on_destroy: Whether to delete all instances in this group when the group is destroyed. Set to `true` to tear them down, `false` (the default) leaves them running.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupLoadBalancerArgs', 'InstanceGroupLoadBalancerArgsDict']]]] load_balancers: The specification of the Load Balancer to link to the Instance group.
        :param pulumi.Input[builtins.str] name: The Instance group name.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project the Instance group is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the Instance group.
        :param pulumi.Input[builtins.str] template_id: The ID of the Instance template to attach to the Instance group.
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which the Instance group exists.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Books and manages Autoscaling Instance groups.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.autoscaling.InstanceGroup("main",
            name="asg-group",
            template_id=main_scaleway_autoscaling_instance_template["id"],
            tags=[
                "terraform-test",
                "instance-group",
            ],
            capacities=[{
                "max_replicas": 5,
                "min_replicas": 1,
                "cooldown_delay": 300,
            }],
            load_balancers=[{
                "id": main_scaleway_lb["id"],
                "backend_ids": [main_scaleway_lb_backend["id"]],
                "private_network_id": main_scaleway_vpc_private_network["id"],
            }])
        ```

        ### With template and policies

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.network.Vpc("main", name="TestAccAutoscalingVPC")
        main_private_network = scaleway.network.PrivateNetwork("main",
            name="TestAccAutoscalingVPC",
            vpc_id=main.id)
        main_volume = scaleway.block.Volume("main",
            iops=5000,
            size_in_gb=10)
        main_snapshot = scaleway.block.Snapshot("main",
            name="test-ds-block-snapshot-basic",
            volume_id=main_volume.id)
        main_ip = scaleway.loadbalancers.Ip("main")
        main_load_balancer = scaleway.loadbalancers.LoadBalancer("main",
            ip_id=main_ip.id,
            name="test-lb",
            type="lb-s",
            private_networks=[{
                "private_network_id": main_private_network.id,
            }])
        main_backend = scaleway.loadbalancers.Backend("main",
            lb_id=main_load_balancer.id,
            forward_protocol="tcp",
            forward_port=80,
            proxy_protocol="none")
        main_instance_template = scaleway.autoscaling.InstanceTemplate("main",
            name="autoscaling-instance-template-basic",
            commercial_type="PLAY2-MICRO",
            tags=[
                "terraform-test",
                "basic",
            ],
            volumes=[{
                "name": "as-volume",
                "volume_type": "sbs",
                "boot": True,
                "from_snapshot": {
                    "snapshot_id": main_snapshot.id,
                },
                "perf_iops": 5000,
            }],
            public_ips_v4_count=1,
            private_network_ids=[main_private_network.id])
        main_instance_group = scaleway.autoscaling.InstanceGroup("main",
            name="autoscaling-instance-group-basic",
            template_id=main_instance_template.id,
            tags=[
                "terraform-test",
                "instance-group",
            ],
            capacities=[{
                "max_replicas": 5,
                "min_replicas": 1,
                "cooldown_delay": 300,
            }],
            load_balancers=[{
                "id": main_load_balancer.id,
                "backend_ids": [main_backend.id],
                "private_network_id": main_private_network.id,
            }],
            delete_servers_on_destroy=True)
        up = scaleway.autoscaling.InstancePolicy("up",
            instance_group_id=main_instance_group.id,
            name="scale-up-if-cpu-high",
            action="scale_up",
            type="flat_count",
            value=1,
            priority=1,
            metrics=[{
                "name": "cpu scale up",
                "managed_metric": "managed_metric_instance_cpu",
                "operator": "operator_greater_than",
                "aggregate": "aggregate_average",
                "sampling_range_min": 5,
                "threshold": 70,
            }])
        down = scaleway.autoscaling.InstancePolicy("down",
            instance_group_id=main_instance_group.id,
            name="scale-down-if-cpu-low",
            action="scale_down",
            type="flat_count",
            value=1,
            priority=2,
            metrics=[{
                "name": "cpu scale down",
                "managed_metric": "managed_metric_instance_cpu",
                "operator": "operator_less_than",
                "aggregate": "aggregate_average",
                "sampling_range_min": 5,
                "threshold": 40,
            }])
        ```

        ## Import

        Autoscaling Instance groups can be imported using `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:autoscaling/instanceGroup:InstanceGroup main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param InstanceGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupCapacityArgs', 'InstanceGroupCapacityArgsDict']]]]] = None,
                 delete_servers_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupLoadBalancerArgs', 'InstanceGroupLoadBalancerArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 template_id: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceGroupArgs.__new__(InstanceGroupArgs)

            __props__.__dict__["capacities"] = capacities
            __props__.__dict__["delete_servers_on_destroy"] = delete_servers_on_destroy
            __props__.__dict__["load_balancers"] = load_balancers
            __props__.__dict__["name"] = name
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["tags"] = tags
            if template_id is None and not opts.urn:
                raise TypeError("Missing required property 'template_id'")
            __props__.__dict__["template_id"] = template_id
            __props__.__dict__["zone"] = zone
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        super(InstanceGroup, __self__).__init__(
            'scaleway:autoscaling/instanceGroup:InstanceGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capacities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupCapacityArgs', 'InstanceGroupCapacityArgsDict']]]]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            delete_servers_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
            load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupLoadBalancerArgs', 'InstanceGroupLoadBalancerArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            template_id: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'InstanceGroup':
        """
        Get an existing InstanceGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupCapacityArgs', 'InstanceGroupCapacityArgsDict']]]] capacities: The specification of the minimum and maximum replicas for the Instance group, and the cooldown interval between two scaling events.
        :param pulumi.Input[builtins.str] created_at: Date and time of Instance group's creation (RFC 3339 format).
        :param pulumi.Input[builtins.bool] delete_servers_on_destroy: Whether to delete all instances in this group when the group is destroyed. Set to `true` to tear them down, `false` (the default) leaves them running.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupLoadBalancerArgs', 'InstanceGroupLoadBalancerArgsDict']]]] load_balancers: The specification of the Load Balancer to link to the Instance group.
        :param pulumi.Input[builtins.str] name: The Instance group name.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project the Instance group is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The tags associated with the Instance group.
        :param pulumi.Input[builtins.str] template_id: The ID of the Instance template to attach to the Instance group.
        :param pulumi.Input[builtins.str] updated_at: Date and time of Instance group's last update (RFC 3339 format).
        :param pulumi.Input[builtins.str] zone: `zone`) The zone in which the Instance group exists.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceGroupState.__new__(_InstanceGroupState)

        __props__.__dict__["capacities"] = capacities
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["delete_servers_on_destroy"] = delete_servers_on_destroy
        __props__.__dict__["load_balancers"] = load_balancers
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["template_id"] = template_id
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["zone"] = zone
        return InstanceGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def capacities(self) -> pulumi.Output[Sequence['outputs.InstanceGroupCapacity']]:
        """
        The specification of the minimum and maximum replicas for the Instance group, and the cooldown interval between two scaling events.
        """
        return pulumi.get(self, "capacities")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Date and time of Instance group's creation (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="deleteServersOnDestroy")
    def delete_servers_on_destroy(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to delete all instances in this group when the group is destroyed. Set to `true` to tear them down, `false` (the default) leaves them running.
        """
        return pulumi.get(self, "delete_servers_on_destroy")

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> pulumi.Output[Sequence['outputs.InstanceGroupLoadBalancer']]:
        """
        The specification of the Load Balancer to link to the Instance group.
        """
        return pulumi.get(self, "load_balancers")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The Instance group name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        `project_id`) The ID of the Project the Instance group is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The tags associated with the Instance group.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Instance template to attach to the Instance group.
        """
        return pulumi.get(self, "template_id")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        Date and time of Instance group's last update (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        `zone`) The zone in which the Instance group exists.
        """
        return pulumi.get(self, "zone")

