# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'InstanceGroupCapacity',
    'InstanceGroupLoadBalancer',
    'InstancePolicyMetric',
    'InstanceTemplateVolume',
    'InstanceTemplateVolumeFromEmpty',
    'InstanceTemplateVolumeFromSnapshot',
]

@pulumi.output_type
class InstanceGroupCapacity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cooldownDelay":
            suggest = "cooldown_delay"
        elif key == "maxReplicas":
            suggest = "max_replicas"
        elif key == "minReplicas":
            suggest = "min_replicas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceGroupCapacity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceGroupCapacity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceGroupCapacity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cooldown_delay: Optional[builtins.int] = None,
                 max_replicas: Optional[builtins.int] = None,
                 min_replicas: Optional[builtins.int] = None):
        """
        :param builtins.int cooldown_delay: Time (in seconds) after a scaling action during which requests to carry out a new scaling action will be denied.
        :param builtins.int max_replicas: The maximum count of Instances for the Instance group.
        :param builtins.int min_replicas: The minimum count of Instances for the Instance group.
        """
        if cooldown_delay is not None:
            pulumi.set(__self__, "cooldown_delay", cooldown_delay)
        if max_replicas is not None:
            pulumi.set(__self__, "max_replicas", max_replicas)
        if min_replicas is not None:
            pulumi.set(__self__, "min_replicas", min_replicas)

    @property
    @pulumi.getter(name="cooldownDelay")
    def cooldown_delay(self) -> Optional[builtins.int]:
        """
        Time (in seconds) after a scaling action during which requests to carry out a new scaling action will be denied.
        """
        return pulumi.get(self, "cooldown_delay")

    @property
    @pulumi.getter(name="maxReplicas")
    def max_replicas(self) -> Optional[builtins.int]:
        """
        The maximum count of Instances for the Instance group.
        """
        return pulumi.get(self, "max_replicas")

    @property
    @pulumi.getter(name="minReplicas")
    def min_replicas(self) -> Optional[builtins.int]:
        """
        The minimum count of Instances for the Instance group.
        """
        return pulumi.get(self, "min_replicas")


@pulumi.output_type
class InstanceGroupLoadBalancer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backendIds":
            suggest = "backend_ids"
        elif key == "privateNetworkId":
            suggest = "private_network_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceGroupLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceGroupLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceGroupLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backend_ids: Optional[Sequence[builtins.str]] = None,
                 id: Optional[builtins.str] = None,
                 private_network_id: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] backend_ids: The Load Balancer backend IDs.
        :param builtins.str id: The ID of the Load Balancer.
        :param builtins.str private_network_id: The ID of the Private Network attached to the Load Balancer.
        """
        if backend_ids is not None:
            pulumi.set(__self__, "backend_ids", backend_ids)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if private_network_id is not None:
            pulumi.set(__self__, "private_network_id", private_network_id)

    @property
    @pulumi.getter(name="backendIds")
    def backend_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The Load Balancer backend IDs.
        """
        return pulumi.get(self, "backend_ids")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the Load Balancer.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> Optional[builtins.str]:
        """
        The ID of the Private Network attached to the Load Balancer.
        """
        return pulumi.get(self, "private_network_id")


@pulumi.output_type
class InstancePolicyMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cockpitMetricName":
            suggest = "cockpit_metric_name"
        elif key == "managedMetric":
            suggest = "managed_metric"
        elif key == "samplingRangeMin":
            suggest = "sampling_range_min"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePolicyMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePolicyMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePolicyMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aggregate: builtins.str,
                 name: builtins.str,
                 operator: builtins.str,
                 cockpit_metric_name: Optional[builtins.str] = None,
                 managed_metric: Optional[builtins.str] = None,
                 sampling_range_min: Optional[builtins.int] = None,
                 threshold: Optional[builtins.int] = None):
        """
        :param builtins.str aggregate: How the values sampled for the `metric` should be aggregated.
        :param builtins.str name: Name or description of the metric policy.
        :param builtins.str operator: Operator used when comparing the threshold value of the chosen `metric` to the actual sampled and aggregated value.
        :param builtins.str cockpit_metric_name: The custom metric to use for this policy. This must be stored in Scaleway Cockpit. The metric forms the basis of the condition that will be checked to determine whether a scaling action should be triggered
        :param builtins.str managed_metric: The managed metric to use for this policy. These are available by default in Cockpit without any configuration or `node_exporter`. The chosen metric forms the basis of the condition that will be checked to determine whether a scaling action should be triggered.
        :param builtins.int sampling_range_min: The Interval of time, in minutes, during which metric is sampled.
        :param builtins.int threshold: The threshold value to measure the aggregated sampled `metric` value against. Combined with the `operator` field, determines whether a scaling action should be triggered.
        """
        pulumi.set(__self__, "aggregate", aggregate)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        if cockpit_metric_name is not None:
            pulumi.set(__self__, "cockpit_metric_name", cockpit_metric_name)
        if managed_metric is not None:
            pulumi.set(__self__, "managed_metric", managed_metric)
        if sampling_range_min is not None:
            pulumi.set(__self__, "sampling_range_min", sampling_range_min)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter
    def aggregate(self) -> builtins.str:
        """
        How the values sampled for the `metric` should be aggregated.
        """
        return pulumi.get(self, "aggregate")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name or description of the metric policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def operator(self) -> builtins.str:
        """
        Operator used when comparing the threshold value of the chosen `metric` to the actual sampled and aggregated value.
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter(name="cockpitMetricName")
    def cockpit_metric_name(self) -> Optional[builtins.str]:
        """
        The custom metric to use for this policy. This must be stored in Scaleway Cockpit. The metric forms the basis of the condition that will be checked to determine whether a scaling action should be triggered
        """
        return pulumi.get(self, "cockpit_metric_name")

    @property
    @pulumi.getter(name="managedMetric")
    def managed_metric(self) -> Optional[builtins.str]:
        """
        The managed metric to use for this policy. These are available by default in Cockpit without any configuration or `node_exporter`. The chosen metric forms the basis of the condition that will be checked to determine whether a scaling action should be triggered.
        """
        return pulumi.get(self, "managed_metric")

    @property
    @pulumi.getter(name="samplingRangeMin")
    def sampling_range_min(self) -> Optional[builtins.int]:
        """
        The Interval of time, in minutes, during which metric is sampled.
        """
        return pulumi.get(self, "sampling_range_min")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[builtins.int]:
        """
        The threshold value to measure the aggregated sampled `metric` value against. Combined with the `operator` field, determines whether a scaling action should be triggered.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class InstanceTemplateVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeType":
            suggest = "volume_type"
        elif key == "fromEmpty":
            suggest = "from_empty"
        elif key == "fromSnapshot":
            suggest = "from_snapshot"
        elif key == "perfIops":
            suggest = "perf_iops"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceTemplateVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceTemplateVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceTemplateVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 volume_type: builtins.str,
                 boot: Optional[builtins.bool] = None,
                 from_empty: Optional['outputs.InstanceTemplateVolumeFromEmpty'] = None,
                 from_snapshot: Optional['outputs.InstanceTemplateVolumeFromSnapshot'] = None,
                 perf_iops: Optional[builtins.int] = None,
                 tags: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str name: The name of the volume.
        :param builtins.str volume_type: The type of the volume.
        :param builtins.bool boot: Force the Instance to boot on this volume.
        :param 'InstanceTemplateVolumeFromEmptyArgs' from_empty: Volume instance template from empty
        :param 'InstanceTemplateVolumeFromSnapshotArgs' from_snapshot: Volume instance template from snapshot
        :param builtins.int perf_iops: The maximum IO/s expected, according to the different options available in stock (`5000 | 15000`).
        :param Sequence[builtins.str] tags: The list of tags assigned to the volume.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "volume_type", volume_type)
        if boot is not None:
            pulumi.set(__self__, "boot", boot)
        if from_empty is not None:
            pulumi.set(__self__, "from_empty", from_empty)
        if from_snapshot is not None:
            pulumi.set(__self__, "from_snapshot", from_snapshot)
        if perf_iops is not None:
            pulumi.set(__self__, "perf_iops", perf_iops)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the volume.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> builtins.str:
        """
        The type of the volume.
        """
        return pulumi.get(self, "volume_type")

    @property
    @pulumi.getter
    def boot(self) -> Optional[builtins.bool]:
        """
        Force the Instance to boot on this volume.
        """
        return pulumi.get(self, "boot")

    @property
    @pulumi.getter(name="fromEmpty")
    def from_empty(self) -> Optional['outputs.InstanceTemplateVolumeFromEmpty']:
        """
        Volume instance template from empty
        """
        return pulumi.get(self, "from_empty")

    @property
    @pulumi.getter(name="fromSnapshot")
    def from_snapshot(self) -> Optional['outputs.InstanceTemplateVolumeFromSnapshot']:
        """
        Volume instance template from snapshot
        """
        return pulumi.get(self, "from_snapshot")

    @property
    @pulumi.getter(name="perfIops")
    def perf_iops(self) -> Optional[builtins.int]:
        """
        The maximum IO/s expected, according to the different options available in stock (`5000 | 15000`).
        """
        return pulumi.get(self, "perf_iops")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of tags assigned to the volume.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class InstanceTemplateVolumeFromEmpty(dict):
    def __init__(__self__, *,
                 size: builtins.int):
        """
        :param builtins.int size: Size in GB of the new empty volume
        """
        pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def size(self) -> builtins.int:
        """
        Size in GB of the new empty volume
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class InstanceTemplateVolumeFromSnapshot(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotId":
            suggest = "snapshot_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceTemplateVolumeFromSnapshot. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceTemplateVolumeFromSnapshot.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceTemplateVolumeFromSnapshot.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshot_id: builtins.str,
                 size: Optional[builtins.int] = None):
        """
        :param builtins.str snapshot_id: ID of the snapshot to clone
        :param builtins.int size: Override size (in GB) of the cloned volume
        """
        pulumi.set(__self__, "snapshot_id", snapshot_id)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> builtins.str:
        """
        ID of the snapshot to clone
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter
    def size(self) -> Optional[builtins.int]:
        """
        Override size (in GB) of the cloned volume
        """
        return pulumi.get(self, "size")


