# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SnapshotArgs', 'Snapshot']

@pulumi.input_type
class SnapshotArgs:
    def __init__(__self__, *,
                 export: Optional[pulumi.Input['SnapshotExportArgs']] = None,
                 import_: Optional[pulumi.Input['SnapshotImportArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 volume_id: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Snapshot resource.
        :param pulumi.Input['SnapshotExportArgs'] export: Use this block to export the volume as a QCOW file to Object Storage.
        :param pulumi.Input['SnapshotImportArgs'] import_: Use this block to import a QCOW image from Object Storage to create a volume.
        :param pulumi.Input[builtins.str] name: The name of the snapshot. If not provided, a name will be randomly generated.
        :param pulumi.Input[builtins.str] project_id: ). The ID of the Scaleway Project the snapshot is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of tags to apply to the snapshot.
        :param pulumi.Input[builtins.str] volume_id: The ID of the volume to take a snapshot from.
        :param pulumi.Input[builtins.str] zone: ). The zone in which the snapshot should be created.
        """
        if export is not None:
            pulumi.set(__self__, "export", export)
        if import_ is not None:
            pulumi.set(__self__, "import_", import_)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def export(self) -> Optional[pulumi.Input['SnapshotExportArgs']]:
        """
        Use this block to export the volume as a QCOW file to Object Storage.
        """
        return pulumi.get(self, "export")

    @export.setter
    def export(self, value: Optional[pulumi.Input['SnapshotExportArgs']]):
        pulumi.set(self, "export", value)

    @property
    @pulumi.getter(name="import")
    def import_(self) -> Optional[pulumi.Input['SnapshotImportArgs']]:
        """
        Use this block to import a QCOW image from Object Storage to create a volume.
        """
        return pulumi.get(self, "import_")

    @import_.setter
    def import_(self, value: Optional[pulumi.Input['SnapshotImportArgs']]):
        pulumi.set(self, "import_", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the snapshot. If not provided, a name will be randomly generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ). The ID of the Scaleway Project the snapshot is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of tags to apply to the snapshot.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the volume to take a snapshot from.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volume_id", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ). The zone in which the snapshot should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _SnapshotState:
    def __init__(__self__, *,
                 export: Optional[pulumi.Input['SnapshotExportArgs']] = None,
                 import_: Optional[pulumi.Input['SnapshotImportArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 volume_id: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Snapshot resources.
        :param pulumi.Input['SnapshotExportArgs'] export: Use this block to export the volume as a QCOW file to Object Storage.
        :param pulumi.Input['SnapshotImportArgs'] import_: Use this block to import a QCOW image from Object Storage to create a volume.
        :param pulumi.Input[builtins.str] name: The name of the snapshot. If not provided, a name will be randomly generated.
        :param pulumi.Input[builtins.str] project_id: ). The ID of the Scaleway Project the snapshot is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of tags to apply to the snapshot.
        :param pulumi.Input[builtins.str] volume_id: The ID of the volume to take a snapshot from.
        :param pulumi.Input[builtins.str] zone: ). The zone in which the snapshot should be created.
        """
        if export is not None:
            pulumi.set(__self__, "export", export)
        if import_ is not None:
            pulumi.set(__self__, "import_", import_)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def export(self) -> Optional[pulumi.Input['SnapshotExportArgs']]:
        """
        Use this block to export the volume as a QCOW file to Object Storage.
        """
        return pulumi.get(self, "export")

    @export.setter
    def export(self, value: Optional[pulumi.Input['SnapshotExportArgs']]):
        pulumi.set(self, "export", value)

    @property
    @pulumi.getter(name="import")
    def import_(self) -> Optional[pulumi.Input['SnapshotImportArgs']]:
        """
        Use this block to import a QCOW image from Object Storage to create a volume.
        """
        return pulumi.get(self, "import_")

    @import_.setter
    def import_(self, value: Optional[pulumi.Input['SnapshotImportArgs']]):
        pulumi.set(self, "import_", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the snapshot. If not provided, a name will be randomly generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ). The ID of the Scaleway Project the snapshot is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of tags to apply to the snapshot.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the volume to take a snapshot from.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volume_id", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ). The zone in which the snapshot should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("scaleway:block/snapshot:Snapshot")
class Snapshot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 export: Optional[pulumi.Input[Union['SnapshotExportArgs', 'SnapshotExportArgsDict']]] = None,
                 import_: Optional[pulumi.Input[Union['SnapshotImportArgs', 'SnapshotImportArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 volume_id: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The `block.Snapshot` resource is used to create and manage snapshots of Block Storage volumes.

        Refer to the Block Storage [product documentation](https://www.scaleway.com/en/docs/block-storage/) and [API documentation](https://www.scaleway.com/en/developers/api/block/) for more information.

        ## Example Usage

        ### Create a snapshot of a Block Storage volume

        The following command allows you to create a snapshot (`some-snapshot-name`) from a Block Storage volume specified by its ID.

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        block_volume = scaleway.block.Volume("block_volume",
            iops=5000,
            name="some-volume-name",
            size_in_gb=20)
        block_snapshot = scaleway.block.Snapshot("block_snapshot",
            name="some-snapshot-name",
            volume_id=block_volume.id)
        ```

        ## Import

        This section explains how to import the snapshot of a Block Storage volume using the zoned ID format (`{zone}/{id}`).

        bash

        ```sh
        $ pulumi import scaleway:block/snapshot:Snapshot main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SnapshotExportArgs', 'SnapshotExportArgsDict']] export: Use this block to export the volume as a QCOW file to Object Storage.
        :param pulumi.Input[Union['SnapshotImportArgs', 'SnapshotImportArgsDict']] import_: Use this block to import a QCOW image from Object Storage to create a volume.
        :param pulumi.Input[builtins.str] name: The name of the snapshot. If not provided, a name will be randomly generated.
        :param pulumi.Input[builtins.str] project_id: ). The ID of the Scaleway Project the snapshot is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of tags to apply to the snapshot.
        :param pulumi.Input[builtins.str] volume_id: The ID of the volume to take a snapshot from.
        :param pulumi.Input[builtins.str] zone: ). The zone in which the snapshot should be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SnapshotArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `block.Snapshot` resource is used to create and manage snapshots of Block Storage volumes.

        Refer to the Block Storage [product documentation](https://www.scaleway.com/en/docs/block-storage/) and [API documentation](https://www.scaleway.com/en/developers/api/block/) for more information.

        ## Example Usage

        ### Create a snapshot of a Block Storage volume

        The following command allows you to create a snapshot (`some-snapshot-name`) from a Block Storage volume specified by its ID.

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        block_volume = scaleway.block.Volume("block_volume",
            iops=5000,
            name="some-volume-name",
            size_in_gb=20)
        block_snapshot = scaleway.block.Snapshot("block_snapshot",
            name="some-snapshot-name",
            volume_id=block_volume.id)
        ```

        ## Import

        This section explains how to import the snapshot of a Block Storage volume using the zoned ID format (`{zone}/{id}`).

        bash

        ```sh
        $ pulumi import scaleway:block/snapshot:Snapshot main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param SnapshotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnapshotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 export: Optional[pulumi.Input[Union['SnapshotExportArgs', 'SnapshotExportArgsDict']]] = None,
                 import_: Optional[pulumi.Input[Union['SnapshotImportArgs', 'SnapshotImportArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 volume_id: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnapshotArgs.__new__(SnapshotArgs)

            __props__.__dict__["export"] = export
            __props__.__dict__["import_"] = import_
            __props__.__dict__["name"] = name
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["volume_id"] = volume_id
            __props__.__dict__["zone"] = zone
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/blockSnapshot:BlockSnapshot")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Snapshot, __self__).__init__(
            'scaleway:block/snapshot:Snapshot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            export: Optional[pulumi.Input[Union['SnapshotExportArgs', 'SnapshotExportArgsDict']]] = None,
            import_: Optional[pulumi.Input[Union['SnapshotImportArgs', 'SnapshotImportArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            volume_id: Optional[pulumi.Input[builtins.str]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'Snapshot':
        """
        Get an existing Snapshot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SnapshotExportArgs', 'SnapshotExportArgsDict']] export: Use this block to export the volume as a QCOW file to Object Storage.
        :param pulumi.Input[Union['SnapshotImportArgs', 'SnapshotImportArgsDict']] import_: Use this block to import a QCOW image from Object Storage to create a volume.
        :param pulumi.Input[builtins.str] name: The name of the snapshot. If not provided, a name will be randomly generated.
        :param pulumi.Input[builtins.str] project_id: ). The ID of the Scaleway Project the snapshot is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of tags to apply to the snapshot.
        :param pulumi.Input[builtins.str] volume_id: The ID of the volume to take a snapshot from.
        :param pulumi.Input[builtins.str] zone: ). The zone in which the snapshot should be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnapshotState.__new__(_SnapshotState)

        __props__.__dict__["export"] = export
        __props__.__dict__["import_"] = import_
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["volume_id"] = volume_id
        __props__.__dict__["zone"] = zone
        return Snapshot(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def export(self) -> pulumi.Output[Optional['outputs.SnapshotExport']]:
        """
        Use this block to export the volume as a QCOW file to Object Storage.
        """
        return pulumi.get(self, "export")

    @property
    @pulumi.getter(name="import")
    def import_(self) -> pulumi.Output[Optional['outputs.SnapshotImport']]:
        """
        Use this block to import a QCOW image from Object Storage to create a volume.
        """
        return pulumi.get(self, "import_")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the snapshot. If not provided, a name will be randomly generated.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        ). The ID of the Scaleway Project the snapshot is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of tags to apply to the snapshot.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the volume to take a snapshot from.
        """
        return pulumi.get(self, "volume_id")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        ). The zone in which the snapshot should be created.
        """
        return pulumi.get(self, "zone")

