# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseAclArgs', 'DatabaseAcl']

@pulumi.input_type
class DatabaseAclArgs:
    def __init__(__self__, *,
                 acl_rules: pulumi.Input[Sequence[pulumi.Input['DatabaseAclAclRuleArgs']]],
                 instance_id: pulumi.Input[builtins.str],
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a DatabaseAcl resource.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseAclAclRuleArgs']]] acl_rules: A list of ACLs (structure is described below)
               
               > **Important:** The `databases.Acl` resource replaces **all** ACL rules for the given instance. Multiple `databases.Acl` resources targeting the same `instance_id` will conflict with each other. Use multiple `acl_rules` blocks within a single resource instead.
        :param pulumi.Input[builtins.str] instance_id: UUID of the Database Instance.
               
               > **Important:** Updates to `instance_id` will recreate the Database ACL.
        :param pulumi.Input[builtins.str] region: `region`) The region in which the Database Instance should be created.
        """
        pulumi.set(__self__, "acl_rules", acl_rules)
        pulumi.set(__self__, "instance_id", instance_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="aclRules")
    def acl_rules(self) -> pulumi.Input[Sequence[pulumi.Input['DatabaseAclAclRuleArgs']]]:
        """
        A list of ACLs (structure is described below)

        > **Important:** The `databases.Acl` resource replaces **all** ACL rules for the given instance. Multiple `databases.Acl` resources targeting the same `instance_id` will conflict with each other. Use multiple `acl_rules` blocks within a single resource instead.
        """
        return pulumi.get(self, "acl_rules")

    @acl_rules.setter
    def acl_rules(self, value: pulumi.Input[Sequence[pulumi.Input['DatabaseAclAclRuleArgs']]]):
        pulumi.set(self, "acl_rules", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[builtins.str]:
        """
        UUID of the Database Instance.

        > **Important:** Updates to `instance_id` will recreate the Database ACL.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`) The region in which the Database Instance should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DatabaseAclState:
    def __init__(__self__, *,
                 acl_rules: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseAclAclRuleArgs']]]] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatabaseAcl resources.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseAclAclRuleArgs']]] acl_rules: A list of ACLs (structure is described below)
               
               > **Important:** The `databases.Acl` resource replaces **all** ACL rules for the given instance. Multiple `databases.Acl` resources targeting the same `instance_id` will conflict with each other. Use multiple `acl_rules` blocks within a single resource instead.
        :param pulumi.Input[builtins.str] instance_id: UUID of the Database Instance.
               
               > **Important:** Updates to `instance_id` will recreate the Database ACL.
        :param pulumi.Input[builtins.str] region: `region`) The region in which the Database Instance should be created.
        """
        if acl_rules is not None:
            pulumi.set(__self__, "acl_rules", acl_rules)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="aclRules")
    def acl_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseAclAclRuleArgs']]]]:
        """
        A list of ACLs (structure is described below)

        > **Important:** The `databases.Acl` resource replaces **all** ACL rules for the given instance. Multiple `databases.Acl` resources targeting the same `instance_id` will conflict with each other. Use multiple `acl_rules` blocks within a single resource instead.
        """
        return pulumi.get(self, "acl_rules")

    @acl_rules.setter
    def acl_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseAclAclRuleArgs']]]]):
        pulumi.set(self, "acl_rules", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        UUID of the Database Instance.

        > **Important:** Updates to `instance_id` will recreate the Database ACL.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`) The region in which the Database Instance should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)


warnings.warn("""scaleway.index/databaseacl.DatabaseAcl has been deprecated in favor of scaleway.databases/acl.Acl""", DeprecationWarning)


@pulumi.type_token("scaleway:index/databaseAcl:DatabaseAcl")
class DatabaseAcl(pulumi.CustomResource):
    warnings.warn("""scaleway.index/databaseacl.DatabaseAcl has been deprecated in favor of scaleway.databases/acl.Acl""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseAclAclRuleArgs', 'DatabaseAclAclRuleArgsDict']]]]] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Database instance authorized IPs.
        For more information refer to the [API documentation](https://www.scaleway.com/en/developers/api/managed-database-postgre-mysql/#acl-rules-allowed-ips).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.Instance("main",
            name="test-rdb",
            node_type="DB-DEV-S",
            engine="PostgreSQL-15",
            is_ha_cluster=True,
            disable_backup=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret")
        main_acl = scaleway.databases.Acl("main",
            instance_id=main.id,
            acl_rules=[{
                "ip": "1.2.3.4/32",
                "description": "foo",
            }])
        ```

        ### Multiple ACL Rules

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.Acl("main",
            instance_id=main_scaleway_rdb_instance["id"],
            acl_rules=[
                {
                    "ip": "1.2.3.4/32",
                    "description": "Office IP",
                },
                {
                    "ip": "5.6.7.8/32",
                    "description": "Home IP",
                },
                {
                    "ip": "10.0.0.0/24",
                    "description": "Internal network",
                },
            ])
        ```

        ### Dynamic ACL Rules with Variables

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        config = pulumi.Config()
        # Map of allowed IPs with descriptions
        allowed_ips = config.get_object("allowedIps")
        if allowed_ips is None:
            allowed_ips = {
                "1.2.3.4/32": "Office IP",
                "10.0.0.0/24": "Internal network",
                "5.6.7.8/32": "Home IP",
            }
        main = scaleway.databases.Acl("main",
            acl_rules=[{
                "ip": entry["key"],
                "description": entry["value"],
            } for entry in [{"key": k, "value": v} for k, v in allowed_ips]],
            instance_id=main_scaleway_rdb_instance["id"])
        ```

        ## Import

        Database Instance can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/databaseAcl:DatabaseAcl acl01 fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabaseAclAclRuleArgs', 'DatabaseAclAclRuleArgsDict']]]] acl_rules: A list of ACLs (structure is described below)
               
               > **Important:** The `databases.Acl` resource replaces **all** ACL rules for the given instance. Multiple `databases.Acl` resources targeting the same `instance_id` will conflict with each other. Use multiple `acl_rules` blocks within a single resource instead.
        :param pulumi.Input[builtins.str] instance_id: UUID of the Database Instance.
               
               > **Important:** Updates to `instance_id` will recreate the Database ACL.
        :param pulumi.Input[builtins.str] region: `region`) The region in which the Database Instance should be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseAclArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Database instance authorized IPs.
        For more information refer to the [API documentation](https://www.scaleway.com/en/developers/api/managed-database-postgre-mysql/#acl-rules-allowed-ips).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.Instance("main",
            name="test-rdb",
            node_type="DB-DEV-S",
            engine="PostgreSQL-15",
            is_ha_cluster=True,
            disable_backup=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret")
        main_acl = scaleway.databases.Acl("main",
            instance_id=main.id,
            acl_rules=[{
                "ip": "1.2.3.4/32",
                "description": "foo",
            }])
        ```

        ### Multiple ACL Rules

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.Acl("main",
            instance_id=main_scaleway_rdb_instance["id"],
            acl_rules=[
                {
                    "ip": "1.2.3.4/32",
                    "description": "Office IP",
                },
                {
                    "ip": "5.6.7.8/32",
                    "description": "Home IP",
                },
                {
                    "ip": "10.0.0.0/24",
                    "description": "Internal network",
                },
            ])
        ```

        ### Dynamic ACL Rules with Variables

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        config = pulumi.Config()
        # Map of allowed IPs with descriptions
        allowed_ips = config.get_object("allowedIps")
        if allowed_ips is None:
            allowed_ips = {
                "1.2.3.4/32": "Office IP",
                "10.0.0.0/24": "Internal network",
                "5.6.7.8/32": "Home IP",
            }
        main = scaleway.databases.Acl("main",
            acl_rules=[{
                "ip": entry["key"],
                "description": entry["value"],
            } for entry in [{"key": k, "value": v} for k, v in allowed_ips]],
            instance_id=main_scaleway_rdb_instance["id"])
        ```

        ## Import

        Database Instance can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/databaseAcl:DatabaseAcl acl01 fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseAclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseAclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseAclAclRuleArgs', 'DatabaseAclAclRuleArgsDict']]]]] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""DatabaseAcl is deprecated: scaleway.index/databaseacl.DatabaseAcl has been deprecated in favor of scaleway.databases/acl.Acl""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseAclArgs.__new__(DatabaseAclArgs)

            if acl_rules is None and not opts.urn:
                raise TypeError("Missing required property 'acl_rules'")
            __props__.__dict__["acl_rules"] = acl_rules
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["region"] = region
        super(DatabaseAcl, __self__).__init__(
            'scaleway:index/databaseAcl:DatabaseAcl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabaseAclAclRuleArgs', 'DatabaseAclAclRuleArgsDict']]]]] = None,
            instance_id: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None) -> 'DatabaseAcl':
        """
        Get an existing DatabaseAcl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabaseAclAclRuleArgs', 'DatabaseAclAclRuleArgsDict']]]] acl_rules: A list of ACLs (structure is described below)
               
               > **Important:** The `databases.Acl` resource replaces **all** ACL rules for the given instance. Multiple `databases.Acl` resources targeting the same `instance_id` will conflict with each other. Use multiple `acl_rules` blocks within a single resource instead.
        :param pulumi.Input[builtins.str] instance_id: UUID of the Database Instance.
               
               > **Important:** Updates to `instance_id` will recreate the Database ACL.
        :param pulumi.Input[builtins.str] region: `region`) The region in which the Database Instance should be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseAclState.__new__(_DatabaseAclState)

        __props__.__dict__["acl_rules"] = acl_rules
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["region"] = region
        return DatabaseAcl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aclRules")
    def acl_rules(self) -> pulumi.Output[Sequence['outputs.DatabaseAclAclRule']]:
        """
        A list of ACLs (structure is described below)

        > **Important:** The `databases.Acl` resource replaces **all** ACL rules for the given instance. Multiple `databases.Acl` resources targeting the same `instance_id` will conflict with each other. Use multiple `acl_rules` blocks within a single resource instead.
        """
        return pulumi.get(self, "acl_rules")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[builtins.str]:
        """
        UUID of the Database Instance.

        > **Important:** Updates to `instance_id` will recreate the Database ACL.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        `region`) The region in which the Database Instance should be created.
        """
        return pulumi.get(self, "region")

