# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AclAclRuleArgs',
    'AclAclRuleArgsDict',
    'InstanceLoadBalancerArgs',
    'InstanceLoadBalancerArgsDict',
    'InstanceLogsPolicyArgs',
    'InstanceLogsPolicyArgsDict',
    'InstancePrivateIpArgs',
    'InstancePrivateIpArgsDict',
    'InstancePrivateNetworkArgs',
    'InstancePrivateNetworkArgsDict',
    'InstanceReadReplicaArgs',
    'InstanceReadReplicaArgsDict',
    'ReadReplicaDirectAccessArgs',
    'ReadReplicaDirectAccessArgsDict',
    'ReadReplicaPrivateNetworkArgs',
    'ReadReplicaPrivateNetworkArgsDict',
]

MYPY = False

if not MYPY:
    class AclAclRuleArgsDict(TypedDict):
        ip: pulumi.Input[builtins.str]
        """
        The IP range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        """
        description: NotRequired[pulumi.Input[builtins.str]]
        """
        A text describing this rule. Default description: `IP allowed`
        """
elif False:
    AclAclRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AclAclRuleArgs:
    def __init__(__self__, *,
                 ip: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] ip: The IP range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        :param pulumi.Input[builtins.str] description: A text describing this rule. Default description: `IP allowed`
        """
        pulumi.set(__self__, "ip", ip)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Input[builtins.str]:
        """
        The IP range to whitelist in [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation)
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A text describing this rule. Default description: `IP allowed`
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class InstanceLoadBalancerArgsDict(TypedDict):
        endpoint_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the endpoint.
        """
        hostname: NotRequired[pulumi.Input[builtins.str]]
        """
        Hostname of the endpoint.
        """
        ip: NotRequired[pulumi.Input[builtins.str]]
        """
        IPv4 address on the network.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the Database Instance.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        Port in the Private Network.
        """
elif False:
    InstanceLoadBalancerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceLoadBalancerArgs:
    def __init__(__self__, *,
                 endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 ip: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] endpoint_id: The ID of the endpoint.
        :param pulumi.Input[builtins.str] hostname: Hostname of the endpoint.
        :param pulumi.Input[builtins.str] ip: IPv4 address on the network.
        :param pulumi.Input[builtins.str] name: The name of the Database Instance.
        :param pulumi.Input[builtins.int] port: Port in the Private Network.
        """
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Hostname of the endpoint.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv4 address on the network.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Port in the Private Network.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class InstanceLogsPolicyArgsDict(TypedDict):
        max_age_retention: NotRequired[pulumi.Input[builtins.int]]
        """
        The max age (in days) of remote logs to keep on the Database Instance
        """
        total_disk_retention: NotRequired[pulumi.Input[builtins.int]]
        """
        The max disk size of remote logs to keep on the Database Instance.
        """
elif False:
    InstanceLogsPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceLogsPolicyArgs:
    def __init__(__self__, *,
                 max_age_retention: Optional[pulumi.Input[builtins.int]] = None,
                 total_disk_retention: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] max_age_retention: The max age (in days) of remote logs to keep on the Database Instance
        :param pulumi.Input[builtins.int] total_disk_retention: The max disk size of remote logs to keep on the Database Instance.
        """
        if max_age_retention is not None:
            pulumi.set(__self__, "max_age_retention", max_age_retention)
        if total_disk_retention is not None:
            pulumi.set(__self__, "total_disk_retention", total_disk_retention)

    @property
    @pulumi.getter(name="maxAgeRetention")
    def max_age_retention(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The max age (in days) of remote logs to keep on the Database Instance
        """
        return pulumi.get(self, "max_age_retention")

    @max_age_retention.setter
    def max_age_retention(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_age_retention", value)

    @property
    @pulumi.getter(name="totalDiskRetention")
    def total_disk_retention(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The max disk size of remote logs to keep on the Database Instance.
        """
        return pulumi.get(self, "total_disk_retention")

    @total_disk_retention.setter
    def total_disk_retention(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "total_disk_retention", value)


if not MYPY:
    class InstancePrivateIpArgsDict(TypedDict):
        address: NotRequired[pulumi.Input[builtins.str]]
        """
        The private IPv4 address.
        """
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the IPv4 address resource.
        """
elif False:
    InstancePrivateIpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstancePrivateIpArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] address: The private IPv4 address.
        :param pulumi.Input[builtins.str] id: The ID of the IPv4 address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The private IPv4 address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the IPv4 address resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)


if not MYPY:
    class InstancePrivateNetworkArgsDict(TypedDict):
        pn_id: pulumi.Input[builtins.str]
        """
        The private network ID
        """
        enable_ipam: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether or not the private network endpoint should be configured with IPAM
        """
        endpoint_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the endpoint.
        """
        hostname: NotRequired[pulumi.Input[builtins.str]]
        """
        Hostname of the endpoint.
        """
        ip: NotRequired[pulumi.Input[builtins.str]]
        """
        IPv4 address on the network.
        """
        ip_net: NotRequired[pulumi.Input[builtins.str]]
        """
        The IP with the given mask within the private subnet
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the Database Instance.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        Port in the Private Network.
        """
        zone: NotRequired[pulumi.Input[builtins.str]]
        """
        The zone you want to attach the resource to
        """
elif False:
    InstancePrivateNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstancePrivateNetworkArgs:
    def __init__(__self__, *,
                 pn_id: pulumi.Input[builtins.str],
                 enable_ipam: Optional[pulumi.Input[builtins.bool]] = None,
                 endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 ip: Optional[pulumi.Input[builtins.str]] = None,
                 ip_net: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] pn_id: The private network ID
        :param pulumi.Input[builtins.bool] enable_ipam: Whether or not the private network endpoint should be configured with IPAM
        :param pulumi.Input[builtins.str] endpoint_id: The ID of the endpoint.
        :param pulumi.Input[builtins.str] hostname: Hostname of the endpoint.
        :param pulumi.Input[builtins.str] ip: IPv4 address on the network.
        :param pulumi.Input[builtins.str] ip_net: The IP with the given mask within the private subnet
        :param pulumi.Input[builtins.str] name: The name of the Database Instance.
        :param pulumi.Input[builtins.int] port: Port in the Private Network.
        :param pulumi.Input[builtins.str] zone: The zone you want to attach the resource to
        """
        pulumi.set(__self__, "pn_id", pn_id)
        if enable_ipam is not None:
            pulumi.set(__self__, "enable_ipam", enable_ipam)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_net is not None:
            pulumi.set(__self__, "ip_net", ip_net)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> pulumi.Input[builtins.str]:
        """
        The private network ID
        """
        return pulumi.get(self, "pn_id")

    @pn_id.setter
    def pn_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "pn_id", value)

    @property
    @pulumi.getter(name="enableIpam")
    def enable_ipam(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not the private network endpoint should be configured with IPAM
        """
        return pulumi.get(self, "enable_ipam")

    @enable_ipam.setter
    def enable_ipam(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_ipam", value)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Hostname of the endpoint.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv4 address on the network.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="ipNet")
    def ip_net(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP with the given mask within the private subnet
        """
        return pulumi.get(self, "ip_net")

    @ip_net.setter
    def ip_net(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_net", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Port in the Private Network.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The zone you want to attach the resource to
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


if not MYPY:
    class InstanceReadReplicaArgsDict(TypedDict):
        ip: NotRequired[pulumi.Input[builtins.str]]
        """
        IPv4 address on the network.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the Database Instance.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        Port in the Private Network.
        """
elif False:
    InstanceReadReplicaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceReadReplicaArgs:
    def __init__(__self__, *,
                 ip: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] ip: IPv4 address on the network.
        :param pulumi.Input[builtins.str] name: The name of the Database Instance.
        :param pulumi.Input[builtins.int] port: Port in the Private Network.
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv4 address on the network.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Database Instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Port in the Private Network.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class ReadReplicaDirectAccessArgsDict(TypedDict):
        endpoint_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the endpoint of the Read Replica.
        """
        hostname: NotRequired[pulumi.Input[builtins.str]]
        """
        Hostname of the endpoint. Only one of IP and hostname may be set.
        """
        ip: NotRequired[pulumi.Input[builtins.str]]
        """
        IPv4 address of the endpoint (IP address). Only one of IP and hostname may be set.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the endpoint.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        TCP port of the endpoint.
        """
elif False:
    ReadReplicaDirectAccessArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReadReplicaDirectAccessArgs:
    def __init__(__self__, *,
                 endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 ip: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] endpoint_id: The ID of the endpoint of the Read Replica.
        :param pulumi.Input[builtins.str] hostname: Hostname of the endpoint. Only one of IP and hostname may be set.
        :param pulumi.Input[builtins.str] ip: IPv4 address of the endpoint (IP address). Only one of IP and hostname may be set.
        :param pulumi.Input[builtins.str] name: Name of the endpoint.
        :param pulumi.Input[builtins.int] port: TCP port of the endpoint.
        """
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the endpoint of the Read Replica.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Hostname of the endpoint. Only one of IP and hostname may be set.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv4 address of the endpoint (IP address). Only one of IP and hostname may be set.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the endpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class ReadReplicaPrivateNetworkArgsDict(TypedDict):
        private_network_id: pulumi.Input[builtins.str]
        """
        UUID of the Private Netork to be connected to the Read Replica.
        """
        enable_ipam: NotRequired[pulumi.Input[builtins.bool]]
        """
        If true, the IP network address within the private subnet is determined by the IP Address Management (IPAM) service.

        > **Important:** One of `service_ip` or `enable_ipam=true` must be set.
        """
        endpoint_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the endpoint of the Read Replica.
        """
        hostname: NotRequired[pulumi.Input[builtins.str]]
        """
        Hostname of the endpoint. Only one of IP and hostname may be set.
        """
        ip: NotRequired[pulumi.Input[builtins.str]]
        """
        IPv4 address of the endpoint (IP address). Only one of IP and hostname may be set.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the endpoint.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        TCP port of the endpoint.
        """
        service_ip: NotRequired[pulumi.Input[builtins.str]]
        """
        The IP network address within the private subnet. This must be an IPv4 address with a CIDR notation. If not set, The IP network address within the private subnet is determined by the IP Address Management (IPAM) service.
        """
        zone: NotRequired[pulumi.Input[builtins.str]]
        """
        Private network zone
        """
elif False:
    ReadReplicaPrivateNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReadReplicaPrivateNetworkArgs:
    def __init__(__self__, *,
                 private_network_id: pulumi.Input[builtins.str],
                 enable_ipam: Optional[pulumi.Input[builtins.bool]] = None,
                 endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 ip: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 service_ip: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] private_network_id: UUID of the Private Netork to be connected to the Read Replica.
        :param pulumi.Input[builtins.bool] enable_ipam: If true, the IP network address within the private subnet is determined by the IP Address Management (IPAM) service.
               
               > **Important:** One of `service_ip` or `enable_ipam=true` must be set.
        :param pulumi.Input[builtins.str] endpoint_id: The ID of the endpoint of the Read Replica.
        :param pulumi.Input[builtins.str] hostname: Hostname of the endpoint. Only one of IP and hostname may be set.
        :param pulumi.Input[builtins.str] ip: IPv4 address of the endpoint (IP address). Only one of IP and hostname may be set.
        :param pulumi.Input[builtins.str] name: Name of the endpoint.
        :param pulumi.Input[builtins.int] port: TCP port of the endpoint.
        :param pulumi.Input[builtins.str] service_ip: The IP network address within the private subnet. This must be an IPv4 address with a CIDR notation. If not set, The IP network address within the private subnet is determined by the IP Address Management (IPAM) service.
        :param pulumi.Input[builtins.str] zone: Private network zone
        """
        pulumi.set(__self__, "private_network_id", private_network_id)
        if enable_ipam is not None:
            pulumi.set(__self__, "enable_ipam", enable_ipam)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service_ip is not None:
            pulumi.set(__self__, "service_ip", service_ip)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> pulumi.Input[builtins.str]:
        """
        UUID of the Private Netork to be connected to the Read Replica.
        """
        return pulumi.get(self, "private_network_id")

    @private_network_id.setter
    def private_network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "private_network_id", value)

    @property
    @pulumi.getter(name="enableIpam")
    def enable_ipam(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the IP network address within the private subnet is determined by the IP Address Management (IPAM) service.

        > **Important:** One of `service_ip` or `enable_ipam=true` must be set.
        """
        return pulumi.get(self, "enable_ipam")

    @enable_ipam.setter
    def enable_ipam(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_ipam", value)

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the endpoint of the Read Replica.
        """
        return pulumi.get(self, "endpoint_id")

    @endpoint_id.setter
    def endpoint_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_id", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Hostname of the endpoint. Only one of IP and hostname may be set.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv4 address of the endpoint (IP address). Only one of IP and hostname may be set.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the endpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        TCP port of the endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="serviceIp")
    def service_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP network address within the private subnet. This must be an IPv4 address with a CIDR notation. If not set, The IP network address within the private subnet is determined by the IP Address Management (IPAM) service.
        """
        return pulumi.get(self, "service_ip")

    @service_ip.setter
    def service_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_ip", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Private network zone
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


