# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ZoneArgs', 'Zone']

@pulumi.input_type
class ZoneArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[builtins.str],
                 subdomain: pulumi.Input[builtins.str],
                 project_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Zone resource.
        :param pulumi.Input[builtins.str] domain: The main domain where the DNS zone will be created.
        :param pulumi.Input[builtins.str] subdomain: The name of the subdomain (zone name) to create within the domain.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project associated with the domain.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "subdomain", subdomain)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input[builtins.str]:
        """
        The main domain where the DNS zone will be created.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def subdomain(self) -> pulumi.Input[builtins.str]:
        """
        The name of the subdomain (zone name) to create within the domain.
        """
        return pulumi.get(self, "subdomain")

    @subdomain.setter
    def subdomain(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subdomain", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the Project associated with the domain.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class _ZoneState:
    def __init__(__self__, *,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 message: Optional[pulumi.Input[builtins.str]] = None,
                 ns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ns_defaults: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ns_masters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 subdomain: Optional[pulumi.Input[builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Zone resources.
        :param pulumi.Input[builtins.str] domain: The main domain where the DNS zone will be created.
        :param pulumi.Input[builtins.str] message: Message.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ns: The list of same servers for the zone.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ns_defaults: The default list of same servers for the zone.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ns_masters: The master list of same servers for the zone.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project associated with the domain.
        :param pulumi.Input[builtins.str] status: The status of the domain zone.
        :param pulumi.Input[builtins.str] subdomain: The name of the subdomain (zone name) to create within the domain.
        :param pulumi.Input[builtins.str] updated_at: The date and time at which the DNS zone was last updated.
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if ns is not None:
            pulumi.set(__self__, "ns", ns)
        if ns_defaults is not None:
            pulumi.set(__self__, "ns_defaults", ns_defaults)
        if ns_masters is not None:
            pulumi.set(__self__, "ns_masters", ns_masters)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subdomain is not None:
            pulumi.set(__self__, "subdomain", subdomain)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The main domain where the DNS zone will be created.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Message.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def ns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of same servers for the zone.
        """
        return pulumi.get(self, "ns")

    @ns.setter
    def ns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ns", value)

    @property
    @pulumi.getter(name="nsDefaults")
    def ns_defaults(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The default list of same servers for the zone.
        """
        return pulumi.get(self, "ns_defaults")

    @ns_defaults.setter
    def ns_defaults(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ns_defaults", value)

    @property
    @pulumi.getter(name="nsMasters")
    def ns_masters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The master list of same servers for the zone.
        """
        return pulumi.get(self, "ns_masters")

    @ns_masters.setter
    def ns_masters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ns_masters", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the Project associated with the domain.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of the domain zone.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def subdomain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the subdomain (zone name) to create within the domain.
        """
        return pulumi.get(self, "subdomain")

    @subdomain.setter
    def subdomain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subdomain", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time at which the DNS zone was last updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("scaleway:domain/zone:Zone")
class Zone(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 subdomain: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        This section explains how to import a zone using the `{subdomain}.{domain}` format.

        bash

        ```sh
        $ pulumi import scaleway:domain/zone:Zone test test.scaleway-terraform.com
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] domain: The main domain where the DNS zone will be created.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project associated with the domain.
        :param pulumi.Input[builtins.str] subdomain: The name of the subdomain (zone name) to create within the domain.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZoneArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        This section explains how to import a zone using the `{subdomain}.{domain}` format.

        bash

        ```sh
        $ pulumi import scaleway:domain/zone:Zone test test.scaleway-terraform.com
        ```

        :param str resource_name: The name of the resource.
        :param ZoneArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZoneArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 subdomain: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZoneArgs.__new__(ZoneArgs)

            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            __props__.__dict__["project_id"] = project_id
            if subdomain is None and not opts.urn:
                raise TypeError("Missing required property 'subdomain'")
            __props__.__dict__["subdomain"] = subdomain
            __props__.__dict__["message"] = None
            __props__.__dict__["ns"] = None
            __props__.__dict__["ns_defaults"] = None
            __props__.__dict__["ns_masters"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/domainZone:DomainZone")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Zone, __self__).__init__(
            'scaleway:domain/zone:Zone',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain: Optional[pulumi.Input[builtins.str]] = None,
            message: Optional[pulumi.Input[builtins.str]] = None,
            ns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            ns_defaults: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            ns_masters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            subdomain: Optional[pulumi.Input[builtins.str]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None) -> 'Zone':
        """
        Get an existing Zone resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] domain: The main domain where the DNS zone will be created.
        :param pulumi.Input[builtins.str] message: Message.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ns: The list of same servers for the zone.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ns_defaults: The default list of same servers for the zone.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ns_masters: The master list of same servers for the zone.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the Project associated with the domain.
        :param pulumi.Input[builtins.str] status: The status of the domain zone.
        :param pulumi.Input[builtins.str] subdomain: The name of the subdomain (zone name) to create within the domain.
        :param pulumi.Input[builtins.str] updated_at: The date and time at which the DNS zone was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZoneState.__new__(_ZoneState)

        __props__.__dict__["domain"] = domain
        __props__.__dict__["message"] = message
        __props__.__dict__["ns"] = ns
        __props__.__dict__["ns_defaults"] = ns_defaults
        __props__.__dict__["ns_masters"] = ns_masters
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["status"] = status
        __props__.__dict__["subdomain"] = subdomain
        __props__.__dict__["updated_at"] = updated_at
        return Zone(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[builtins.str]:
        """
        The main domain where the DNS zone will be created.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def message(self) -> pulumi.Output[builtins.str]:
        """
        Message.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def ns(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The list of same servers for the zone.
        """
        return pulumi.get(self, "ns")

    @property
    @pulumi.getter(name="nsDefaults")
    def ns_defaults(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The default list of same servers for the zone.
        """
        return pulumi.get(self, "ns_defaults")

    @property
    @pulumi.getter(name="nsMasters")
    def ns_masters(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The master list of same servers for the zone.
        """
        return pulumi.get(self, "ns_masters")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        `project_id`) The ID of the Project associated with the domain.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The status of the domain zone.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def subdomain(self) -> pulumi.Output[builtins.str]:
        """
        The name of the subdomain (zone name) to create within the domain.
        """
        return pulumi.get(self, "subdomain")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time at which the DNS zone was last updated.
        """
        return pulumi.get(self, "updated_at")

