# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EdgeServicesBackendStageArgs', 'EdgeServicesBackendStage']

@pulumi.input_type
class EdgeServicesBackendStageArgs:
    def __init__(__self__, *,
                 pipeline_id: pulumi.Input[builtins.str],
                 lb_backend_configs: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeServicesBackendStageLbBackendConfigArgs']]]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 s3_backend_config: Optional[pulumi.Input['EdgeServicesBackendStageS3BackendConfigArgs']] = None):
        """
        The set of arguments for constructing a EdgeServicesBackendStage resource.
        :param pulumi.Input[builtins.str] pipeline_id: The ID of the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input['EdgeServicesBackendStageLbBackendConfigArgs']]] lb_backend_configs: The Scaleway Load Balancer linked to the backend stage.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the backend stage is associated with.
        :param pulumi.Input['EdgeServicesBackendStageS3BackendConfigArgs'] s3_backend_config: The Scaleway Object Storage origin bucket (S3) linked to the backend stage.
        """
        pulumi.set(__self__, "pipeline_id", pipeline_id)
        if lb_backend_configs is not None:
            pulumi.set(__self__, "lb_backend_configs", lb_backend_configs)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if s3_backend_config is not None:
            pulumi.set(__self__, "s3_backend_config", s3_backend_config)

    @property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @pipeline_id.setter
    def pipeline_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "pipeline_id", value)

    @property
    @pulumi.getter(name="lbBackendConfigs")
    def lb_backend_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdgeServicesBackendStageLbBackendConfigArgs']]]]:
        """
        The Scaleway Load Balancer linked to the backend stage.
        """
        return pulumi.get(self, "lb_backend_configs")

    @lb_backend_configs.setter
    def lb_backend_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeServicesBackendStageLbBackendConfigArgs']]]]):
        pulumi.set(self, "lb_backend_configs", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project the backend stage is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="s3BackendConfig")
    def s3_backend_config(self) -> Optional[pulumi.Input['EdgeServicesBackendStageS3BackendConfigArgs']]:
        """
        The Scaleway Object Storage origin bucket (S3) linked to the backend stage.
        """
        return pulumi.get(self, "s3_backend_config")

    @s3_backend_config.setter
    def s3_backend_config(self, value: Optional[pulumi.Input['EdgeServicesBackendStageS3BackendConfigArgs']]):
        pulumi.set(self, "s3_backend_config", value)


@pulumi.input_type
class _EdgeServicesBackendStageState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 lb_backend_configs: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeServicesBackendStageLbBackendConfigArgs']]]] = None,
                 pipeline_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 s3_backend_config: Optional[pulumi.Input['EdgeServicesBackendStageS3BackendConfigArgs']] = None,
                 updated_at: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering EdgeServicesBackendStage resources.
        :param pulumi.Input[builtins.str] created_at: The date and time of the creation of the backend stage.
        :param pulumi.Input[Sequence[pulumi.Input['EdgeServicesBackendStageLbBackendConfigArgs']]] lb_backend_configs: The Scaleway Load Balancer linked to the backend stage.
        :param pulumi.Input[builtins.str] pipeline_id: The ID of the pipeline.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the backend stage is associated with.
        :param pulumi.Input['EdgeServicesBackendStageS3BackendConfigArgs'] s3_backend_config: The Scaleway Object Storage origin bucket (S3) linked to the backend stage.
        :param pulumi.Input[builtins.str] updated_at: The date and time of the last update of the backend stage.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if lb_backend_configs is not None:
            pulumi.set(__self__, "lb_backend_configs", lb_backend_configs)
        if pipeline_id is not None:
            pulumi.set(__self__, "pipeline_id", pipeline_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if s3_backend_config is not None:
            pulumi.set(__self__, "s3_backend_config", s3_backend_config)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time of the creation of the backend stage.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="lbBackendConfigs")
    def lb_backend_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EdgeServicesBackendStageLbBackendConfigArgs']]]]:
        """
        The Scaleway Load Balancer linked to the backend stage.
        """
        return pulumi.get(self, "lb_backend_configs")

    @lb_backend_configs.setter
    def lb_backend_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EdgeServicesBackendStageLbBackendConfigArgs']]]]):
        pulumi.set(self, "lb_backend_configs", value)

    @property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @pipeline_id.setter
    def pipeline_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pipeline_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project the backend stage is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="s3BackendConfig")
    def s3_backend_config(self) -> Optional[pulumi.Input['EdgeServicesBackendStageS3BackendConfigArgs']]:
        """
        The Scaleway Object Storage origin bucket (S3) linked to the backend stage.
        """
        return pulumi.get(self, "s3_backend_config")

    @s3_backend_config.setter
    def s3_backend_config(self, value: Optional[pulumi.Input['EdgeServicesBackendStageS3BackendConfigArgs']]):
        pulumi.set(self, "s3_backend_config", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time of the last update of the backend stage.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("scaleway:index/edgeServicesBackendStage:EdgeServicesBackendStage")
class EdgeServicesBackendStage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 lb_backend_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EdgeServicesBackendStageLbBackendConfigArgs', 'EdgeServicesBackendStageLbBackendConfigArgsDict']]]]] = None,
                 pipeline_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 s3_backend_config: Optional[pulumi.Input[Union['EdgeServicesBackendStageS3BackendConfigArgs', 'EdgeServicesBackendStageS3BackendConfigArgsDict']]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Edge Services Backend Stages.

        ## Example Usage

        ### With object backend

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.object.Bucket("main",
            name="my-bucket-name",
            tags={
                "foo": "bar",
            })
        main_edge_services_pipeline = scaleway.EdgeServicesPipeline("main", name="my-pipeline")
        main_edge_services_backend_stage = scaleway.EdgeServicesBackendStage("main",
            pipeline_id=main_edge_services_pipeline.id,
            s3_backend_config={
                "bucket_name": main.name,
                "bucket_region": "fr-par",
            })
        ```

        ### With LB backend

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.loadbalancers.LoadBalancer("main",
            ip_ids=[main_scaleway_lb_ip["id"]],
            zone="fr-par-1",
            type="LB-S")
        main_frontend = scaleway.loadbalancers.Frontend("main",
            lb_id=main.id,
            backend_id=main_scaleway_lb_backend["id"],
            name="frontend01",
            inbound_port=443,
            certificate_ids=[cert01["id"]])
        main_edge_services_pipeline = scaleway.EdgeServicesPipeline("main", name="my-pipeline")
        main_edge_services_backend_stage = scaleway.EdgeServicesBackendStage("main",
            pipeline_id=main_edge_services_pipeline.id,
            lb_backend_configs=[{
                "lb_config": {
                    "id": main.id,
                    "frontend_id": id,
                    "is_ssl": True,
                    "zone": "fr-par-1",
                },
            }])
        ```

        ## Import

        Backend stages can be imported using the `{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/edgeServicesBackendStage:EdgeServicesBackendStage basic 11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EdgeServicesBackendStageLbBackendConfigArgs', 'EdgeServicesBackendStageLbBackendConfigArgsDict']]]] lb_backend_configs: The Scaleway Load Balancer linked to the backend stage.
        :param pulumi.Input[builtins.str] pipeline_id: The ID of the pipeline.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the backend stage is associated with.
        :param pulumi.Input[Union['EdgeServicesBackendStageS3BackendConfigArgs', 'EdgeServicesBackendStageS3BackendConfigArgsDict']] s3_backend_config: The Scaleway Object Storage origin bucket (S3) linked to the backend stage.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EdgeServicesBackendStageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Edge Services Backend Stages.

        ## Example Usage

        ### With object backend

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.object.Bucket("main",
            name="my-bucket-name",
            tags={
                "foo": "bar",
            })
        main_edge_services_pipeline = scaleway.EdgeServicesPipeline("main", name="my-pipeline")
        main_edge_services_backend_stage = scaleway.EdgeServicesBackendStage("main",
            pipeline_id=main_edge_services_pipeline.id,
            s3_backend_config={
                "bucket_name": main.name,
                "bucket_region": "fr-par",
            })
        ```

        ### With LB backend

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.loadbalancers.LoadBalancer("main",
            ip_ids=[main_scaleway_lb_ip["id"]],
            zone="fr-par-1",
            type="LB-S")
        main_frontend = scaleway.loadbalancers.Frontend("main",
            lb_id=main.id,
            backend_id=main_scaleway_lb_backend["id"],
            name="frontend01",
            inbound_port=443,
            certificate_ids=[cert01["id"]])
        main_edge_services_pipeline = scaleway.EdgeServicesPipeline("main", name="my-pipeline")
        main_edge_services_backend_stage = scaleway.EdgeServicesBackendStage("main",
            pipeline_id=main_edge_services_pipeline.id,
            lb_backend_configs=[{
                "lb_config": {
                    "id": main.id,
                    "frontend_id": id,
                    "is_ssl": True,
                    "zone": "fr-par-1",
                },
            }])
        ```

        ## Import

        Backend stages can be imported using the `{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/edgeServicesBackendStage:EdgeServicesBackendStage basic 11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param EdgeServicesBackendStageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EdgeServicesBackendStageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 lb_backend_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EdgeServicesBackendStageLbBackendConfigArgs', 'EdgeServicesBackendStageLbBackendConfigArgsDict']]]]] = None,
                 pipeline_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 s3_backend_config: Optional[pulumi.Input[Union['EdgeServicesBackendStageS3BackendConfigArgs', 'EdgeServicesBackendStageS3BackendConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EdgeServicesBackendStageArgs.__new__(EdgeServicesBackendStageArgs)

            __props__.__dict__["lb_backend_configs"] = lb_backend_configs
            if pipeline_id is None and not opts.urn:
                raise TypeError("Missing required property 'pipeline_id'")
            __props__.__dict__["pipeline_id"] = pipeline_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["s3_backend_config"] = s3_backend_config
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        super(EdgeServicesBackendStage, __self__).__init__(
            'scaleway:index/edgeServicesBackendStage:EdgeServicesBackendStage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            lb_backend_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EdgeServicesBackendStageLbBackendConfigArgs', 'EdgeServicesBackendStageLbBackendConfigArgsDict']]]]] = None,
            pipeline_id: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            s3_backend_config: Optional[pulumi.Input[Union['EdgeServicesBackendStageS3BackendConfigArgs', 'EdgeServicesBackendStageS3BackendConfigArgsDict']]] = None,
            updated_at: Optional[pulumi.Input[builtins.str]] = None) -> 'EdgeServicesBackendStage':
        """
        Get an existing EdgeServicesBackendStage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] created_at: The date and time of the creation of the backend stage.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EdgeServicesBackendStageLbBackendConfigArgs', 'EdgeServicesBackendStageLbBackendConfigArgsDict']]]] lb_backend_configs: The Scaleway Load Balancer linked to the backend stage.
        :param pulumi.Input[builtins.str] pipeline_id: The ID of the pipeline.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the backend stage is associated with.
        :param pulumi.Input[Union['EdgeServicesBackendStageS3BackendConfigArgs', 'EdgeServicesBackendStageS3BackendConfigArgsDict']] s3_backend_config: The Scaleway Object Storage origin bucket (S3) linked to the backend stage.
        :param pulumi.Input[builtins.str] updated_at: The date and time of the last update of the backend stage.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EdgeServicesBackendStageState.__new__(_EdgeServicesBackendStageState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["lb_backend_configs"] = lb_backend_configs
        __props__.__dict__["pipeline_id"] = pipeline_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["s3_backend_config"] = s3_backend_config
        __props__.__dict__["updated_at"] = updated_at
        return EdgeServicesBackendStage(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of the creation of the backend stage.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="lbBackendConfigs")
    def lb_backend_configs(self) -> pulumi.Output[Optional[Sequence['outputs.EdgeServicesBackendStageLbBackendConfig']]]:
        """
        The Scaleway Load Balancer linked to the backend stage.
        """
        return pulumi.get(self, "lb_backend_configs")

    @property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        `project_id`) The ID of the project the backend stage is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="s3BackendConfig")
    def s3_backend_config(self) -> pulumi.Output[Optional['outputs.EdgeServicesBackendStageS3BackendConfig']]:
        """
        The Scaleway Object Storage origin bucket (S3) linked to the backend stage.
        """
        return pulumi.get(self, "s3_backend_config")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        The date and time of the last update of the backend stage.
        """
        return pulumi.get(self, "updated_at")

