# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FunctionArgs', 'Function']

@pulumi.input_type
class FunctionArgs:
    def __init__(__self__, *,
                 handler: pulumi.Input[builtins.str],
                 namespace_id: pulumi.Input[builtins.str],
                 privacy: pulumi.Input[builtins.str],
                 runtime: pulumi.Input[builtins.str],
                 deploy: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 http_option: Optional[pulumi.Input[builtins.str]] = None,
                 max_scale: Optional[pulumi.Input[builtins.int]] = None,
                 memory_limit: Optional[pulumi.Input[builtins.int]] = None,
                 min_scale: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 private_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 sandbox: Optional[pulumi.Input[builtins.str]] = None,
                 secret_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 zip_file: Optional[pulumi.Input[builtins.str]] = None,
                 zip_hash: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Function resource.
        :param pulumi.Input[builtins.str] handler: Handler of the function, depends on the runtime. Refer to the [dedicated documentation](https://www.scaleway.com/en/developers/api/serverless-functions/#path-functions-create-a-new-function) for the list of supported runtimes.
        :param pulumi.Input[builtins.str] namespace_id: The Functions namespace ID of the function.
               
               > **Important** Updating the `name` argument will recreate the function.
        :param pulumi.Input[builtins.str] privacy: The privacy type defines the way to authenticate to your function. Please check our dedicated [section](https://www.scaleway.com/en/developers/api/serverless-functions/#protocol-9dd4c8).
        :param pulumi.Input[builtins.str] runtime: Runtime of the function. Runtimes can be fetched using [specific route](https://www.scaleway.com/en/developers/api/serverless-functions/#path-functions-get-a-function)
        :param pulumi.Input[builtins.str] description: The description of the function.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] environment_variables: The [environment variables](https://www.scaleway.com/en/docs/compute/functions/concepts/#environment-variables) of the function.
        :param pulumi.Input[builtins.str] http_option: Allows both HTTP and HTTPS (`enabled`) or redirect HTTP to HTTPS (`redirected`). Defaults to `enabled`.
        :param pulumi.Input[builtins.int] max_scale: The maximum number of instances this function can scale to. Default to 20. Your function will scale automatically based on the incoming workload, but will never exceed the configured `max_scale` value.
        :param pulumi.Input[builtins.int] memory_limit: The memory resources in MB to allocate to each function. Defaults to 256 MB.
        :param pulumi.Input[builtins.int] min_scale: The minimum number of function instances running continuously. Defaults to 0. Functions are billed when executed, and using a `min_scale` greater than 0 will cause your function to run constantly.
        :param pulumi.Input[builtins.str] name: The unique name of the function name.
        :param pulumi.Input[builtins.str] private_network_id: The ID of the Private Network the function is connected to.
               
               > **Important** This feature is currently in beta and requires a namespace with VPC integration activated by setting the `activate_vpc_integration` attribute to `true`.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the functions namespace is associated with.
        :param pulumi.Input[builtins.str] region: `region`). The region in which the namespace should be created.
        :param pulumi.Input[builtins.str] sandbox: Execution environment of the function.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] secret_environment_variables: The [secret environment variables](https://www.scaleway.com/en/docs/compute/functions/concepts/#secrets) of the function.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The list of tags associated with the function.
        :param pulumi.Input[builtins.int] timeout: The maximum amount of time your function can spend processing a request before being stopped. Defaults to 300s.
        :param pulumi.Input[builtins.str] zip_file: Path to the zip file containing your function sources to upload.
        :param pulumi.Input[builtins.str] zip_hash: The hash of your source zip file, changing it will re-apply function. Can be any string
        """
        pulumi.set(__self__, "handler", handler)
        pulumi.set(__self__, "namespace_id", namespace_id)
        pulumi.set(__self__, "privacy", privacy)
        pulumi.set(__self__, "runtime", runtime)
        if deploy is not None:
            pulumi.set(__self__, "deploy", deploy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if http_option is not None:
            pulumi.set(__self__, "http_option", http_option)
        if max_scale is not None:
            pulumi.set(__self__, "max_scale", max_scale)
        if memory_limit is not None:
            pulumi.set(__self__, "memory_limit", memory_limit)
        if min_scale is not None:
            pulumi.set(__self__, "min_scale", min_scale)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_network_id is not None:
            pulumi.set(__self__, "private_network_id", private_network_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if sandbox is not None:
            pulumi.set(__self__, "sandbox", sandbox)
        if secret_environment_variables is not None:
            pulumi.set(__self__, "secret_environment_variables", secret_environment_variables)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if zip_file is not None:
            pulumi.set(__self__, "zip_file", zip_file)
        if zip_hash is not None:
            pulumi.set(__self__, "zip_hash", zip_hash)

    @property
    @pulumi.getter
    def handler(self) -> pulumi.Input[builtins.str]:
        """
        Handler of the function, depends on the runtime. Refer to the [dedicated documentation](https://www.scaleway.com/en/developers/api/serverless-functions/#path-functions-create-a-new-function) for the list of supported runtimes.
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "handler", value)

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> pulumi.Input[builtins.str]:
        """
        The Functions namespace ID of the function.

        > **Important** Updating the `name` argument will recreate the function.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "namespace_id", value)

    @property
    @pulumi.getter
    def privacy(self) -> pulumi.Input[builtins.str]:
        """
        The privacy type defines the way to authenticate to your function. Please check our dedicated [section](https://www.scaleway.com/en/developers/api/serverless-functions/#protocol-9dd4c8).
        """
        return pulumi.get(self, "privacy")

    @privacy.setter
    def privacy(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "privacy", value)

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Input[builtins.str]:
        """
        Runtime of the function. Runtimes can be fetched using [specific route](https://www.scaleway.com/en/developers/api/serverless-functions/#path-functions-get-a-function)
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter
    def deploy(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "deploy")

    @deploy.setter
    def deploy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deploy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the function.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The [environment variables](https://www.scaleway.com/en/docs/compute/functions/concepts/#environment-variables) of the function.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="httpOption")
    def http_option(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Allows both HTTP and HTTPS (`enabled`) or redirect HTTP to HTTPS (`redirected`). Defaults to `enabled`.
        """
        return pulumi.get(self, "http_option")

    @http_option.setter
    def http_option(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "http_option", value)

    @property
    @pulumi.getter(name="maxScale")
    def max_scale(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of instances this function can scale to. Default to 20. Your function will scale automatically based on the incoming workload, but will never exceed the configured `max_scale` value.
        """
        return pulumi.get(self, "max_scale")

    @max_scale.setter
    def max_scale(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_scale", value)

    @property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The memory resources in MB to allocate to each function. Defaults to 256 MB.
        """
        return pulumi.get(self, "memory_limit")

    @memory_limit.setter
    def memory_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "memory_limit", value)

    @property
    @pulumi.getter(name="minScale")
    def min_scale(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum number of function instances running continuously. Defaults to 0. Functions are billed when executed, and using a `min_scale` greater than 0 will cause your function to run constantly.
        """
        return pulumi.get(self, "min_scale")

    @min_scale.setter
    def min_scale(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_scale", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique name of the function name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Private Network the function is connected to.

        > **Important** This feature is currently in beta and requires a namespace with VPC integration activated by setting the `activate_vpc_integration` attribute to `true`.
        """
        return pulumi.get(self, "private_network_id")

    @private_network_id.setter
    def private_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_network_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project the functions namespace is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`). The region in which the namespace should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def sandbox(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Execution environment of the function.
        """
        return pulumi.get(self, "sandbox")

    @sandbox.setter
    def sandbox(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sandbox", value)

    @property
    @pulumi.getter(name="secretEnvironmentVariables")
    def secret_environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The [secret environment variables](https://www.scaleway.com/en/docs/compute/functions/concepts/#secrets) of the function.
        """
        return pulumi.get(self, "secret_environment_variables")

    @secret_environment_variables.setter
    def secret_environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "secret_environment_variables", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of tags associated with the function.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum amount of time your function can spend processing a request before being stopped. Defaults to 300s.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="zipFile")
    def zip_file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Path to the zip file containing your function sources to upload.
        """
        return pulumi.get(self, "zip_file")

    @zip_file.setter
    def zip_file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zip_file", value)

    @property
    @pulumi.getter(name="zipHash")
    def zip_hash(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hash of your source zip file, changing it will re-apply function. Can be any string
        """
        return pulumi.get(self, "zip_hash")

    @zip_hash.setter
    def zip_hash(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zip_hash", value)


@pulumi.input_type
class _FunctionState:
    def __init__(__self__, *,
                 cpu_limit: Optional[pulumi.Input[builtins.int]] = None,
                 deploy: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 handler: Optional[pulumi.Input[builtins.str]] = None,
                 http_option: Optional[pulumi.Input[builtins.str]] = None,
                 max_scale: Optional[pulumi.Input[builtins.int]] = None,
                 memory_limit: Optional[pulumi.Input[builtins.int]] = None,
                 min_scale: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[builtins.str]] = None,
                 privacy: Optional[pulumi.Input[builtins.str]] = None,
                 private_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 runtime: Optional[pulumi.Input[builtins.str]] = None,
                 sandbox: Optional[pulumi.Input[builtins.str]] = None,
                 secret_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 zip_file: Optional[pulumi.Input[builtins.str]] = None,
                 zip_hash: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Function resources.
        :param pulumi.Input[builtins.int] cpu_limit: The CPU limit in mVCPU for your function.
        :param pulumi.Input[builtins.str] description: The description of the function.
        :param pulumi.Input[builtins.str] domain_name: The native domain name of the function.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] environment_variables: The [environment variables](https://www.scaleway.com/en/docs/compute/functions/concepts/#environment-variables) of the function.
        :param pulumi.Input[builtins.str] handler: Handler of the function, depends on the runtime. Refer to the [dedicated documentation](https://www.scaleway.com/en/developers/api/serverless-functions/#path-functions-create-a-new-function) for the list of supported runtimes.
        :param pulumi.Input[builtins.str] http_option: Allows both HTTP and HTTPS (`enabled`) or redirect HTTP to HTTPS (`redirected`). Defaults to `enabled`.
        :param pulumi.Input[builtins.int] max_scale: The maximum number of instances this function can scale to. Default to 20. Your function will scale automatically based on the incoming workload, but will never exceed the configured `max_scale` value.
        :param pulumi.Input[builtins.int] memory_limit: The memory resources in MB to allocate to each function. Defaults to 256 MB.
        :param pulumi.Input[builtins.int] min_scale: The minimum number of function instances running continuously. Defaults to 0. Functions are billed when executed, and using a `min_scale` greater than 0 will cause your function to run constantly.
        :param pulumi.Input[builtins.str] name: The unique name of the function name.
        :param pulumi.Input[builtins.str] namespace_id: The Functions namespace ID of the function.
               
               > **Important** Updating the `name` argument will recreate the function.
        :param pulumi.Input[builtins.str] organization_id: The organization ID the function is associated with.
        :param pulumi.Input[builtins.str] privacy: The privacy type defines the way to authenticate to your function. Please check our dedicated [section](https://www.scaleway.com/en/developers/api/serverless-functions/#protocol-9dd4c8).
        :param pulumi.Input[builtins.str] private_network_id: The ID of the Private Network the function is connected to.
               
               > **Important** This feature is currently in beta and requires a namespace with VPC integration activated by setting the `activate_vpc_integration` attribute to `true`.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the functions namespace is associated with.
        :param pulumi.Input[builtins.str] region: `region`). The region in which the namespace should be created.
        :param pulumi.Input[builtins.str] runtime: Runtime of the function. Runtimes can be fetched using [specific route](https://www.scaleway.com/en/developers/api/serverless-functions/#path-functions-get-a-function)
        :param pulumi.Input[builtins.str] sandbox: Execution environment of the function.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] secret_environment_variables: The [secret environment variables](https://www.scaleway.com/en/docs/compute/functions/concepts/#secrets) of the function.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The list of tags associated with the function.
        :param pulumi.Input[builtins.int] timeout: The maximum amount of time your function can spend processing a request before being stopped. Defaults to 300s.
        :param pulumi.Input[builtins.str] zip_file: Path to the zip file containing your function sources to upload.
        :param pulumi.Input[builtins.str] zip_hash: The hash of your source zip file, changing it will re-apply function. Can be any string
        """
        if cpu_limit is not None:
            pulumi.set(__self__, "cpu_limit", cpu_limit)
        if deploy is not None:
            pulumi.set(__self__, "deploy", deploy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if handler is not None:
            pulumi.set(__self__, "handler", handler)
        if http_option is not None:
            pulumi.set(__self__, "http_option", http_option)
        if max_scale is not None:
            pulumi.set(__self__, "max_scale", max_scale)
        if memory_limit is not None:
            pulumi.set(__self__, "memory_limit", memory_limit)
        if min_scale is not None:
            pulumi.set(__self__, "min_scale", min_scale)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if privacy is not None:
            pulumi.set(__self__, "privacy", privacy)
        if private_network_id is not None:
            pulumi.set(__self__, "private_network_id", private_network_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if sandbox is not None:
            pulumi.set(__self__, "sandbox", sandbox)
        if secret_environment_variables is not None:
            pulumi.set(__self__, "secret_environment_variables", secret_environment_variables)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if zip_file is not None:
            pulumi.set(__self__, "zip_file", zip_file)
        if zip_hash is not None:
            pulumi.set(__self__, "zip_hash", zip_hash)

    @property
    @pulumi.getter(name="cpuLimit")
    def cpu_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The CPU limit in mVCPU for your function.
        """
        return pulumi.get(self, "cpu_limit")

    @cpu_limit.setter
    def cpu_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cpu_limit", value)

    @property
    @pulumi.getter
    def deploy(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "deploy")

    @deploy.setter
    def deploy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deploy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the function.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The native domain name of the function.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The [environment variables](https://www.scaleway.com/en/docs/compute/functions/concepts/#environment-variables) of the function.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter
    def handler(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Handler of the function, depends on the runtime. Refer to the [dedicated documentation](https://www.scaleway.com/en/developers/api/serverless-functions/#path-functions-create-a-new-function) for the list of supported runtimes.
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "handler", value)

    @property
    @pulumi.getter(name="httpOption")
    def http_option(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Allows both HTTP and HTTPS (`enabled`) or redirect HTTP to HTTPS (`redirected`). Defaults to `enabled`.
        """
        return pulumi.get(self, "http_option")

    @http_option.setter
    def http_option(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "http_option", value)

    @property
    @pulumi.getter(name="maxScale")
    def max_scale(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of instances this function can scale to. Default to 20. Your function will scale automatically based on the incoming workload, but will never exceed the configured `max_scale` value.
        """
        return pulumi.get(self, "max_scale")

    @max_scale.setter
    def max_scale(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_scale", value)

    @property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The memory resources in MB to allocate to each function. Defaults to 256 MB.
        """
        return pulumi.get(self, "memory_limit")

    @memory_limit.setter
    def memory_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "memory_limit", value)

    @property
    @pulumi.getter(name="minScale")
    def min_scale(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The minimum number of function instances running continuously. Defaults to 0. Functions are billed when executed, and using a `min_scale` greater than 0 will cause your function to run constantly.
        """
        return pulumi.get(self, "min_scale")

    @min_scale.setter
    def min_scale(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "min_scale", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique name of the function name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Functions namespace ID of the function.

        > **Important** Updating the `name` argument will recreate the function.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "namespace_id", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The organization ID the function is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter
    def privacy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The privacy type defines the way to authenticate to your function. Please check our dedicated [section](https://www.scaleway.com/en/developers/api/serverless-functions/#protocol-9dd4c8).
        """
        return pulumi.get(self, "privacy")

    @privacy.setter
    def privacy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "privacy", value)

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Private Network the function is connected to.

        > **Important** This feature is currently in beta and requires a namespace with VPC integration activated by setting the `activate_vpc_integration` attribute to `true`.
        """
        return pulumi.get(self, "private_network_id")

    @private_network_id.setter
    def private_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_network_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `project_id`) The ID of the project the functions namespace is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        `region`). The region in which the namespace should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Runtime of the function. Runtimes can be fetched using [specific route](https://www.scaleway.com/en/developers/api/serverless-functions/#path-functions-get-a-function)
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter
    def sandbox(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Execution environment of the function.
        """
        return pulumi.get(self, "sandbox")

    @sandbox.setter
    def sandbox(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sandbox", value)

    @property
    @pulumi.getter(name="secretEnvironmentVariables")
    def secret_environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The [secret environment variables](https://www.scaleway.com/en/docs/compute/functions/concepts/#secrets) of the function.
        """
        return pulumi.get(self, "secret_environment_variables")

    @secret_environment_variables.setter
    def secret_environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "secret_environment_variables", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of tags associated with the function.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum amount of time your function can spend processing a request before being stopped. Defaults to 300s.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="zipFile")
    def zip_file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Path to the zip file containing your function sources to upload.
        """
        return pulumi.get(self, "zip_file")

    @zip_file.setter
    def zip_file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zip_file", value)

    @property
    @pulumi.getter(name="zipHash")
    def zip_hash(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hash of your source zip file, changing it will re-apply function. Can be any string
        """
        return pulumi.get(self, "zip_hash")

    @zip_hash.setter
    def zip_hash(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zip_hash", value)


@pulumi.type_token("scaleway:functions/function:Function")
class Function(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deploy: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 handler: Optional[pulumi.Input[builtins.str]] = None,
                 http_option: Optional[pulumi.Input[builtins.str]] = None,
                 max_scale: Optional[pulumi.Input[builtins.int]] = None,
                 memory_limit: Optional[pulumi.Input[builtins.int]] = None,
                 min_scale: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[builtins.str]] = None,
                 privacy: Optional[pulumi.Input[builtins.str]] = None,
                 private_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 runtime: Optional[pulumi.Input[builtins.str]] = None,
                 sandbox: Optional[pulumi.Input[builtins.str]] = None,
                 secret_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 zip_file: Optional[pulumi.Input[builtins.str]] = None,
                 zip_hash: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        Functions can be imported using, `{region}/{id}`, as shown below:

        bash

        ```sh
        $ pulumi import scaleway:functions/function:Function main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the function.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] environment_variables: The [environment variables](https://www.scaleway.com/en/docs/compute/functions/concepts/#environment-variables) of the function.
        :param pulumi.Input[builtins.str] handler: Handler of the function, depends on the runtime. Refer to the [dedicated documentation](https://www.scaleway.com/en/developers/api/serverless-functions/#path-functions-create-a-new-function) for the list of supported runtimes.
        :param pulumi.Input[builtins.str] http_option: Allows both HTTP and HTTPS (`enabled`) or redirect HTTP to HTTPS (`redirected`). Defaults to `enabled`.
        :param pulumi.Input[builtins.int] max_scale: The maximum number of instances this function can scale to. Default to 20. Your function will scale automatically based on the incoming workload, but will never exceed the configured `max_scale` value.
        :param pulumi.Input[builtins.int] memory_limit: The memory resources in MB to allocate to each function. Defaults to 256 MB.
        :param pulumi.Input[builtins.int] min_scale: The minimum number of function instances running continuously. Defaults to 0. Functions are billed when executed, and using a `min_scale` greater than 0 will cause your function to run constantly.
        :param pulumi.Input[builtins.str] name: The unique name of the function name.
        :param pulumi.Input[builtins.str] namespace_id: The Functions namespace ID of the function.
               
               > **Important** Updating the `name` argument will recreate the function.
        :param pulumi.Input[builtins.str] privacy: The privacy type defines the way to authenticate to your function. Please check our dedicated [section](https://www.scaleway.com/en/developers/api/serverless-functions/#protocol-9dd4c8).
        :param pulumi.Input[builtins.str] private_network_id: The ID of the Private Network the function is connected to.
               
               > **Important** This feature is currently in beta and requires a namespace with VPC integration activated by setting the `activate_vpc_integration` attribute to `true`.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the functions namespace is associated with.
        :param pulumi.Input[builtins.str] region: `region`). The region in which the namespace should be created.
        :param pulumi.Input[builtins.str] runtime: Runtime of the function. Runtimes can be fetched using [specific route](https://www.scaleway.com/en/developers/api/serverless-functions/#path-functions-get-a-function)
        :param pulumi.Input[builtins.str] sandbox: Execution environment of the function.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] secret_environment_variables: The [secret environment variables](https://www.scaleway.com/en/docs/compute/functions/concepts/#secrets) of the function.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The list of tags associated with the function.
        :param pulumi.Input[builtins.int] timeout: The maximum amount of time your function can spend processing a request before being stopped. Defaults to 300s.
        :param pulumi.Input[builtins.str] zip_file: Path to the zip file containing your function sources to upload.
        :param pulumi.Input[builtins.str] zip_hash: The hash of your source zip file, changing it will re-apply function. Can be any string
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FunctionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Functions can be imported using, `{region}/{id}`, as shown below:

        bash

        ```sh
        $ pulumi import scaleway:functions/function:Function main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param FunctionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deploy: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 handler: Optional[pulumi.Input[builtins.str]] = None,
                 http_option: Optional[pulumi.Input[builtins.str]] = None,
                 max_scale: Optional[pulumi.Input[builtins.int]] = None,
                 memory_limit: Optional[pulumi.Input[builtins.int]] = None,
                 min_scale: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[builtins.str]] = None,
                 privacy: Optional[pulumi.Input[builtins.str]] = None,
                 private_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 runtime: Optional[pulumi.Input[builtins.str]] = None,
                 sandbox: Optional[pulumi.Input[builtins.str]] = None,
                 secret_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 zip_file: Optional[pulumi.Input[builtins.str]] = None,
                 zip_hash: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionArgs.__new__(FunctionArgs)

            __props__.__dict__["deploy"] = deploy
            __props__.__dict__["description"] = description
            __props__.__dict__["environment_variables"] = environment_variables
            if handler is None and not opts.urn:
                raise TypeError("Missing required property 'handler'")
            __props__.__dict__["handler"] = handler
            __props__.__dict__["http_option"] = http_option
            __props__.__dict__["max_scale"] = max_scale
            __props__.__dict__["memory_limit"] = memory_limit
            __props__.__dict__["min_scale"] = min_scale
            __props__.__dict__["name"] = name
            if namespace_id is None and not opts.urn:
                raise TypeError("Missing required property 'namespace_id'")
            __props__.__dict__["namespace_id"] = namespace_id
            if privacy is None and not opts.urn:
                raise TypeError("Missing required property 'privacy'")
            __props__.__dict__["privacy"] = privacy
            __props__.__dict__["private_network_id"] = private_network_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            if runtime is None and not opts.urn:
                raise TypeError("Missing required property 'runtime'")
            __props__.__dict__["runtime"] = runtime
            __props__.__dict__["sandbox"] = sandbox
            __props__.__dict__["secret_environment_variables"] = None if secret_environment_variables is None else pulumi.Output.secret(secret_environment_variables)
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["zip_file"] = zip_file
            __props__.__dict__["zip_hash"] = zip_hash
            __props__.__dict__["cpu_limit"] = None
            __props__.__dict__["domain_name"] = None
            __props__.__dict__["organization_id"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/function:Function")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secretEnvironmentVariables"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Function, __self__).__init__(
            'scaleway:functions/function:Function',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cpu_limit: Optional[pulumi.Input[builtins.int]] = None,
            deploy: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            domain_name: Optional[pulumi.Input[builtins.str]] = None,
            environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            handler: Optional[pulumi.Input[builtins.str]] = None,
            http_option: Optional[pulumi.Input[builtins.str]] = None,
            max_scale: Optional[pulumi.Input[builtins.int]] = None,
            memory_limit: Optional[pulumi.Input[builtins.int]] = None,
            min_scale: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            namespace_id: Optional[pulumi.Input[builtins.str]] = None,
            organization_id: Optional[pulumi.Input[builtins.str]] = None,
            privacy: Optional[pulumi.Input[builtins.str]] = None,
            private_network_id: Optional[pulumi.Input[builtins.str]] = None,
            project_id: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            runtime: Optional[pulumi.Input[builtins.str]] = None,
            sandbox: Optional[pulumi.Input[builtins.str]] = None,
            secret_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            timeout: Optional[pulumi.Input[builtins.int]] = None,
            zip_file: Optional[pulumi.Input[builtins.str]] = None,
            zip_hash: Optional[pulumi.Input[builtins.str]] = None) -> 'Function':
        """
        Get an existing Function resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] cpu_limit: The CPU limit in mVCPU for your function.
        :param pulumi.Input[builtins.str] description: The description of the function.
        :param pulumi.Input[builtins.str] domain_name: The native domain name of the function.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] environment_variables: The [environment variables](https://www.scaleway.com/en/docs/compute/functions/concepts/#environment-variables) of the function.
        :param pulumi.Input[builtins.str] handler: Handler of the function, depends on the runtime. Refer to the [dedicated documentation](https://www.scaleway.com/en/developers/api/serverless-functions/#path-functions-create-a-new-function) for the list of supported runtimes.
        :param pulumi.Input[builtins.str] http_option: Allows both HTTP and HTTPS (`enabled`) or redirect HTTP to HTTPS (`redirected`). Defaults to `enabled`.
        :param pulumi.Input[builtins.int] max_scale: The maximum number of instances this function can scale to. Default to 20. Your function will scale automatically based on the incoming workload, but will never exceed the configured `max_scale` value.
        :param pulumi.Input[builtins.int] memory_limit: The memory resources in MB to allocate to each function. Defaults to 256 MB.
        :param pulumi.Input[builtins.int] min_scale: The minimum number of function instances running continuously. Defaults to 0. Functions are billed when executed, and using a `min_scale` greater than 0 will cause your function to run constantly.
        :param pulumi.Input[builtins.str] name: The unique name of the function name.
        :param pulumi.Input[builtins.str] namespace_id: The Functions namespace ID of the function.
               
               > **Important** Updating the `name` argument will recreate the function.
        :param pulumi.Input[builtins.str] organization_id: The organization ID the function is associated with.
        :param pulumi.Input[builtins.str] privacy: The privacy type defines the way to authenticate to your function. Please check our dedicated [section](https://www.scaleway.com/en/developers/api/serverless-functions/#protocol-9dd4c8).
        :param pulumi.Input[builtins.str] private_network_id: The ID of the Private Network the function is connected to.
               
               > **Important** This feature is currently in beta and requires a namespace with VPC integration activated by setting the `activate_vpc_integration` attribute to `true`.
        :param pulumi.Input[builtins.str] project_id: `project_id`) The ID of the project the functions namespace is associated with.
        :param pulumi.Input[builtins.str] region: `region`). The region in which the namespace should be created.
        :param pulumi.Input[builtins.str] runtime: Runtime of the function. Runtimes can be fetched using [specific route](https://www.scaleway.com/en/developers/api/serverless-functions/#path-functions-get-a-function)
        :param pulumi.Input[builtins.str] sandbox: Execution environment of the function.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] secret_environment_variables: The [secret environment variables](https://www.scaleway.com/en/docs/compute/functions/concepts/#secrets) of the function.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The list of tags associated with the function.
        :param pulumi.Input[builtins.int] timeout: The maximum amount of time your function can spend processing a request before being stopped. Defaults to 300s.
        :param pulumi.Input[builtins.str] zip_file: Path to the zip file containing your function sources to upload.
        :param pulumi.Input[builtins.str] zip_hash: The hash of your source zip file, changing it will re-apply function. Can be any string
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionState.__new__(_FunctionState)

        __props__.__dict__["cpu_limit"] = cpu_limit
        __props__.__dict__["deploy"] = deploy
        __props__.__dict__["description"] = description
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["environment_variables"] = environment_variables
        __props__.__dict__["handler"] = handler
        __props__.__dict__["http_option"] = http_option
        __props__.__dict__["max_scale"] = max_scale
        __props__.__dict__["memory_limit"] = memory_limit
        __props__.__dict__["min_scale"] = min_scale
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace_id"] = namespace_id
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["privacy"] = privacy
        __props__.__dict__["private_network_id"] = private_network_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["sandbox"] = sandbox
        __props__.__dict__["secret_environment_variables"] = secret_environment_variables
        __props__.__dict__["tags"] = tags
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["zip_file"] = zip_file
        __props__.__dict__["zip_hash"] = zip_hash
        return Function(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cpuLimit")
    def cpu_limit(self) -> pulumi.Output[builtins.int]:
        """
        The CPU limit in mVCPU for your function.
        """
        return pulumi.get(self, "cpu_limit")

    @property
    @pulumi.getter
    def deploy(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "deploy")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the function.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[builtins.str]:
        """
        The native domain name of the function.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The [environment variables](https://www.scaleway.com/en/docs/compute/functions/concepts/#environment-variables) of the function.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter
    def handler(self) -> pulumi.Output[builtins.str]:
        """
        Handler of the function, depends on the runtime. Refer to the [dedicated documentation](https://www.scaleway.com/en/developers/api/serverless-functions/#path-functions-create-a-new-function) for the list of supported runtimes.
        """
        return pulumi.get(self, "handler")

    @property
    @pulumi.getter(name="httpOption")
    def http_option(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Allows both HTTP and HTTPS (`enabled`) or redirect HTTP to HTTPS (`redirected`). Defaults to `enabled`.
        """
        return pulumi.get(self, "http_option")

    @property
    @pulumi.getter(name="maxScale")
    def max_scale(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The maximum number of instances this function can scale to. Default to 20. Your function will scale automatically based on the incoming workload, but will never exceed the configured `max_scale` value.
        """
        return pulumi.get(self, "max_scale")

    @property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The memory resources in MB to allocate to each function. Defaults to 256 MB.
        """
        return pulumi.get(self, "memory_limit")

    @property
    @pulumi.getter(name="minScale")
    def min_scale(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The minimum number of function instances running continuously. Defaults to 0. Functions are billed when executed, and using a `min_scale` greater than 0 will cause your function to run constantly.
        """
        return pulumi.get(self, "min_scale")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The unique name of the function name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> pulumi.Output[builtins.str]:
        """
        The Functions namespace ID of the function.

        > **Important** Updating the `name` argument will recreate the function.
        """
        return pulumi.get(self, "namespace_id")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[builtins.str]:
        """
        The organization ID the function is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def privacy(self) -> pulumi.Output[builtins.str]:
        """
        The privacy type defines the way to authenticate to your function. Please check our dedicated [section](https://www.scaleway.com/en/developers/api/serverless-functions/#protocol-9dd4c8).
        """
        return pulumi.get(self, "privacy")

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the Private Network the function is connected to.

        > **Important** This feature is currently in beta and requires a namespace with VPC integration activated by setting the `activate_vpc_integration` attribute to `true`.
        """
        return pulumi.get(self, "private_network_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[builtins.str]:
        """
        `project_id`) The ID of the project the functions namespace is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        `region`). The region in which the namespace should be created.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[builtins.str]:
        """
        Runtime of the function. Runtimes can be fetched using [specific route](https://www.scaleway.com/en/developers/api/serverless-functions/#path-functions-get-a-function)
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter
    def sandbox(self) -> pulumi.Output[builtins.str]:
        """
        Execution environment of the function.
        """
        return pulumi.get(self, "sandbox")

    @property
    @pulumi.getter(name="secretEnvironmentVariables")
    def secret_environment_variables(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The [secret environment variables](https://www.scaleway.com/en/docs/compute/functions/concepts/#secrets) of the function.
        """
        return pulumi.get(self, "secret_environment_variables")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The list of tags associated with the function.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[builtins.int]:
        """
        The maximum amount of time your function can spend processing a request before being stopped. Defaults to 300s.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="zipFile")
    def zip_file(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Path to the zip file containing your function sources to upload.
        """
        return pulumi.get(self, "zip_file")

    @property
    @pulumi.getter(name="zipHash")
    def zip_hash(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The hash of your source zip file, changing it will re-apply function. Can be any string
        """
        return pulumi.get(self, "zip_hash")

